/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid;

import java.awt.Image;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.painter.IconPainter;
import oracle.bali.ewt.painter.PaintContext;

public class TwoIconPainter
extends IconPainter {
    private Icon _trueIcon;
    private Icon _falseIcon;
    private Icon _disabledTrueIcon;
    private Icon _disabledFalseIcon;

    public TwoIconPainter(Icon trueIcon, Icon falseIcon) {
        this(trueIcon, falseIcon, null, null);
    }

    public TwoIconPainter(Icon trueIcon, Icon falseIcon, Icon disabledTrueIcon, Icon disabledFalseIcon) {
        this.setTrueIcon(trueIcon);
        this.setFalseIcon(falseIcon);
        this.setDisabledTrueIcon(disabledTrueIcon);
        this.setDisabledFalseIcon(disabledFalseIcon);
    }

    public Icon getTrueIcon() {
        return this._trueIcon;
    }

    public void setTrueIcon(Icon trueIcon) {
        this._trueIcon = trueIcon;
    }

    public Icon getFalseIcon() {
        return this._falseIcon;
    }

    public void setFalseIcon(Icon falseIcon) {
        this._falseIcon = falseIcon;
    }

    public Icon getDisabledTrueIcon() {
        Icon trueIcon;
        if (this._disabledTrueIcon == null && (trueIcon = this.getTrueIcon()) != null && trueIcon instanceof ImageIcon) {
            Image image = ((ImageIcon)trueIcon).getImage();
            image = ImageUtils.createDisabledImage(image);
            this._disabledTrueIcon = new ImageIcon(image);
        }
        return this._disabledTrueIcon;
    }

    public void setDisabledTrueIcon(Icon disabledTrueIcon) {
        this._disabledTrueIcon = disabledTrueIcon;
    }

    public Icon getDisabledFalseIcon() {
        Icon falseIcon;
        if (this._disabledFalseIcon == null && (falseIcon = this.getFalseIcon()) != null && falseIcon instanceof ImageIcon) {
            Image image = ((ImageIcon)falseIcon).getImage();
            image = ImageUtils.createDisabledImage(image);
            this._disabledFalseIcon = new ImageIcon(image);
        }
        return this._disabledFalseIcon;
    }

    public void setDisabledFalseIcon(Icon disabledFalseIcon) {
        this._disabledFalseIcon = disabledFalseIcon;
    }

    protected Icon getIconData(PaintContext context) {
        Object data = context.getPaintData(this.getDataKey());
        int state = context.getPaintState();
        boolean enabled = (state & 1) == 0;
        Icon icon = null;
        if (Boolean.TRUE.equals(data)) {
            if (enabled) {
                icon = this.getTrueIcon();
            } else {
                icon = this.getDisabledTrueIcon();
                if (icon == null) {
                    icon = this.getTrueIcon();
                }
            }
        } else if (enabled) {
            icon = this.getFalseIcon();
        } else {
            icon = this.getDisabledFalseIcon();
            if (icon == null) {
                icon = this.getFalseIcon();
            }
        }
        return icon;
    }
}

