/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Enumeration;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.layout.EqualLayout;

public class EqualRowLayout
extends EqualLayout
implements LayoutManager {
    public static final int ALIGN_START = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_END = 2;

    public EqualRowLayout() {
    }

    public EqualRowLayout(int interiorGap) {
        super(interiorGap);
    }

    public EqualRowLayout(int interiorGap, int layoutAlignment, int perpendicularAlignment) {
        super(interiorGap, layoutAlignment, perpendicularAlignment);
    }

    public void layoutContainer(Container target) {
        int cellHeight;
        int layoutAlignment = this.getLayoutAlignment();
        Insets containerInsets = target.getInsets();
        Dimension size = target.getSize();
        int width = size.width;
        int height = size.height;
        int numVisibleChildren = EqualRowLayout.getNumberVisibleChildren(target);
        int cellWidth = width - containerInsets.left - containerInsets.right;
        if (numVisibleChildren > 1) {
            cellWidth -= this.getInteriorGap() * (numVisibleChildren - 1);
            cellWidth /= numVisibleChildren;
        }
        Dimension cellPrefSize = this.getCellSize(target, true);
        if (cellWidth > cellPrefSize.width) {
            cellWidth = cellPrefSize.width;
        }
        if ((cellHeight = height - containerInsets.top - containerInsets.bottom) > cellPrefSize.height) {
            cellHeight = cellPrefSize.height;
        }
        int x = containerInsets.left;
        boolean flip = false;
        if (target instanceof LWComponent) {
            boolean bl = flip = ((LWComponent)target).getActualReadingDirection() == 2;
        }
        if (flip) {
            if (layoutAlignment == 0) {
                layoutAlignment = 2;
            } else if (layoutAlignment == 2) {
                layoutAlignment = 0;
            }
        }
        int totalWidth = cellWidth * numVisibleChildren;
        if (numVisibleChildren > 1) {
            totalWidth += this.getInteriorGap() * (numVisibleChildren - 1);
        }
        if (layoutAlignment != 0) {
            x = layoutAlignment == 2 ? width - totalWidth - containerInsets.right : (x += width - totalWidth >> 1);
        }
        if (flip) {
            x += totalWidth - cellWidth;
        }
        int perpendicularAlignment = this.getPerpendicularAlignment();
        Enumeration componentEnumeration = this.getComponentEnumeration(target);
        while (componentEnumeration.hasMoreElements()) {
            Component currChild = (Component)componentEnumeration.nextElement();
            if (!currChild.isVisible()) continue;
            int y = containerInsets.top;
            if (perpendicularAlignment != 0) {
                y = perpendicularAlignment == 2 ? height - containerInsets.top - cellHeight : (y += height - containerInsets.top - containerInsets.bottom - cellHeight >> 1);
            }
            currChild.setBounds(x, y, cellWidth, cellHeight);
            if (flip) {
                x -= cellWidth + this.getInteriorGap();
                continue;
            }
            x += cellWidth + this.getInteriorGap();
        }
    }

    protected Dimension getInsetLayoutSize(Container target, boolean usePreferredSize) {
        int numVisibleChildren = EqualRowLayout.getNumberVisibleChildren(target);
        Dimension cellSize = this.getCellSize(target, usePreferredSize);
        int width = cellSize.width * numVisibleChildren;
        if (numVisibleChildren > 1) {
            width += this.getInteriorGap() * (numVisibleChildren - 1);
        }
        return new Dimension(width, cellSize.height);
    }
}

