/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.layout;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;

public class MaximumBorderLayout
extends BorderLayout {
    private Component _north;
    private Component _south;
    private Component _east;
    private Component _west;
    private Component _center;

    public MaximumBorderLayout() {
    }

    public MaximumBorderLayout(int hgap, int vgap) {
        super(hgap, vgap);
    }

    public void addLayoutComponent(String name, Component comp) {
        if (name == null) {
            return;
        }
        super.addLayoutComponent(name, comp);
        if (name.equals("Center")) {
            this._center = comp;
        } else if (name.equals("North")) {
            this._north = comp;
        } else if (name.equals("South")) {
            this._south = comp;
        } else if (name.equals("East")) {
            this._east = comp;
        } else if (name.equals("West")) {
            this._west = comp;
        }
    }

    public void removeLayoutComponent(Component comp) {
        super.removeLayoutComponent(comp);
        if (comp != this._center) {
            if (comp == this._north) {
                this._north = null;
            } else if (comp == this._south) {
                this._south = null;
            } else if (comp == this._east) {
                this._east = null;
            } else if (comp == this._west) {
                this._west = null;
            }
        }
    }

    public Dimension maximumLayoutSize(Container target) {
        Dimension centerSize = this._getMaximumSize(this._center);
        Dimension northSize = this._getMaximumSize(this._north);
        Dimension southSize = this._getMaximumSize(this._south);
        Dimension eastSize = this._getMaximumSize(this._east);
        Dimension westSize = this._getMaximumSize(this._west);
        int hGap = this.getHgap();
        int vGap = this.getVgap();
        int maxWidth = 0;
        int maxHeight = Short.MAX_VALUE;
        if (centerSize != null) {
            maxWidth += centerSize.width;
            maxHeight = centerSize.height;
        }
        if (eastSize != null) {
            maxWidth += eastSize.width + hGap;
            if (eastSize.height < maxHeight) {
                maxHeight = eastSize.height;
            }
        }
        if (westSize != null) {
            maxWidth += westSize.width + hGap;
            if (westSize.height < maxHeight) {
                maxHeight = westSize.height;
            }
        }
        if (maxWidth == 0) {
            maxWidth = Short.MAX_VALUE;
        }
        if (northSize != null) {
            if (northSize.width < maxWidth) {
                maxWidth = northSize.width;
            }
            maxHeight += northSize.height + vGap;
        }
        if (southSize != null) {
            if (southSize.width < maxWidth) {
                maxWidth = southSize.width;
            }
            maxHeight += southSize.height + vGap;
        }
        Insets insets = target.getInsets();
        return new Dimension(maxWidth += insets.left + insets.right, maxHeight += insets.top + insets.bottom);
    }

    protected Component getComponent(Object key) {
        Component comp = null;
        if (key.equals("Center")) {
            comp = this._center;
        } else if (key.equals("North")) {
            comp = this._north;
        } else if (key.equals("South")) {
            comp = this._south;
        } else if (key.equals("East")) {
            comp = this._east;
        } else if (key.equals("West")) {
            comp = this._west;
        }
        return comp;
    }

    private Dimension _getMaximumSize(Component comp) {
        if (comp == null || !comp.isVisible()) {
            return null;
        }
        Dimension maxSize = comp.getMaximumSize();
        if (maxSize.width > Short.MAX_VALUE) {
            maxSize.width = Short.MAX_VALUE;
        }
        if (maxSize.height > Short.MAX_VALUE) {
            maxSize.height = Short.MAX_VALUE;
        }
        return maxSize;
    }
}

