/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;

public final class PreferredGridLayout
implements LayoutManager2 {
    public static final int UNLIMITED_COUNT = 0;
    public static final int NO_STRETCH = -1;
    private static final int _CALC_TYPE_PREFERRED = 0;
    private static final int _CALC_TYPE_MINIMUM = 1;
    private static final int _CALC_TYPE_MAXIMUM = 2;
    private Container _target;
    private int _hGap;
    private int _vGap;
    private int _numRows;
    private int _numColumns;
    private int _stretchRow;
    private int _stretchColumn;
    private transient int[] _preferredWidths;
    private transient int[] _preferredHeights;
    private transient Dimension _preferredSize;
    private transient Dimension _minimumSize;
    private transient Dimension _maximumSize;

    public PreferredGridLayout(Container target) {
        this(target, 1, 0);
    }

    public PreferredGridLayout(Container target, int rowCount, int columnCount) {
        this(target, rowCount, columnCount, 0, 0);
    }

    public PreferredGridLayout(Container target, int rowCount, int columnCount, int hGap, int vGap) {
        this(target, rowCount, columnCount, hGap, vGap, -1, -1);
    }

    public PreferredGridLayout(Container target, int rowCount, int columnCount, int hGap, int vGap, int stretchRow, int stretchColumn) {
        if (target == null) {
            throw new IllegalArgumentException();
        }
        this._checkCountException(rowCount, columnCount);
        this._target = target;
        this._numRows = rowCount;
        this._numColumns = columnCount;
        this._hGap = hGap;
        this._vGap = vGap;
        this._stretchRow = stretchRow;
        this._stretchColumn = stretchColumn;
    }

    public void setRowCount(int newRowCount) {
        if (this._numRows != newRowCount) {
            this._checkCountException(newRowCount, this._numColumns);
            this._numRows = newRowCount;
            this._target.invalidate();
        }
    }

    public int getRowCount() {
        return this._numRows;
    }

    public void setColumnCount(int newColumnCount) {
        if (this._numColumns != newColumnCount) {
            this._checkCountException(this._numRows, newColumnCount);
            this._numColumns = newColumnCount;
            this._target.invalidate();
        }
    }

    public int getColumnCount() {
        return this._numColumns;
    }

    public void setHGap(int newHGap) {
        if (this._hGap != newHGap) {
            this._hGap = newHGap;
            this._target.invalidate();
        }
    }

    public int getHGap() {
        return this._hGap;
    }

    public void setVGap(int newVGap) {
        if (this._vGap != newVGap) {
            this._vGap = newVGap;
            this._target.invalidate();
        }
    }

    public int getVGap() {
        return this._vGap;
    }

    public float getLayoutAlignmentX(Container target) {
        this._checkTargetException(target);
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container target) {
        this._checkTargetException(target);
        return 0.0f;
    }

    public void addLayoutComponent(String constraintName, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public void addLayoutComponent(Component comp, Object constraints) {
    }

    public Dimension preferredLayoutSize(Container target) {
        this._checkTargetException(target);
        if (this._preferredSize == null) {
            this._preferredSize = this._calculateSize(target, 0);
        }
        return new Dimension(this._preferredSize);
    }

    public Dimension minimumLayoutSize(Container target) {
        this._checkTargetException(target);
        if (this._minimumSize == null) {
            this._minimumSize = this._calculateSize(target, 1);
        }
        return new Dimension(this._minimumSize);
    }

    public Dimension maximumLayoutSize(Container target) {
        this._checkTargetException(target);
        if (this._maximumSize == null) {
            this._maximumSize = this._calculateSize(target, 2);
        }
        return new Dimension(this._maximumSize);
    }

    public void layoutContainer(Container target) {
        this._checkTargetException(target);
        Dimension preferredSize = this.preferredLayoutSize(target);
        Dimension fillSize = target.getSize();
        int stretchWidth = fillSize.width - preferredSize.width;
        int stretchHeight = fillSize.height - preferredSize.height;
        int numComponents = target.getComponentCount();
        int numRows = this._getNumRows(numComponents, this._numColumns);
        int numColumns = this._getNumColumns(numComponents, this._numRows);
        int stretchRow = this._getStretchRow(numRows);
        int stretchColumn = this._getStretchColumn(numColumns);
        int[] preferredWidths = this._preferredWidths;
        int[] preferredHeights = this._preferredHeights;
        int hGap = this._hGap;
        int vGap = this._vGap;
        Insets targetInsets = target.getInsets();
        if (targetInsets == null) {
            targetInsets = new Insets(0, 0, 0, 0);
        }
        int currComponentIndex = 0;
        int currY = targetInsets.top;
        for (int currRow = 0; currRow < numRows; ++currRow) {
            int currX = targetInsets.left;
            int rowHeight = preferredHeights[currRow];
            if (currRow == stretchRow && (rowHeight += stretchHeight) < 0) {
                rowHeight = 0;
            }
            for (int currColumn = 0; currColumn < numColumns; ++currColumn) {
                currComponentIndex = this._getComponentIndex(currColumn, currRow, numColumns);
                if (currComponentIndex >= numComponents) continue;
                int columnWidth = preferredWidths[currColumn];
                if (currColumn == stretchColumn && (columnWidth += stretchWidth) < 0) {
                    columnWidth = 0;
                }
                target.getComponent(currComponentIndex).setBounds(currX, currY, columnWidth, rowHeight);
                currX += columnWidth + hGap;
            }
            currY += rowHeight + vGap;
        }
    }

    public void invalidateLayout(Container target) {
        this._checkTargetException(target);
        this._preferredWidths = null;
        this._preferredHeights = null;
        this._preferredSize = null;
        this._minimumSize = null;
        this._maximumSize = null;
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this._hGap + ",vgap=" + this._vGap + ",rows=" + this._numRows + ",cols=" + this._numColumns + "]";
    }

    private Dimension _calculateSize(Container target, int calcType) {
        int currColumn;
        int numComponents = target.getComponentCount();
        int numRows = this._getNumRows(numComponents, this._numColumns);
        int numColumns = this._getNumColumns(numComponents, this._numRows);
        boolean isPreferred = calcType == 0;
        boolean useMaximum = calcType != 2;
        Dimension[] sizes = new Dimension[numComponents];
        for (int currComponentIndex = 0; currComponentIndex < numComponents; ++currComponentIndex) {
            Component currComponent = target.getComponent(currComponentIndex);
            sizes[currComponentIndex] = currComponent.getPreferredSize();
        }
        this._preferredWidths = new int[numColumns];
        this._preferredHeights = new int[numRows];
        int stretchRow = this._getStretchRow(numRows);
        long totalHeight = 0L;
        for (int currRow = 0; currRow < numRows; ++currRow) {
            boolean recalcSize = !isPreferred && currRow == stretchRow;
            int currRowHeight = 0;
            for (currColumn = 0; currColumn < numColumns; ++currColumn) {
                int currComponentIndex = this._getComponentIndex(currColumn, currRow, numColumns);
                if (currComponentIndex >= numComponents) continue;
                int currHeight = sizes[currComponentIndex].height;
                if (recalcSize) {
                    Component currComponent = target.getComponent(currComponentIndex);
                    currHeight = (useMaximum ? currComponent.getMinimumSize() : currComponent.getMaximumSize()).height;
                }
                if (useMaximum) {
                    if (currRowHeight >= currHeight) continue;
                    currRowHeight = currHeight;
                    continue;
                }
                if (currRowHeight <= currHeight) continue;
                currRowHeight = currHeight;
            }
            totalHeight += (long)currRowHeight;
            if (!isPreferred) continue;
            this._preferredHeights[currRow] = currRowHeight;
        }
        int stretchColumn = this._getStretchColumn(numColumns);
        long totalWidth = 0L;
        for (currColumn = 0; currColumn < numColumns; ++currColumn) {
            boolean recalcSize = !isPreferred && currColumn == stretchColumn;
            int currColumnWidth = 0;
            for (int currRow = 0; currRow < numRows; ++currRow) {
                int currComponentIndex = this._getComponentIndex(currColumn, currRow, numColumns);
                if (currComponentIndex >= numComponents) continue;
                int currWidth = sizes[currComponentIndex].width;
                if (recalcSize) {
                    Component currComponent = target.getComponent(currComponentIndex);
                    currWidth = (useMaximum ? currComponent.getMinimumSize() : currComponent.getMaximumSize()).width;
                }
                if (useMaximum) {
                    if (currColumnWidth >= currWidth) continue;
                    currColumnWidth = currWidth;
                    continue;
                }
                if (currColumnWidth <= currWidth) continue;
                currColumnWidth = currWidth;
            }
            if (isPreferred) {
                this._preferredWidths[currColumn] = currColumnWidth;
            }
            totalWidth += (long)currColumnWidth;
        }
        Insets targetInsets = target.getInsets();
        if (targetInsets == null) {
            targetInsets = new Insets(0, 0, 0, 0);
        }
        int clippedWidth = (totalWidth += (long)(targetInsets.left + targetInsets.right + (numColumns - 1) * this._hGap)) < Integer.MAX_VALUE ? (int)totalWidth : Integer.MAX_VALUE;
        int clippedHeight = totalHeight < Integer.MAX_VALUE ? (int)(totalHeight += (long)(targetInsets.top + targetInsets.bottom + (numRows - 1) * this._vGap)) : Integer.MAX_VALUE;
        return new Dimension(clippedWidth, clippedHeight);
    }

    private void _checkTargetException(Container target) {
        if (this._target != target) {
            throw new IllegalStateException(this.getClass().getName() + " instances cannot be shared across containers");
        }
    }

    private void _checkCountException(int numRows, int numColumns) {
        String exceptionString = null;
        if (numRows == 0 && numColumns == 0) {
            exceptionString = "number of rows and number of columns cannot both be unlimited";
        } else if (numRows < 0) {
            exceptionString = "number of rows cannot be negative";
        } else if (numColumns < 0) {
            exceptionString = "number of columns cannot be negative";
        }
        if (exceptionString != null) {
            throw new IllegalArgumentException(exceptionString);
        }
    }

    private int _getComponentIndex(int columnIndex, int rowIndex, int numColumns) {
        return rowIndex * numColumns + columnIndex;
    }

    private int _getNumColumns(int numComponents, int numRows) {
        int numColumns = this._numColumns;
        if (numColumns == 0) {
            numColumns = (numComponents + this._numRows - 1) / this._numRows;
        }
        return numColumns;
    }

    private int _getNumRows(int numComponents, int numColumns) {
        int numRows = this._numRows;
        if (this._numRows == 0) {
            numRows = (numComponents + numColumns - 1) / numColumns;
        }
        return numRows;
    }

    private int _getStretchRow(int numRows) {
        int stretchRow = this._stretchRow;
        if (stretchRow >= numRows) {
            stretchRow = -1;
        }
        return stretchRow;
    }

    private int _getStretchColumn(int numColumns) {
        int stretchColumn = this._stretchColumn;
        if (stretchColumn >= numColumns) {
            stretchColumn = -1;
        }
        return stretchColumn;
    }
}

