/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.image.ImageFilter;
import java.awt.image.IndexColorModel;
import javax.swing.plaf.ColorUIResource;
import oracle.bali.ewt.graphics.ColorizingFilter;
import oracle.bali.ewt.olaf.ColorScheme;

class BrowserColorScheme
extends ColorScheme {
    private static final boolean _USE_HIGH_COLOR = !(Toolkit.getDefaultToolkit().getColorModel() instanceof IndexColorModel);
    private static final int _sSand = -856164377;
    private Color _definingColor;

    public BrowserColorScheme() {
        this("Browser", "Oracle Browser Color Scheme", 0);
    }

    public BrowserColorScheme(String name, String description, int index) {
        super(name, description, null, index);
        this.__setIntRamp(this._createRamp());
    }

    public Color getDefiningColor() {
        if (this._definingColor == null) {
            this._definingColor = new ColorUIResource(new Color(this.getSandColor()));
        }
        return this._definingColor;
    }

    public ImageFilter createColorizingFilter() {
        return new Filter(this.getColorMappingTable());
    }

    protected int getSandColor() {
        return -856164377;
    }

    private int[] _createRamp() {
        int[] nArray;
        if (_USE_HIGH_COLOR) {
            int[] nArray2 = new int[9];
            nArray2[0] = -1;
            nArray2[1] = this.getSandColor();
            nArray2[2] = -1714235216;
            nArray2[3] = 1725094064;
            nArray2[4] = 0x33999966;
            nArray2[5] = 0;
            nArray2[6] = 255;
            nArray2[7] = 14674679;
            nArray = nArray2;
            nArray2[8] = 11849708;
        } else {
            int[] nArray3 = new int[7];
            nArray3[0] = -1;
            nArray3[1] = this.getSandColor();
            nArray3[2] = -1714235216;
            nArray3[3] = 1725094064;
            nArray3[4] = 0x33999966;
            nArray3[5] = 0x99CCFF;
            nArray = nArray3;
            nArray3[6] = 0x6699FF;
        }
        return nArray;
    }

    private class Filter
    extends ColorizingFilter {
        public Filter(int[] mappingTable) {
            super(mappingTable);
        }

        public int filterRGB(int x, int y, int rgb) {
            int index = rgb & 0xFF;
            if (index < 128) {
                return -10066330;
            }
            return super.filterRGB(x, y, rgb);
        }
    }
}

