/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import oracle.bali.ewt.olaf.AbstractButtonPaintContext;
import oracle.bali.ewt.olaf.AlignedPainterJoiner;
import oracle.bali.ewt.olaf.IconTextGapPainter;
import oracle.bali.ewt.olaf.OracleButtonListener;
import oracle.bali.ewt.olaf.OracleButtonPainter;
import oracle.bali.ewt.olaf.OracleFocusPainter;
import oracle.bali.ewt.olaf.OracleToolBarUI;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.olaf.PainterUI;
import oracle.bali.ewt.painter.AlignmentPainter;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.MarginBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.plaf.BorderAdapter;
import oracle.bali.ewt.plaf.UIUtils;
import oracle.bali.share.collection.StringKey;

public class OracleButtonUI
extends BasicButtonUI
implements PainterUI {
    private Painter[] _painters = new Painter[2];
    private BorderPainter[] _borderPainters = new BorderPainter[4];
    private static final OracleButtonUI _sInstance = new OracleButtonUI();
    static final Object _INTERIOR_PAINT_CONTEXT_KEY = new StringKey("_EWTInteriorPaintContext");
    private static final boolean _DEFAULT_BUTTON_ROUNDING = false;
    private static final Object _TEXT_POSITION_CHANGED = new StringKey("TextPositionChanged");
    private static final TextPositionListener _TEXT_POSITION_LISTENER = new TextPositionListener();

    public static ComponentUI createUI(JComponent component) {
        return _sInstance;
    }

    public void installUI(JComponent component) {
        super.installUI(component);
        if (component.getClass() == JToggleButton.class) {
            LookAndFeel.installBorder(component, "ToggleButton.border");
        }
        OracleUIUtils.putPaintContext(component);
        component.putClientProperty(_INTERIOR_PAINT_CONTEXT_KEY, this.createInteriorPaintContext(component));
        component.addPropertyChangeListener(_TEXT_POSITION_LISTENER);
    }

    public void uninstallUI(JComponent component) {
        super.uninstallUI(component);
        OracleUIUtils.removePaintContext(component);
        component.putClientProperty(_INTERIOR_PAINT_CONTEXT_KEY, null);
        component.removePropertyChangeListener(_TEXT_POSITION_LISTENER);
    }

    protected void installDefaults(AbstractButton b) {
        if (b.getParent() instanceof JToolBar) {
            return;
        }
        super.installDefaults(b);
        b.setOpaque(false);
    }

    protected void installKeyboardActions(AbstractButton b) {
        if (b.getParent() instanceof JToolBar) {
            return;
        }
        super.installKeyboardActions(b);
    }

    public Painter getPainter(JComponent component) {
        return this.getPainter(component, component.getParent() instanceof JToolBar);
    }

    public Dimension getPreferredSize(JComponent component) {
        return OracleUIUtils.getPreferredSize(this, component);
    }

    public Dimension getMinimumSize(JComponent component) {
        return OracleUIUtils.getMinimumSize(this, component);
    }

    public Dimension getMaximumSize(JComponent component) {
        Dimension maxSize = OracleUIUtils.getMaximumSize(this, component);
        Container parent = component.getParent();
        if (parent instanceof JToolBar) {
            int orientation = ((JToolBar)parent).getOrientation();
            switch (orientation) {
                case 0: {
                    maxSize.height = Integer.MAX_VALUE;
                    break;
                }
                case 1: {
                    maxSize.width = Integer.MAX_VALUE;
                }
            }
        }
        return maxSize;
    }

    public void update(Graphics g, JComponent component) {
        this.fillBackground(g, component);
        this.paint(g, component);
    }

    public void paint(Graphics g, JComponent component) {
        PaintContext context = (PaintContext)component.getClientProperty(_INTERIOR_PAINT_CONTEXT_KEY);
        UIUtils.paint(g, OracleUIUtils._getPainter(this, component), context, component);
    }

    public boolean contains(JComponent component, int x, int y) {
        return OracleUIUtils.contains(this, component, x, y);
    }

    public BorderPainter getBorderPainter(JComponent component) {
        BorderPainter painter;
        boolean isLeftmost = true;
        boolean isRightmost = true;
        int index = 0;
        if (isLeftmost) {
            index += 2;
        }
        if (isRightmost) {
            ++index;
        }
        if ((painter = this._borderPainters[index]) == null) {
            this._borderPainters[index] = painter = new OracleButtonPainter(null, isLeftmost, isRightmost);
        }
        return painter;
    }

    public static Object instantiate(UIDefaults defaults, Object key, String discriminant) {
        if (key.equals("Button.border")) {
            return new BorderAdapter(new OracleButtonPainter(null, false, false));
        }
        if ("ToggleButton.border".equals(key)) {
            return new BorderAdapter(new OracleButtonPainter(null, false, false, Boolean.TRUE));
        }
        return null;
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new OracleButtonListener(b);
    }

    protected OracleButtonUI() {
    }

    protected void fillBackground(Graphics g, JComponent c) {
        if (c.getParent() instanceof JToolBar) {
            return;
        }
        AbstractButton b = (AbstractButton)c;
        if (!b.isContentAreaFilled()) {
            return;
        }
        if (b.isBorderPainted()) {
            OracleUIUtils.fillBackground(g, c);
        } else {
            Color savedColor = g.getColor();
            g.setColor(c.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
            g.setColor(savedColor);
        }
    }

    protected PaintContext createInteriorPaintContext(JComponent component) {
        return new AbstractButtonPaintContext((AbstractButton)component, true);
    }

    protected Painter getPainter(JComponent component, boolean inToolBar) {
        if (inToolBar) {
            AbstractButton ab = (AbstractButton)component;
            Object value = ab.getClientProperty(_TEXT_POSITION_CHANGED);
            if (!Boolean.TRUE.equals(value)) {
                ab.setHorizontalTextPosition(0);
                ab.setVerticalTextPosition(3);
                ab.putClientProperty(_TEXT_POSITION_CHANGED, Boolean.TRUE);
            }
            return OracleToolBarUI.getButtonPainter((JToolBar)component.getParent(), ab);
        }
        boolean hasIcon = this._hasIcon((AbstractButton)component);
        int index = hasIcon ? 1 : 0;
        Painter painter = this._painters[index];
        if (painter == null) {
            painter = hasIcon ? new OracleFocusPainter(new MarginBorderPainter(new AlignmentPainter(new AlignedPainterJoiner(OracleUIUtils.getIconPainter(), new IconTextGapPainter(OracleUIUtils.getHTMLTextPainter()))))) : new OracleFocusPainter(new MarginBorderPainter(OracleUIUtils.getHTMLTextPainter()));
            this._painters[index] = painter;
        }
        return painter;
    }

    private boolean _hasIcon(AbstractButton button) {
        return button.getIcon() != null;
    }

    private static class TextPositionListener
    implements PropertyChangeListener {
        private TextPositionListener() {
        }

        public void propertyChange(PropertyChangeEvent pe) {
            Object component = pe.getSource();
            if (component instanceof AbstractButton) {
                AbstractButton ab = (AbstractButton)component;
                String name = pe.getPropertyName();
                if ("horizontalTextPosition".equals(name) || "verticalTextPosition".equals(name)) {
                    ab.putClientProperty(_TEXT_POSITION_CHANGED, Boolean.TRUE);
                }
            }
        }
    }
}

