/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.olaf.OracleComboBoxButton;

class OracleComboPopup
extends BasicComboPopup {
    private OracleComboBoxButton _button;
    private Object _enterAction;
    private static final int _BOTTOM = 0;
    private static final int _TOP = 1;
    private static final int _RIGHT = 2;
    private static final int _LEFT = 3;
    private static final int _TOPINSET = 3;
    private static final int _BOTTOMINSET = 3;
    private static final int _LEFTINSET = 3;
    private static final int _RIGHTINSET = 3;

    public OracleComboPopup(JComboBox combo, OracleComboBoxButton button) {
        super(combo);
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        InputMap inputMap = this.comboBox.getInputMap(1);
        this._enterAction = inputMap.get(enter);
        inputMap.remove(enter);
        KeyStroke key = KeyStroke.getKeyStroke("alt pressed ALT");
        this.getInputMap(2).put(key, "none");
        this._button = button;
    }

    void hackEscape() {
        ActionMap actionMap = this.getComboBox().getActionMap();
        actionMap.put("hidePopup", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                OracleComboPopup.this.getComboBox().setPopupVisible(false);
            }

            public boolean isEnabled() {
                return OracleComboPopup.this.isVisible();
            }
        });
    }

    protected MouseListener createListMouseListener() {
        return new MouseHandler();
    }

    protected KeyListener createKeyListener() {
        return new ComboPopupKeyHandler();
    }

    void _updateSelectedIndex() {
        this.comboBox.setSelectedIndex(this.list.getSelectedIndex());
    }

    protected JComboBox getComboBox() {
        return this.comboBox;
    }

    public void setVisible(boolean b) {
        JComboBox combo = this.getComboBox();
        if (b && (combo.getItemCount() == 0 || combo.getItemCount() == 1 && combo.getSelectedItem() == combo.getItemAt(0))) {
            return;
        }
        super.setVisible(b);
        this.comboBox.repaint();
    }

    public void show() {
        InputMap map = this.getComboBox().getInputMap(1);
        map.put(KeyStroke.getKeyStroke(10, 0), this._enterAction);
        super.show();
    }

    public void hide() {
        super.hide();
        InputMap map = this.getComboBox().getInputMap(1);
        map.remove(KeyStroke.getKeyStroke(10, 0));
    }

    public void reshape(int x, int y, int w, int h) {
        int maxWidth = this.getMaximumSize().width;
        if (w > maxWidth) {
            w = maxWidth;
        }
        super.reshape(x, y, w, h);
    }

    protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
        boolean inModalDialog;
        Container parent;
        JScrollBar scrollbar;
        Rectangle r = super.computePopupBounds(px, py, pw, ph);
        int popupDisplayWidth = r.width;
        int popupDisplayHeight = r.height;
        int x = px;
        int y = py;
        JViewport viewport = this.scroller.getViewport();
        int preferredWidth = (viewport != null ? viewport.getPreferredSize().width : 0) + ((scrollbar = this.scroller.getVerticalScrollBar()) != null ? scrollbar.getPreferredSize().width : 0);
        if (r.width < preferredWidth) {
            r.width = preferredWidth;
        }
        for (parent = this.comboBox.getParent(); parent != null && !(parent instanceof Dialog) && !(parent instanceof Window); parent = parent.getParent()) {
        }
        boolean bl = inModalDialog = parent instanceof Dialog && ((Dialog)parent).isModal();
        if (inModalDialog) {
            Dialog parentDialog = (Dialog)parent;
            Rectangle dialogBounds = parentDialog instanceof JDialog ? ((JDialog)parentDialog).getRootPane().getBounds() : parentDialog.getBounds();
            Rectangle comboBounds = this.comboBox.getBounds();
            Insets dialogInsets = parentDialog instanceof JDialog ? ((JDialog)parentDialog).getRootPane().getInsets() : parentDialog.getInsets();
            Insets comboInsets = this.comboBox.getInsets();
            comboBounds = SwingUtilities.convertRectangle(this.comboBox.getParent(), comboBounds, parentDialog);
            boolean horizontal = false;
            Dimension bottomArea = new Dimension(dialogBounds.width - (dialogInsets.left + dialogInsets.right + 3 + 3), dialogBounds.y + dialogBounds.height - (dialogInsets.top + dialogInsets.bottom + 3 + 3 + comboBounds.y + comboBounds.height));
            Dimension topArea = new Dimension(dialogBounds.width - (dialogInsets.left + dialogInsets.right + 3 + 3), comboBounds.y - dialogBounds.y);
            Dimension rightArea = new Dimension(dialogBounds.x + dialogBounds.width - (dialogInsets.left + dialogInsets.right + 3 + 3 + comboBounds.x + comboBounds.width), dialogBounds.height - (dialogInsets.top + dialogInsets.bottom + 3 + 3));
            Dimension leftArea = new Dimension(comboBounds.x - (dialogInsets.left + 3 + dialogBounds.x + comboInsets.left), dialogBounds.height - (dialogInsets.top + dialogInsets.bottom + 3 + 3));
            int[] area = new int[]{Math.min(bottomArea.width, popupDisplayWidth) * Math.min(bottomArea.height, popupDisplayHeight), Math.min(topArea.width, popupDisplayWidth) * Math.min(topArea.height, popupDisplayHeight), Math.min(rightArea.width, popupDisplayWidth) * Math.min(rightArea.height, popupDisplayHeight), Math.min(leftArea.width, popupDisplayWidth) * Math.min(leftArea.height, popupDisplayHeight)};
            int maxArea = area[0];
            int pos = 0;
            for (int i = 1; i < area.length; ++i) {
                if (maxArea >= area[i]) continue;
                maxArea = area[i];
                pos = i;
            }
            if (pos == 0) {
                horizontal = false;
                popupDisplayWidth = Math.min(bottomArea.width, r.width);
                popupDisplayHeight = Math.min(bottomArea.height, r.height);
                y = comboBounds.height;
            } else if (pos == 1) {
                horizontal = false;
                popupDisplayWidth = Math.min(topArea.width, r.width);
                popupDisplayHeight = Math.min(topArea.height, r.height);
                y = -popupDisplayHeight;
            } else if (pos == 2) {
                horizontal = true;
                popupDisplayWidth = Math.min(rightArea.width, r.width);
                popupDisplayHeight = Math.min(rightArea.height, r.height);
                x = comboBounds.width;
            } else if (pos == 3) {
                horizontal = true;
                popupDisplayWidth = Math.min(leftArea.width, r.width);
                popupDisplayHeight = Math.min(leftArea.height, r.height);
                x = -(popupDisplayWidth + comboInsets.left + comboInsets.right);
            }
            if (horizontal) {
                int usableTopHeight;
                int usableBottomHeight = Math.min(bottomArea.height + comboBounds.height, popupDisplayHeight);
                y = usableBottomHeight >= (usableTopHeight = Math.min(topArea.height + comboBounds.height, popupDisplayHeight)) ? usableBottomHeight - popupDisplayHeight : comboBounds.height - usableTopHeight;
            } else {
                int usableLeftWidth;
                int usableRightWidth = Math.min(rightArea.width + comboBounds.width, popupDisplayWidth);
                x = usableRightWidth > (usableLeftWidth = Math.min(leftArea.width + comboBounds.width, popupDisplayWidth)) ? usableRightWidth - popupDisplayWidth : comboBounds.width - (usableLeftWidth + 3 + 3);
            }
        }
        r.width = popupDisplayWidth;
        r.height = popupDisplayHeight;
        r.x = x;
        r.y = y;
        return r;
    }

    class ComboPopupKeyHandler
    extends BasicComboPopup.InvocationKeyHandler {
        ComboPopupKeyHandler() {
            super(OracleComboPopup.this);
        }

        public void keyReleased(KeyEvent e) {
            if (!OracleComboPopup.this.getComboBox().isEditable()) {
                super.keyReleased(e);
            }
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mouseReleased(MouseEvent anEvent) {
            OracleComboPopup.this._updateSelectedIndex();
            OracleComboPopup.this.getComboBox().setPopupVisible(false);
            Component editor = OracleComboPopup.this.getComboBox().getEditor().getEditorComponent();
            if (OracleComboPopup.this.getComboBox().isEditable() && editor instanceof JTextComponent) {
                ((JTextComponent)editor).selectAll();
            }
        }
    }
}

