/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.UIDefaults;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.NullPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.plaf.BorderAdapter;
import oracle.bali.ewt.util.ImmInsets;

public class OracleGroupBoxPainter
extends AbstractBorderPainter {
    public static final int TOP_SIDE = 0;
    public static final int LEFT_SIDE = 1;
    public static final int BOTTOM_SIDE = 2;
    public static final int RIGHT_SIDE = 3;
    private static final int _LABEL_INSET = 10;
    private static final int _BORDER_INSET = 3;
    private static final int _CORNER_INSET = 3;
    private Painter _labelPainter;
    private float _alignment;
    private int _side;

    public static Object instantiate(UIDefaults defaults, Object key, String discriminant) {
        if (key.equals("TitledBorder.border")) {
            return new BorderAdapter(new OracleGroupBoxPainter());
        }
        return null;
    }

    public OracleGroupBoxPainter() {
        this(null, null);
    }

    public OracleGroupBoxPainter(Painter wrappedPainter, Painter labelPainter) {
        this(wrappedPainter, labelPainter, 0.0f);
    }

    public OracleGroupBoxPainter(Painter wrappedPainter, Painter labelPainter, float alignment) {
        this(wrappedPainter, labelPainter, alignment, 0);
    }

    public OracleGroupBoxPainter(Painter wrappedPainter, Painter labelPainter, float alignment, int side) {
        super(wrappedPainter);
        if (labelPainter == null) {
            labelPainter = NullPainter.getPainter();
        }
        this._labelPainter = labelPainter;
        this._alignment = alignment;
        this._side = side;
    }

    protected ImmInsets getOwnInsets(PaintContext context) {
        int top = 3;
        int left = 3;
        int bottom = 3;
        int right = 3;
        Dimension labelSize = this._labelPainter.getPreferredSize(context);
        switch (this._side) {
            case 0: {
                if (top >= labelSize.height) break;
                top = labelSize.height;
                break;
            }
            case 1: {
                if (left >= labelSize.width) break;
                left = labelSize.width;
                break;
            }
            case 2: {
                if (bottom >= labelSize.height) break;
                bottom = labelSize.height;
                break;
            }
            case 3: {
                if (right >= labelSize.width) break;
                right = labelSize.width;
            }
        }
        return new ImmInsets(top, left, bottom, right);
    }

    public void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Rectangle labelBounds = this._getLabelBounds(context, x, y, width, height);
        Color savedColor = g.getColor();
        UIDefaults defaults = context.getPaintUIDefaults();
        g.setColor(defaults.getColor("controlText"));
        this._labelPainter.paint(context, g, labelBounds.x, labelBounds.y, labelBounds.width, labelBounds.height);
        g.setColor(defaults.getColor("TitledBorder.lineColor"));
        int right = x + width - 1;
        int bottom = y + height - 1;
        int side = this._side;
        if (side == 0 || side == 2) {
            int offset = labelBounds.height / 2;
            int lineY = side == 0 ? (y += offset) : (bottom -= offset);
            g.drawLine(x + 3, lineY, labelBounds.x, lineY);
            g.drawLine(labelBounds.x + labelBounds.width, lineY, right - 3, lineY);
        } else {
            int offset = labelBounds.width / 2;
            int lineX = side == 1 ? (x += offset) : (right -= offset);
            g.drawLine(lineX, y + 3, lineX, labelBounds.y);
            g.drawLine(lineX, labelBounds.y + labelBounds.height, lineX, bottom - 3);
        }
        g.drawLine(x, y + 3, x + 3, y);
        g.drawLine(x + 1, y + 1, x + 1, y + 1);
        g.drawLine(right - 3, y, right, y + 3);
        g.drawLine(right - 1, y + 1, right - 1, y + 1);
        g.drawLine(x, bottom - 3, x + 3, bottom);
        g.drawLine(x + 1, bottom - 1, x + 1, bottom - 1);
        g.drawLine(right - 3, bottom, right, bottom - 3);
        g.drawLine(right - 1, bottom - 1, right - 1, bottom - 1);
        if (side != 0) {
            g.drawLine(x + 3, y, right - 3, y);
        }
        if (side != 1) {
            g.drawLine(x, y + 3, x, bottom - 3);
        }
        if (side != 2) {
            g.drawLine(x + 3, bottom, right - 3, bottom);
        }
        if (side != 3) {
            g.drawLine(right, y + 3, right, bottom - 3);
        }
        g.setColor(savedColor);
    }

    protected Painter getBorderPainterAt(PaintContext context, int availableWidth, int availableHeight, int x, int y, Painter proxyPainter) {
        Rectangle labelBounds = this._getLabelBounds(context, x, y, availableWidth, availableHeight);
        Painter painterAt = this._labelPainter.getPainterAt(context, labelBounds.width, labelBounds.height, x - labelBounds.x, y - labelBounds.y, proxyPainter);
        if (proxyPainter == this && painterAt != null) {
            painterAt = this;
        }
        return painterAt;
    }

    public boolean isBorderTransparent(PaintContext context) {
        return true;
    }

    public int getRepaintFlags(PaintContext context) {
        return this._labelPainter.getRepaintFlags(context);
    }

    public int getInvalidateFlags(PaintContext context) {
        return this._labelPainter.getInvalidateFlags(context);
    }

    private Rectangle _getLabelBounds(PaintContext context, int x, int y, int availableWidth, int availableHeight) {
        Rectangle labelBounds = new Rectangle();
        Dimension labelSize = this._labelPainter.getPreferredSize(context);
        int labelWidth = labelSize.width;
        int labelHeight = labelSize.height;
        int labelOffset = 0;
        int side = this._side;
        if (side == 0 || side == 2) {
            if (labelHeight < 3) {
                labelOffset = 1;
            }
            int n = side == 0 ? labelOffset : (labelBounds.y = availableHeight - (labelOffset == 0 ? labelHeight : labelOffset));
            if ((availableWidth -= 20) < labelWidth) {
                labelWidth = availableWidth;
                labelBounds.x = 10;
            } else {
                labelBounds.x = 10 + (int)((float)(availableWidth - labelWidth) * this._alignment);
            }
        } else {
            if (labelWidth < 3) {
                labelOffset = 1;
            }
            int n = side == 1 ? labelOffset : (labelBounds.x = availableWidth - (labelOffset == 0 ? labelWidth : labelOffset));
            if ((availableHeight -= 20) < labelHeight) {
                labelHeight = availableHeight;
                labelBounds.y = 10;
            } else {
                labelBounds.y = 10 + (int)((float)(availableHeight - labelHeight) * this._alignment);
            }
        }
        labelBounds.x += x;
        labelBounds.y += y;
        labelBounds.width = labelWidth;
        labelBounds.height = labelHeight;
        return labelBounds;
    }
}

