/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.olaf.OracleCaret;
import oracle.bali.ewt.olaf.OracleTextFieldUI;
import oracle.bali.ewt.olaf.OracleUIUtils;

public class OracleTextAreaUI
extends BasicTextAreaUI {
    private static Key _sKey = new Key();

    public static ComponentUI createUI(JComponent component) {
        return new OracleTextAreaUI();
    }

    public void installUI(JComponent component) {
        super.installUI(component);
        component.setOpaque(true);
        OracleTextFieldUI.__initializeBackground(component);
        OracleUIUtils.putPaintContext(component);
    }

    public void uninstallUI(JComponent component) {
        super.uninstallUI(component);
        OracleUIUtils.removePaintContext(component);
    }

    public void update(Graphics g, JComponent component) {
        if (component.isOpaque()) {
            OracleUIUtils.fillBackground(g, component);
        }
        this.paint(g, component);
    }

    protected void paintBackground(Graphics g) {
    }

    protected void installListeners() {
        super.installListeners();
        this.getComponent().addKeyListener(_sKey);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.getComponent().removeKeyListener(_sKey);
    }

    protected void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        OracleTextFieldUI.__fixBackground(e, "TextArea.background");
    }

    protected Caret createCaret() {
        return new OracleCaret();
    }

    private OracleTextAreaUI() {
    }

    private static class Key
    extends KeyAdapter {
        private Key() {
        }

        private void _forceCaretOn(KeyEvent event) {
            if (event.getComponent() instanceof JTextComponent) {
                ((JTextComponent)event.getComponent()).getCaret().setVisible(true);
            }
        }

        public void keyPressed(KeyEvent event) {
            this._forceCaretOn(event);
        }

        public void keyTyped(KeyEvent event) {
            this._forceCaretOn(event);
        }
    }
}

