/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf2;

import java.awt.Font;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

final class HTMLLabel
extends JEditorPane {
    public HTMLLabel() {
        this.configureTextPane();
    }

    public boolean isFocusable() {
        return false;
    }

    private void configureTextPane() {
        this.setEditorKit(new RichHintLabelEditorKit());
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setEditable(false);
        this.setOpaque(false);
        this.setCaret(new DefaultCaret(){

            public void setSelectionVisible(boolean vis) {
                super.setSelectionVisible(false);
            }
        });
    }

    private static String displayPropertiesToCSS(Font font) {
        StringBuilder rule = new StringBuilder("body {");
        if (font != null) {
            rule.append(" font-family: ");
            rule.append(font.getFamily());
            rule.append(" ; ");
            rule.append(" font-size: ");
            rule.append(font.getSize());
            rule.append("pt ;");
            if (font.isBold()) {
                rule.append(" font-weight: 700 ; ");
            }
            if (font.isItalic()) {
                rule.append(" font-style: italic ; ");
            }
        }
        rule.append(" }");
        return rule.toString();
    }

    private static class RichHintLabelEditorKit
    extends HTMLEditorKit {
        private static StyleSheet _defaultStyles;

        private RichHintLabelEditorKit() {
        }

        public StyleSheet getStyleSheet() {
            if (_defaultStyles == null) {
                _defaultStyles = new StyleSheet();
                _defaultStyles.addStyleSheet(super.getStyleSheet());
                _defaultStyles.addStyleSheet(this.createStyleSheetFromString("a {color: 2255BA; text-decoration:none}"));
                _defaultStyles.addStyleSheet(this.createStyleSheetFromString("p { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }"));
                _defaultStyles.addStyleSheet(this.createStyleSheetFromString(HTMLLabel.displayPropertiesToCSS(new JLabel().getFont())));
            }
            return _defaultStyles;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private StyleSheet createStyleSheetFromString(String s) {
            StyleSheet ss = new StyleSheet();
            StringReader r = null;
            try {
                r = new StringReader(s);
                ss.loadRules(r, null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (r != null) {
                    r.close();
                }
            }
            return ss;
        }

        public Document createDefaultDocument() {
            StyleSheet styles = this.getStyleSheet();
            StyleSheet ss = new StyleSheet();
            ss.addStyleSheet(styles);
            return new MyDocument(ss);
        }
    }

    private static class MyDocument
    extends HTMLDocument {
        MyDocument(StyleSheet s) {
            super(s);
            this.setAsynchronousLoadPriority(Integer.MAX_VALUE);
        }
    }
}

