/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf2;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLabelUI;

public class OracleLabelUI
extends MetalLabelUI {
    private static final String _ENABLED_PROPERTY = "enabled";
    private static final OracleLabelUI _INSTANCE = new OracleLabelUI();
    private static Listener _sListener;

    public static ComponentUI createUI(JComponent c) {
        return _INSTANCE;
    }

    protected void uninstallListeners(JLabel label) {
        super.uninstallListeners(label);
        Component labelFor = label.getLabelFor();
        if (labelFor instanceof JComponent) {
            this.uninstallEnableListener((JComponent)labelFor);
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        if ("labelFor".equals(e.getPropertyName())) {
            Object newComp;
            Object oldComp = e.getOldValue();
            if (oldComp instanceof JComponent) {
                this.uninstallEnableListener((JComponent)oldComp);
            }
            if ((newComp = e.getNewValue()) instanceof JComponent) {
                JComponent newLabelFor = (JComponent)newComp;
                this.installEnableListener(newLabelFor);
                JLabel label = (JLabel)e.getSource();
                label.setEnabled(newLabelFor.isEnabled());
            }
        }
    }

    private void installEnableListener(JComponent comp) {
        if (_sListener == null) {
            _sListener = new Listener();
        }
        comp.addPropertyChangeListener(_ENABLED_PROPERTY, _sListener);
    }

    private void uninstallEnableListener(JComponent comp) {
        if (_sListener != null) {
            comp.removePropertyChangeListener(_ENABLED_PROPERTY, _sListener);
        }
    }

    private class Listener
    implements PropertyChangeListener {
        private static final String _LABELED_BY_PROPERTY = "labeledBy";

        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent pe) {
            JComponent comp = (JComponent)pe.getSource();
            JLabel label = (JLabel)comp.getClientProperty(_LABELED_BY_PROPERTY);
            if (label != null) {
                label.setEnabled(Boolean.TRUE.equals(pe.getNewValue()));
            }
        }
    }
}

