/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf2;

import com.jgoodies.looks.plastic.PlasticScrollPaneUI;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.plaf.ComponentUI;

public class OracleScrollPaneUI
extends PlasticScrollPaneUI {
    private Listener _listener;
    private MouseWheelListener _mouseWheelLis;

    public static ComponentUI createUI(JComponent b) {
        return new OracleScrollPaneUI();
    }

    public void installListeners(JScrollPane pane) {
        super.installListeners(pane);
        this._listener = new Listener();
        this._addScrollBar(null, this.scrollpane.getVerticalScrollBar());
        this._addScrollBar(null, this.scrollpane.getHorizontalScrollBar());
        pane.addPropertyChangeListener(this._listener);
        this._updateMouseWheelScrolling();
    }

    protected void uninstallListeners(JComponent pane) {
        super.uninstallListeners(pane);
        pane.removePropertyChangeListener(this._listener);
        this._addScrollBar(this.scrollpane.getVerticalScrollBar(), null);
        this._addScrollBar(this.scrollpane.getHorizontalScrollBar(), null);
        this._mouseWheelLis = null;
        this._listener = null;
    }

    protected MouseWheelListener createMouseWheelListener() {
        this._mouseWheelLis = super.createMouseWheelListener();
        return this._mouseWheelLis;
    }

    private void _addScrollBar(JScrollBar oldBar, JScrollBar newBar) {
        if (oldBar != null) {
            oldBar.removeComponentListener(this._listener);
        }
        if (newBar != null) {
            newBar.addComponentListener(this._listener);
        }
    }

    private void _updateMouseWheelScrolling() {
        JScrollBar vsb = this.scrollpane.getVerticalScrollBar();
        JScrollBar hsb = this.scrollpane.getHorizontalScrollBar();
        if (!(this.scrollpane.isWheelScrollingEnabled() && (vsb != null || hsb != null) && (vsb != null && vsb.isVisible() || hsb != null && hsb.isVisible()))) {
            this.scrollpane.removeMouseWheelListener(this._mouseWheelLis);
        } else if (!this._isMouseWheelAlreadyAdded()) {
            this.scrollpane.addMouseWheelListener(this._mouseWheelLis);
        }
    }

    private boolean _isMouseWheelAlreadyAdded() {
        MouseWheelListener[] listeners;
        for (MouseWheelListener l : listeners = this.scrollpane.getMouseWheelListeners()) {
            if (l != this._mouseWheelLis) continue;
            return true;
        }
        return false;
    }

    private class Listener
    extends ComponentAdapter
    implements PropertyChangeListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent pe) {
            String propertyName = pe.getPropertyName();
            if (propertyName == "verticalScrollBar") {
                OracleScrollPaneUI.this._addScrollBar((JScrollBar)pe.getOldValue(), (JScrollBar)pe.getNewValue());
            } else if (propertyName == "horizontalScrollBar") {
                OracleScrollPaneUI.this._addScrollBar((JScrollBar)pe.getOldValue(), (JScrollBar)pe.getNewValue());
            } else if ("wheelScrollingEnabled".equals(propertyName)) {
                OracleScrollPaneUI.this._updateMouseWheelScrolling();
            }
        }

        public void componentShown(ComponentEvent e) {
            OracleScrollPaneUI.this._updateMouseWheelScrolling();
        }

        public void componentHidden(ComponentEvent e) {
            OracleScrollPaneUI.this._updateMouseWheelScrolling();
        }
    }
}

