/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.painter;

import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;

public class DirectionalBorderPainter
extends AbstractBorderPainter {
    private ImmInsets _insets;
    private ImmInsets _rightToLeftInsets;

    public DirectionalBorderPainter(int top, int left, int bottom, int right) {
        this._init(top, left, bottom, right);
    }

    public DirectionalBorderPainter(Painter wrappedPainter, int top, int left, int bottom, int right) {
        super(wrappedPainter);
        this._init(top, left, bottom, right);
    }

    public DirectionalBorderPainter(Painter wrappedPainter, int top, int left, int bottom, int right, boolean alwaysAddBorder) {
        super(wrappedPainter, alwaysAddBorder);
        this._init(top, left, bottom, right);
    }

    protected ImmInsets getOwnInsets(PaintContext context) {
        if (context.getReadingDirection() == 2) {
            return this._getRightToLeftInsets();
        }
        return this._insets;
    }

    protected boolean isBorderTransparent(PaintContext context) {
        ImmInsets insets = this._insets;
        return insets.top != 0 || insets.left != 0 || insets.bottom != 0 || insets.right != 0;
    }

    public int getRepaintFlags(PaintContext context) {
        return super.getRepaintFlags(context) | 0x4000;
    }

    public int getInvalidateFlags(PaintContext context) {
        return super.getInvalidateFlags(context) | 0x4000;
    }

    private void _init(int top, int left, int bottom, int right) {
        this._insets = new ImmInsets(top, left, bottom, right);
    }

    private ImmInsets _getRightToLeftInsets() {
        if (this._rightToLeftInsets == null) {
            ImmInsets insets = this._insets;
            this._rightToLeftInsets = new ImmInsets(insets.top, insets.right, insets.bottom, insets.left);
        }
        return this._rightToLeftInsets;
    }
}

