/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.painter;

import java.awt.Dimension;
import java.awt.Graphics;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

public class PainterStacker
extends AbstractPainter {
    private Painter _topPainter;
    private Painter _bottomPainter;

    public PainterStacker(Painter bottomPainter, Painter topPainter) {
        this._bottomPainter = bottomPainter;
        this._topPainter = topPainter;
    }

    public Dimension getSize(PaintContext context, int availableWidth, int availableHeight) {
        return this._getMaxCombinedSize(this._topPainter.getSize(context, availableWidth, availableHeight), this._bottomPainter.getSize(context, availableWidth, availableHeight));
    }

    public Dimension getPreferredSize(PaintContext context) {
        return this._getMaxCombinedSize(this._topPainter.getPreferredSize(context), this._bottomPainter.getPreferredSize(context));
    }

    public Dimension getMinimumSize(PaintContext context) {
        return this._getMaxCombinedSize(this._topPainter.getMinimumSize(context), this._bottomPainter.getMinimumSize(context));
    }

    public Dimension getMaximumSize(PaintContext context) {
        return this._getMinCombinedSize(this._topPainter.getMaximumSize(context), this._bottomPainter.getMaximumSize(context));
    }

    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        if (this._topPainter.isTransparent(context)) {
            this._bottomPainter.paint(context, g, x, y, width, height);
        }
        this._topPainter.paint(context, g, x, y, width, height);
    }

    public Painter getPainterAt(PaintContext context, int availableWidth, int availableHeight, int x, int y, Painter proxyPainter) {
        Painter containedPainter = this._topPainter.getPainterAt(context, availableWidth, availableHeight, x, y, proxyPainter);
        if (containedPainter == null) {
            containedPainter = this._bottomPainter.getPainterAt(context, availableWidth, availableHeight, x, y, proxyPainter);
        }
        if (containedPainter == this && containedPainter != null) {
            containedPainter = this;
        }
        return containedPainter;
    }

    public boolean isTransparent(PaintContext context) {
        return this._bottomPainter.isTransparent(context) && this._topPainter.isTransparent(context);
    }

    public int getRepaintFlags(PaintContext context) {
        int repaintFlags = this._topPainter.getRepaintFlags(context);
        if (this._topPainter.isTransparent(context)) {
            repaintFlags |= this._bottomPainter.getRepaintFlags(context);
        }
        return repaintFlags;
    }

    public int getInvalidateFlags(PaintContext context) {
        return this._topPainter.getInvalidateFlags(context) | this._bottomPainter.getInvalidateFlags(context);
    }

    private Dimension _getMaxCombinedSize(Dimension topSize, Dimension bottomSize) {
        if (topSize.width < bottomSize.width) {
            topSize.width = bottomSize.width;
        }
        if (topSize.height < bottomSize.height) {
            topSize.height = bottomSize.height;
        }
        return topSize;
    }

    private Dimension _getMinCombinedSize(Dimension topSize, Dimension bottomSize) {
        if (topSize.width > bottomSize.width) {
            topSize.width = bottomSize.width;
        }
        if (topSize.height > bottomSize.height) {
            topSize.height = bottomSize.height;
        }
        return topSize;
    }
}

