/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.painter;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import oracle.bali.ewt.graphics.GraphicUtils;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.util.StringUtils;

public class TextPainter
extends AbstractPainter {
    private boolean _supportMnemonics;
    private Object _dataKey;

    public TextPainter() {
        this._init(PaintContext.LABEL_KEY, true);
    }

    public TextPainter(Object dataKey) {
        this._init(dataKey, true);
    }

    public TextPainter(Object dataKey, boolean supportMnemonics) {
        this._init(dataKey, supportMnemonics);
    }

    public Dimension getSize(PaintContext context, int availableWidth, int availableHeight) {
        Dimension minimumSize = this.getPreferredSize(context);
        if (this.getAlignmentX(context) != 0.0f && minimumSize.width < availableWidth) {
            minimumSize.width = availableWidth;
        }
        if (this.getAlignmentY(context) != 0.0f && minimumSize.height < availableHeight) {
            minimumSize.height = availableHeight;
        }
        return minimumSize;
    }

    public Dimension getPreferredSize(PaintContext context) {
        return this._getSize(context, true);
    }

    public Dimension getMinimumSize(PaintContext context) {
        return this._getSize(context, false);
    }

    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        int textLength;
        String text;
        FontMetrics metrics = g.getFontMetrics();
        if (metrics != null && (text = this.getStringData(context)) != null && (textLength = text.length()) != 0) {
            Object mnemonic;
            int stringHeight;
            float alignmentX = this.getAlignmentX(context);
            int numLines = TextPainter._getNumberOfTextLines(text);
            float alignmentY = this.getAlignmentY(context);
            if (alignmentY != 0.0f && (stringHeight = numLines * metrics.getHeight()) < height) {
                y = (int)((float)y + (float)(height - stringHeight) * alignmentY);
            }
            y += metrics.getAscent();
            int mnemonicIndex = -1;
            if (this._supportMnemonics && (mnemonic = context.getPaintData(PaintContext.MNEMONIC_INDEX_KEY)) != null && mnemonic instanceof Integer) {
                mnemonicIndex = (Integer)mnemonic;
            }
            if (numLines == 1 && text.charAt(textLength - 1) != '\n') {
                this.paintText(context, g, metrics, text, x, y, width, alignmentX, mnemonicIndex);
            } else {
                int lastIndex;
                int currIndex = -1;
                int lineHeight = metrics.getHeight();
                while ((lastIndex = currIndex + 1) < textLength) {
                    currIndex = text.indexOf(10, lastIndex);
                    if (currIndex == -1) {
                        currIndex = textLength;
                    }
                    this.paintText(context, g, metrics, text.substring(lastIndex, currIndex), x, y, width, alignmentX, mnemonicIndex - lastIndex);
                    y += lineHeight;
                }
            }
        }
    }

    public boolean isTransparent(PaintContext context) {
        return true;
    }

    public int getRepaintFlags(PaintContext context) {
        return 19328;
    }

    public int getInvalidateFlags(PaintContext context) {
        return 384;
    }

    protected String getPaintText(PaintContext context, String text, FontMetrics metrics, int availableWidth) {
        return text;
    }

    protected String getStringData(PaintContext context) {
        return (String)this.getData(context);
    }

    protected String getMinimumStringData(PaintContext context) {
        return this.getStringData(context);
    }

    protected Object getData(PaintContext context) {
        Object data = super.getData(context);
        if (data != null) {
            return data.toString();
        }
        return null;
    }

    protected Object getDataKey() {
        return this._dataKey;
    }

    private Dimension _getSize(PaintContext context, boolean usePreferredSize) {
        int width = 0;
        int height = 0;
        Font font = context.getPaintFont();
        if (font != null) {
            String text;
            FontMetrics metrics = context.getFontMetrics(font);
            String string = text = usePreferredSize ? this.getStringData(context) : this.getMinimumStringData(context);
            if (metrics != null && text != null) {
                int numLines = TextPainter._getNumberOfTextLines(text);
                if (numLines == 1) {
                    text = StringUtils.getDisplayString(text, context);
                    width = metrics.stringWidth(text);
                } else {
                    width = TextPainter._getMaxLineWidth(context, text, metrics);
                }
                height = numLines * metrics.getHeight() - metrics.getLeading();
            }
        }
        return new Dimension(width, height);
    }

    private static final int _getNumberOfTextLines(String text) {
        int currIndex;
        int numLines = 0;
        int foundIndex = -1;
        int textLength = text.length();
        while ((currIndex = foundIndex + 1) != textLength) {
            foundIndex = text.indexOf(10, currIndex);
            ++numLines;
            if (foundIndex != -1) continue;
        }
        return numLines;
    }

    private static final int _getMaxLineWidth(PaintContext context, String text, FontMetrics metrics) {
        int lastIndex;
        int maxWidth = 0;
        int currIndex = -1;
        int textLength = text.length();
        while ((lastIndex = currIndex + 1) < textLength) {
            String subtext;
            int currWidth;
            currIndex = text.indexOf(10, lastIndex);
            if (currIndex == -1) {
                currIndex = textLength;
            }
            if (maxWidth >= (currWidth = metrics.stringWidth(subtext = StringUtils.getDisplayString(text.substring(lastIndex, currIndex), context)))) continue;
            maxWidth = currWidth;
        }
        return maxWidth;
    }

    protected int paintText(PaintContext context, Graphics g, FontMetrics metrics, String text, int x, int y, int availableWidth, float alignmentX, int mnemonicIndex) {
        int stringWidth;
        text = StringUtils.getDisplayString(text, context);
        String paintText = this.getPaintText(context, text, metrics, availableWidth);
        if (alignmentX != 0.0f && (stringWidth = metrics.stringWidth(paintText)) < availableWidth) {
            x = (int)((float)x + (float)(availableWidth - stringWidth) * alignmentX);
        }
        this.drawString(context, g, paintText, x, y);
        if (mnemonicIndex >= 0 && mnemonicIndex < paintText.length()) {
            int mnemonicX = x;
            if (mnemonicIndex > 0) {
                mnemonicX += metrics.stringWidth(paintText.substring(0, mnemonicIndex));
            }
            g.drawLine(mnemonicX + 1, y + 1, mnemonicX + metrics.charWidth(paintText.charAt(mnemonicIndex)) - 2, y + 1);
        }
        return x;
    }

    protected void drawString(PaintContext context, Graphics g, String paintText, int x, int y) {
        GraphicUtils.drawString(g, paintText, x, y);
    }

    protected float getAlignmentX(PaintContext context) {
        return context.getInteriorAlignmentX();
    }

    protected float getAlignmentY(PaintContext context) {
        return context.getInteriorAlignmentY();
    }

    private void _init(Object dataKey, boolean supportMnemonics) {
        this._dataKey = dataKey;
        this._supportMnemonics = supportMnemonics;
    }
}

