/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterGraphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import oracle.bali.ewt.elaf.EWTPivotHeaderGridUI;
import oracle.bali.ewt.elaf.EWTPivotHeaderHeaderUI;
import oracle.bali.ewt.elaf.EWTPivotHeaderUI;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.geometry.AbstractWrappingGeometryManager;
import oracle.bali.ewt.geometry.GeometryManager;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.AppearanceManager;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.ComplexAppearanceManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.SingleAppearanceManager;
import oracle.bali.ewt.grid.bigCell.AbstractBigCell;
import oracle.bali.ewt.grid.bigCell.BigCellGridKeyHandler;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderEvent;
import oracle.bali.ewt.model.NullOneDModel;
import oracle.bali.ewt.model.NullTwoDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.model.TwoDModelAdapter;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.AbstractWrappingPainter;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.FixedBorderPainter;
import oracle.bali.ewt.painter.ImagePainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.PainterJoiner;
import oracle.bali.ewt.painter.TruncatingTextPainter;
import oracle.bali.ewt.pivot.AbstractPivotHeaderCell;
import oracle.bali.ewt.pivot.AbstractPivotHeaderHeaderItem;
import oracle.bali.ewt.pivot.CollapseEvent;
import oracle.bali.ewt.pivot.CollapseListener;
import oracle.bali.ewt.pivot.DrillEvent;
import oracle.bali.ewt.pivot.DrillListener;
import oracle.bali.ewt.pivot.GridResizer;
import oracle.bali.ewt.pivot.JDKPivotDragDropAdapter;
import oracle.bali.ewt.pivot.LevelHighlighter;
import oracle.bali.ewt.pivot.PivotDragDropAdapter;
import oracle.bali.ewt.pivot.PivotHeaderAppearMgr;
import oracle.bali.ewt.pivot.PivotHeaderGridSelectionManager;
import oracle.bali.ewt.pivot.PivotHeaderHeaderInputHandler;
import oracle.bali.ewt.pivot.PivotHeaderInputHandler;
import oracle.bali.ewt.pivot.PivotHeaderPainter;
import oracle.bali.ewt.pivot.PivotScrollPaneView;
import oracle.bali.ewt.pivot.PivotTable;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.CellRange;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.share.collection.Range;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.util.IntegerUtils;

public class PivotHeader
extends SpreadTable {
    public static final String KEY_OUTLINE = "pivotheader.outline";
    public static final String KEY_HORIZONTAL = "pivotheader.horizontal";
    static final String _RESOURCE_BUNDLE = "oracle.bali.ewt.resource.AccessibilityBundle";
    static final String _DRILL_KEY = "DRILL";
    static final String _COLLAPSE_KEY = "COLLAPSE";
    private static final int _PIVOT_FEEDBACK_SIZE = 4;
    private static final int _PIVOT_SIZE = 6;
    int mouseItem = -1;
    int _dropIndex = -1;
    int _dragIndex = -1;
    int _highlightItem = -1;
    boolean _swapping;
    private int _resizeItem = -1;
    private Image _drillImage;
    private Image _drilledImage;
    private int _orientation;
    private boolean _dragEnabled = true;
    private DrillListener _drillListener;
    private CollapseListener _collapseListener;
    private TwoDModelAdapter _hListener;
    private TwoDModelAdapter _vListener;
    private PivotTable _pivotTable;
    private boolean _drilling;
    private boolean _needToValidateMinSize;
    int _minSize;
    private int _headerResizeItem = -1;
    private boolean _traversable;
    private boolean _displayDrillImages = true;
    private boolean _axisLabelsVisible;
    private boolean _jdkDnD;
    private Painter _axisLabelPainter;
    private GridResizer _gridResizer;
    private LevelHighlighter _levelHighlighter;
    private PivotDragDropAdapter _dragDropSupport;
    private JDKPivotDragDropAdapter _jdkDragDropSupport;
    private JViewport _viewport;
    private boolean[] _resizeArr;
    private SelectionListener _selectionListener;
    private boolean _canSelectGrid = true;

    public PivotHeader() {
        this(NullTwoDModel.getTwoDModel(), 1);
    }

    public PivotHeader(TwoDModel ds, int orientation) {
        this._orientation = orientation;
        this._hListener = new _HListen();
        this._vListener = new _VListen();
        if (this._isHorizontal()) {
            this.setRowGeometryManager(super.getRowGeometryManager());
        } else {
            this.setColumnGeometryManager(super.getColumnGeometryManager());
        }
        Grid grid = this.getGrid();
        grid.setCellBorderVisible(false);
        this._selectionListener = new SelectionListener();
        grid.addVetoableChangeListener(this._selectionListener);
        if (ds == null) {
            this.setVisible(false);
        }
        this.setModel(ds);
        Header header = this._isHorizontal() ? this.getRowHeader() : this.getColumnHeader();
        header.setCanResizeItems(true);
        header.setCanMoveItems(false);
        PivotHeaderHeaderInputHandler pivotHeaderHeaderInputHandler = new PivotHeaderHeaderInputHandler(this);
        header.setItemInputHandler(pivotHeaderHeaderInputHandler);
        header.setHeaderKeyHandler(pivotHeaderHeaderInputHandler);
        header.setScrollByItem(false);
        this._gridResizer = new GridResizer(this);
        this._levelHighlighter = new LevelHighlighter(this);
        this._dragDropSupport = new PivotDragDropAdapter(this);
        Painter p = this.getPivotHeaderUI().getDefaultHeaderItemPainter(this, !this._isHorizontal());
        header.setDefaultPainter(p);
        PivotHeaderPainter painter = new PivotHeaderPainter(this);
        grid.setDefaultPainter(painter);
        grid.setVerticalSeparatorsVisible(false);
        grid.setHorizontalSeparatorsVisible(false);
        this.setInputHandler(new PivotHeaderInputHandler());
        grid.setGridSelectionManager(new PivotHeaderGridSelectionManager(grid, this._isHorizontal()));
        grid.setGridKeyHandler(BigCellGridKeyHandler.getGridKeyHandler());
        SingleAppearanceManager a = (SingleAppearanceManager)grid.getAppearanceManager();
        PivotHeaderAppearMgr mgr = new PivotHeaderAppearMgr(a, this);
        grid.setAppearanceManager(mgr);
        Object app = UIManager.get("PivotHeader.DefaultAppearance");
        a.setAppearance((Appearance)app);
        this._traversable = true;
        this.updateUI();
    }

    public void dispose() {
        PivotHeaderAppearMgr manager;
        if (this._gridResizer == null) {
            return;
        }
        this._axisLabelPainter = null;
        this.getHeader().setItemInputHandler(null);
        Painter p = this.getDefaultPainter();
        if (p instanceof PivotHeaderPainter) {
            ((PivotHeaderPainter)p).dispose();
        }
        if ((manager = this._getPivotHeaderAppearMgr()) != null) {
            manager.dispose();
        }
        Grid grid = this.getGrid();
        grid.setGridSelectionManager(null);
        grid.removeVetoableChangeListener(this._selectionListener);
        this._gridResizer.dispose();
        this._levelHighlighter.dispose();
        this._gridResizer = null;
        this._levelHighlighter = null;
        if (this._dragDropSupport != null) {
            this._dragDropSupport.dispose();
            this._dragDropSupport = null;
        }
        if (this._jdkDragDropSupport != null) {
            this._jdkDragDropSupport.dispose();
            this._jdkDragDropSupport = null;
        }
        this.setModel(null);
        this._hListener = null;
        this._vListener = null;
        this._selectionListener = null;
        super.dispose();
    }

    public String getUIClassID() {
        return "EWTPivotHeaderUI";
    }

    public int getOrientation() {
        return this._orientation;
    }

    public final PivotTable getPivotTable() {
        return this._pivotTable;
    }

    void setPivotTable(PivotTable table) {
        this._pivotTable = table;
    }

    public final AppearanceManager getAppearanceManager() {
        AppearanceManager manager = this.getGrid().getAppearanceManager();
        if (manager instanceof PivotHeaderAppearMgr) {
            manager = ((PivotHeaderAppearMgr)manager).getWrapped();
        }
        return manager;
    }

    public final void setAppearanceManager(AppearanceManager manager) {
        if (!(manager instanceof PivotHeaderAppearMgr)) {
            manager = new PivotHeaderAppearMgr(manager, this);
        }
        this.getGrid().setAppearanceManager(manager);
        manager.updateUI();
    }

    public final TwoDModel getModel() {
        return this.getGrid().getModel();
    }

    public void setModel(TwoDModel ds) {
        TwoDModel old = this.getModel();
        if (ds == null) {
            if (this._isHorizontal()) {
                old.removeModelListener(this._hListener);
            } else {
                old.removeModelListener(this._vListener);
            }
            this.setModels(null, null, null);
        } else if (this._isHorizontal()) {
            old.removeModelListener(this._hListener);
            NullOneDModel rds = new NullOneDModel(ds.getRowCount());
            this.setModels(ds, null, rds);
            ds.addModelListener(this._hListener);
        } else {
            old.removeModelListener(this._vListener);
            NullOneDModel cds = new NullOneDModel(ds.getColumnCount());
            this.setModels(ds, cds, null);
            ds.addModelListener(this._vListener);
        }
    }

    public void setLevelResizable(int index, boolean resizable) {
        int count = this.getOrientation() == 0 ? this.getGrid().getRowCount() : this.getGrid().getColumnCount();
        if (this._resizeArr == null) {
            this._resizeArr = new boolean[count];
            for (int i = 0; i < count; ++i) {
                this._resizeArr[i] = true;
            }
        } else {
            int arrCount = this._resizeArr.length;
            if (arrCount < count) {
                boolean[] resizeArr = new boolean[count];
                System.arraycopy(this._resizeArr, 0, resizeArr, 0, arrCount);
                for (int i = arrCount; i < count; ++i) {
                    resizeArr[i] = true;
                }
                this._resizeArr = resizeArr;
            }
        }
        if (index < this._resizeArr.length) {
            this._resizeArr[index] = resizable;
        }
    }

    public boolean isLevelResizable(int index) {
        if (this._resizeArr != null && index < this._resizeArr.length) {
            return this._resizeArr[index];
        }
        return true;
    }

    public void setAxisLabelModel(OneDModel model) {
        this.getHeader().setModel(model);
    }

    public OneDModel getAxisLabelModel() {
        return this.getHeader().getModel();
    }

    public void setAxisLabelsVisible(boolean visible) {
        if (this._axisLabelsVisible != visible) {
            this._axisLabelsVisible = visible;
            this._setAxisPainter();
        }
    }

    public boolean isAxisLabelsVisible() {
        return this._axisLabelsVisible;
    }

    public Painter getAxisLabelPainter() {
        if (this._axisLabelPainter == null) {
            this._axisLabelPainter = new TruncatingTextPainter();
        }
        return this._axisLabelPainter;
    }

    public void setAxisLabelPainter(Painter painter) {
        if (this._axisLabelPainter != painter) {
            this._axisLabelPainter = painter;
            this._setAxisPainter();
        }
    }

    public void setInputHandler(CellInputHandler handler) {
        this.getGrid().setDefaultInputHandler(handler);
    }

    public CellInputHandler getInputHandler() {
        return this.getGrid().getDefaultInputHandler();
    }

    public void setDefaultPainter(Painter painter) {
        this.getGrid().setDefaultPainter(painter);
        this.repaint();
    }

    public Painter getDefaultPainter() {
        return this.getGrid().getDefaultPainter();
    }

    public boolean isOutline() {
        PivotHeaderPainter painter = this._getPivotHeaderPainter();
        return painter == null ? false : painter.isOutline();
    }

    public void setOutline(boolean outline) {
        PivotHeaderPainter painter = this._getPivotHeaderPainter();
        if (painter != null && !this._isHorizontal() && this.isOutline() != outline) {
            painter.setOutline(outline);
            this.repaint();
        }
    }

    public void setKeepHeaderCellsVisible(boolean keepHeaderCellsVisible) {
        PivotHeaderPainter painter = this._getPivotHeaderPainter();
        if (painter != null) {
            painter.setKeepHeaderCellsVisible(keepHeaderCellsVisible);
            this.repaint();
        }
        this._updateScrollMode(keepHeaderCellsVisible);
    }

    public boolean getKeepHeaderCellsVisible() {
        PivotHeaderPainter painter = this._getPivotHeaderPainter();
        return painter == null ? false : painter.getKeepHeaderCellsVisible();
    }

    public void setColumnGeometryManager(GeometryManager geometryManager) {
        if (!this._isHorizontal()) {
            geometryManager = new GM(geometryManager);
        }
        super.setColumnGeometryManager(geometryManager);
    }

    public void setRowGeometryManager(GeometryManager geometryManager) {
        if (this._isHorizontal()) {
            geometryManager = new GM(geometryManager);
        }
        super.setRowGeometryManager(geometryManager);
    }

    public final EWTPivotHeaderUI getPivotHeaderUI() {
        return (EWTPivotHeaderUI)this.ui;
    }

    public boolean isGridFocusTraversable() {
        return this._traversable;
    }

    public void setGridFocusTraversable(boolean traversable) {
        this._traversable = traversable;
    }

    public void enableJDKDnD() {
        if (!this._jdkDnD) {
            this._jdkDnD = true;
            if (this._dragDropSupport != null) {
                this._dragDropSupport.dispose();
                this._dragDropSupport = null;
            }
            this._jdkDragDropSupport = new JDKPivotDragDropAdapter(this);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setDragEnabled(this.isEnabled());
    }

    public Dimension layoutCanvas() {
        Dimension d = super.layoutCanvas();
        this._validateMinimumSize();
        return d;
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        Header header = this.getHeader();
        if (header.getItemCount() == 0) {
            if (this._isHorizontal()) {
                d.height += header.getDefaultItemSize();
            } else {
                d.width += header.getDefaultItemSize();
            }
        }
        if (this.getPivotTable() != null) {
            this.getPivotTable().checkHeaderSize(this, d);
        }
        return d;
    }

    public Dimension getMinimumSize() {
        Dimension d = super.getMinimumSize();
        Header header = this.getHeader();
        if (header.getItemCount() == 0) {
            if (this._isHorizontal()) {
                d.height += header.getDefaultItemSize();
            } else {
                d.width += header.getDefaultItemSize();
            }
        }
        return d;
    }

    public void updateUI() {
        this.setUI((EWTPivotHeaderUI)UIManager.getUI(this));
        this.getGrid().getAppearanceManager().updateUI();
        if (this.isAxisLabelsVisible()) {
            this._setAxisPainter();
        }
        this.updateLayout();
    }

    public void setDrawRaised(boolean raised) {
        super.setDrawRaised(raised);
        if (this._isHorizontal()) {
            this.getRowHeader().setDrawRaised(raised);
        } else {
            this.getColumnHeader().setDrawRaised(raised);
        }
    }

    public void setColumnWidth(int index, int width) {
        int canvasWidth;
        super.setColumnWidth(index, width);
        if (!this._isHorizontal() && this._minSize > (canvasWidth = this.getHeader().getGeometryManager().getTotalSize())) {
            int count = this.getHeader().getItemCount();
            int itemSize = this.getColumnWidth(count - 1) + (this._minSize - canvasWidth);
            super.setColumnWidth(count - 1, itemSize);
        }
    }

    public void setRowHeight(int index, int height) {
        int canvasHeight;
        super.setRowHeight(index, height);
        if (this._isHorizontal() && this._minSize > (canvasHeight = this.getHeader().getGeometryManager().getTotalSize())) {
            int count = this.getHeader().getItemCount();
            int itemSize = this.getRowHeight(count - 1) + (this._minSize - canvasHeight);
            super.setRowHeight(count - 1, itemSize);
        }
    }

    public void addNotify() {
        super.addNotify();
        Container parent = this.getParent();
        if (parent instanceof PivotScrollPaneView) {
            parent = parent.getParent();
        }
        if (parent instanceof JViewport) {
            this._viewport = (JViewport)parent;
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this._viewport = null;
    }

    protected Image getDrillImage(int column, int row) {
        Image image = null;
        AbstractPivotHeaderCell cell = this.getPivotHeaderCell(column, row);
        if (cell != null) {
            int drillState = cell.getDrillState();
            switch (drillState) {
                case 0: {
                    image = null;
                    break;
                }
                case 2: {
                    if (this._drilledImage == null) {
                        this._drilledImage = this.getPivotHeaderUI().getDrilledImage(this);
                    }
                    image = this._drilledImage;
                    break;
                }
                case 1: {
                    if (this._drillImage == null) {
                        this._drillImage = this.getPivotHeaderUI().getDrillImage(this);
                    }
                    image = this._drillImage;
                }
            }
        }
        return image;
    }

    protected boolean isDrill(int column, int row, int x, int y) {
        boolean drill = false;
        Image image = this.getDrillImage(column, row);
        if (image != null) {
            FontMetrics metrics;
            int width = image.getWidth(this);
            int height = image.getHeight(this);
            Grid grid = this.getGrid();
            AbstractPivotHeaderCell cell = this.getPivotHeaderCell(column, row);
            Rectangle cellBounds = AbstractPivotHeaderCell.getCellBounds(grid, column, row);
            int rowHeight = cellBounds.height;
            PaintContext context = grid.getCellPaintContext(column, row);
            float align = context.getInteriorAlignmentY();
            if (this.getKeepHeaderCellsVisible() && cell != null && this.getParent() != null) {
                int rowPos;
                Point p = this.getParent().getLocation();
                int columnPos = grid.getColumnPosition(column);
                if (columnPos < -p.x) {
                    x -= -p.x - columnPos;
                }
                if ((rowPos = grid.getRowPosition(row)) < -p.y) {
                    y -= -p.y - rowPos;
                }
                Point pointOnGrid = grid.convertCanvasToOuter(columnPos, rowPos);
                Rectangle rect = new Rectangle(pointOnGrid.x, pointOnGrid.y, cellBounds.width, cellBounds.height);
                rect = rect.intersection(grid.getVisibleRect());
                rowHeight = rect.height;
            }
            Font f = context.getPaintFont();
            int fontSize = 0;
            if (f == null) {
                f = this.getFont();
            }
            if (f != null && (metrics = context.getFontMetrics(f)) != null) {
                fontSize = metrics.getHeight();
            }
            if (rowHeight < fontSize) {
                rowHeight = fontSize;
            }
            y = (int)((float)y - ((float)(rowHeight - fontSize) * align + (float)((fontSize - height) / 2)));
            drill = x >= 0 && x <= width && y >= 0 && y <= height;
        }
        return drill;
    }

    protected boolean isDrillable(int column, int row) {
        AbstractPivotHeaderCell cell = this.getPivotHeaderCell(column, row);
        if (cell != null) {
            return cell.getDrillState() == 1;
        }
        return false;
    }

    protected boolean isCollapsable(int column, int row) {
        AbstractPivotHeaderCell cell = this.getPivotHeaderCell(column, row);
        if (cell != null) {
            return cell.getDrillState() == 2;
        }
        return false;
    }

    protected Cursor getPivotCursor(int index) {
        return Cursor.getPredefinedCursor(12);
    }

    protected Cursor getDrillCursor(int column, int row) {
        return Cursor.getPredefinedCursor(12);
    }

    protected Image getAxisLabelDrillImage(int levelIndex) {
        Image image = null;
        AbstractPivotHeaderHeaderItem item = this.getPivotHeaderHeaderItem(levelIndex);
        if (item != null) {
            int drillState = item.getDrillState();
            switch (drillState) {
                case 0: {
                    break;
                }
                case 2: {
                    if (this._drilledImage == null) {
                        this._drilledImage = this.getPivotHeaderUI().getDrilledImage(this);
                    }
                    image = this._drilledImage;
                    break;
                }
                case 1: {
                    if (this._drillImage == null) {
                        this._drillImage = this.getPivotHeaderUI().getDrillImage(this);
                    }
                    image = this._drillImage;
                }
            }
        }
        return image;
    }

    protected Cursor getAxisLabelDrillCursor(int levelIndex) {
        return Cursor.getPredefinedCursor(12);
    }

    protected boolean isAxisLabelDrill(int levelIndex, int x, int y) {
        boolean drill = false;
        Image image = this.getAxisLabelDrillImage(levelIndex);
        if (image != null) {
            int width = image.getWidth(this);
            int height = image.getHeight(this);
            drill = x >= 0 && x <= width && y >= 0 && y <= height;
        }
        return drill;
    }

    protected boolean isAxisLabelDrillable(int levelIndex) {
        AbstractPivotHeaderHeaderItem item = this.getPivotHeaderHeaderItem(levelIndex);
        if (item != null) {
            return item.getDrillState() == 1;
        }
        return false;
    }

    protected boolean isAxisLabelCollapsable(int levelIndex) {
        AbstractPivotHeaderHeaderItem item = this.getPivotHeaderHeaderItem(levelIndex);
        if (item != null) {
            return item.getDrillState() == 2;
        }
        return false;
    }

    protected void firePivotEvent(Object source, int sourceIndex, Object destination, int destinationIndex) {
        PivotTable table = this.getPivotTable();
        if (table != null) {
            try {
                table.deselectAll();
            }
            catch (PropertyVetoException pve) {
                // empty catch block
            }
            table.firePivotEvent(source, sourceIndex, destination, destinationIndex);
        }
    }

    protected void fireSwapEvent(Object source, int sourceIndex, Object destination, int destinationIndex) {
        PivotTable table = this.getPivotTable();
        if (table != null) {
            table.fireSwapEvent(source, sourceIndex, destination, destinationIndex);
            try {
                table.deselectAll();
            }
            catch (PropertyVetoException pve) {
                // empty catch block
            }
        }
    }

    protected int getDropIndex(Point p, boolean inHeader, boolean isSwap) {
        int index = -1;
        if (this._isHorizontal()) {
            Header header = this.getRowHeader();
            index = header.getItemAt(2, p.y);
            if (!isSwap) {
                if (index == -1) {
                    index = 0;
                } else {
                    int size;
                    int position = header.getItemPosition(index);
                    if (p.y > position + (size = header.getItemSize(index)) / 2) {
                        ++index;
                    }
                }
            }
        } else {
            Header header = this.getColumnHeader();
            index = header.getItemAt(p.x, 2);
            if (!isSwap) {
                if (index == -1) {
                    index = 0;
                } else {
                    int size;
                    int position = header.getItemPosition(index);
                    if (p.x > position + (size = header.getItemSize(index)) / 2) {
                        ++index;
                    }
                }
            }
        }
        return index;
    }

    protected boolean isSwap(Point p, boolean inHeader) {
        if (this.getPivotTable() == null || !this.getPivotTable().isSwapAllowed()) {
            return false;
        }
        int index = -1;
        if (this._isHorizontal()) {
            Header header = this.getRowHeader();
            index = header.getItemAt(p.x, p.y);
            if (index == -1) {
                return false;
            }
            int position = header.getItemPosition(index);
            int size = header.getItemSize(index);
            if (p.y < position + 6) {
                return false;
            }
            if (p.y > position + size - 6) {
                return false;
            }
        } else {
            Header header = this.getColumnHeader();
            index = header.getItemAt(p.x, p.y);
            if (index == -1) {
                return false;
            }
            int position = header.getItemPosition(index);
            int size = header.getItemSize(index);
            if (p.x < position + 6) {
                return false;
            }
            if (p.x > position + size - 6) {
                return false;
            }
        }
        return true;
    }

    protected void paintDropFeedback(Graphics g, int dropIndex, boolean isSwap) {
        if (isSwap) {
            return;
        }
        Header header = this.getHeader();
        Rectangle rect = this.getInnerBounds();
        Dimension bounds = this.getCanvasSize();
        Color oldColor = g.getColor();
        g.setColor(Color.black);
        int count = header.getItemCount();
        int position = dropIndex < count ? header.getItemPosition(dropIndex) : (dropIndex == count && count != 0 ? header.getItemPosition(dropIndex - 1) + header.getItemSize(dropIndex - 1) : 0);
        if (!this._isHorizontal()) {
            int x;
            if (!(this.getParent() instanceof PivotScrollPaneView)) {
                bounds.height += header.getSize().height;
            }
            if ((x = position - 2) < rect.x) {
                x = rect.x;
            }
            if (x + 4 > rect.width) {
                x = rect.width - 4;
            }
            if (bounds.height < rect.height && count != 0) {
                rect.height = bounds.height;
            }
            g.fillRect(x, rect.y, 4, rect.height);
        } else {
            int y;
            if (!(this.getParent() instanceof PivotScrollPaneView)) {
                bounds.width += header.getSize().width;
            }
            if ((y = position - 2) < rect.y) {
                y = rect.y;
            }
            if (y + 4 > rect.height) {
                y = rect.height - 4;
            }
            if (bounds.width < rect.width && count != 0) {
                rect.width = bounds.width;
            }
            g.fillRect(rect.x, y, rect.width, 4);
        }
        if (oldColor != null) {
            g.setColor(oldColor);
        }
    }

    protected int getDragIndex(Point p, boolean inHeader) {
        boolean horizontal = this._isHorizontal();
        Header header = this.getHeader();
        int index = -1;
        if (inHeader) {
            if (header.getItemCount() == 0) {
                return -1;
            }
            index = header.getItemAt(p.x, p.y);
        } else {
            Grid grid = this.getGrid();
            if (grid.getRowCount() == 0 || grid.getColumnCount() == 0) {
                return -1;
            }
            int originColumn = grid.getColumnAt(p.x);
            int originRow = grid.getRowAt(p.y);
            if (originColumn == -1 || originRow == -1) {
                return -1;
            }
            AbstractBigCell cell = AbstractBigCell.getBigCell(grid, originColumn, originRow);
            int column = originColumn;
            int row = originRow;
            if (cell != null) {
                if (horizontal) {
                    row = cell.getRow();
                } else if (this.isOutline() && cell instanceof AbstractPivotHeaderCell) {
                    AbstractPivotHeaderCell a = (AbstractPivotHeaderCell)cell;
                    column = a.getColumn() + a.getIndent();
                } else {
                    column = cell.getColumn();
                }
            }
            index = horizontal ? row : column;
        }
        return index;
    }

    protected final int getDragIndex() {
        return this._dragIndex;
    }

    protected final boolean isSwapping() {
        return this._swapping;
    }

    protected final int getDropIndex() {
        return this._dropIndex;
    }

    protected final Grid createGrid(TwoDModel model) {
        return this.createPivotHeaderGrid(model);
    }

    protected PivotHeaderGrid createPivotHeaderGrid(TwoDModel model) {
        return new PivotHeaderGrid(model);
    }

    protected final Header createColumnHeader(OneDModel model) {
        return this.createPivotHeaderColumnHeader(model);
    }

    protected PivotHeaderHeader createPivotHeaderColumnHeader(OneDModel model) {
        return new PivotHeaderHeader(model, 0);
    }

    protected final Header createRowHeader(OneDModel model) {
        return this.createPivotHeaderRowHeader(model);
    }

    protected PivotHeaderHeader createPivotHeaderRowHeader(OneDModel model) {
        return new PivotHeaderHeader(model, 1);
    }

    public void paintOverChildren(Graphics g) {
        if (this._dropIndex != -1) {
            this.paintDropFeedback(g, this._dropIndex, this._swapping);
        }
    }

    protected void setUI(ComponentUI newUI) {
        super.setUI(newUI);
        this._drillImage = null;
        this._drilledImage = null;
    }

    void setDrillImagesDisplayed(boolean displayImages) {
        this._displayDrillImages = displayImages;
    }

    boolean getDrillImagesDisplayed() {
        return this._displayDrillImages;
    }

    void resetAppearanceManager() {
        AppearanceManager mgr = this.getAppearanceManager();
        if (mgr instanceof SingleAppearanceManager) {
            SingleAppearanceManager sam = (SingleAppearanceManager)mgr;
            Object app = UIManager.get("PivotHeader.DefaultAppearance");
            sam.setAppearance((Appearance)app);
        } else if (mgr instanceof ComplexAppearanceManager) {
            ComplexAppearanceManager cam = (ComplexAppearanceManager)mgr;
            Object app = UIManager.get("PivotHeader.DefaultAppearance");
            cam.setAppearance((Appearance)app);
        }
    }

    AbstractPivotHeaderCell getPivotHeaderCell(int column, int row) {
        Object data = this.getGrid().getModel().getData(column, row);
        if (data instanceof AbstractPivotHeaderCell) {
            return (AbstractPivotHeaderCell)data;
        }
        return null;
    }

    AbstractPivotHeaderHeaderItem getPivotHeaderHeaderItem(int index) {
        Object data = this.getHeader().getModel().getData(index);
        if (data instanceof AbstractPivotHeaderHeaderItem) {
            return (AbstractPivotHeaderHeaderItem)data;
        }
        return null;
    }

    void setDragEnabled(boolean enabled) {
        this._dragEnabled = enabled;
    }

    boolean isDragEnabled() {
        return this._dragEnabled;
    }

    void fireHeaderCellDrillRequest(int column, int row) {
        if (this._drillListener == null) {
            return;
        }
        int id = 2001;
        DrillEvent e = new DrillEvent(this, id, this.getOrientation(), column, row);
        this._drillListener.headerCellDrillRequest(e);
    }

    void fireCollapse(int column, int row) {
        if (this._collapseListener == null) {
            return;
        }
        int id = 2001;
        CollapseEvent e = new CollapseEvent(this, id, this.getOrientation(), column, row);
        this._collapseListener.collapse(e);
    }

    Image getDragImage(int index) {
        Header header;
        int height;
        int width;
        PivotTable table = this.getPivotTable();
        if (this._isHorizontal()) {
            width = table == null ? this.getRowHeaderWidth() : table.getPivotTableUI().getSelectorSize(table);
            height = index < 0 || index >= this.getGrid().getRowCount() ? this.getDefaultRowHeight() : this.getRowHeight(index);
            header = this.getRowHeader();
        } else {
            width = index < 0 || index >= this.getGrid().getColumnCount() ? this.getDefaultColumnWidth() : this.getColumnWidth(index);
            height = table == null ? this.getColumnHeaderHeight() : table.getPivotTableUI().getSelectorSize(table);
            header = this.getColumnHeader();
        }
        Image image = this.createImage(width, height);
        if (image != null) {
            Graphics g = image.getGraphics();
            PaintContext context = header.getPaintContext();
            BorderPainter bp = header.getHeaderItemBorderPainter();
            ImmInsets insets = bp.getInsets(context);
            bp.paint(context, g, 0, 0, width, height);
            Painter p = header.getDefaultPainter();
            p.paint(context, g, insets.left, insets.top, width -= insets.left + insets.right, height -= insets.top + insets.bottom);
        }
        return image;
    }

    synchronized void setDrillListener(DrillListener listener) {
        this._drillListener = listener;
    }

    synchronized void setCollapseListener(CollapseListener listener) {
        this._collapseListener = listener;
    }

    void setDropLocation(int index, boolean isSwap) {
        if (this._dropIndex != index || this._swapping != isSwap) {
            PivotHeaderAppearMgr mgr = this._getPivotHeaderAppearMgr();
            if (mgr != null) {
                int swapIndex = !isSwap ? -1 : (index == -1 ? -1 : (index == this._dragIndex ? -1 : index));
                mgr.setSwapItem(swapIndex);
            }
            this._swapping = isSwap;
            if (index == -1 || this._dragIndex == -1 || this._swapping && this._dragIndex != index) {
                this._dropIndex = index;
                this.repaintFeedback();
            } else {
                if (this._dragIndex != -1 && (this._dragIndex == index || this._dragIndex == index - 1)) {
                    index = -1;
                }
                this._dropIndex = index;
                this.repaintFeedback();
            }
        }
    }

    void setDragItem(int item) {
        try {
            if (this._dragIndex != -1) {
                if (this._isHorizontal()) {
                    this.getGrid().deselectAll();
                    this.getRowHeader().deselectAll();
                } else {
                    this.getGrid().deselectAll();
                    this.getColumnHeader().deselectAll();
                }
            }
            this._dragIndex = item;
            if (this._dragIndex >= 0) {
                if (this._isHorizontal()) {
                    if (this._dragIndex < this.getGrid().getRowCount()) {
                        this.getGrid().setSelection(new TwoDSelection(this._dragIndex, true));
                    }
                } else if (this._dragIndex < this.getGrid().getColumnCount()) {
                    this.getGrid().setSelection(new TwoDSelection(this._dragIndex, false));
                }
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.repaintFeedback();
    }

    Header getHeader() {
        if (this._isHorizontal()) {
            return this.getRowHeader();
        }
        return this.getColumnHeader();
    }

    boolean _isHorizontal() {
        return this.getOrientation() == 0;
    }

    final boolean isDrilling() {
        return this._drilling;
    }

    final void setDrilling(boolean drilling) {
        this._drilling = drilling;
    }

    final int getResizeItem() {
        return this._resizeItem;
    }

    final void setResizeItem(int item) {
        this._resizeItem = item;
    }

    final void setMinimumSize(int minSize) {
        this._minSize = minSize;
        this._needToValidateMinSize = true;
        this._validateMinimumSize();
    }

    final int getHeaderResizeItem() {
        return this._headerResizeItem;
    }

    final void setHeaderResizeItem(int item) {
        if (this._headerResizeItem != item) {
            this._headerResizeItem = item;
            PivotTable table = this.getPivotTable();
            PivotHeader h = item == -1 ? null : this;
            table.setResizeHeader(h);
        }
    }

    final void updateHeaderResizeFeedback() {
        if (this._headerResizeItem != -1 && this.getPivotTable() != null) {
            this.getPivotTable().paintParent();
        }
    }

    final void setHighlightItem(int item) {
        if (this._highlightItem != item) {
            this._highlightItem = item;
            this.getHeader().paintImmediateInterior();
        }
    }

    Painter __getPivotGrippyPainter() {
        if (this.isAxisLabelsVisible()) {
            return this.getPivotHeaderUI().getDefaultHeaderItemPainterWithBorder(this);
        }
        return this.getPivotHeaderUI().getDefaultHeaderItemPainter(this, !this._isHorizontal());
    }

    void __selectGrid(boolean select) {
        this._canSelectGrid = select;
    }

    private void _setAxisPainter() {
        Painter p = null;
        if (this._axisLabelsVisible) {
            p = new PainterJoiner(this._getAxisLabelImagePainter(), new FixedBorderPainter(this.getAxisLabelPainter(), 0, 2, 0, 0), 13, true);
            FixedBorderPainter contentPainter = new FixedBorderPainter(p, 0, 2, 0, 0);
            p = new PainterJoiner(this.getPivotHeaderUI().getDefaultHeaderItemPainterWithBorder(this), contentPainter, 13, true);
            p = new AxisPainter(p, contentPainter);
        } else {
            p = this.getPivotHeaderUI().getDefaultHeaderItemPainter(this, !this._isHorizontal());
        }
        this.getHeader().setDefaultPainter(p);
    }

    private void _validateMinimumSize() {
        if (!this._needToValidateMinSize) {
            return;
        }
        this._needToValidateMinSize = false;
        this.validate();
        int count = this.getHeader().getItemCount();
        if (count == 0) {
            this._needToValidateMinSize = true;
        } else {
            Dimension size = this.getInnerSize();
            if (this._isHorizontal()) {
                int canvasHeight = this.getHeader().getGeometryManager().getTotalSize();
                if (canvasHeight == 0) {
                    this._needToValidateMinSize = true;
                } else {
                    this._needToValidateMinSize = false;
                    if (size.height > canvasHeight) {
                        if (this._minSize > canvasHeight) {
                            int itemSize = this.getRowHeight(count - 1) + (size.height - canvasHeight);
                            super.setRowHeight(count - 1, itemSize);
                        } else {
                            this.setSize(this.getSize().width, canvasHeight);
                        }
                    }
                }
            } else {
                int canvasWidth = this.getHeader().getGeometryManager().getTotalSize();
                if (canvasWidth == 0) {
                    this._needToValidateMinSize = true;
                } else {
                    this._needToValidateMinSize = false;
                    if (size.width > canvasWidth) {
                        if (this._minSize > canvasWidth) {
                            int itemSize = this.getColumnWidth(count - 1) + (size.width - canvasWidth);
                            super.setColumnWidth(count - 1, itemSize);
                        } else {
                            this.setSize(canvasWidth, this.getSize().height);
                        }
                    }
                }
            }
        }
    }

    private void repaintFeedback() {
        this.paintImmediateInterior();
        if (this.getParent() instanceof PivotScrollPaneView || this.getParent() instanceof JViewport) {
            this.getHeader().paintImmediateInterior();
        }
    }

    private PivotHeaderPainter _getPivotHeaderPainter() {
        Painter p = this.getGrid().getDefaultPainter();
        return p instanceof PivotHeaderPainter ? (PivotHeaderPainter)p : null;
    }

    private PivotHeaderAppearMgr _getPivotHeaderAppearMgr() {
        AppearanceManager mgr = this.getGrid().getAppearanceManager();
        if (mgr instanceof PivotHeaderAppearMgr) {
            return (PivotHeaderAppearMgr)mgr;
        }
        return null;
    }

    String __getAccessibleString(String key) {
        Locale l = LocaleUtils.getDefaultableLocale((Component)this);
        ResourceBundle b = ResourceBundle.getBundle(_RESOURCE_BUNDLE, l);
        return b.getString(key);
    }

    private void _updateScrollMode(boolean keepHeaderCellVisible) {
        if (this._viewport != null) {
            if (keepHeaderCellVisible) {
                this._viewport.setScrollMode(0);
            } else {
                this._viewport.setScrollMode(1);
            }
        }
    }

    private AbstractPainter _getAxisLabelImagePainter() {
        return new TotalP();
    }

    private EWTPivotHeaderUI _getUI() {
        return (EWTPivotHeaderUI)this.ui;
    }

    private class AxisPainter
    extends AbstractWrappingPainter {
        private Painter _printPainter;

        public AxisPainter(Painter defaultPainter, Painter printPainter) {
            super(defaultPainter);
            this._printPainter = printPainter;
        }

        public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
            if (g instanceof PrintGraphics || g instanceof PrinterGraphics) {
                this._printPainter.paint(context, g, x, y, width, height);
            } else {
                super.paint(context, g, x, y, width, height);
            }
        }
    }

    private class TotalP
    extends AbstractPainter {
        private ImageP _imagePainter = new ImageP();

        public Dimension getMinimumSize(PaintContext context) {
            Image image;
            Object o = context.getPaintData("header.item");
            if (o instanceof Integer && (image = PivotHeader.this.getAxisLabelDrillImage((Integer)o)) != null) {
                return new Dimension(image.getWidth(PivotHeader.this), image.getHeight(PivotHeader.this));
            }
            return new Dimension();
        }

        public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
            Object o = context.getPaintData("header.item");
            Image image = null;
            if (o instanceof Integer) {
                image = PivotHeader.this.getAxisLabelDrillImage((Integer)o);
            }
            if (image != null) {
                FontMetrics metrics;
                this._imagePainter.setImage(image);
                Dimension d = this._imagePainter.getPreferredSize(context);
                float alignY = context.getInteriorAlignmentY();
                Font f = context.getPaintFont();
                int fontSize = 0;
                if (f == null) {
                    f = PivotHeader.this.getFont();
                }
                if (f != null && (metrics = context.getFontMetrics(f)) != null) {
                    fontSize = metrics.getHeight();
                }
                if (height < fontSize) {
                    height = fontSize;
                }
                y = (int)((float)y + (float)(height - fontSize) * alignY + (float)((fontSize - d.height) / 2));
                this._imagePainter.paint(context, g, x, y, d.width, height);
            }
        }
    }

    private static class ImageP
    extends ImagePainter {
        private Image _image;

        public ImageP() {
            super(0);
        }

        public void setImage(Image image) {
            this._image = image;
        }

        protected Image getImageData(PaintContext context) {
            return this._image;
        }
    }

    private class GM
    extends AbstractWrappingGeometryManager {
        public GM(GeometryManager geometryManager) {
            super(geometryManager);
        }

        public void setItemSize(int modelIndex, int size) {
            int oldSize;
            int diff;
            int totalSize;
            if (this.isResizing() && (totalSize = this.getTotalSize()) + (diff = size - (oldSize = this.getItemSize(modelIndex))) < PivotHeader.this._minSize) {
                size = PivotHeader.this._minSize + oldSize - totalSize;
            }
            super.setItemSize(modelIndex, size);
        }
    }

    private class _VListen
    extends TwoDModelAdapter {
        private _VListen() {
        }

        public void rowsAdded(TwoDModelEvent e) {
            this._clearSelection();
        }

        public void rowsRemoved(TwoDModelEvent e) {
            this._clearSelection();
        }

        public void invalidateRows(TwoDModelEvent e) {
            this._clearSelection();
        }

        public void invalidateColumns(TwoDModelEvent e) {
            this._clearSelection();
        }

        public void invalidateCells(TwoDModelEvent e) {
            this._clearSelection();
        }

        private void _clearSelection() {
            try {
                PivotHeader.this.deselectAll();
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        public void columnsAdded(TwoDModelEvent e) {
            OneDModel ds = PivotHeader.this.getColumnHeader().getModel();
            if (ds instanceof NullOneDModel) {
                NullOneDModel nds = (NullOneDModel)ds;
                nds.addItems(e.getColumnStartIndex(), e.getColumnCount());
            }
            this._clearSelection();
            PivotHeader.this.revalidate();
            PivotTable table = PivotHeader.this.getPivotTable();
            if (table != null) {
                table.invalidateParent();
            }
        }

        public void columnsRemoved(TwoDModelEvent e) {
            OneDModel ds = PivotHeader.this.getColumnHeader().getModel();
            if (ds instanceof NullOneDModel) {
                NullOneDModel nds = (NullOneDModel)ds;
                nds.removeItems(e.getColumnStartIndex(), e.getColumnCount());
            }
            this._clearSelection();
            PivotHeader.this.revalidate();
            PivotTable table = PivotHeader.this.getPivotTable();
            if (table != null) {
                table.invalidateParent();
            }
        }
    }

    private class _HListen
    extends TwoDModelAdapter {
        private _HListen() {
        }

        public void columnsAdded(TwoDModelEvent e) {
            this._clearSelection();
        }

        public void columnsRemoved(TwoDModelEvent e) {
            this._clearSelection();
        }

        public void invalidateRows(TwoDModelEvent e) {
            this._clearSelection();
        }

        public void invalidateColumns(TwoDModelEvent e) {
            this._clearSelection();
        }

        public void invalidateCells(TwoDModelEvent e) {
            this._clearSelection();
        }

        private void _clearSelection() {
            try {
                PivotHeader.this.deselectAll();
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        public void rowsAdded(TwoDModelEvent e) {
            OneDModel ds = PivotHeader.this.getRowHeader().getModel();
            if (ds instanceof NullOneDModel) {
                NullOneDModel nds = (NullOneDModel)ds;
                nds.addItems(e.getRowStartIndex(), e.getRowCount());
            }
            this._clearSelection();
            PivotHeader.this.revalidate();
            PivotTable table = PivotHeader.this.getPivotTable();
            if (table != null) {
                table.invalidateParent();
            }
        }

        public void rowsRemoved(TwoDModelEvent e) {
            OneDModel ds = PivotHeader.this.getRowHeader().getModel();
            if (ds instanceof NullOneDModel) {
                NullOneDModel nds = (NullOneDModel)ds;
                nds.removeItems(e.getRowStartIndex(), e.getRowCount());
            }
            this._clearSelection();
            PivotHeader.this.revalidate();
            PivotTable table = PivotHeader.this.getPivotTable();
            if (table != null) {
                table.invalidateParent();
            }
        }
    }

    private class SelectionListener
    implements VetoableChangeListener {
        private SelectionListener() {
        }

        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if (!PivotHeader.this._canSelectGrid) {
                throw new PropertyVetoException(evt.getPropertyName(), evt);
            }
        }
    }

    public class PivotHeaderGrid
    extends Grid {
        public PivotHeaderGrid(TwoDModel ds) {
            super(ds);
            this.updateUI();
        }

        public String getUIClassID() {
            return "EWTPivotHeaderGridUI";
        }

        public final void updateUI() {
            this.setUI((EWTPivotHeaderGridUI)UIManager.getUI(this));
        }

        public final Object getPaintData(Object key) {
            if (PivotHeader.KEY_OUTLINE.equals(key)) {
                return PivotHeader.this.isOutline() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (PivotHeader.KEY_HORIZONTAL.equals(key)) {
                return PivotHeader.this._isHorizontal() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (PivotTable.KEY_DRAW_RAISED.equals(key)) {
                return PivotHeader.this.getDrawRaised() ? Boolean.TRUE : Boolean.FALSE;
            }
            return super.getPaintData(key);
        }

        public final boolean isFocusTraversable() {
            return PivotHeader.this.isGridFocusTraversable();
        }

        public final void requestFocus() {
            if (PivotHeader.this.getPivotTable() != null && !this.isFocusTraversable()) {
                PivotHeader.this.getPivotTable().requestFocus();
            } else {
                super.requestFocus();
            }
        }

        public final void paintCell(int columnIndex, int rowIndex) {
            AbstractPivotHeaderCell cell = PivotHeader.this.getPivotHeaderCell(columnIndex, rowIndex);
            if (cell == null) {
                super.paintCell(columnIndex, rowIndex);
            } else {
                int firstColumn = cell.getColumn();
                int firstRow = cell.getRow();
                int columnCount = cell.getColumnCount();
                int rowCount = cell.getRowCount();
                for (int i = 0; i < columnCount; ++i) {
                    for (int j = 0; j < rowCount; ++j) {
                        super.paintCell(firstColumn + i, firstRow + j);
                    }
                }
            }
        }

        public final Cell getCellAt(int x, int y) {
            AbstractBigCell bigCell;
            Cell cell = super.getCellAt(x, y);
            if (cell != null && (bigCell = AbstractBigCell.getBigCell(this, cell.column, cell.row)) != null) {
                cell.column = bigCell.getColumn();
                cell.row = bigCell.getRow();
            }
            return cell;
        }

        public final Cell getFocusCell() {
            AbstractBigCell bigCell;
            Cell cell = super.getFocusCell();
            if (cell != null && (bigCell = AbstractBigCell.getBigCell(this, cell.column, cell.row)) != null) {
                cell.column = bigCell.getColumn();
                cell.row = bigCell.getRow();
            }
            return cell;
        }

        public final boolean requestFocus(int column, int row, AWTEvent event) {
            AbstractBigCell bigCell = AbstractBigCell.getBigCell(this, column, row);
            if (bigCell != null) {
                column = bigCell.getColumn();
                row = bigCell.getRow();
            }
            return super.requestFocus(column, row, event);
        }

        protected final void paintFocusCell(Graphics g) {
            Cell focusCell = this.getFocusCell();
            if (!(this.getDrawFocusCellHighlite() && focusCell != null && this.isColumnOnScreen(focusCell.column) && this.isRowOnScreen(focusCell.row) && (this.isAlwaysDrawFocusCellHighlite() || this.hasFocus()))) {
                return;
            }
            int x = 0;
            int y = 0;
            int width = 0;
            int height = 0;
            AbstractPivotHeaderCell cell = PivotHeader.this.getPivotHeaderCell(focusCell.column, focusCell.row);
            if (cell == null) {
                x = this.getColumnPosition(focusCell.column);
                y = this.getRowPosition(focusCell.row);
                width = this.getColumnWidth(focusCell.column);
                height = this.getRowHeight(focusCell.row);
            } else {
                x = this.getColumnPosition(cell.getColumn());
                y = this.getRowPosition(cell.getRow());
                int columnCount = cell.getColumnCount();
                for (int i = 0; i < columnCount; ++i) {
                    width += this.getColumnWidth(cell.getColumn() + i);
                }
                int rowCount = cell.getRowCount();
                for (int i = 0; i < rowCount; ++i) {
                    height += this.getRowHeight(cell.getRow() + i);
                }
            }
            Rectangle bounds = new Rectangle(x, y, width, height);
            this._paintBorderAroundCells(bounds, g);
        }

        protected final boolean paintSelectionBorder(Graphics g) {
            Rectangle selBounds = this._getSelectionBounds();
            if (selBounds == null) {
                return false;
            }
            this._paintBorderAroundCells(selBounds, g);
            return true;
        }

        public final Insets getAutoscrollInsets() {
            return new Insets(0, 0, 0, 0);
        }

        protected final Component getScrollParent() {
            return this.getParent();
        }

        protected final int getCellPaintState(int state, int column, int row) {
            if (PivotHeader.this.isOutline()) {
                TwoDSelection sel = this.getSelection();
                boolean select = false;
                OneDSelection cols = sel.getColumnSelection();
                if (!cols.isEmpty()) {
                    int selectedColumn = cols.getSingleItem();
                    Object data = super.getModel().getData(column, row);
                    if (data instanceof AbstractPivotHeaderCell) {
                        AbstractPivotHeaderCell cell = (AbstractPivotHeaderCell)data;
                        select = cell.getIndent() == selectedColumn;
                    }
                } else {
                    boolean bl = select = sel.containsCell(column, row) || sel.containsRow(row);
                }
                state = !select ? (state &= 0xFFFFFFDF) : (state |= 0x20);
            }
            return state;
        }

        protected TwoDSelection getModelRangeSelection(int modelColumn1, int modelRow1, int modelColumn2, int modelRow2) {
            boolean isEqual;
            AbstractBigCell bigCell = AbstractBigCell.getBigCell(this, modelColumn1, modelRow1);
            if (bigCell != null) {
                modelColumn1 = bigCell.getColumn();
                modelRow1 = bigCell.getRow();
            }
            if ((bigCell = AbstractBigCell.getBigCell(this, modelColumn2, modelRow2)) != null) {
                modelColumn2 = bigCell.getColumn();
                modelRow2 = bigCell.getRow();
            }
            TwoDSelection sel = TwoDSelection.getEmptySelection();
            boolean horizontal = PivotHeader.this._isHorizontal();
            boolean bl = horizontal ? modelRow1 == modelRow2 : (isEqual = modelColumn1 == modelColumn2);
            if (!isEqual) {
                boolean intermediateLevels;
                int row2;
                int col2;
                boolean swap;
                boolean bl2 = horizontal ? modelRow1 > modelRow2 : (swap = modelColumn1 > modelColumn2);
                if (swap) {
                    int temp = modelRow1;
                    modelRow1 = modelRow2;
                    modelRow2 = temp;
                    temp = modelColumn1;
                    modelColumn1 = modelColumn2;
                    modelColumn2 = temp;
                }
                int col1 = modelColumn1;
                int row1 = modelRow1;
                if (horizontal) {
                    col2 = this.getPreviousVisibleColumn(this.getColumnCount());
                    row2 = row1;
                } else {
                    col2 = col1;
                    row2 = this.getPreviousVisibleRow(this.getRowCount());
                }
                sel = sel.add(super.getModelRangeSelection(col1, row1, col2, row2));
                col1 = modelColumn2;
                row1 = modelRow2;
                if (horizontal) {
                    col2 = this.getNextVisibleColumn(-1);
                    row2 = row1;
                } else {
                    col2 = col1;
                    row2 = this.getNextVisibleRow(-1);
                }
                sel = sel.add(super.getModelRangeSelection(col1, row1, col2, row2));
                boolean bl3 = horizontal ? modelRow2 - modelRow1 > 1 : (intermediateLevels = modelColumn2 - modelColumn1 > 1);
                if (intermediateLevels) {
                    if (horizontal) {
                        col1 = this.getNextVisibleColumn(-1);
                        row1 = modelRow1 + 1;
                        col2 = this.getPreviousVisibleColumn(this.getColumnCount());
                        row2 = modelRow2 - 1;
                    } else {
                        col1 = modelColumn1 + 1;
                        row1 = this.getNextVisibleRow(-1);
                        col2 = modelColumn2 - 1;
                        row2 = this.getPreviousVisibleRow(this.getRowCount());
                    }
                    sel = sel.add(super.getModelRangeSelection(col1, row1, col2, row2));
                }
            } else {
                sel = super.getModelRangeSelection(modelColumn1, modelRow1, modelColumn2, modelRow2);
            }
            return sel;
        }

        protected Grid.AccessibleGrid createAccessibleGrid() {
            return new PivotHeaderAccessibleGrid();
        }

        private Rectangle _getSelectionBounds() {
            TwoDSelection sel = this.getSelection();
            if (sel.isEmpty()) {
                return null;
            }
            CellRange[] cellRanges = sel.getCellRanges();
            Range[] colRanges = sel.getColumnSelection().getRanges();
            CellRange[] colCellRanges = this._cellRangesFromLevelRanges(colRanges, true);
            Range[] rowRanges = sel.getRowSelection().getRanges();
            CellRange[] rowCellRanges = this._cellRangesFromLevelRanges(rowRanges, false);
            cellRanges = CellRange.addCellRanges(cellRanges, colCellRanges);
            cellRanges = CellRange.addCellRanges(cellRanges, rowCellRanges);
            int minRow = -1;
            int minCol = -1;
            int maxRow = -1;
            int maxCol = -1;
            if (cellRanges != null && cellRanges.length != 0) {
                for (int i = 0; i < cellRanges.length; ++i) {
                    Cell minCell = cellRanges[i].getLowerLimit();
                    Cell maxCell = cellRanges[i].getUpperLimit();
                    minCol = minCol == -1 ? minCell.column : Math.min(minCol, minCell.column);
                    maxCol = maxCol == -1 ? maxCell.column : Math.max(maxCol, maxCell.column);
                    minRow = minRow == -1 ? minCell.row : Math.min(minRow, minCell.row);
                    maxRow = maxRow == -1 ? maxCell.row : Math.max(maxRow, maxCell.row);
                }
                CellRange[] result = new CellRange[]{new CellRange(minCol, minRow, maxCol, maxRow)};
                if (!CellRange.cellRangesContain(cellRanges, result)) {
                    maxCol = -1;
                    maxRow = -1;
                    minCol = -1;
                    minRow = -1;
                }
            }
            if (minRow == -1 || minCol == -1 || maxCol == -1 || maxRow == -1) {
                return null;
            }
            return this.getCellBounds(minCol, minRow, maxCol, maxRow);
        }

        private CellRange[] _cellRangesFromLevelRanges(Range[] ranges, boolean isCol) {
            if (ranges == null || ranges.length == 0) {
                return null;
            }
            CellRange[] cellRanges = null;
            int count = isCol ? this.getRowCount() : this.getColumnCount();
            for (int i = 0; i < ranges.length; ++i) {
                int lower = ranges[i].getLowerLimit();
                int upper = ranges[i].getUpperLimit();
                for (int j = lower; j <= upper; ++j) {
                    for (int k = 0; k < count; ++k) {
                        int col = isCol ? j : k;
                        int row = isCol ? k : j;
                        CellRange[] temp = new CellRange[1];
                        AbstractBigCell bigCell = AbstractBigCell.getBigCell(this, col, row);
                        if (bigCell != null) {
                            if (col == bigCell.getColumn() && row == bigCell.getRow()) {
                                temp[0] = new CellRange(col, row, col + bigCell.getColumnCount() - 1, row + bigCell.getRowCount() - 1);
                            }
                        } else {
                            temp[0] = new CellRange(col, row);
                        }
                        if (temp[0] == null) continue;
                        cellRanges = CellRange.addCellRanges(cellRanges, temp);
                    }
                }
            }
            return cellRanges;
        }

        private void _paintBorderAroundCells(Rectangle drawRect, Graphics g) {
            BorderPainter ptr = (BorderPainter)UIManager.get("Grid.focusPainter");
            if (ptr != null) {
                ptr.paint(this.getPaintContext(), g, drawRect.x, drawRect.y, drawRect.width, drawRect.height);
            }
        }

        public class PivotHeaderAccessibleGrid
        extends Grid.AccessibleGrid {
            private PivotHeaderAccessibleGridCell[] _children;
            private int _count = -1;

            public int getAccessibleChildrenCount() {
                if (this._count != -1) {
                    return this._count;
                }
                int columns = PivotHeaderGrid.this.getColumnCount();
                int rows = PivotHeaderGrid.this.getRowCount();
                int count = 0;
                TwoDModel model = PivotHeaderGrid.this.getModel();
                for (int j = 0; j < rows; ++j) {
                    for (int i = 0; i < columns; ++i) {
                        Object data = model.getData(i, j);
                        if (data != null && data instanceof AbstractBigCell) {
                            AbstractBigCell bc = (AbstractBigCell)data;
                            if (bc.getColumn() != i || bc.getRow() != j) continue;
                            ++count;
                            continue;
                        }
                        ++count;
                    }
                }
                this._count = count;
                return this._count;
            }

            public int getAccessibleSelectionCount() {
                int count = 0;
                TwoDSelection selection = PivotHeaderGrid.this.getSelection();
                int gridCount = selection.getSelectedCellCount();
                TwoDModel model = PivotHeaderGrid.this.getModel();
                for (int i = 0; i < gridCount; ++i) {
                    AbstractBigCell bc;
                    Cell cell = selection.getSelectedCellAtIndex(i);
                    Object data = model.getData(cell.column, cell.row);
                    if (data == null || !(data instanceof AbstractBigCell) || (bc = (AbstractBigCell)data).getColumn() != cell.column || bc.getRow() != cell.row) continue;
                    ++count;
                }
                return count;
            }

            public Accessible getAccessibleSelection(int index) {
                int count = -1;
                TwoDSelection selection = PivotHeaderGrid.this.getSelection();
                int gridCount = selection.getSelectedCellCount();
                TwoDModel model = PivotHeaderGrid.this.getModel();
                for (int i = 0; i < gridCount; ++i) {
                    AbstractBigCell bc;
                    Cell cell = selection.getSelectedCellAtIndex(i);
                    Object data = model.getData(cell.column, cell.row);
                    if (data != null && data instanceof AbstractBigCell && (bc = (AbstractBigCell)data).getColumn() == cell.column && bc.getRow() == cell.row) {
                        ++count;
                    }
                    if (count != index) continue;
                    int child = this._convertCellToIndex(cell.column, cell.row);
                    return this.getAccessibleChild(child);
                }
                return null;
            }

            public boolean isAccessibleChildSelected(int i) {
                TwoDSelection childSelection = this._getSelectionFromIndex(i);
                if (childSelection == null) {
                    return false;
                }
                TwoDSelection sel = PivotHeaderGrid.this.getSelection();
                return sel.contains(childSelection);
            }

            public void addAccessibleSelection(int i) {
                TwoDSelection childSelection = this._getSelectionFromIndex(i);
                if (childSelection != null) {
                    try {
                        PivotHeaderGrid.this.getGridSelectionManager().addSelection(childSelection);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }

            public void removeAccessibleSelection(int i) {
                TwoDSelection childSelection = this._getSelectionFromIndex(i);
                if (childSelection != null) {
                    try {
                        PivotHeaderGrid.this.getGridSelectionManager().removeSelection(childSelection);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }

            public int getAccessibleRowAtIndex(int i) {
                Cell c = this._convertIndexToCell(i);
                if (c != null) {
                    return c.row;
                }
                return -1;
            }

            public int getAccessibleColumnAtIndex(int i) {
                Cell c = this._convertIndexToCell(i);
                if (c != null) {
                    return c.column;
                }
                return -1;
            }

            public int getAccessibleIndexAt(int column, int row) {
                return this._convertCellToIndex(column, row);
            }

            public void rowsAdded(TwoDModelEvent e) {
                super.rowsAdded(e);
                this._children = null;
                this._count = -1;
            }

            public void rowsRemoved(TwoDModelEvent e) {
                super.rowsRemoved(e);
                this._children = null;
                this._count = -1;
            }

            public void columnsAdded(TwoDModelEvent e) {
                super.columnsAdded(e);
                this._children = null;
                this._count = -1;
            }

            public void columnsRemoved(TwoDModelEvent e) {
                super.columnsRemoved(e);
                this._children = null;
                this._count = -1;
            }

            public Accessible getAccessibleChild(int i) {
                int count = this.getAccessibleChildrenCount();
                if (i < 0 || i >= count) {
                    return null;
                }
                if (this._children == null) {
                    this._children = new PivotHeaderAccessibleGridCell[count];
                }
                if (this._children[i] == null) {
                    this._children[i] = new PivotHeaderAccessibleGridCell(i);
                }
                return this._children[i];
            }

            protected String getAccessibleName(int column, int row, Object data) {
                String name = super.getAccessibleName(column, row, data);
                String key = null;
                if (PivotHeader.this.isDrillable(column, row)) {
                    key = "PIVOT_HEADER.IS_DRILLABLE";
                } else if (PivotHeader.this.isCollapsable(column, row)) {
                    key = "PIVOT_HEADER.IS_COLLAPSABLE";
                }
                if (key != null) {
                    String message = PivotHeader.this.__getAccessibleString(key);
                    MessageFormat form = new MessageFormat(message);
                    Object[] args = new Object[]{name};
                    name = form.format(args);
                }
                return name;
            }

            private TwoDSelection _getSelectionFromIndex(int i) {
                int column = this.getAccessibleColumnAtIndex(i);
                int row = this.getAccessibleRowAtIndex(i);
                TwoDSelection sel = null;
                if (column != 1 && row != -1) {
                    TwoDModel model = PivotHeaderGrid.this.getModel();
                    Object data = model.getData(column, row);
                    if (data instanceof AbstractBigCell) {
                        AbstractBigCell bc = (AbstractBigCell)data;
                        sel = new TwoDSelection(null, null, bc.getColumn(), bc.getRow(), bc.getColumn() + bc.getColumnCount() - 1, bc.getRow() + bc.getRowCount() - 1);
                    } else {
                        sel = new TwoDSelection(column, row);
                    }
                }
                return sel;
            }

            private Cell _convertIndexToCell(int index) {
                int columns = PivotHeaderGrid.this.getColumnCount();
                int rows = PivotHeaderGrid.this.getRowCount();
                int count = -1;
                TwoDModel model = PivotHeaderGrid.this.getModel();
                for (int j = 0; j < rows; ++j) {
                    for (int i = 0; i < columns; ++i) {
                        Object data = model.getData(i, j);
                        if (data != null && data instanceof AbstractBigCell) {
                            AbstractBigCell bc = (AbstractBigCell)data;
                            if (bc.getColumn() == i && bc.getRow() == j) {
                                ++count;
                            }
                        } else {
                            ++count;
                        }
                        if (count != index) continue;
                        return new Cell(i, j);
                    }
                }
                return null;
            }

            private int _convertCellToIndex(int column, int row) {
                int columns = PivotHeaderGrid.this.getColumnCount();
                int rows = PivotHeaderGrid.this.getRowCount();
                int count = 0;
                TwoDModel model = PivotHeaderGrid.this.getModel();
                for (int j = 0; j < rows; ++j) {
                    for (int i = 0; i < columns; ++i) {
                        if (i == column && j == row) {
                            return count;
                        }
                        Object data = model.getData(i, j);
                        if (data != null && data instanceof AbstractBigCell) {
                            AbstractBigCell bc = (AbstractBigCell)data;
                            if (bc.getColumn() != i || bc.getRow() != j) continue;
                            ++count;
                            continue;
                        }
                        ++count;
                    }
                }
                return -1;
            }

            private class PivotHeaderAccessibleGridCell
            extends Grid.AccessibleGrid.AccessibleGridCell
            implements AccessibleAction {
                public PivotHeaderAccessibleGridCell(int index) {
                    super(index);
                }

                public Rectangle getBounds() {
                    int i;
                    AbstractPivotHeaderCell cell = this._getPivotHeaderCell();
                    if (cell == null) {
                        return super.getBounds();
                    }
                    int column = cell.getColumn();
                    int row = cell.getRow();
                    int x = PivotHeaderGrid.this.getColumnPosition(column);
                    int y = PivotHeaderGrid.this.getRowPosition(row);
                    int width = 0;
                    int height = 0;
                    for (i = column; i < column + cell.getColumnCount(); ++i) {
                        width += PivotHeaderGrid.this.getColumnWidth(i);
                    }
                    for (i = row; i < row + cell.getRowCount(); ++i) {
                        height += PivotHeaderGrid.this.getRowHeight(i);
                    }
                    return new Rectangle(x, y, width, height);
                }

                public Dimension getSize() {
                    AbstractPivotHeaderCell cell = this._getPivotHeaderCell();
                    if (cell == null) {
                        return super.getSize();
                    }
                    int column = cell.getColumn();
                    int row = cell.getRow();
                    Rectangle rect = AbstractPivotHeaderCell.getCellBounds(PivotHeaderGrid.this, column, row);
                    return rect.getSize();
                }

                public AccessibleAction getAccessibleAction() {
                    return this;
                }

                public int getAccessibleActionCount() {
                    return 2;
                }

                public String getAccessibleActionDescription(int i) {
                    if (i < 0 || i >= this.getAccessibleActionCount()) {
                        return null;
                    }
                    switch (i) {
                        case 0: {
                            return PivotHeader.this.__getAccessibleString(PivotHeader._DRILL_KEY);
                        }
                        case 1: {
                            return PivotHeader.this.__getAccessibleString(PivotHeader._COLLAPSE_KEY);
                        }
                    }
                    return null;
                }

                public boolean doAccessibleAction(int i) {
                    if (i < 0 || i >= this.getAccessibleActionCount()) {
                        return false;
                    }
                    AbstractPivotHeaderCell cell = this._getPivotHeaderCell();
                    if (cell == null) {
                        return false;
                    }
                    int column = cell.getColumn();
                    int row = cell.getRow();
                    boolean ok = true;
                    switch (i) {
                        case 0: {
                            ok = PivotHeader.this.isDrillable(column, row);
                            if (!ok) break;
                            PivotHeader.this.fireHeaderCellDrillRequest(column, row);
                            break;
                        }
                        case 1: {
                            ok = PivotHeader.this.isCollapsable(column, row);
                            if (!ok) break;
                            PivotHeader.this.fireCollapse(column, row);
                        }
                    }
                    return ok;
                }

                private AbstractPivotHeaderCell _getPivotHeaderCell() {
                    int pos = this.getAccessibleIndexInParent();
                    int row = PivotHeaderAccessibleGrid.this.getAccessibleRowAtIndex(pos);
                    int column = PivotHeaderAccessibleGrid.this.getAccessibleColumnAtIndex(pos);
                    if (row != -1 && column != -1) {
                        return PivotHeader.this.getPivotHeaderCell(column, row);
                    }
                    return null;
                }
            }
        }
    }

    public class PivotHeaderHeader
    extends Header {
        private boolean _resetCursor;

        public PivotHeaderHeader(OneDModel ds, int orientation) {
            super(ds, orientation);
            this.updateUI();
        }

        public String getUIClassID() {
            return "EWTPivotHeaderHeaderUI";
        }

        public final Insets getAutoscrollInsets() {
            return new Insets(0, 0, 0, 0);
        }

        protected final void paintExtraCanvas(Graphics g, PaintContext context, int x, int y, int width, int height) {
            g.setColor(this.getAppearance().getBackground());
            g.fillRect(x, y, width, height);
        }

        protected final void resetCursor() {
            if (this._resetCursor) {
                super.resetCursor();
            }
            this._resetCursor = false;
        }

        protected final int getItemPaintState(int baseState, int item) {
            if (PivotHeader.this._dragIndex == item || PivotHeader.this._swapping & PivotHeader.this._dropIndex == item) {
                baseState |= 2;
            } else if (PivotHeader.this._highlightItem == item) {
                baseState |= 0x22;
            }
            return baseState;
        }

        public void updateUI() {
            this.setUI((EWTPivotHeaderHeaderUI)UIManager.getUI(this));
        }

        protected final void processResizeEvent(HeaderEvent e) {
            super.processResizeEvent(e);
            if (e instanceof Cancelable && ((Cancelable)((Object)e)).isCancelled()) {
                return;
            }
            int id = e.getID();
            int item = e.getHeaderItem();
            if (id == 2006) {
                item = -1;
            }
            PivotHeader.this.setHeaderResizeItem(item);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void processMouseMotionEvent(MouseEvent e) {
            PivotTable table = PivotHeader.this.getPivotTable();
            if (table != null) {
                table.freezeRepaints();
            }
            try {
                this._resetCursor = e.getID() != 503;
                super.processMouseMotionEvent(e);
                PivotHeader.this.updateHeaderResizeFeedback();
            }
            finally {
                if (table != null) {
                    table.unfreezeRepaints();
                }
            }
        }

        protected Header.AccessibleHeader createAccessibleHeader() {
            return new PivotHeaderAccessibleHeader();
        }

        public class PivotHeaderAccessibleHeader
        extends Header.AccessibleHeader {
            protected String getAccessibleName(int index, Object data) {
                String name;
                String string = name = data == null ? null : super.getAccessibleName(index, data);
                if (name == null) {
                    name = IntegerUtils.getString((int)index);
                }
                String message = PivotHeader.this.__getAccessibleString("PIVOT_HEADER.NAMED_LEVEL");
                MessageFormat form = new MessageFormat(message);
                Object[] args = new Object[]{name};
                name = form.format(args);
                return name;
            }

            protected String getAccessibleNameForTable(int index, Object data, String itemName) {
                return itemName;
            }
        }
    }
}

