/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.print;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.print.PrinterGraphics;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.JComponent;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.print.IntegerPrinterGraphics;
import oracle.bali.ewt.print.IntegerPrinterGraphics2D;
import oracle.bali.ewt.print.PrintPaintContext;
import oracle.bali.ewt.print.StackPrintGraphics;
import oracle.bali.share.collection.StringKey;
import oracle.bali.share.util.IntegerUtils;

public class PrinterUtils {
    public static final Object PAGE_KEY = new StringKey("CurrPage");
    public static final Object XYPAGE_KEY = new StringKey("CurrXYPage");
    public static final Object PAGE_DIMENSION_KEY = new StringKey("PageSize");
    public static final Object CONTENT_DIMENSION_KEY = new StringKey("ContentSize");
    public static final Object PAGE_COUNT_KEY = new StringKey("PageCount");

    private PrinterUtils() {
    }

    public static void print(JComponent printee, Dictionary printProperties, boolean printByByColumns, Frame parentFrame, String jobName, Painter headerPainter, Painter footerPainter, Painter watermarkPainter, double topMargin, double leftMargin, double bottomMargin, double rightMargin) {
        PrintJob job = Toolkit.getDefaultToolkit().getPrintJob(parentFrame, jobName, null);
        if (job != null) {
            PrinterUtils.print(printee, printProperties, printByByColumns, job, headerPainter, footerPainter, watermarkPainter, topMargin, leftMargin, bottomMargin, rightMargin);
            job.end();
        }
    }

    public static void print(JComponent printee, Dictionary printProperties, boolean printByByColumns, PrintJob job, Painter headerPainter, Painter footerPainter, Painter watermarkPainter, double topMargin, double leftMargin, double bottomMargin, double rightMargin) {
        int pageDPI = job.getPageResolution();
        PrinterUtils.print(printee, printProperties, printByByColumns, job, headerPainter, footerPainter, watermarkPainter, (int)((double)pageDPI * topMargin), (int)((double)pageDPI * leftMargin), (int)((double)pageDPI * bottomMargin), (int)((double)pageDPI * rightMargin));
    }

    public static void print(JComponent printee, Dictionary printProperties, boolean printByByColumns, Frame parentFrame, String jobName, Painter headerPainter, Painter footerPainter, Painter watermarkPainter, int topMargin, int leftMargin, int bottomMargin, int rightMargin) {
        PrintJob job = Toolkit.getDefaultToolkit().getPrintJob(parentFrame, jobName, null);
        if (job != null) {
            PrinterUtils.print(printee, printProperties, printByByColumns, job, headerPainter, footerPainter, watermarkPainter, topMargin, leftMargin, bottomMargin, rightMargin);
            job.end();
        }
    }

    public static void print(JComponent printee, Dictionary printProperties, boolean printByByColumns, PrintJob job, Painter headerPainter, Painter footerPainter, Painter watermarkPainter, int topMargin, int leftMargin, int bottomMargin, int rightMargin) {
        if (printProperties == null) {
            printProperties = new Hashtable<Object, Serializable>(1);
        }
        Dimension pageSize = job.getPageDimension();
        int imagingWidth = pageSize.width - leftMargin - rightMargin;
        int imagingHeight = pageSize.height - topMargin - bottomMargin;
        ((Dictionary)printProperties).put(PAGE_DIMENSION_KEY, new Dimension(imagingWidth, imagingHeight));
        Graphics printGraphics = PrinterUtils._getPrintGraphics(job, printee);
        PrintPaintContext printContext = new PrintPaintContext(printee, printProperties);
        int currPage = 1;
        Integer currentPage = (Integer)((Dictionary)printProperties).get(PAGE_KEY);
        if (currentPage != null) {
            currPage = currentPage + 1;
        }
        int currYPage = currPage;
        int currXPage = 1;
        printContext.updatePage(printGraphics, currPage, currXPage, currYPage);
        int headerSize = 0;
        int footerSize = 0;
        if (headerPainter != null) {
            headerSize = headerPainter.getPreferredSize((PaintContext)printContext).height;
        }
        if (footerPainter != null) {
            footerSize = footerPainter.getPreferredSize((PaintContext)printContext).height;
        }
        LWComponent lwc = printee instanceof LWComponent ? (LWComponent)printee : null;
        int contentWidth = imagingWidth;
        int contentHeight = imagingHeight - headerSize - footerSize;
        ((Dictionary)printProperties).put(CONTENT_DIMENSION_KEY, new Dimension(contentWidth, contentHeight));
        Dimension documentSize = lwc == null ? printee.getSize() : lwc.getDocumentSize(printContext, printProperties);
        int outerYIncrement = 1;
        int outerXIncrement = 0;
        int innerYIncrement = 0;
        int innerXIncrement = 1;
        int outerLoopEnd = documentSize.height;
        int innerLoopEnd = documentSize.width;
        if (!printByByColumns) {
            outerYIncrement = 0;
            outerXIncrement = 1;
            innerYIncrement = 1;
            innerXIncrement = 0;
            outerLoopEnd = documentSize.width;
            innerLoopEnd = documentSize.height;
        }
        int currX = 0;
        int currY = 0;
        int currOuter = 0;
        while (currOuter < outerLoopEnd) {
            int currInner = 0;
            Rectangle newPageBounds = null;
            while (currInner < innerLoopEnd) {
                if (headerSize != 0) {
                    headerPainter.paint(printContext, printGraphics, leftMargin, topMargin, imagingWidth, headerSize);
                }
                if (footerSize != 0) {
                    footerPainter.paint(printContext, printGraphics, leftMargin, pageSize.height - bottomMargin - footerSize, imagingWidth, footerSize);
                }
                newPageBounds = lwc == null ? new Rectangle(contentWidth, contentHeight, contentWidth, contentHeight) : lwc.getPageBounds(printContext, printProperties, currX, currY, contentWidth, contentHeight);
                int currHeight = newPageBounds.height;
                printGraphics.translate(leftMargin, topMargin + headerSize);
                printGraphics.setClip(0, 0, newPageBounds.width, newPageBounds.height);
                printGraphics.translate(-currX, -currY);
                if (lwc == null) {
                    printee.print(printGraphics);
                } else {
                    lwc.printPage(printContext, printProperties, printGraphics);
                }
                if (watermarkPainter != null) {
                    watermarkPainter.paint(printContext, printGraphics, currX, currY, newPageBounds.width, newPageBounds.height);
                }
                if ((currInner = printByByColumns ? (currX += newPageBounds.x) : (currY += newPageBounds.y)) >= innerLoopEnd) continue;
                printGraphics.dispose();
                printGraphics = PrinterUtils._getPrintGraphics(job, printee);
                printContext.updatePage(printGraphics, ++currPage, currXPage += innerXIncrement, currYPage += innerYIncrement);
            }
            if (printByByColumns) {
                currX = 0;
                currXPage = 1;
                currOuter = currY += newPageBounds.y;
            } else {
                currY = 0;
                currYPage = 1;
                currOuter = currX += newPageBounds.x;
            }
            if (currOuter >= outerLoopEnd) continue;
            printGraphics.dispose();
            printGraphics = PrinterUtils._getPrintGraphics(job, printee);
            printContext.updatePage(printGraphics, ++currPage, currXPage += outerXIncrement, currYPage += outerYIncrement);
        }
        ((Dictionary)printProperties).put(PAGE_KEY, IntegerUtils.getInteger((int)currPage));
    }

    public static Object getPrinterProperty(Dictionary printerProperties, Object key, Object defaultValue) {
        Object newValue;
        if (printerProperties != null && (newValue = printerProperties.get(key)) != null) {
            return newValue;
        }
        return defaultValue;
    }

    public static boolean getPrinterProperty(Dictionary printerProperties, Object key, boolean defaultValue) {
        try {
            Boolean newValue = (Boolean)PrinterUtils.getPrinterProperty(printerProperties, key, null);
            if (newValue != null) {
                return newValue;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public static Graphics getIntegerPrintGraphics(PrinterGraphics g) {
        if (g instanceof Graphics2D) {
            return new IntegerPrinterGraphics2D(g);
        }
        return new IntegerPrinterGraphics(g);
    }

    private static Graphics _getPrintGraphics(PrintJob job, JComponent printComponent) {
        StackPrintGraphics printGraphics = new StackPrintGraphics(job.getGraphics());
        ((Graphics)printGraphics).setColor(printComponent.getForeground());
        ((Graphics)printGraphics).setFont(printComponent.getFont());
        return printGraphics;
    }
}

