/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.shuttle;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.button.ContinuousButtonModel;
import oracle.bali.ewt.elaf.EWTShuttleUI;
import oracle.bali.ewt.layout.EqualColumnLayout;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Reorderable;
import oracle.bali.ewt.shuttle.Reorderable2;
import oracle.bali.ewt.shuttle.ShuttleDnDSupport;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleLayout;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.bali.ewt.util.FocusUtils;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.share.util.IntegerUtils;

public class Shuttle
extends LWComponent
implements Accessible {
    public static final String FROM_HEADER_COMPONENT = "FromHeader";
    public static final String TO_HEADER_COMPONENT = "ToHeader";
    public static final String FROM_FOOTER_COMPONENT = "FromFooter";
    public static final String TO_FOOTER_COMPONENT = "ToFooter";
    public static final String COMMON_FOOTER_COMPONENT = "CommonFooter";
    public static final String BUTTON_AREA_COMPONENT = "ButtonArea";
    public static final int ICON_MODE = 1;
    public static final int TEXT_MODE = 2;
    public static final int MOVE_BUTTON = 1;
    public static final int MOVE_ALL_BUTTON = 2;
    public static final int REMOVE_BUTTON = 4;
    public static final int REMOVE_ALL_BUTTON = 8;
    public static final int MOVE_MODE = 0;
    public static final int COPY_MODE = 1;
    public static final int BUTTON_INDEX_ADD = 0;
    public static final int BUTTON_INDEX_REMOVE = 1;
    public static final int BUTTON_INDEX_ADD_ALL = 2;
    public static final int BUTTON_INDEX_REMOVE_ALL = 3;
    public static final int BUTTON_INDEX_COPY = 4;
    public static final int BUTTON_INDEX_COPY_ALL = 5;
    public static final int BUTTON_INDEX_UP = 6;
    public static final int BUTTON_INDEX_DOWN = 7;
    public static final int BUTTON_INDEX_TOP = 8;
    public static final int BUTTON_INDEX_BOTTOM = 9;
    private boolean _ignoreSelectionEvents = false;
    private LayoutManager _HORIZONTAL_BUTTON_LAYOUT;
    private LayoutManager _VERTICAL_BUTTON_LAYOUT;
    private ItemPicker _fromPicker;
    private ItemPicker _toPicker;
    private JPanel _shuttleButtons;
    private JButton _addButton;
    private JButton _removeButton;
    private JButton _addAllButton;
    private JButton _removeAllButton;
    private JButton _toReorderUp;
    private JButton _toReorderDown;
    private JButton _toReorderTop;
    private JButton _toReorderBottom;
    private JButton _fromReorderUp;
    private JButton _fromReorderDown;
    private JButton _fromReorderTop;
    private JButton _fromReorderBottom;
    private Header _fromHeader;
    private Header _toHeader;
    private int _buttonMode;
    private int _buttonsShown;
    private int _itemsUnique;
    private boolean _horizontalLayout = true;
    private boolean _reversed;
    private boolean _actualReversed;
    private String[] _buttonLabels;
    private int[] _buttonMnemonics;
    private static Image[] _buttonImages;
    private ShuttleHandler _handler;
    private ListenerManager _shuttleListeners;
    private int[] _actionMap;
    private ShuttleDnDSupport _shuttleDnDSupport;
    private static final int _INTERIOR_BUTTON_GAP = 3;
    private static final LayoutManager _REORDER_LAYOUT;
    private static final int _STRINGINDEX_MOVE = 0;
    private static final int _STRINGINDEX_MOVEALL = 1;
    private static final int _STRINGINDEX_REMOVE = 2;
    private static final int _STRINGINDEX_REMOVEALL = 3;
    private static final int _STRINGINDEX_COPY = 4;
    private static final int _STRINGINDEX_COPYALL = 5;
    private static final int _STRINGINDEX_REORDER_UP = 6;
    private static final int _STRINGINDEX_REORDER_DOWN = 7;
    private static final int _STRINGINDEX_REORDER_TOP = 8;
    private static final int _STRINGINDEX_REORDER_BOTTOM = 9;
    private static final int _OLD_MNEMONIC_COUNT = 6;
    private static final int _MNEMONIC_COUNT = 10;
    private static final String _RESOURCE_BUNDLE = "oracle.bali.ewt.resource.JEWTBundle";
    private static final String _MOVE_KEY = "SHUTTLE.MOVE";
    private static final String _REMOVE_KEY = "SHUTTLE.REMOVE";
    private static final String _MOVE_ALL_KEY = "SHUTTLE.MOVE_ALL";
    private static final String _REMOVE_ALL_KEY = "SHUTTLE.REMOVE_ALL";
    private static final String _COPY_KEY = "SHUTTLE.COPY";
    private static final String _COPY_ALL_KEY = "SHUTTLE.COPY_ALL";
    private static final String _REORDER_UP_KEY = "SHUTTLE.REORDER_UP";
    private static final String _REORDER_DOWN_KEY = "SHUTTLE.REORDER_DOWN";
    private static final String _REORDER_TOP_KEY = "SHUTTLE.REORDER_TOP";
    private static final String _REORDER_BOTTOM_KEY = "SHUTTLE.REORDER_BOTTOM";
    private static final String _BUTTON_TOOL_TIP_KEY = "SHUTTLE.BUTTON_TOOL_TIP";
    private static Method _sIconGapMethod;
    private static final String _ADD_NAME = "Add";
    private static final String _ADD_ALL_NAME = "Add All";
    private static final String _REMOVE_NAME = "Remove";
    private static final String _REMOVE_ALL_NAME = "Remove All";
    private static final String _UP_NAME = "Up";
    private static final String _DOWN_NAME = "Down";
    private static final String _TOP_NAME = "Top";
    private static final String _BOTTOM_NAME = "Bottom";
    private static final String _LABELED_BY = "labeledBy";

    public Shuttle() {
        ShuttleLayout layout = this._createLayoutManager();
        super.setLayout(layout);
        this._buttonMode = 1;
        this._buttonsShown = 15;
        this._shuttleButtons = new JPanel();
        FocusUtils.setFocusable(this._shuttleButtons, false);
        this._handler = new ShuttleHandler();
        this._addButton = this._createButton(_ADD_NAME);
        this._removeButton = this._createButton(_REMOVE_NAME);
        this._addAllButton = this._createButton(_ADD_ALL_NAME);
        this._removeAllButton = this._createButton(_REMOVE_ALL_NAME);
        this._loadCompatibleButtonLabels();
        this._updateButtonVisibility();
        this._shuttleButtons.add(this._addButton);
        this._shuttleButtons.add(this._addAllButton);
        this._shuttleButtons.add(this._removeButton);
        this._shuttleButtons.add(this._removeAllButton);
        this.add((Component)this._shuttleButtons, "ShuttleControl");
        this.addPropertyChangeListener(this._handler);
        this.updateUI();
    }

    public void dispose() {
        Enumeration e;
        if (this._shuttleButtons == null) {
            return;
        }
        ItemPicker fromPicker = this._fromPicker;
        this.setFromPicker(null);
        if (fromPicker != null && fromPicker instanceof ListPicker) {
            ((ListPicker)fromPicker).dispose();
        }
        this._fromPicker = null;
        ItemPicker toPicker = this._toPicker;
        this.setToPicker(null);
        if (toPicker != null && toPicker instanceof ListPicker) {
            ((ListPicker)toPicker).dispose();
        }
        this._toPicker = null;
        this._disposeReorderControls();
        if (this._fromHeader != null) {
            this._fromHeader.setHeader(null);
            this._fromHeader = null;
        }
        if (this._toHeader != null) {
            this._toHeader.setHeader(null);
            this._toHeader = null;
        }
        if (this._shuttleDnDSupport != null) {
            this._shuttleDnDSupport.dispose();
            this._shuttleDnDSupport = null;
        }
        this._addButton.removeActionListener(this._handler);
        this._addButton = null;
        this._removeButton.removeActionListener(this._handler);
        this._removeButton = null;
        this._addAllButton.removeActionListener(this._handler);
        this._addAllButton = null;
        this._removeAllButton.removeActionListener(this._handler);
        this._removeAllButton = null;
        this.removePropertyChangeListener(this._handler);
        this._handler = null;
        this._buttonLabels = null;
        this._buttonMnemonics = null;
        this._actionMap = null;
        if (this._shuttleListeners != null && (e = this._shuttleListeners.getListeners()) != null) {
            while (e.hasMoreElements()) {
                this._shuttleListeners.removeListener((EventListener)e.nextElement());
            }
        }
        this._shuttleListeners = null;
        this._shuttleButtons.removeAll();
        this._shuttleButtons.setLayout(null);
        this._shuttleButtons = null;
        this.removeAll();
        this.setLayout(null);
    }

    public synchronized void addShuttleListener(ShuttleListener listener) {
        if (this._shuttleListeners == null) {
            this._shuttleListeners = new ListenerManager();
        }
        this._shuttleListeners.addListener((EventListener)listener);
    }

    public synchronized void removeShuttleListener(ShuttleListener listener) {
        this._shuttleListeners.removeListener((EventListener)listener);
    }

    public void setFromPicker(ItemPicker fromPicker) {
        if (this._fromPicker != null) {
            this.remove(this._fromPicker.getComponent());
        }
        if (fromPicker != null) {
            this.add(fromPicker.getComponent(), "FromList");
            if (this._fromHeader == null) {
                this._fromHeader = new Header(fromPicker, null, true);
                this.add((Component)this._fromHeader, FROM_HEADER_COMPONENT);
            }
        }
        if (this._fromHeader != null) {
            this._fromHeader.setItemPicker(fromPicker);
        }
        this._setFromPicker(fromPicker);
    }

    public final ItemPicker getFromPicker() {
        return this._fromPicker;
    }

    public void setToPicker(ItemPicker toPicker) {
        if (this._toPicker != null) {
            this.remove(this._toPicker.getComponent());
        }
        if (toPicker != null) {
            this.add(toPicker.getComponent(), "ToList");
            if (this._toHeader == null) {
                this._toHeader = new Header(toPicker, null, false);
                this.add((Component)this._toHeader, TO_HEADER_COMPONENT);
            }
        }
        if (this._toHeader != null) {
            this._toHeader.setItemPicker(toPicker);
        }
        this._setToPicker(toPicker);
    }

    public final ItemPicker getToPicker() {
        return this._toPicker;
    }

    public Component getComponent(Object constraint) {
        if (constraint == FROM_HEADER_COMPONENT) {
            return this._fromHeader == null ? null : this._fromHeader.getUserHeader();
        }
        if (constraint == TO_HEADER_COMPONENT) {
            return this._toHeader == null ? null : this._toHeader.getUserHeader();
        }
        return this._getLayout().getComponent(constraint);
    }

    public void setUseTextButtons(boolean useTextLabels) {
        if (useTextLabels) {
            this.setButtonDisplayMode(2);
        } else {
            this.setButtonDisplayMode(1);
        }
    }

    public void setButtonDisplayMode(int buttonMode) {
        if (buttonMode != this._buttonMode) {
            if (buttonMode < 1 || buttonMode > 3) {
                throw new IllegalArgumentException();
            }
            this._buttonMode = buttonMode;
            this._updateButtonContents();
            this._updateButtonMnemonics();
            this._updateReorderContents();
        }
    }

    public int getButtonDisplayMode() {
        return this._buttonMode;
    }

    public boolean getUseTextButtons() {
        return (this._buttonMode & 2) != 0;
    }

    public boolean isHorizontalLayout() {
        return this._horizontalLayout;
    }

    public boolean isLayoutReversed() {
        return this._reversed;
    }

    public int getMode() {
        return this._itemsUnique;
    }

    public void setHorizontalLayout(boolean horizontal) {
        if (horizontal != this._horizontalLayout) {
            this._horizontalLayout = horizontal;
            this._getLayout().setHorizontalLayout(horizontal);
            if (this._horizontalLayout) {
                this._shuttleButtons.setLayout(this._HORIZONTAL_BUTTON_LAYOUT);
            } else {
                this._shuttleButtons.setLayout(this._VERTICAL_BUTTON_LAYOUT);
            }
            this._updateButtonContents();
            this.revalidate();
            AccessibleContext ac = this.accessibleContext;
            if (ac != null) {
                ac.firePropertyChange("AccessibleState", horizontal ? AccessibleState.VERTICAL : AccessibleState.HORIZONTAL, horizontal ? AccessibleState.HORIZONTAL : AccessibleState.VERTICAL);
            }
        }
    }

    public void setLayoutReversed(boolean reversed) {
        this._reversed = reversed;
        int direction = this.getActualReadingDirection();
        if (direction == 2) {
            this._setActualLayoutReversed(!reversed);
        } else {
            this._setActualLayoutReversed(reversed);
        }
    }

    public void setMode(int mode) {
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException();
        }
        if (mode != this._itemsUnique) {
            this._itemsUnique = mode;
            this._updateButtonContents();
            this._updateButtonMnemonics();
            this.revalidate();
            this._createShuttleDnDSupport();
        }
    }

    public void setMoveAllAllowed(boolean moveAllButtonsShown) {
        if (moveAllButtonsShown) {
            this.setButtonsShown(this._buttonsShown | 2 | 8);
        } else {
            this.setButtonsShown(this._buttonsShown & 0xFFFFFFFD & 0xFFFFFFF7);
        }
    }

    public void setMoveAllowed(boolean moveButtonsShown) {
        if (moveButtonsShown) {
            this.setButtonsShown(this._buttonsShown | 1 | 4);
        } else {
            this.setButtonsShown(this._buttonsShown & 0xFFFFFFFE & 0xFFFFFFFB);
        }
    }

    public void setButtonsShown(int buttonsShown) {
        if (buttonsShown != this._buttonsShown) {
            this._buttonsShown = buttonsShown;
            this._updateButtonVisibility();
        }
    }

    public String[] getButtonLabels() {
        if (this._buttonLabels == null) {
            this._loadCompatibleButtonLabels();
        }
        String[] result = new String[]{this._buttonLabels[0], this._buttonLabels[2], this._buttonLabels[1], this._buttonLabels[3], this._buttonLabels[4], this._buttonLabels[5], this._buttonLabels[6], this._buttonLabels[7], this._buttonLabels[8], this._buttonLabels[9]};
        return result;
    }

    public void setButtonLabels(String[] labels) {
        if (labels == null) {
            this._loadCompatibleButtonLabels();
        } else {
            if (labels.length < 6) {
                throw new IllegalArgumentException("Must provide all 6 button labels");
            }
            if (this._buttonLabels == null) {
                this._loadCompatibleButtonLabels();
            }
            this._buttonLabels[0] = labels[0];
            this._buttonLabels[2] = labels[1];
            this._buttonLabels[1] = labels[2];
            this._buttonLabels[3] = labels[3];
            this._buttonLabels[4] = labels[4];
            this._buttonLabels[5] = labels[5];
            this._updateMnemonicsfromLabel(labels);
        }
        this._updateButtonContents();
        this._updateButtonMnemonics();
    }

    public int[] getButtonMnemonics() {
        int[] result = null;
        if (this._buttonMnemonics != null) {
            result = new int[]{this._buttonMnemonics[0], this._buttonMnemonics[2], this._buttonMnemonics[1], this._buttonMnemonics[3], this._buttonMnemonics[4], this._buttonMnemonics[5], this._buttonMnemonics[6], this._buttonMnemonics[7], this._buttonMnemonics[8], this._buttonMnemonics[9]};
        } else {
            result = this._getDefaultMnemonics();
            int addAll = result[1];
            int remove = result[2];
            result[2] = addAll;
            result[1] = remove;
        }
        return result;
    }

    public void setButtonMnemonics(int[] mnemonics) {
        if (mnemonics == null) {
            this._buttonMnemonics = null;
        } else {
            if (mnemonics.length != 10 && mnemonics.length != 6) {
                throw new IllegalArgumentException("wrong mnemonic count");
            }
            if (this._buttonMnemonics == null || this._buttonMnemonics.length != 10) {
                this._buttonMnemonics = new int[10];
            }
            this._buttonMnemonics[0] = mnemonics[0];
            this._buttonMnemonics[2] = mnemonics[1];
            this._buttonMnemonics[1] = mnemonics[2];
            this._buttonMnemonics[3] = mnemonics[3];
            this._buttonMnemonics[4] = mnemonics[4];
            this._buttonMnemonics[5] = mnemonics[5];
            if (mnemonics.length == 6) {
                this._buttonMnemonics[6] = 0;
                this._buttonMnemonics[7] = 0;
                this._buttonMnemonics[8] = 0;
                this._buttonMnemonics[9] = 0;
            } else {
                this._buttonMnemonics[6] = mnemonics[6];
                this._buttonMnemonics[7] = mnemonics[7];
                this._buttonMnemonics[8] = mnemonics[8];
                this._buttonMnemonics[9] = mnemonics[9];
            }
        }
        this._updateButtonMnemonics();
        this._updateButtonContents();
        this._updateReorderContents();
    }

    public boolean isMoveAllAllowed() {
        return (this._buttonsShown & 2) != 0 && (this._buttonsShown & 8) != 0;
    }

    public boolean isMoveAllowed() {
        return (this._buttonsShown & 1) != 0 && (this._buttonsShown & 4) != 0;
    }

    public int getButtonsShown() {
        return this._buttonsShown;
    }

    public void remove(Component comp) {
        if (comp != null && comp.getParent() == this._shuttleButtons) {
            this._shuttleButtons.remove(comp);
            this._updateButtonFocus();
        } else if (comp != null && comp.getParent() instanceof Header) {
            ((Header)comp.getParent()).setHeader(null);
            this._updateButtonFocus();
        } else {
            this._updateFooterVisiblity(comp, false);
            super.remove(comp);
        }
    }

    public void setFont(Font f) {
        super.setFont(f);
        this._updateButtonFonts();
    }

    public void addNotify() {
        super.addNotify();
        this._updateButtonFonts();
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (constraints == null || constraints == BUTTON_AREA_COMPONENT) {
            int newIndex = this._shuttleButtons.getComponentCount();
            if (this.isMoveAllowed()) {
                newIndex -= 2;
            } else if (this.isMoveAllAllowed()) {
                --newIndex;
            }
            this._shuttleButtons.add(comp, newIndex);
            this._updateButtonFocus();
            this._updateButtonFonts();
            this.revalidate();
        } else {
            ShuttleLayout layout = this._getLayout();
            Component c = this.getComponent(constraints);
            if (constraints == FROM_HEADER_COMPONENT) {
                if (this._fromHeader == null) {
                    this._fromHeader = new Header(this._fromPicker, comp, true);
                    comp = this._fromHeader;
                } else if (comp != this._fromHeader) {
                    this._fromHeader.setHeader(comp);
                    this._updateButtonFocus();
                    return;
                }
            } else if (constraints == TO_HEADER_COMPONENT) {
                if (this._toHeader == null) {
                    this._toHeader = new Header(this._toPicker, comp, false);
                    comp = this._toHeader;
                } else if (comp != this._toHeader) {
                    this._toHeader.setHeader(comp);
                    this._updateButtonFocus();
                    return;
                }
            }
            super.addImpl(comp, constraints, index);
            if (c != null) {
                super.remove(c);
            }
            if (this._updateFooterVisiblity(comp, true)) {
                this._updateButtonFocus();
            }
        }
    }

    public String getUIClassID() {
        return "EWTShuttleUI";
    }

    public void setLayout(LayoutManager newLayout) {
        if (newLayout instanceof ShuttleLayout) {
            super.setLayout(newLayout);
        }
    }

    public void setLocale(Locale l) {
        super.setLocale(l);
        if (this._addButton != null) {
            this._loadCompatibleButtonLabels();
            this._updateButtonContents();
            this._updateButtonMnemonics();
        }
        if (this._fromReorderUp != null || this._toReorderUp != null) {
            this._updateReorderContents();
        }
        if (this._fromHeader != null) {
            this._fromHeader.loadButtonLabel();
        }
        if (this._toHeader != null) {
            this._toHeader.loadButtonLabel();
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Component[] children = this.getComponents();
        for (int i = 0; i < children.length; ++i) {
            children[i].setEnabled(enabled);
        }
        if (this._toReorderUp != null) {
            this._toReorderUp.setEnabled(enabled);
            this._toReorderDown.setEnabled(enabled);
        }
        if (this._fromReorderUp != null) {
            this._fromReorderUp.setEnabled(enabled);
            this._fromReorderDown.setEnabled(enabled);
        }
        if (this._toReorderTop != null) {
            this._toReorderTop.setEnabled(enabled);
            this._toReorderBottom.setEnabled(enabled);
        }
        if (this._fromReorderTop != null) {
            this._fromReorderTop.setEnabled(enabled);
            this._fromReorderBottom.setEnabled(enabled);
        }
        Component[] comps = this._shuttleButtons.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            comps[i].setEnabled(enabled);
        }
        if (enabled) {
            this._updateReorderButtonsEnabled(this._toPicker, null);
            if (this._fromPicker != null) {
                this._updateButtonsEnabled(this._fromPicker);
            }
            if (this._toPicker != null) {
                this._updateButtonsEnabled(this._toPicker);
            }
        }
    }

    public void removeAll() {
        if (this._shuttleButtons != null) {
            this._shuttleButtons.removeAll();
        }
        this._setFromPicker(null);
        this._setToPicker(null);
        super.removeAll();
    }

    public void setNextFocusableComponent(Component c) {
        super.setNextFocusableComponent(c);
        this._getLayout().updateFocusCycle();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleShuttle();
        }
        return this.accessibleContext;
    }

    public void updateUI() {
        this.setUI((EWTShuttleUI)UIManager.getUI(this));
        EWTShuttleUI sui = (EWTShuttleUI)this.ui;
        this._HORIZONTAL_BUTTON_LAYOUT = sui.getHorizontalButtonLayout(this);
        this._VERTICAL_BUTTON_LAYOUT = sui.getVerticalButtonLayout(this);
        if (this._horizontalLayout) {
            this._shuttleButtons.setLayout(this._HORIZONTAL_BUTTON_LAYOUT);
        } else {
            this._shuttleButtons.setLayout(this._VERTICAL_BUTTON_LAYOUT);
        }
        this._updateButtonContents();
        this._updateButtonMnemonics();
        this._updateButtonMargins();
        this._updateReorderContents();
        Color backColor = UIManager.getColor("control");
        if (this._toReorderUp != null) {
            this._toReorderUp.setBackground(backColor);
            this._toReorderDown.setBackground(backColor);
        }
        if (this._fromReorderUp != null) {
            this._fromReorderUp.setBackground(backColor);
            this._fromReorderDown.setBackground(backColor);
        }
        this._updateButtonFonts();
    }

    protected String paramString() {
        String describingString = super.paramString();
        describingString = describingString + ", mode=" + (this.getMode() == 0 ? "MOVE" : "COPY");
        describingString = describingString + ", horizontal=" + this.isHorizontalLayout();
        describingString = describingString + ", reverseLayout=" + this.isLayoutReversed();
        describingString = describingString + ", moveAllAllowed=" + this.isMoveAllAllowed();
        describingString = describingString + ", textLabels=" + this.getUseTextButtons();
        return describingString;
    }

    protected void validateTree() {
        super.validateTree();
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            this._getLayout().updateFocusCycle();
        }
    }

    private void _updateButtonFonts() {
        Font f = this.getFont();
        if (f != null) {
            float size = f.getSize2D() - 2.0f;
            if (size < 10.0f) {
                size = Math.min(f.getSize2D(), 10.0f);
            }
            f = f.deriveFont(size);
            for (int i = 0; i < this._shuttleButtons.getComponentCount(); ++i) {
                this._shuttleButtons.getComponent(i).setFont(f);
            }
            if (this._toReorderUp != null) {
                this._toReorderUp.setFont(f);
                this._toReorderDown.setFont(f);
            }
            if (this._toReorderTop != null) {
                this._toReorderTop.setFont(f);
                this._toReorderBottom.setFont(f);
            }
            if (this._fromReorderUp != null) {
                this._fromReorderUp.setFont(f);
                this._fromReorderDown.setFont(f);
            }
            if (this._fromReorderTop != null) {
                this._fromReorderTop.setFont(f);
                this._fromReorderBottom.setFont(f);
            }
        }
    }

    private void _setFromPicker(ItemPicker fromPicker) {
        ItemPicker oldPicker = this._fromPicker;
        this._fromPicker = fromPicker;
        this._setPicker(oldPicker, fromPicker, this._toPicker, false);
    }

    private void _setToPicker(ItemPicker toPicker) {
        ItemPicker oldPicker = this._toPicker;
        this._toPicker = toPicker;
        this._setPicker(oldPicker, this._toPicker, this._fromPicker, true);
    }

    private void _setPicker(ItemPicker oldPicker, ItemPicker newPicker, ItemPicker otherPicker, boolean isTo) {
        if (oldPicker != newPicker) {
            if (oldPicker != null) {
                oldPicker.removePropertyChangeListener(this._handler);
                oldPicker.removeActionListener(this._handler);
                boolean remove = false;
                if (oldPicker instanceof Reorderable2) {
                    remove = !(newPicker instanceof Reorderable2);
                } else if (oldPicker instanceof Reorderable) {
                    boolean bl = remove = newPicker instanceof Reorderable2 || !(newPicker instanceof Reorderable);
                }
                if (remove) {
                    this._removeReorderControls(isTo);
                }
            }
            if (newPicker != null) {
                newPicker.addPropertyChangeListener(this._handler);
                newPicker.addActionListener(this._handler);
                boolean create = false;
                if (newPicker instanceof Reorderable2) {
                    create = !(oldPicker instanceof Reorderable2);
                } else if (newPicker instanceof Reorderable) {
                    boolean bl = create = oldPicker instanceof Reorderable2 || !(oldPicker instanceof Reorderable);
                }
                if (create) {
                    boolean createTopDown = newPicker instanceof Reorderable2;
                    this._createReorderControls(isTo, createTopDown);
                    this._updateButtonsEnabled(newPicker);
                } else if (newPicker instanceof Reorderable) {
                    this._updateReorderButtonsEnabled(newPicker, null);
                } else {
                    this._updateButtonsEnabled(newPicker);
                }
                if (otherPicker != null) {
                    this._updateButtonsEnabled(otherPicker);
                }
            }
            this._createShuttleDnDSupport();
        }
    }

    private Component _getFromComponent() {
        return this._fromPicker != null ? this._fromPicker.getComponent() : null;
    }

    private Component _getToComponent() {
        return this._toPicker != null ? this._toPicker.getComponent() : null;
    }

    private Component _getShuttleControl() {
        return this._getLayout().getShuttleControl();
    }

    private ShuttleLayout _getLayout() {
        return (ShuttleLayout)this.getLayout();
    }

    private ShuttleLayout _createLayoutManager() {
        return new ShuttleLayout(this);
    }

    private JButton _createButton(String buttonName) {
        JButton newButton = new JButton("");
        newButton.setHorizontalTextPosition(0);
        newButton.setVerticalTextPosition(3);
        newButton.addActionListener(this._handler);
        newButton.setMargin(this._getButtonMargin());
        Shuttle._setIconTextGap(newButton);
        newButton.setName(buttonName);
        return newButton;
    }

    private Insets _getButtonMargin() {
        return UIManager.getInsets("EWTShuttleButton.margin");
    }

    private static void _setIconTextGap(AbstractButton b) {
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            if (_sIconGapMethod == null) {
                try {
                    _sIconGapMethod = AbstractButton.class.getMethod("setIconTextGap", Integer.TYPE);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (_sIconGapMethod != null) {
                try {
                    _sIconGapMethod.invoke((Object)b, IntegerUtils.getInteger((int)0));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void _updateButtonVisibility() {
        this._addAllButton.setVisible((this._buttonsShown & 2) != 0);
        this._removeAllButton.setVisible((this._buttonsShown & 8) != 0);
        this._addButton.setVisible((this._buttonsShown & 1) != 0);
        this._removeButton.setVisible((this._buttonsShown & 4) != 0);
        this._updateButtonFocus();
    }

    private void _updateButtonFocus() {
        int count = this._shuttleButtons.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = this._shuttleButtons.getComponent(i);
            if (!(c instanceof JComponent)) continue;
            ((JComponent)c).setNextFocusableComponent(null);
        }
        this._getLayout().updateFocusCycle();
    }

    private void _loadButtonImage(JButton button, int type) {
        Image[] images = _buttonImages;
        if (images == null) {
            images = new Image[8];
        }
        if (this._isActualLayoutReversed()) {
            type = (type + 2) % 4;
        }
        if (!this.isHorizontalLayout()) {
            type += 4;
        }
        EWTShuttleUI sui = (EWTShuttleUI)this.ui;
        button.setIcon(sui.getButtonIcon(this, type));
    }

    private void _updateButtonContents() {
        boolean copy = this.getMode() == 1;
        String[] labels = this._buttonLabels;
        if ((this._buttonMode & 2) != 0) {
            this._addButton.setText(StringUtils.stripMnemonic((String)(copy ? labels[4] : labels[0])));
            this._addAllButton.setText(StringUtils.stripMnemonic((String)(copy ? labels[5] : labels[1])));
            this._removeButton.setText(StringUtils.stripMnemonic((String)labels[2]));
            this._removeAllButton.setText(StringUtils.stripMnemonic((String)labels[3]));
            this._addButton.setToolTipText(null);
            this._removeButton.setToolTipText(null);
            this._addAllButton.setToolTipText(null);
            this._removeAllButton.setToolTipText(null);
        } else {
            this._addButton.setText(null);
            this._removeButton.setText(null);
            this._addAllButton.setText(null);
            this._removeAllButton.setText(null);
            this._updateButtonMnemonics();
            String[] args = new String[2];
            ResourceBundle shuttleBundle = ResourceBundle.getBundle(_RESOURCE_BUNDLE, LocaleUtils.getDefaultableLocale((Component)this));
            String pattern = shuttleBundle.getString(_BUTTON_TOOL_TIP_KEY);
            String tipText = null;
            args[0] = StringUtils.stripMnemonic((String)(copy ? labels[4] : labels[0]));
            args[1] = this._getAcceleratorString(this._addButton.getMnemonic());
            tipText = "".equals(args[1]) ? args[0] : MessageFormat.format(pattern, args);
            this._addButton.setToolTipText(tipText);
            args[0] = StringUtils.stripMnemonic((String)(copy ? labels[5] : labels[1]));
            args[1] = this._getAcceleratorString(this._addAllButton.getMnemonic());
            tipText = "".equals(args[1]) ? args[0] : MessageFormat.format(pattern, args);
            this._addAllButton.setToolTipText(tipText);
            args[0] = StringUtils.stripMnemonic((String)labels[2]);
            args[1] = this._getAcceleratorString(this._removeButton.getMnemonic());
            tipText = "".equals(args[1]) ? args[0] : MessageFormat.format(pattern, args);
            this._removeButton.setToolTipText(tipText);
            args[0] = StringUtils.stripMnemonic((String)labels[3]);
            args[1] = this._getAcceleratorString(this._removeAllButton.getMnemonic());
            tipText = "".equals(args[1]) ? args[0] : MessageFormat.format(pattern, args);
            this._removeAllButton.setToolTipText(tipText);
        }
        if ((this._buttonMode & 1) != 0) {
            this._loadButtonImage(this._addButton, 0);
            this._loadButtonImage(this._removeButton, 2);
            this._loadButtonImage(this._addAllButton, 1);
            this._loadButtonImage(this._removeAllButton, 3);
        } else {
            this._addButton.setIcon(null);
            this._addAllButton.setIcon(null);
            this._removeButton.setIcon(null);
            this._removeAllButton.setIcon(null);
        }
        AccessibleContext ac = this._addButton.getAccessibleContext();
        ac.setAccessibleName(StringUtils.stripMnemonic((String)(copy ? labels[4] : labels[0])));
        ac.setAccessibleDescription(ac.getAccessibleName());
        ac = this._addAllButton.getAccessibleContext();
        ac.setAccessibleName(StringUtils.stripMnemonic((String)(copy ? labels[5] : labels[1])));
        ac.setAccessibleDescription(ac.getAccessibleName());
        ac = this._removeButton.getAccessibleContext();
        ac.setAccessibleName(StringUtils.stripMnemonic((String)labels[2]));
        ac.setAccessibleDescription(ac.getAccessibleName());
        ac = this._removeAllButton.getAccessibleContext();
        ac.setAccessibleName(StringUtils.stripMnemonic((String)labels[3]));
        ac.setAccessibleDescription(ac.getAccessibleName());
    }

    private void _updateReorderContents() {
        AccessibleContext ac;
        int[] mnemonics;
        boolean textMode;
        if (this._toReorderUp == null && this._fromReorderUp == null) {
            return;
        }
        EWTShuttleUI sui = (EWTShuttleUI)this.ui;
        boolean reversed = this._isActualLayoutReversed();
        Icon buttonP = null;
        String[] args = new String[2];
        ResourceBundle shuttleBundle = ResourceBundle.getBundle(_RESOURCE_BUNDLE, LocaleUtils.getDefaultableLocale((Component)this));
        String pattern = shuttleBundle.getString(_BUTTON_TOOL_TIP_KEY);
        String tipText = null;
        int buttonMode = this.getButtonDisplayMode();
        boolean iconMode = (buttonMode & 1) != 0;
        boolean bl = textMode = (buttonMode & 2) != 0;
        if (this._buttonLabels == null) {
            this._loadCompatibleButtonLabels();
        }
        String up = StringUtils.stripMnemonic((String)this._buttonLabels[6]);
        String down = StringUtils.stripMnemonic((String)this._buttonLabels[7]);
        String top = null;
        String bottom = null;
        if (this._toReorderTop != null || this._fromReorderTop != null) {
            top = StringUtils.stripMnemonic((String)this._buttonLabels[8]);
            bottom = StringUtils.stripMnemonic((String)this._buttonLabels[9]);
        }
        if ((mnemonics = this._buttonMnemonics) == null) {
            mnemonics = this._getDefaultMnemonics();
        }
        if (this._toReorderUp != null) {
            if (textMode) {
                this._toReorderUp.setMnemonic(mnemonics[6]);
                this._toReorderDown.setMnemonic(mnemonics[7]);
            } else {
                this._toReorderUp.setMnemonic(0);
                this._toReorderDown.setMnemonic(0);
            }
            ac = this._toReorderUp.getAccessibleContext();
            ac.setAccessibleName(up);
            ac.setAccessibleDescription(up);
            ac = this._toReorderDown.getAccessibleContext();
            ac.setAccessibleName(down);
            ac.setAccessibleDescription(down);
            if (iconMode) {
                buttonP = sui.getButtonIcon(this, reversed ? 10 : 8);
                this._toReorderUp.setIcon(buttonP);
                buttonP = sui.getButtonIcon(this, reversed ? 11 : 9);
                this._toReorderDown.setIcon(buttonP);
            } else {
                this._toReorderUp.setIcon(null);
                this._toReorderDown.setIcon(null);
            }
            if (textMode) {
                this._toReorderUp.setText(up);
                this._toReorderDown.setText(down);
                this._toReorderUp.setToolTipText(null);
                this._toReorderDown.setToolTipText(null);
            } else {
                this._toReorderUp.setText(null);
                this._toReorderDown.setText(null);
                args[0] = up;
                args[1] = this._getAcceleratorString(this._toReorderUp.getMnemonic());
                tipText = "".equals(args[1]) ? args[0] : MessageFormat.format(pattern, args);
                this._toReorderUp.setToolTipText(tipText);
                args[0] = down;
                args[1] = this._getAcceleratorString(this._toReorderDown.getMnemonic());
                tipText = "".equals(args[1]) ? args[0] : MessageFormat.format(pattern, args);
                this._toReorderDown.setToolTipText(tipText);
            }
        }
        if (this._toReorderTop != null) {
            if (textMode) {
                this._toReorderTop.setMnemonic(mnemonics[8]);
                this._toReorderBottom.setMnemonic(mnemonics[9]);
            } else {
                this._toReorderTop.setMnemonic(0);
                this._toReorderBottom.setMnemonic(0);
            }
            ac = this._toReorderTop.getAccessibleContext();
            ac.setAccessibleName(top);
            ac.setAccessibleDescription(top);
            ac = this._toReorderBottom.getAccessibleContext();
            ac.setAccessibleName(bottom);
            ac.setAccessibleDescription(bottom);
            if (iconMode) {
                buttonP = sui.getButtonIcon(this, reversed ? 14 : 12);
                this._toReorderTop.setIcon(buttonP);
                buttonP = sui.getButtonIcon(this, reversed ? 15 : 13);
                this._toReorderBottom.setIcon(buttonP);
            } else {
                this._toReorderTop.setIcon(null);
                this._toReorderBottom.setIcon(null);
            }
            if (textMode) {
                this._toReorderTop.setText(top);
                this._toReorderBottom.setText(bottom);
                this._toReorderTop.setToolTipText(null);
                this._toReorderBottom.setToolTipText(null);
            } else {
                this._toReorderTop.setText(null);
                this._toReorderBottom.setText(null);
                args[0] = top;
                args[1] = this._getAcceleratorString(this._toReorderTop.getMnemonic());
                tipText = "".equals(args[1]) ? args[0] : MessageFormat.format(pattern, args);
                this._toReorderTop.setToolTipText(tipText);
                args[0] = bottom;
                args[1] = this._getAcceleratorString(this._toReorderBottom.getMnemonic());
                tipText = "".equals(args[1]) ? args[0] : MessageFormat.format(pattern, args);
                this._toReorderBottom.setToolTipText(tipText);
            }
        }
        if (this._fromReorderUp != null) {
            if (textMode && this._toReorderUp == null) {
                this._fromReorderUp.setMnemonic(mnemonics[6]);
                this._fromReorderDown.setMnemonic(mnemonics[7]);
            } else {
                this._fromReorderUp.setMnemonic(0);
                this._fromReorderDown.setMnemonic(0);
            }
            ac = this._fromReorderUp.getAccessibleContext();
            ac.setAccessibleName(up);
            ac.setAccessibleDescription(up);
            ac = this._fromReorderDown.getAccessibleContext();
            ac.setAccessibleName(down);
            ac.setAccessibleDescription(down);
            if (iconMode) {
                buttonP = sui.getButtonIcon(this, reversed ? 8 : 10);
                this._fromReorderUp.setIcon(buttonP);
                buttonP = sui.getButtonIcon(this, reversed ? 9 : 11);
                this._fromReorderDown.setIcon(buttonP);
            } else {
                this._fromReorderUp.setIcon(null);
                this._fromReorderDown.setIcon(null);
            }
            if (textMode) {
                this._fromReorderUp.setText(up);
                this._fromReorderDown.setText(down);
                this._fromReorderUp.setToolTipText(null);
                this._fromReorderDown.setToolTipText(null);
            } else {
                this._fromReorderUp.setText(null);
                this._fromReorderDown.setText(null);
                args[0] = up;
                args[1] = this._getAcceleratorString(this._fromReorderUp.getMnemonic());
                tipText = "".equals(args[1]) ? args[0] : MessageFormat.format(pattern, args);
                this._fromReorderUp.setToolTipText(tipText);
                args[0] = down;
                args[1] = this._getAcceleratorString(this._fromReorderDown.getMnemonic());
                tipText = "".equals(args[1]) ? args[0] : MessageFormat.format(pattern, args);
                this._fromReorderDown.setToolTipText(tipText);
            }
        }
        if (this._fromReorderTop != null) {
            if (textMode && this._toReorderTop == null) {
                this._fromReorderTop.setMnemonic(mnemonics[8]);
                this._fromReorderBottom.setMnemonic(mnemonics[9]);
            } else {
                this._fromReorderTop.setMnemonic(0);
                this._fromReorderBottom.setMnemonic(0);
            }
            ac = this._fromReorderTop.getAccessibleContext();
            ac.setAccessibleName(top);
            ac.setAccessibleDescription(top);
            ac = this._fromReorderBottom.getAccessibleContext();
            ac.setAccessibleName(bottom);
            ac.setAccessibleDescription(bottom);
            if (iconMode) {
                buttonP = sui.getButtonIcon(this, reversed ? 12 : 14);
                this._fromReorderTop.setIcon(buttonP);
                buttonP = sui.getButtonIcon(this, reversed ? 13 : 15);
                this._fromReorderBottom.setIcon(buttonP);
            } else {
                this._fromReorderTop.setIcon(null);
                this._fromReorderBottom.setIcon(null);
            }
            if (textMode) {
                this._fromReorderTop.setText(top);
                this._fromReorderBottom.setText(bottom);
                this._fromReorderTop.setToolTipText(null);
                this._fromReorderBottom.setToolTipText(null);
            } else {
                this._fromReorderTop.setText(null);
                this._fromReorderBottom.setText(null);
                args[0] = top;
                args[1] = this._getAcceleratorString(this._fromReorderTop.getMnemonic());
                tipText = "".equals(args[1]) ? args[0] : MessageFormat.format(pattern, args);
                this._fromReorderTop.setToolTipText(tipText);
                args[0] = bottom;
                args[1] = this._getAcceleratorString(this._fromReorderBottom.getMnemonic());
                tipText = "".equals(args[1]) ? args[0] : MessageFormat.format(pattern, args);
                this._fromReorderBottom.setToolTipText(tipText);
            }
        }
    }

    private void _updateButtonMargins() {
        Insets i = this._getButtonMargin();
        this._addButton.setMargin(i);
        this._removeButton.setMargin(i);
        this._addAllButton.setMargin(i);
        this._removeAllButton.setMargin(i);
        if (this._toReorderUp != null) {
            this._toReorderUp.setMargin(i);
            this._toReorderDown.setMargin(i);
            if (this._toReorderTop != null) {
                this._toReorderTop.setMargin(i);
                this._toReorderBottom.setMargin(i);
            }
        }
        if (this._fromReorderUp != null) {
            this._fromReorderUp.setMargin(i);
            this._fromReorderDown.setMargin(i);
            if (this._fromReorderTop != null) {
                this._fromReorderTop.setMargin(i);
                this._fromReorderBottom.setMargin(i);
            }
        }
    }

    private boolean _isActualLayoutReversed() {
        return this._actualReversed;
    }

    void _setActualLayoutReversed(boolean reversed) {
        if (this._actualReversed != reversed) {
            this._actualReversed = reversed;
            this._getLayout().setReverseLayout(reversed);
            this._updateButtonContents();
            this._updateReorderContents();
            this.revalidate();
        }
    }

    private void _updateReorderButtonsEnabled(ItemPicker picker, JButton button) {
        if (!(picker instanceof Reorderable) || this._ignoreSelectionEvents) {
            return;
        }
        Reorderable reordered = (Reorderable)((Object)picker);
        if (reordered == this._fromPicker) {
            this._update(reordered, this._fromPicker, this._fromReorderUp, this._fromReorderDown, this._fromReorderTop, this._fromReorderBottom);
        } else {
            this._update(reordered, this._toPicker, this._toReorderUp, this._toReorderDown, this._toReorderTop, this._toReorderBottom);
        }
    }

    private void _update(Reorderable reordered, ItemPicker picker, JButton up, JButton down, JButton top, JButton bottom) {
        Component focused;
        Component newFocused = focused = SwingUtilities.findFocusOwner(this);
        boolean reorderUpEnabled = reordered.isSelectionUpwardlyMobile();
        boolean reorderDownEnabled = reordered.isSelectionDownwardlyMobile();
        boolean reorderTopEnabled = false;
        boolean reorderBottomEnabled = false;
        if (reordered instanceof Reorderable2) {
            Reorderable2 r2 = (Reorderable2)reordered;
            reorderTopEnabled = r2.isSelectionTopMobile();
            reorderBottomEnabled = r2.isSelectionBottomMobile();
        }
        if (focused == up && !reorderUpEnabled || top != null && focused == top && !reorderTopEnabled) {
            newFocused = reorderDownEnabled ? down : ShuttleLayout.__getFocusableComponent(picker.getComponent());
        } else if (focused == down && !reorderDownEnabled || bottom != null && focused == bottom && !reorderBottomEnabled) {
            newFocused = reorderUpEnabled ? up : ShuttleLayout.__getFocusableComponent(picker.getComponent());
        }
        up.setEnabled(reorderUpEnabled);
        down.setEnabled(reorderDownEnabled);
        if (top != null) {
            top.setEnabled(reorderTopEnabled);
        }
        if (bottom != null) {
            bottom.setEnabled(reorderBottomEnabled);
        }
        if (focused == top || focused == bottom) {
            if (newFocused != null) {
                final Component temp = newFocused;
                Runnable r = new Runnable(){
                    boolean _first = true;

                    public void run() {
                        temp.requestFocus();
                        if (this._first) {
                            this._first = false;
                            SwingUtilities.invokeLater(this);
                        }
                    }
                };
                SwingUtilities.invokeLater(r);
            }
        } else if (focused != newFocused && newFocused != null) {
            newFocused.requestFocus();
        }
    }

    private void _updateButtonsEnabled(ItemPicker source) {
        JButton moveAllButton;
        JButton moveButton;
        if (this._ignoreSelectionEvents || !this.isEnabled()) {
            return;
        }
        if (source == this._fromPicker) {
            moveButton = this._addButton;
            moveAllButton = this._addAllButton;
        } else {
            moveButton = this._removeButton;
            moveAllButton = this._removeAllButton;
        }
        this._updateReorderButtonsEnabled(source, null);
        boolean allItemsCompatible = source.isSelectableItemPresent();
        boolean selectedItemsCompatible = source.isItemSelected();
        if (source == this._fromPicker && this._toPicker != null) {
            boolean isItemSelected = selectedItemsCompatible;
            DataFlavor[] outgoing = source.getSelectionDataFlavors();
            if (selectedItemsCompatible && outgoing != null) {
                selectedItemsCompatible = this._toPicker.canAcceptFlavors(outgoing);
            }
            if (allItemsCompatible && (selectedItemsCompatible || !isItemSelected)) {
                if (outgoing != null) {
                    allItemsCompatible = this._toPicker.canAcceptFlavors(outgoing);
                }
            } else {
                allItemsCompatible = false;
            }
        }
        Component focusOwner = SwingUtilities.findFocusOwner(this);
        moveAllButton.setEnabled(allItemsCompatible);
        moveButton.setEnabled(selectedItemsCompatible);
        Component next = null;
        if (focusOwner == moveButton && !selectedItemsCompatible) {
            if (moveButton == this._addButton) {
                if (this._toPicker != null) {
                    next = FocusUtils.getFirstFocusableComponent((Container)this._toPicker.getComponent());
                }
            } else if (moveButton == this._removeButton && this._fromPicker != null) {
                next = FocusUtils.getFirstFocusableComponent((Container)this._fromPicker.getComponent());
            }
        } else if (focusOwner == moveAllButton && !allItemsCompatible) {
            if (moveAllButton == this._addAllButton) {
                if (this._toPicker != null) {
                    next = FocusUtils.getFirstFocusableComponent((Container)this._toPicker.getComponent());
                }
            } else if (moveAllButton == this._removeAllButton && this._fromPicker != null) {
                next = FocusUtils.getFirstFocusableComponent((Container)this._fromPicker.getComponent());
            }
        }
        if (next != null) {
            final Component temp = next;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    temp.requestFocus();
                }
            });
        }
        this._updateButtonFocus();
    }

    private boolean _addItems() {
        boolean compatible;
        ItemPicker from = this._fromPicker;
        ItemPicker to = this._toPicker;
        DataFlavor[] flavors = from.getSelectionDataFlavors();
        boolean bl = compatible = flavors == null ? true : to.canAcceptFlavors(flavors);
        if (compatible) {
            boolean added = to.addSelectedItems(from.getSelectedItems());
            if (this._itemsUnique == 0 && added) {
                from.removeSelectedItems();
            }
            return true;
        }
        return false;
    }

    private boolean _removeItems() {
        ItemPicker from = this._fromPicker;
        ItemPicker to = this._toPicker;
        boolean remove = true;
        if (this._itemsUnique == 0) {
            remove = from.addSelectedItems(to.getSelectedItems());
        }
        if (remove) {
            to.removeSelectedItems();
            return true;
        }
        return false;
    }

    protected void processShuttleEvent(ShuttleEvent event) {
        Enumeration enumer;
        int id = event.getID();
        ListenerManager listeners = this._shuttleListeners;
        if (listeners != null && (enumer = listeners.getListeners()) != null) {
            while (enumer.hasMoreElements()) {
                ShuttleListener listener = (ShuttleListener)enumer.nextElement();
                switch (id) {
                    case 2000: 
                    case 2001: 
                    case 2002: 
                    case 2003: {
                        listener.shuttleItemsMoved(event);
                        break;
                    }
                    case 2004: 
                    case 2005: {
                        listener.shuttleItemsRemoved(event);
                        break;
                    }
                    case 2006: 
                    case 2007: 
                    case 2008: 
                    case 2009: 
                    case 2010: {
                        listener.shuttleItemsReordered(event);
                        break;
                    }
                }
            }
        }
    }

    protected String[] getLocalizedLabels(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle shuttleBundle = ResourceBundle.getBundle(_RESOURCE_BUNDLE, locale);
        String[] labels = new String[10];
        labels[0] = shuttleBundle.getString(_MOVE_KEY);
        labels[2] = shuttleBundle.getString(_REMOVE_KEY);
        labels[1] = shuttleBundle.getString(_MOVE_ALL_KEY);
        labels[3] = shuttleBundle.getString(_REMOVE_ALL_KEY);
        labels[4] = shuttleBundle.getString(_COPY_KEY);
        labels[5] = shuttleBundle.getString(_COPY_ALL_KEY);
        labels[6] = shuttleBundle.getString(_REORDER_UP_KEY);
        labels[7] = shuttleBundle.getString(_REORDER_DOWN_KEY);
        labels[8] = shuttleBundle.getString(_REORDER_TOP_KEY);
        labels[9] = shuttleBundle.getString(_REORDER_BOTTOM_KEY);
        return labels;
    }

    protected void initItemPickersSelection() {
        if (this._fromPicker instanceof ListPicker && !this._fromPicker.isItemSelected()) {
            ((ListPicker)this._fromPicker).__selectItem(0);
        }
    }

    private void _updateMnemonicsfromLabel(String[] labels) {
        boolean flag = false;
        for (int i = 0; i < labels.length; ++i) {
            if (StringUtils.getMnemonicKeyCode((String)labels[i]) == 0) continue;
            flag = true;
            break;
        }
        if (flag) {
            if (this._buttonMnemonics == null) {
                this._buttonMnemonics = new int[6];
            }
            this._buttonMnemonics[0] = StringUtils.getMnemonicKeyCode((String)labels[0]);
            this._buttonMnemonics[2] = StringUtils.getMnemonicKeyCode((String)labels[1]);
            this._buttonMnemonics[1] = StringUtils.getMnemonicKeyCode((String)labels[2]);
            this._buttonMnemonics[3] = StringUtils.getMnemonicKeyCode((String)labels[3]);
            this._buttonMnemonics[4] = StringUtils.getMnemonicKeyCode((String)labels[4]);
            this._buttonMnemonics[5] = StringUtils.getMnemonicKeyCode((String)labels[5]);
        }
    }

    private void _disposeReorderControls() {
        if (this._toReorderUp != null) {
            this._toReorderUp.removeActionListener(this._handler);
            this._toReorderUp.setModel(null);
            this._toReorderUp = null;
        }
        if (this._toReorderDown != null) {
            this._toReorderDown.removeActionListener(this._handler);
            this._toReorderDown.setModel(null);
            this._toReorderDown = null;
        }
        if (this._fromReorderUp != null) {
            this._fromReorderUp.removeActionListener(this._handler);
            this._fromReorderUp.setModel(null);
            this._fromReorderUp = null;
        }
        if (this._fromReorderDown != null) {
            this._fromReorderDown.removeActionListener(this._handler);
            this._fromReorderDown.setModel(null);
            this._fromReorderDown = null;
        }
        if (this._toReorderTop != null) {
            this._toReorderTop.removeActionListener(this._handler);
            this._toReorderTop = null;
        }
        if (this._toReorderBottom != null) {
            this._toReorderBottom.removeActionListener(this._handler);
            this._toReorderBottom = null;
        }
        if (this._fromReorderTop != null) {
            this._fromReorderTop.removeActionListener(this._handler);
            this._fromReorderTop = null;
        }
        if (this._fromReorderBottom != null) {
            this._fromReorderBottom.removeActionListener(this._handler);
            this._fromReorderBottom = null;
        }
    }

    void __processMove() {
        this._processMove();
    }

    void __processRemove() {
        this._processRemove();
    }

    void __processDnDReorder(ItemPicker itemPicker) {
        this._ignoreSelectionEvents = true;
        ((ShuttleDnDSupport.ItemPickerDnD)((Object)itemPicker)).processDnDReorder();
        this.processShuttleEvent(new ShuttleEvent(this, 2010, itemPicker.getSelectedItems(), itemPicker));
        this._ignoreSelectionEvents = false;
        this._updateReorderButtonsEnabled(itemPicker, null);
    }

    private void _createReorderControls(boolean to, boolean createTopDown) {
        Insets margin = this._getButtonMargin();
        JButton reorderUp = new JButton();
        reorderUp.setName(_UP_NAME);
        reorderUp.setHorizontalTextPosition(0);
        reorderUp.setVerticalTextPosition(3);
        reorderUp.setMargin(margin);
        reorderUp.addActionListener(this._handler);
        reorderUp.setModel(new ShuttleButtonModel(reorderUp));
        Shuttle._setIconTextGap(reorderUp);
        JButton reorderDown = new JButton();
        reorderDown.setName(_DOWN_NAME);
        reorderDown.setHorizontalTextPosition(0);
        reorderDown.setVerticalTextPosition(3);
        reorderDown.setMargin(margin);
        reorderDown.addActionListener(this._handler);
        reorderDown.setModel(new ShuttleButtonModel(reorderDown));
        Shuttle._setIconTextGap(reorderDown);
        JPanel reorderControl = new JPanel(_REORDER_LAYOUT);
        FocusUtils.setFocusable(reorderControl, false);
        reorderControl.add(reorderUp);
        reorderControl.add(reorderDown);
        reorderUp.addFocusListener(this._handler);
        reorderDown.addFocusListener(this._handler);
        JButton reorderTop = null;
        JButton reorderBottom = null;
        if (createTopDown) {
            reorderTop = new JButton();
            reorderTop.setName(_TOP_NAME);
            reorderTop.setHorizontalTextPosition(0);
            reorderTop.setVerticalTextPosition(3);
            reorderTop.setMargin(margin);
            reorderTop.addActionListener(this._handler);
            reorderControl.add((Component)reorderTop, 0);
            Shuttle._setIconTextGap(reorderTop);
            reorderBottom = new JButton();
            reorderBottom.setName(_BOTTOM_NAME);
            reorderBottom.setHorizontalTextPosition(0);
            reorderBottom.setVerticalTextPosition(3);
            reorderBottom.setMargin(margin);
            reorderBottom.addActionListener(this._handler);
            reorderControl.add(reorderBottom);
            Shuttle._setIconTextGap(reorderBottom);
        }
        if (to) {
            this._toReorderUp = reorderUp;
            this._toReorderDown = reorderDown;
            this._toReorderTop = reorderTop;
            this._toReorderBottom = reorderBottom;
            this.add((Component)reorderControl, "ToReorderControl");
        } else {
            this._fromReorderUp = reorderUp;
            this._fromReorderDown = reorderDown;
            this._fromReorderTop = reorderTop;
            this._fromReorderBottom = reorderBottom;
            this.add((Component)reorderControl, "FromReorderControl");
        }
        this._updateReorderContents();
        this._updateReorderButtonsEnabled(to ? this._toPicker : this._fromPicker, null);
        this._updateButtonFonts();
    }

    private void _removeReorderControls(boolean to) {
        Container parent = null;
        if (to) {
            parent = this._toReorderUp.getParent();
            this._toReorderDown = null;
            this._toReorderUp = null;
            this._toReorderBottom = null;
            this._toReorderTop = null;
        } else {
            parent = this._fromReorderUp.getParent();
            this._fromReorderDown = null;
            this._fromReorderUp = null;
            this._fromReorderBottom = null;
            this._fromReorderTop = null;
        }
        this.remove(parent);
        this._updateReorderContents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _processMove() {
        boolean result = false;
        if (this._fromPicker == null || this._toPicker == null) {
            return result;
        }
        if (this._fromPicker.isItemSelected()) {
            Transferable[] items = this._fromPicker.getSelectedItems();
            this._ignoreSelectionEvents = true;
            try {
                result = this._addItems();
            }
            finally {
                this._ignoreSelectionEvents = false;
            }
            if (result) {
                if (this._itemsUnique == 0) {
                    this.processShuttleEvent(new ShuttleEvent(this, 2000, items));
                } else {
                    this.processShuttleEvent(new ShuttleEvent(this, 2002, items));
                }
            }
        }
        this._updateShuttleButtonsEnabled();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _processRemove() {
        boolean result = false;
        if (this._fromPicker == null || this._toPicker == null) {
            return result;
        }
        if (this._toPicker.isItemSelected()) {
            Transferable[] items = this._toPicker.getSelectedItems();
            this._ignoreSelectionEvents = true;
            try {
                result = this._removeItems();
            }
            finally {
                this._ignoreSelectionEvents = false;
            }
            if (result) {
                this.processShuttleEvent(new ShuttleEvent(this, 2004, items));
            }
        }
        this._updateShuttleButtonsEnabled();
        return result;
    }

    private boolean _processMoveAll() {
        boolean compatible;
        boolean result = false;
        if (this._fromPicker == null || this._toPicker == null) {
            return result;
        }
        DataFlavor[] flavors = this._fromPicker.getSelectionDataFlavors();
        boolean bl = compatible = flavors == null ? true : this._toPicker.canAcceptFlavors(flavors);
        if (compatible) {
            boolean added = false;
            Transferable[] items = this._fromPicker.getAllSelectableItems();
            added = this._toPicker.addSelectedItems(items);
            if (this._itemsUnique == 0 && added) {
                this._fromPicker.removeAllSelectableItems();
            }
            if (added) {
                result = true;
            }
            if (this._itemsUnique == 0) {
                this.processShuttleEvent(new ShuttleEvent(this, 2001, items));
            } else {
                this.processShuttleEvent(new ShuttleEvent(this, 2003, items));
            }
        }
        this._updateShuttleButtonsEnabled();
        return result;
    }

    private boolean _processRemoveAll() {
        if (this._fromPicker == null || this._toPicker == null) {
            return false;
        }
        boolean result = this._itemsUnique == 1;
        Transferable[] items = this._toPicker.getAllSelectableItems();
        if (this._itemsUnique == 0) {
            result = this._fromPicker.addSelectedItems(items);
        }
        if (result) {
            this._toPicker.removeAllSelectableItems();
        }
        this.processShuttleEvent(new ShuttleEvent(this, 2005, items));
        this._updateShuttleButtonsEnabled();
        return result;
    }

    private void _updateShuttleButtonsEnabled() {
        this._updateButtonsEnabled(this._fromPicker);
        this._updateButtonsEnabled(this._toPicker);
    }

    private void _updateButtonMnemonics() {
        boolean copy;
        if ((this._buttonMode & 2) == 0) {
            this._addButton.setMnemonic(0);
            this._addAllButton.setMnemonic(0);
            this._removeButton.setMnemonic(0);
            this._removeAllButton.setMnemonic(0);
            return;
        }
        int[] mnemonics = this._buttonMnemonics;
        if (mnemonics == null) {
            mnemonics = this._getDefaultMnemonics();
        }
        boolean bl = copy = (this.getMode() & 1) != 0;
        if (copy) {
            this._addButton.setMnemonic(mnemonics[4]);
            this._addAllButton.setMnemonic(mnemonics[5]);
        } else {
            this._addButton.setMnemonic(mnemonics[0]);
            this._addAllButton.setMnemonic(mnemonics[1]);
        }
        this._removeButton.setMnemonic(mnemonics[2]);
        this._removeAllButton.setMnemonic(mnemonics[3]);
    }

    private int[] _getDefaultMnemonics() {
        int i;
        boolean copy;
        String key1 = _MOVE_KEY;
        String key2 = _MOVE_ALL_KEY;
        int indx1 = 0;
        int indx2 = 1;
        boolean bl = copy = (this.getMode() & 1) != 0;
        if (copy) {
            key1 = _COPY_KEY;
            key2 = _COPY_ALL_KEY;
            indx1 = 4;
            indx2 = 5;
        }
        Locale locale = LocaleUtils.getDefaultableLocale((Component)this);
        ResourceBundle shuttleBundle = ResourceBundle.getBundle(_RESOURCE_BUNDLE, locale);
        String[] defaultLabels = new String[]{shuttleBundle.getString(key1), shuttleBundle.getString(key2), shuttleBundle.getString(_REMOVE_KEY), shuttleBundle.getString(_REMOVE_ALL_KEY), shuttleBundle.getString(_REORDER_UP_KEY), shuttleBundle.getString(_REORDER_DOWN_KEY), shuttleBundle.getString(_REORDER_TOP_KEY), shuttleBundle.getString(_REORDER_BOTTOM_KEY)};
        if (this._buttonLabels == null) {
            this._loadCompatibleButtonLabels();
        }
        int[] mnemonics = new int[10];
        if (defaultLabels[0].equals(this._buttonLabels[indx1]) && defaultLabels[1].equals(this._buttonLabels[indx2]) && defaultLabels[2].equals(this._buttonLabels[2]) && defaultLabels[3].equals(this._buttonLabels[3])) {
            mnemonics[indx1] = StringUtils.getMnemonicKeyCode((String)defaultLabels[0]);
            mnemonics[indx2] = StringUtils.getMnemonicKeyCode((String)defaultLabels[1]);
            mnemonics[2] = StringUtils.getMnemonicKeyCode((String)defaultLabels[2]);
            mnemonics[3] = StringUtils.getMnemonicKeyCode((String)defaultLabels[3]);
            if (copy) {
                mnemonics[0] = 0;
                mnemonics[1] = 0;
            } else {
                mnemonics[4] = 0;
                mnemonics[5] = 0;
            }
        } else {
            for (i = 0; i < 6; ++i) {
                mnemonics[i] = 0;
            }
        }
        if (defaultLabels[4].equals(this._buttonLabels[6]) && defaultLabels[5].equals(this._buttonLabels[7]) && defaultLabels[6].equals(this._buttonLabels[8]) && defaultLabels[7].equals(this._buttonLabels[9])) {
            mnemonics[6] = StringUtils.getMnemonicKeyCode((String)defaultLabels[4]);
            mnemonics[7] = StringUtils.getMnemonicKeyCode((String)defaultLabels[5]);
            mnemonics[8] = StringUtils.getMnemonicKeyCode((String)defaultLabels[6]);
            mnemonics[9] = StringUtils.getMnemonicKeyCode((String)defaultLabels[7]);
        } else {
            for (i = 6; i <= 9; ++i) {
                mnemonics[i] = 0;
            }
        }
        return mnemonics;
    }

    private String _getAcceleratorString(int mnemonic) {
        if (mnemonic != 0) {
            Object o;
            if (FocusUtils.areNewFocusAPIsAvailable() ? Boolean.FALSE.equals(UIManager.get("ToolTip.hideAccelerator")) : (o = UIManager.get("Shuttle.ShowAcclInToolTip")) == null || Boolean.FALSE.equals(o)) {
                return "";
            }
            String acclDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
            if (acclDelimiter == null) {
                acclDelimiter = "+";
            }
            int mod = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() == 4 ? 2 : 8;
            Locale locale = LocaleUtils.getDefaultableLocale((Component)this);
            return KeyEvent.getKeyModifiersText(mod).toUpperCase(locale) + acclDelimiter + KeyEvent.getKeyText(mnemonic).toUpperCase(locale);
        }
        return "";
    }

    private void _loadCompatibleButtonLabels() {
        String[] labels = this.getLocalizedLabels(LocaleUtils.getDefaultableLocale((Component)this));
        if (labels.length == 8) {
            String[] newLabels = new String[10];
            System.arraycopy(labels, 0, newLabels, 0, 8);
            ResourceBundle shuttleBundle = ResourceBundle.getBundle(_RESOURCE_BUNDLE, LocaleUtils.getDefaultableLocale((Component)this));
            newLabels[8] = shuttleBundle.getString(_REORDER_TOP_KEY);
            newLabels[9] = shuttleBundle.getString(_REORDER_BOTTOM_KEY);
            labels = newLabels;
        }
        if (labels.length < 10) {
            throw new IllegalArgumentException("Should provide 10 button labels");
        }
        this._buttonLabels = labels;
    }

    private boolean _updateFooterVisiblity(Component comp, boolean add) {
        Component temp;
        boolean visible = !add;
        boolean visiblityAffected = false;
        if (comp == this.getComponent(COMMON_FOOTER_COMPONENT)) {
            Component temp2 = this.getComponent(FROM_FOOTER_COMPONENT);
            if (temp2 != null) {
                temp2.setVisible(visible);
                visiblityAffected = true;
            }
            if ((temp2 = this.getComponent(TO_FOOTER_COMPONENT)) != null) {
                temp2.setVisible(visible);
                visiblityAffected = true;
            }
        } else if ((comp == this.getComponent(FROM_FOOTER_COMPONENT) || comp == this.getComponent(TO_FOOTER_COMPONENT)) && (temp = this.getComponent(COMMON_FOOTER_COMPONENT)) != null) {
            if (add) {
                temp.setVisible(visible);
                visiblityAffected = true;
                temp = this.getComponent(FROM_FOOTER_COMPONENT);
                if (temp != null) {
                    temp.setVisible(true);
                }
                if ((temp = this.getComponent(TO_FOOTER_COMPONENT)) != null) {
                    temp.setVisible(true);
                }
            } else if (comp.isVisible()) {
                Component fromFooter = this.getComponent(FROM_FOOTER_COMPONENT);
                Component toFooter = this.getComponent(TO_FOOTER_COMPONENT);
                temp.setVisible(!(fromFooter != comp && fromFooter != null || toFooter != comp && toFooter != null));
                visiblityAffected = true;
            }
        }
        return visiblityAffected;
    }

    private void _createShuttleDnDSupport() {
        if (this._shuttleDnDSupport != null) {
            this._shuttleDnDSupport.dispose();
        }
        boolean isFromItemPickerDnD = this._fromPicker instanceof ShuttleDnDSupport.ItemPickerDnD;
        boolean isToItemPickerDnD = this._toPicker instanceof ShuttleDnDSupport.ItemPickerDnD;
        if (isFromItemPickerDnD && isToItemPickerDnD || isFromItemPickerDnD && this._fromPicker instanceof Reorderable || isToItemPickerDnD && this._toPicker instanceof Reorderable) {
            this._shuttleDnDSupport = new ShuttleDnDSupport(this);
        }
    }

    static /* synthetic */ int[] access$002(Shuttle x0, int[] x1) {
        x0._actionMap = x1;
        return x1;
    }

    static {
        _REORDER_LAYOUT = new EqualColumnLayout(3);
    }

    private class Header
    extends JPanel {
        private JLabel _defHeader;
        private Component _userHeader;
        private boolean _isFromHeader;
        private ItemPicker _itemPicker;

        public Header(ItemPicker picker, Component header, boolean isFrom) {
            this.setLayout(new BorderLayout());
            this._isFromHeader = isFrom;
            this.setHeader(header);
            this.setItemPicker(picker);
        }

        public void setItemPicker(ItemPicker picker) {
            this._itemPicker = picker;
            if (this._defHeader != null && this._userHeader == null) {
                if (this._itemPicker != null) {
                    this._defHeader.setLabelFor(this._getFirstFocusableComponent(this._itemPicker.getComponent()));
                } else {
                    this._defHeader.setLabelFor(null);
                }
            }
        }

        public void setHeader(Component comp) {
            this._userHeader = comp;
            if (this._userHeader == null) {
                if (this._defHeader == null) {
                    this._defHeader = new JLabel();
                    this.loadButtonLabel();
                }
                this.removeAll();
                this.add(this._defHeader);
                if (this._itemPicker != null) {
                    this._defHeader.setLabelFor(this._getFirstFocusableComponent(this._itemPicker.getComponent()));
                }
            } else {
                if (this._defHeader != null) {
                    Component focus = null;
                    Object labeledBy = null;
                    if (this._itemPicker != null && (focus = this._defHeader.getLabelFor()) instanceof JComponent) {
                        labeledBy = ((JComponent)focus).getClientProperty(Shuttle._LABELED_BY);
                    }
                    this._defHeader.setLabelFor(null);
                    if (labeledBy != null && labeledBy != this._defHeader) {
                        ((JComponent)focus).putClientProperty(Shuttle._LABELED_BY, labeledBy);
                    }
                }
                this.removeAll();
                this.add(comp);
            }
            this.revalidate();
        }

        public Component getUserHeader() {
            return this._userHeader;
        }

        public void loadButtonLabel() {
            if (this._defHeader != null) {
                ResourceBundle b = ResourceBundle.getBundle(Shuttle._RESOURCE_BUNDLE, LocaleUtils.getDefaultableLocale((Component)this));
                String text = b.getString(this._isFromHeader ? "SHUTTLE.FROM_HEADER" : "SHUTTLE.TO_HEADER");
                this._defHeader.setText(StringUtils.stripMnemonic((String)text));
                this._defHeader.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)text));
            }
        }

        public Insets getInsets() {
            return this.getUserHeader() == null ? new Insets(0, 0, 5, 0) : super.getInsets();
        }

        private Component _getFirstFocusableComponent(Component comp) {
            if (FocusUtils.isFocusable(comp)) {
                return comp;
            }
            if (comp instanceof Container) {
                Container c = (Container)comp;
                int count = c.getComponentCount();
                for (int i = 0; i < count; ++i) {
                    Component temp = this._getFirstFocusableComponent(c.getComponent(i));
                    if (temp == null) continue;
                    return temp;
                }
            }
            return null;
        }
    }

    private class ShuttleButtonModel
    extends ContinuousButtonModel {
        public ShuttleButtonModel(AbstractButton button) {
            super(button);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processPulse() {
            Reorderable reordered;
            AbstractButton button = this.getButton();
            if (button == Shuttle.this._toReorderUp) {
                Reorderable reordered2 = (Reorderable)((Object)Shuttle.this._toPicker);
                if (reordered2.isSelectionUpwardlyMobile()) {
                    Shuttle.this._ignoreSelectionEvents = true;
                    try {
                        reordered2.moveSelectionUp();
                        Shuttle.this.processShuttleEvent(new ShuttleEvent(Shuttle.this, 2006, Shuttle.this._toPicker.getSelectedItems(), Shuttle.this._toPicker));
                    }
                    finally {
                        Shuttle.this._ignoreSelectionEvents = false;
                    }
                    Shuttle.this._updateReorderButtonsEnabled(Shuttle.this._toPicker, Shuttle.this._toReorderUp);
                    Shuttle.this._updateButtonFocus();
                }
            } else if (button == Shuttle.this._toReorderDown) {
                Reorderable reordered3 = (Reorderable)((Object)Shuttle.this._toPicker);
                if (reordered3.isSelectionDownwardlyMobile()) {
                    Shuttle.this._ignoreSelectionEvents = true;
                    try {
                        reordered3.moveSelectionDown();
                        Shuttle.this.processShuttleEvent(new ShuttleEvent(Shuttle.this, 2007, Shuttle.this._toPicker.getSelectedItems(), Shuttle.this._toPicker));
                    }
                    finally {
                        Shuttle.this._ignoreSelectionEvents = false;
                    }
                    Shuttle.this._updateReorderButtonsEnabled(Shuttle.this._toPicker, Shuttle.this._toReorderDown);
                    Shuttle.this._updateButtonFocus();
                }
            } else if (button == Shuttle.this._fromReorderUp) {
                Reorderable reordered4 = (Reorderable)((Object)Shuttle.this._fromPicker);
                if (reordered4.isSelectionUpwardlyMobile()) {
                    Shuttle.this._ignoreSelectionEvents = true;
                    try {
                        reordered4.moveSelectionUp();
                        Shuttle.this.processShuttleEvent(new ShuttleEvent(Shuttle.this, 2006, Shuttle.this._fromPicker.getSelectedItems(), Shuttle.this._fromPicker));
                    }
                    finally {
                        Shuttle.this._ignoreSelectionEvents = false;
                    }
                    Shuttle.this._updateReorderButtonsEnabled(Shuttle.this._fromPicker, Shuttle.this._fromReorderUp);
                    Shuttle.this._updateButtonFocus();
                }
            } else if (button == Shuttle.this._fromReorderDown && (reordered = (Reorderable)((Object)Shuttle.this._fromPicker)).isSelectionDownwardlyMobile()) {
                Shuttle.this._ignoreSelectionEvents = true;
                try {
                    reordered.moveSelectionDown();
                    Shuttle.this.processShuttleEvent(new ShuttleEvent(Shuttle.this, 2007, Shuttle.this._fromPicker.getSelectedItems(), Shuttle.this._fromPicker));
                }
                finally {
                    Shuttle.this._ignoreSelectionEvents = false;
                }
                Shuttle.this._updateReorderButtonsEnabled(Shuttle.this._fromPicker, Shuttle.this._fromReorderDown);
                Shuttle.this._updateButtonFocus();
            }
        }
    }

    class ShuttleHandler
    implements ActionListener,
    PropertyChangeListener,
    FocusListener {
        ShuttleHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent event) {
            ItemPicker from = Shuttle.this._fromPicker;
            ItemPicker to = Shuttle.this._toPicker;
            if (event.getSource() instanceof ItemPicker && Shuttle.this.isEnabled()) {
                ItemPicker source = (ItemPicker)event.getSource();
                if (source == from) {
                    Shuttle.this._processMove();
                } else if (source == to) {
                    Shuttle.this._processRemove();
                }
            } else if (event.getSource() instanceof Component) {
                Component source = (Component)event.getSource();
                if (source == Shuttle.this._addButton) {
                    Shuttle.this._processMove();
                } else if (source == Shuttle.this._addAllButton) {
                    Shuttle.this._processMoveAll();
                } else if (source == Shuttle.this._removeButton) {
                    Shuttle.this._processRemove();
                } else if (source == Shuttle.this._removeAllButton) {
                    Shuttle.this._processRemoveAll();
                } else if (source == Shuttle.this._toReorderTop) {
                    Shuttle.this._ignoreSelectionEvents = true;
                    try {
                        ((Reorderable2)((Object)Shuttle.this._toPicker)).moveSelectionTop();
                        Shuttle.this.processShuttleEvent(new ShuttleEvent(this, 2008, Shuttle.this._toPicker.getSelectedItems(), Shuttle.this._toPicker));
                    }
                    finally {
                        Shuttle.this._ignoreSelectionEvents = false;
                    }
                    Shuttle.this._updateReorderButtonsEnabled(Shuttle.this._toPicker, null);
                } else if (source == Shuttle.this._fromReorderTop) {
                    Shuttle.this._ignoreSelectionEvents = true;
                    try {
                        ((Reorderable2)((Object)Shuttle.this._fromPicker)).moveSelectionTop();
                        Shuttle.this.processShuttleEvent(new ShuttleEvent(this, 2008, Shuttle.this._fromPicker.getSelectedItems(), Shuttle.this._fromPicker));
                    }
                    finally {
                        Shuttle.this._ignoreSelectionEvents = false;
                    }
                    Shuttle.this._updateReorderButtonsEnabled(Shuttle.this._fromPicker, null);
                } else if (source == Shuttle.this._toReorderBottom) {
                    Shuttle.this._ignoreSelectionEvents = true;
                    try {
                        ((Reorderable2)((Object)Shuttle.this._toPicker)).moveSelectionBottom();
                        Shuttle.this.processShuttleEvent(new ShuttleEvent(this, 2009, Shuttle.this._toPicker.getSelectedItems(), Shuttle.this._toPicker));
                    }
                    finally {
                        Shuttle.this._ignoreSelectionEvents = false;
                    }
                    Shuttle.this._updateReorderButtonsEnabled(Shuttle.this._toPicker, null);
                } else if (source == Shuttle.this._fromReorderBottom) {
                    Shuttle.this._ignoreSelectionEvents = true;
                    try {
                        ((Reorderable2)((Object)Shuttle.this._fromPicker)).moveSelectionBottom();
                        Shuttle.this.processShuttleEvent(new ShuttleEvent(this, 2009, Shuttle.this._fromPicker.getSelectedItems(), Shuttle.this._fromPicker));
                    }
                    finally {
                        Shuttle.this._ignoreSelectionEvents = false;
                    }
                    Shuttle.this._updateReorderButtonsEnabled(Shuttle.this._fromPicker, null);
                }
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (propName == "selection") {
                Shuttle.this._updateButtonsEnabled((ItemPicker)evt.getSource());
            } else if (evt.getSource() == Shuttle.this && "ancestor".equals(propName) && evt.getNewValue() != null && Shuttle.this.isVisible()) {
                Shuttle.this.initItemPickersSelection();
            }
        }

        public void focusGained(FocusEvent e) {
            Component temp = e.getComponent();
            if (!temp.isEnabled()) {
                if (temp == Shuttle.this._fromReorderUp && Shuttle.this._fromReorderDown.isEnabled()) {
                    Shuttle.this._fromReorderDown.requestFocus();
                } else if (temp == Shuttle.this._fromReorderDown && Shuttle.this._fromReorderUp.isEnabled()) {
                    Shuttle.this._fromReorderUp.requestFocus();
                } else if (temp == Shuttle.this._toReorderUp && Shuttle.this._toReorderDown.isEnabled()) {
                    Shuttle.this._toReorderDown.requestFocus();
                } else if (temp == Shuttle.this._toReorderDown && Shuttle.this._toReorderUp.isEnabled()) {
                    Shuttle.this._toReorderUp.requestFocus();
                }
            }
        }

        public void focusLost(FocusEvent e) {
        }
    }

    protected class AccessibleShuttle
    extends JComponent.AccessibleJComponent
    implements AccessibleAction {
        protected AccessibleShuttle() {
            super(Shuttle.this);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            if (Shuttle.this.isHorizontalLayout()) {
                states.add(AccessibleState.HORIZONTAL);
            } else {
                states.add(AccessibleState.VERTICAL);
            }
            return states;
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public int getAccessibleActionCount() {
            if (Shuttle.this._actionMap == null) {
                boolean moveAllowed = Shuttle.this.isMoveAllowed();
                boolean moveAllAllowed = Shuttle.this.isMoveAllAllowed();
                int actionCount = 0;
                if (moveAllowed) {
                    actionCount += 2;
                }
                if (moveAllAllowed) {
                    actionCount += 2;
                }
                Shuttle.access$002(Shuttle.this, new int[actionCount]);
                int currIndex = 0;
                if (moveAllowed) {
                    ((Shuttle)Shuttle.this)._actionMap[currIndex] = 0;
                    ((Shuttle)Shuttle.this)._actionMap[currIndex + 1] = 2;
                    currIndex += 2;
                }
                if (moveAllAllowed) {
                    ((Shuttle)Shuttle.this)._actionMap[currIndex] = 1;
                    ((Shuttle)Shuttle.this)._actionMap[currIndex + 1] = 3;
                }
            }
            return Shuttle.this._actionMap.length;
        }

        public String getAccessibleActionDescription(int i) {
            if (Shuttle.this._buttonLabels == null) {
                Shuttle.this._loadCompatibleButtonLabels();
            }
            return Shuttle.this._buttonLabels[Shuttle.this._actionMap[i]];
        }

        public boolean doAccessibleAction(int i) {
            boolean result = false;
            int action = Shuttle.this._actionMap[i];
            if (action == 0) {
                result = Shuttle.this._processMove();
            } else if (action == 2) {
                result = Shuttle.this._processRemove();
            } else if (action == 1) {
                result = Shuttle.this._processMoveAll();
            } else if (action == 3) {
                result = Shuttle.this._processRemoveAll();
            }
            return result;
        }
    }
}

