/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.spinBox;

import java.util.NoSuchElementException;
import oracle.bali.ewt.spinBox.NumberRange;
import oracle.bali.ewt.spinBox.SpinBoxModel;
import oracle.bali.share.collection.Range;
import oracle.bali.share.util.IntegerUtils;

public class NumericSpinBoxModel
implements SpinBoxModel {
    private Number _present;
    private Number _dStep = 0.1;
    private boolean _decimal;
    private boolean _decimalPart;
    private Range _range;
    private boolean _forward;
    private boolean _iteratedOnce;

    public NumericSpinBoxModel(Range range) {
        if (range == null) {
            throw new NullPointerException();
        }
        this._range = range;
        this._forward = true;
        this._present = range instanceof NumberRange ? (Number)((NumberRange)range).getLower() : (Number)range.getLowerLimit();
        this._iteratedOnce = false;
    }

    public Range getRange() {
        return this._range;
    }

    public boolean isDecimal() {
        return this._decimal;
    }

    public void setDecimal(boolean decimal) {
        this._decimal = decimal;
    }

    public void setValue(int value) {
        Range range = this.getRange();
        if (!range.inRange(value)) {
            throw new IllegalArgumentException();
        }
        this._present = value;
        this._iteratedOnce = false;
    }

    public int getValue() {
        return this._present.intValue();
    }

    public void setNumber(Number value) {
        Range range = this.getRange();
        if (range instanceof NumberRange ? !((NumberRange)range).inRange(value) : !range.inRange(value.intValue())) {
            throw new IllegalArgumentException();
        }
        this._present = value;
        this._iteratedOnce = false;
    }

    public Number getNumber() {
        return this._present;
    }

    public final Object nextElement() {
        return this.skip(1);
    }

    public void setIteratingForward(boolean forward) {
        this._forward = forward;
    }

    public boolean isIteratingForward() {
        return this._forward;
    }

    public final boolean hasMoreElements() {
        return this.remainingElements(1) == 1;
    }

    public Object skip(int count) {
        boolean decimal = this.isDecimal();
        if (count == 0) {
            if (decimal) {
                return this._present;
            }
            return IntegerUtils.getInteger((int)this._present.intValue());
        }
        boolean forward = this.isIteratingForward();
        if (this.remainingElements(count) == count) {
            if (!this._iteratedOnce) {
                this._iteratedOnce = true;
                --count;
            }
            this._present = this.__isIteratingDecimal() ? (forward ? Double.valueOf(this._present.doubleValue() + (double)count * this._dStep.doubleValue()) : Double.valueOf(this._present.doubleValue() - (double)count * this._dStep.doubleValue())) : (forward ? Double.valueOf(this._present.doubleValue() + (double)count) : Double.valueOf(this._present.doubleValue() - (double)count));
            Range range = this.getRange();
            if (range instanceof NumberRange) {
                // empty if block
            }
            if (decimal) {
                return this._present;
            }
            return IntegerUtils.getInteger((int)this._present.intValue());
        }
        throw new NoSuchElementException();
    }

    public int remainingElements(int desired) {
        if (desired == 0) {
            return 0;
        }
        if (desired < 0) {
            boolean forward = this.isIteratingForward();
            this.setIteratingForward(!forward);
            int r = -this.remainingElements(-desired);
            this.setIteratingForward(forward);
            return r;
        }
        Number present = this._present;
        Number step = this._dStep;
        Range range = this._range;
        double upper = 0.0;
        double lower = 0.0;
        if (range instanceof NumberRange) {
            upper = ((NumberRange)range).getUpper().doubleValue();
            lower = ((NumberRange)range).getLower().doubleValue();
        } else {
            upper = range.getUpperLimit();
            lower = range.getLowerLimit();
        }
        long result = this.__isIteratingDecimal() ? (this.isIteratingForward() ? (long)((int)((upper - present.doubleValue()) / step.doubleValue())) : (long)((int)((present.doubleValue() - lower) / step.doubleValue()))) : (this.isIteratingForward() ? (long)((int)(upper - present.doubleValue())) : (long)((int)(present.doubleValue() - lower)));
        if (!this._iteratedOnce) {
            ++result;
        }
        if ((long)desired < result) {
            return desired;
        }
        return (int)result;
    }

    void __setIteratingDecimal(boolean decimalPart) {
        this._decimalPart = decimalPart;
    }

    boolean __isIteratingDecimal() {
        return this._decimalPart;
    }

    Number __getDecimalStep() {
        return this._dStep;
    }
}

