/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderEvent;
import oracle.bali.ewt.header.HeaderMoveListener;
import oracle.bali.ewt.header.HeaderResizeListener;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.table.TableEvent;
import oracle.bali.ewt.table.TableValidateEvent;

final class TableHeaderAdapter
implements HeaderMoveListener,
HeaderResizeListener,
PropertyChangeListener {
    private int _oldIndex;
    private SpreadTable _table;
    private Header _header;
    boolean _originatingSelectionChange;

    public TableHeaderAdapter(SpreadTable table, Header header) {
        this._table = table;
        this._header = header;
    }

    public void dispose() {
        this._table = null;
        this._header = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("focusItem".equals(name)) {
            int item = this._header.getFocusItem();
            Cell focusCell = this._table.getGrid().getFocusCell();
            if (item != -1 && focusCell != null) {
                if (this._header.getOrientation() == 0) {
                    this._table.getGrid().requestFocus(item, focusCell.row, null);
                } else {
                    this._table.getGrid().requestFocus(focusCell.column, item, null);
                }
            }
        } else if ("selection".equals(name) && !this._table.getGridAdapter().originatingSelectionChange()) {
            Grid grid = this._table.getGrid();
            GridSelectionManager sm = grid.getGridSelectionManager();
            OneDSelection headerSel = (OneDSelection)evt.getNewValue();
            try {
                grid.freezeRepaints();
                grid.commitCellEdit();
                TwoDSelection sel = this._header.getOrientation() == 0 ? new TwoDSelection(headerSel, null) : new TwoDSelection(null, headerSel);
                try {
                    this._originatingSelectionChange = true;
                    sm.setSelection(sel, null);
                }
                catch (PropertyVetoException pve) {
                    // empty catch block
                }
            }
            finally {
                this._originatingSelectionChange = false;
                grid.unfreezeRepaints();
            }
        }
    }

    public void itemMoving(HeaderEvent e) {
        int index = e.getHeaderItem();
        boolean cancel = TableHeaderAdapter._isHorizontal(this._header) ? this._table.fireCancelableColumnEvent(2007, index) : this._table.fireCancelableRowEvent(2009, index);
        if (cancel) {
            ((Cancelable)((Object)e)).cancel();
        }
    }

    public void itemMoved(HeaderEvent e) {
        this._table.getGrid().commitCellEdit();
        int index = e.getHeaderItem();
        int visibleIndex = this._header.getItemVisibleIndex(index);
        if (TableHeaderAdapter._isHorizontal(this._header)) {
            this._table.getGrid().setColumnVisibleIndex(index, visibleIndex);
            this._table.fireColumnEvent(2008, index);
        } else {
            this._table.getGrid().setRowVisibleIndex(index, visibleIndex);
            this._table.fireRowEvent(2010, index);
        }
    }

    public void itemResizing(HeaderEvent e) {
        boolean cancel;
        int index = e.getHeaderItem();
        if (TableHeaderAdapter._isHorizontal(this._header)) {
            boolean autoResize = e.isAutoResize();
            if (autoResize && !this._table.isAutoResize()) {
                cancel = true;
            } else {
                TableValidateEvent event = new TableValidateEvent(this._table, 2001, index, -1, autoResize);
                this._table.processEventImpl(event);
                cancel = event.isCancelled();
            }
        } else {
            cancel = e.isAutoResize() ? true : this._table.fireCancelableRowEvent(2003, index);
        }
        if (cancel) {
            ((Cancelable)((Object)e)).cancel();
        }
    }

    public void itemResized(HeaderEvent e) {
        int index = e.getHeaderItem();
        if (TableHeaderAdapter._isHorizontal(this._header)) {
            boolean autoResize = e.isAutoResize();
            boolean fireEvent = true;
            if (autoResize) {
                if (this._table.isAutoResize()) {
                    this._table.autoResizeColumn(index);
                } else {
                    fireEvent = false;
                }
            }
            if (fireEvent) {
                TableEvent event = new TableEvent(this._table, 2002, index, -1, autoResize);
                this._table.processEventImpl(event);
            }
        } else if (!e.isAutoResize()) {
            this._table.fireRowEvent(2004, index);
        }
    }

    boolean originatingSelectionChange() {
        return this._originatingSelectionChange;
    }

    private static boolean _isHorizontal(Header header) {
        return header.getOrientation() == 0;
    }
}

