/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.util;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.Method;
import java.text.AttributedCharacterIterator;
import javax.swing.AbstractButton;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.ewt.util.FocusUtils;
import oracle.bali.ewt.util.WindowUtils;

public class MenuUtils {
    static Object _sLock = new Object();
    static Tracker _sTracker;
    private static Method _sGetScreenInsets;
    private static boolean _sGetScreenInsetsAvailable;

    public static Dimension getBoundingSize(Component invoker) {
        return invoker.getToolkit().getScreenSize();
    }

    public static boolean willPopupFit(JPopupMenu menu, Component invoker) {
        Dimension menuSize = menu.getPreferredSize();
        Dimension boundingSize = MenuUtils.getBoundingSize(invoker);
        return menuSize.width <= boundingSize.width && menuSize.height <= boundingSize.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showPopupMenu(JPopupMenu popup, Component invoker, int x, int y) {
        Window window;
        Point p = MenuUtils.getPopupMenuLocation(popup, invoker, x, y);
        x = p.x;
        y = p.y;
        if (invoker != null && (window = WindowUtils.getWindow(invoker)) != null) {
            Component focused = window.getFocusOwner();
            if (focused == null && invoker.isFocusTraversable()) {
                invoker.requestFocus();
                focused = invoker;
            }
            if (FocusUtils.areNewFocusAPIsAvailable() && focused != invoker) {
                invoker.requestFocus();
                focused = invoker;
            }
            if (focused != null) {
                Object object = _sLock;
                synchronized (object) {
                    _sTracker = new Tracker(focused, popup);
                }
            }
        }
        if (invoker != null && !invoker.isShowing()) {
            return;
        }
        popup.show(invoker, x, y);
    }

    public static Point getPopupMenuLocation(JPopupMenu popup, Component invoker, int x, int y) {
        Point origin = new Point();
        if (invoker != null) {
            try {
                origin = invoker.getLocationOnScreen();
            }
            catch (Exception e) {
                // empty catch block
            }
            x += origin.x;
            y += origin.y;
        }
        Dimension sizeMenu = popup.getPreferredSize();
        Point bottomRightMenu = new Point(x + sizeMenu.width, y + sizeMenu.height);
        int i = 0;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gds = ge.getScreenDevices();
        if (i < gds.length) {
            GraphicsConfiguration dgc = gds[i].getDefaultConfiguration();
            Rectangle screenBounds = dgc.getBounds();
            if (screenBounds.contains(x, y)) {
                // empty if block
            }
            Insets screenInsets = MenuUtils.getScreenInsets(dgc);
            screenBounds.width -= screenInsets.right;
            screenBounds.height -= screenInsets.bottom;
            int xOffset = 0;
            int yOffset = 0;
            if (bottomRightMenu.x > screenBounds.x + screenBounds.width) {
                xOffset = -sizeMenu.width - 5;
            }
            if (bottomRightMenu.y > screenBounds.y + screenBounds.height) {
                yOffset = screenBounds.y + screenBounds.height - bottomRightMenu.y;
            }
            return new Point(x + xOffset - origin.x, y + yOffset - origin.y);
        }
        return new Point(x - origin.x, y - origin.y);
    }

    public static Insets getScreenInsets(GraphicsConfiguration gc) {
        Insets screenInsets = null;
        if (_sGetScreenInsetsAvailable) {
            try {
                if (_sGetScreenInsets == null) {
                    Class[] c = new Class[]{GraphicsConfiguration.class};
                    _sGetScreenInsets = Toolkit.class.getMethod("getScreenInsets", c);
                }
                Object[] o = new Object[]{gc};
                screenInsets = (Insets)_sGetScreenInsets.invoke((Object)Toolkit.getDefaultToolkit(), o);
            }
            catch (NoSuchMethodException e) {
                _sGetScreenInsetsAvailable = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (screenInsets == null) {
            screenInsets = _sGetScreenInsetsAvailable ? new Insets(0, 0, 0, 0) : new Insets(0, 0, 32, 0);
        }
        return screenInsets;
    }

    private MenuUtils() {
    }

    static {
        _sGetScreenInsetsAvailable = true;
    }

    private static class Tracker
    implements AWTEventListener,
    KeyListener,
    PopupMenuListener {
        private FocusManager _focusManager;
        private Component _component;
        private JPopupMenu _popup;
        private boolean _keyListener;

        public Tracker(Component component, JPopupMenu popup) {
            Tracker current = _sTracker;
            if (current != null) {
                current._detach();
            }
            if (!FocusUtils.areNewFocusAPIsAvailable()) {
                this._focusManager = FocusManager.getCurrentManager();
                FocusManager.disableSwingFocusManager();
                try {
                    long mask = 2056L;
                    component.getToolkit().addAWTEventListener(this, mask);
                    this._keyListener = false;
                }
                catch (Exception e) {
                    this._keyListener = true;
                    component.addKeyListener(this);
                }
            }
            this._component = component;
            this._popup = popup;
            popup.addPopupMenuListener(this);
        }

        public void eventDispatched(AWTEvent e) {
            int id = e.getID();
            switch (id) {
                case 401: {
                    this.keyPressed((KeyEvent)e);
                    break;
                }
                case 402: {
                    this.keyReleased((KeyEvent)e);
                    break;
                }
                case 400: {
                    this.keyTyped((KeyEvent)e);
                    break;
                }
                case 1100: {
                    this.inputMethodTextChanged((InputMethodEvent)e);
                }
            }
        }

        public void inputMethodTextChanged(InputMethodEvent e) {
            AttributedCharacterIterator aci = e.getText();
            char c = aci.first();
            KeyEvent keyEvent = new KeyEvent((Component)e.getSource(), 400, 0L, 0, 0, c);
            this._tryOtherKeys(keyEvent);
            e.consume();
        }

        public void keyPressed(KeyEvent e) {
            int keyCode = e.getKeyCode();
            if (keyCode == 27) {
                MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
                if (path.length > 4) {
                    MenuElement[] newPath = new MenuElement[path.length - 2];
                    System.arraycopy(path, 0, newPath, 0, path.length - 2);
                    MenuSelectionManager.defaultManager().setSelectedPath(newPath);
                } else {
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                }
            } else if (keyCode == 18) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            } else if (keyCode == 38 || keyCode == 40) {
                MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
                if (path != null && path.length >= 2) {
                    int index;
                    int length = path.length;
                    MenuElement last = path[length - 1];
                    MenuElement[] siblings = path[length - 2].getSubElements();
                    for (index = 0; index < siblings.length && siblings[index] != last; ++index) {
                    }
                    if (index == siblings.length) {
                        index = 0;
                    } else {
                        index = keyCode == 40 ? ++index : (index += siblings.length - 1);
                        index %= siblings.length;
                    }
                    path[length - 1] = siblings[index];
                    MenuSelectionManager.defaultManager().setSelectedPath(path);
                }
            } else if (keyCode == 10) {
                MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
                if (path != null && path.length > 0) {
                    MenuElement last = path[path.length - 1];
                    if (last instanceof JMenu) {
                        JPopupMenu popup = ((JMenu)last).getPopupMenu();
                        MenuElement[] subElements = popup.getSubElements();
                        if (subElements != null && subElements.length > 0) {
                            MenuElement[] newPath = new MenuElement[path.length + 2];
                            System.arraycopy(path, 0, newPath, 0, path.length);
                            newPath[path.length] = popup;
                            newPath[path.length + 1] = subElements[0];
                            MenuSelectionManager.defaultManager().setSelectedPath(newPath);
                        }
                    } else {
                        Component c = last.getComponent();
                        if (c instanceof AbstractButton) {
                            ((AbstractButton)c).doClick(0);
                        }
                        MenuSelectionManager.defaultManager().clearSelectedPath();
                    }
                }
            } else {
                this._tryOtherKeys(e);
            }
            e.consume();
        }

        public void keyTyped(KeyEvent e) {
            this._tryOtherKeys(e);
            e.consume();
        }

        public void keyReleased(KeyEvent e) {
            this._tryOtherKeys(e);
            e.consume();
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            if (FocusUtils.areNewFocusAPIsAvailable()) {
                this._component.requestFocus();
            }
            this._detach();
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        private void _tryOtherKeys(KeyEvent e) {
            MenuSelectionManager.defaultManager().processKeyEvent(e);
            if (e.isConsumed()) {
                return;
            }
            Component[] children = this._popup.getComponents();
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
            for (int i = 0; i < children.length; ++i) {
                ActionListener action;
                if (!(children[i] instanceof JComponent) || (action = ((JComponent)children[i]).getActionForKeyStroke(keyStroke)) == null) continue;
                ActionEvent event = new ActionEvent(children[i], 1001, null, e.getModifiers());
                action.actionPerformed(event);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void _detach() {
            Object object = _sLock;
            synchronized (object) {
                Tracker current = _sTracker;
                if (current == this) {
                    _sTracker = null;
                    if (!FocusUtils.areNewFocusAPIsAvailable()) {
                        if (this._keyListener) {
                            this._component.removeKeyListener(this);
                        } else {
                            this._component.getToolkit().removeAWTEventListener(this);
                        }
                    }
                    this._popup.removePopupMenuListener(this);
                    if (!FocusUtils.areNewFocusAPIsAvailable()) {
                        FocusManager.setCurrentManager(this._focusManager);
                    }
                    this._popup = null;
                    this._component = null;
                    this._focusManager = null;
                }
            }
        }
    }
}

