/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.PixelGrabber;
import javax.swing.JComponent;
import javax.swing.UIManager;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.wizard.AccessibleLWComponent;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.WizardPage;

public class ImageWizardPage
extends WizardPage {
    private static final ImageVersionDetails[] _IMAGE_VERSION_DETAILS = new ImageVersionDetails[]{new ImageVersionDetails(new Color(51, 102, 153), new Color(102, 153, 204), 96, 120, 200), new ImageVersionDetails(new Color(51, 102, 153), new Color(153, 204, 255), 120, 120, 200), new ImageVersionDetails(new Color(64, 96, 128), new Color(96, 160, 192), 120, 120, 200){

        public boolean isImageOfThisVersion(Image image) {
            if (Toolkit.getDefaultToolkit().getColorModel().getPixelSize() != 8) {
                return false;
            }
            return super.isImageOfThisVersion(image);
        }
    }};
    private static final LWComponent _IMAGE_OBSERVER = new LWComponent();
    private ColorStrip _imageCanvas;
    private JComponent _interactiveComponent;
    private Component _interactiveArea;

    public ImageWizardPage() {
        this((Component)null, (Image)null, "");
    }

    public ImageWizardPage(Component interactive, Image image, String label) {
        this(interactive, image, label, null);
    }

    ImageWizardPage(Component interactive, Image image, String label, String pageTitle) {
        super(new AccessibleLWComponent(), label, pageTitle);
        AccessibleLWComponent c = (AccessibleLWComponent)this.getContent();
        c.setLayout(new BorderLayout(16, 0));
        this._imageCanvas = new ColorStrip();
        this._imageCanvas.setImage(image);
        this._interactiveComponent = new AccessibleLWComponent();
        this._interactiveComponent.setOpaque(Boolean.TRUE.equals(UIManager.get("EWTWizardPanels.opaque")));
        this._interactiveComponent.setLayout(new BorderLayout());
        this.setInteractiveArea(interactive);
        c.add((Component)this._interactiveComponent, "Center");
    }

    public Image getImage() {
        return this._imageCanvas.getImage();
    }

    public void setImage(Image image) {
        this._imageCanvas.setImage(image);
    }

    public Component getInteractiveArea() {
        return this._interactiveArea;
    }

    public void setInteractiveArea(Component interactiveArea) {
        Component oldInteractive = this._interactiveArea;
        if (oldInteractive == interactiveArea) {
            return;
        }
        if (oldInteractive != null) {
            this._interactiveComponent.remove(oldInteractive);
        }
        this._interactiveArea = interactiveArea;
        if (interactiveArea != null) {
            this._interactiveComponent.add(interactiveArea, "Center");
        }
    }

    private void _addOrRemoveImageArea(Image image) {
        AccessibleLWComponent c = (AccessibleLWComponent)this.getContent();
        if (BaseWizard.isImageWizardPageSupported() && image != null) {
            c.add((Component)this._imageCanvas, "West");
        } else {
            c.remove(this._imageCanvas);
        }
    }

    private static class ImageVersionDetails {
        private Color _topColor;
        private Color _bottomColor;
        private int _stripWidth;
        private int _imageWidth;
        private int _imageHeight;

        ImageVersionDetails(Color topColor, Color bottomColor, int stripWidth, int imageWidth, int imageHeight) {
            this._topColor = topColor;
            this._bottomColor = bottomColor;
            this._stripWidth = stripWidth;
            this._imageWidth = imageWidth;
            this._imageHeight = imageHeight;
        }

        public Color getTopColor() {
            return this._topColor;
        }

        public Color getBottomColor() {
            return this._bottomColor;
        }

        public int getStripWidth() {
            return this._stripWidth;
        }

        public int getUISpecImageHeight() {
            return this._imageHeight;
        }

        public int getUISpecImageWidth() {
            return this._imageWidth;
        }

        public boolean isImageOfThisVersion(Image image) {
            boolean correctSize;
            if (image == null) {
                return false;
            }
            int width = image.getWidth(_IMAGE_OBSERVER);
            int height = image.getHeight(_IMAGE_OBSERVER);
            boolean bl = correctSize = width == this.getUISpecImageWidth() && height == this.getUISpecImageHeight();
            if (!correctSize) {
                return false;
            }
            int[] topPixel = new int[1];
            int[] bottomPixel = new int[1];
            PixelGrabber topLeft = new PixelGrabber(image, 0, 0, 1, 1, topPixel, 0, width);
            PixelGrabber bottomLeft = new PixelGrabber(image, 0, height - 1, 1, 1, bottomPixel, 0, width);
            try {
                topLeft.grabPixels();
                bottomLeft.grabPixels();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            return topPixel[0] == this.getTopColor().getRGB() && bottomPixel[0] == this.getBottomColor().getRGB();
        }
    }

    private class ColorStrip
    extends AccessibleLWComponent {
        private ImageVersionDetails _imageVersionDetails;
        private Image _image;

        private ColorStrip() {
        }

        public Dimension getPreferredSize() {
            return this._imageVersionDetails == null ? new Dimension(this._image.getWidth(this), this._image.getHeight(this)) : new Dimension(this._imageVersionDetails.getUISpecImageWidth(), this._imageVersionDetails.getUISpecImageHeight());
        }

        public void setImage(Image image) {
            this._image = image;
            ImageUtils.loadImage(image);
            this._imageVersionDetails = this._getImageVersionDetails();
            ImageWizardPage.this._addOrRemoveImageArea(image);
        }

        public Image getImage() {
            return this._image;
        }

        protected void paintComponent(Graphics g) {
            int imageHeight;
            if (this._image == null) {
                return;
            }
            Dimension d = this.getSize();
            if (this._imageVersionDetails != null) {
                g.setColor(this._imageVersionDetails.getTopColor());
                g.fillRect(0, 0, this._imageVersionDetails.getStripWidth(), d.height / 2);
                g.setColor(this._imageVersionDetails.getBottomColor());
                g.fillRect(0, d.height / 2, this._imageVersionDetails.getStripWidth(), d.height / 2);
                imageHeight = this._imageVersionDetails.getUISpecImageHeight();
            } else {
                imageHeight = this._image.getHeight(this);
            }
            int imgTop = d.height / 2 - imageHeight / 2;
            g.drawImage(this._image, 0, imgTop, this);
        }

        private ImageVersionDetails _getImageVersionDetails() {
            if (this._image != null) {
                for (int i = 0; i < _IMAGE_VERSION_DETAILS.length; ++i) {
                    if (!_IMAGE_VERSION_DETAILS[i].isImageOfThisVersion(this._image)) continue;
                    return _IMAGE_VERSION_DETAILS[i];
                }
            }
            return null;
        }
    }
}

