/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.util.PaintUtils;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.WelcomeWizardPage;
import oracle.bali.ewt.wizard.WizardAdapter;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.ewt.wizard.WizardListener2;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.bali.ewt.wizard.WizardSize;
import oracle.bali.ewt.wizard.WizardWindowTitle;

public class WizardDialog
extends JDialog {
    private BaseWizard _wizard;
    private boolean _cancelled;
    private WizardListener2 _listener;
    private boolean _finishPage;
    private boolean _welcomePage;
    private WelcomeWizardPage _welcomeWizardPage;
    private boolean _skipNextTime;
    private WizardWindowTitle _windowTitle;
    private Locale _locale;
    private Component _centerOver;
    private int _initialWidth = -1;
    private int _initialHeight = -1;
    private Runnable _runnable = null;
    private Dimension _prevMinSize = null;
    private boolean _isInitial = true;

    public WizardDialog() {
        this(null, (Frame)null, true);
    }

    public WizardDialog(BaseWizard wizard) {
        this(wizard, (Frame)null, true);
    }

    public WizardDialog(BaseWizard wizard, Frame parent) {
        this(wizard, parent, true);
    }

    public WizardDialog(BaseWizard wizard, Frame parent, boolean modal) {
        super(parent, "", modal);
        this._init(wizard);
    }

    public WizardDialog(BaseWizard wizard, Dialog parent) {
        this(wizard, parent, true);
    }

    public WizardDialog(BaseWizard wizard, Dialog parent, boolean modal) {
        super(parent, "", modal);
        this._init(wizard);
    }

    public BaseWizard getWizard() {
        return this._wizard;
    }

    public void setWizard(BaseWizard wizard) {
        if (this.isVisible()) {
            throw new IllegalStateException();
        }
        this._wizard = wizard;
        this._windowTitle.setWizard(this._wizard);
    }

    public void setWizardTitle(String wizardTitle) {
        this._windowTitle.setBaseTitle(wizardTitle);
    }

    public String getWizardTitle() {
        return this._windowTitle.getBaseTitle();
    }

    public void setWelcomePageIncluded(boolean welcomePage) {
        this._welcomePage = welcomePage;
    }

    public boolean isWelcomePageIncluded() {
        return this._welcomePage;
    }

    public void setWelcomeWizardPage(WelcomeWizardPage welcomePage) {
        this._welcomeWizardPage = welcomePage;
        this.setWelcomePageIncluded(welcomePage != null);
    }

    public WelcomeWizardPage getWelcomeWizardPage() {
        return this._welcomeWizardPage;
    }

    public void setFinishPageIncluded(boolean finishPage) {
        this._finishPage = finishPage;
    }

    public boolean isFinishPageIncluded() {
        return this._finishPage;
    }

    public boolean isCancelled() {
        return this._cancelled;
    }

    public Component getCenterOver() {
        return this._centerOver;
    }

    public void setCenterOver(Component centerOver) {
        this._centerOver = centerOver;
    }

    public boolean runDialog() {
        return this.runDialog(null);
    }

    public boolean runDialog(Runnable runnable) {
        BaseWizard wizard = this._wizard;
        if (this.isVisible() || wizard == null || wizard.getParent() != null) {
            throw new IllegalStateException();
        }
        this._runnable = runnable;
        this.getContentPane().add((Component)wizard, "Center");
        wizard.addWizardListener(this._listener);
        this._initialWidth = -1;
        this._initialHeight = -1;
        if (!this._isInitial) {
            super.setMinimumSize(this._prevMinSize);
        }
        if (this._welcomeWizardPage != null && this._welcomeWizardPage.isVisible()) {
            this._skipNextTime = this._welcomeWizardPage.isSkipNextTime();
            wizard.restart();
            if (this._skipNextTime) {
                wizard.doNext();
            }
        }
        this._windowTitle.setCanUpdate(true);
        this._windowTitle.updateTitle();
        this.pack();
        this.setBackground(wizard.getBackground());
        this.getContentPane().setBackground(wizard.getBackground());
        Component centerOver = this.getCenterOver();
        if (centerOver == null) {
            centerOver = this.getParent();
        }
        WindowUtils.centerWindow(this, centerOver);
        this._initialWidth = this.getWidth();
        this._initialHeight = this.getHeight();
        this._prevMinSize = this.isMinimumSizeSet() ? super.getMinimumSize() : null;
        this.setMinimumSize(new Dimension(this._initialWidth, this._initialHeight));
        this._isInitial = false;
        this._cancelled = false;
        this.setVisible(true);
        if (this.isModal() && this._wizard != null) {
            wizard.removeWizardListener(this._listener);
            this._windowTitle.setCanUpdate(false);
            this.getContentPane().remove(wizard);
        }
        return !this._cancelled;
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    public Locale getLocale() {
        Locale locale = this._locale;
        if (locale != null) {
            return locale;
        }
        Container parent = this.getParent();
        if (parent != null && (locale = parent.getLocale()) != null) {
            return locale;
        }
        return super.getLocale();
    }

    public Dimension getPreferredSize() {
        if (this._wizard != null) {
            return WizardSize.getWizardWindowSize(this, this._wizard.getDefaultWizardSize());
        }
        return WizardSize.getWizardWindowSize(this, 0);
    }

    public Dimension getMinimumSize() {
        if (this._initialWidth != -1 && this._initialHeight != -1) {
            return new Dimension(this._initialWidth, this._initialHeight);
        }
        return super.getMinimumSize();
    }

    public void dispose() {
        super.dispose();
        if (this._wizard == null) {
            return;
        }
        WindowUtils.unregisterWindow(this);
        this._windowTitle.setWizard(null);
        this.getContentPane().remove(this._wizard);
        this._wizard.removeWizardListener(this._listener);
        this._wizard.dispose();
        this._listener = null;
        this._windowTitle = null;
        this._wizard = null;
        this._locale = null;
        this._centerOver = null;
    }

    protected void dismissDialog(boolean cancelled) {
        this._cancelled = cancelled;
        if (this.isVisible()) {
            this.setVisible(false);
            if (!this.isModal()) {
                this._wizard.removeWizardListener(this._listener);
                this._windowTitle.setCanUpdate(false);
                this.getContentPane().remove(this._wizard);
            }
            if (!this._cancelled && this._runnable != null) {
                PaintUtils.invokeAfterRepaint(this._runnable);
                this._runnable = null;
            }
        }
    }

    protected void processComponentEvent(ComponentEvent e) {
        int originalHeight;
        int originalWidth;
        super.processComponentEvent(e);
        if (e.getID() != 101) {
            return;
        }
        int width = originalWidth = this.getWidth();
        int height = originalHeight = this.getHeight();
        if (this._initialWidth != -1) {
            width = Math.max(this._initialWidth, width);
        }
        if (this._initialHeight != -1) {
            height = Math.max(this._initialHeight, height);
        }
        if (originalWidth != width || originalHeight != height) {
            this.setSize(width, height);
        }
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201 && this._wizard != null) {
            this._wizard.__doCancelClick();
        }
        super.processWindowEvent(e);
    }

    private void _init(BaseWizard wizard) {
        WindowUtils.registerWindow(this);
        this._wizard = wizard;
        this._listener = new WizListener();
        JComponent content = (JComponent)this.getContentPane();
        content.setLayout(new BorderLayout());
        this.enableEvents(65L);
        this.setDefaultCloseOperation(0);
        this._windowTitle = new WizardWindowTitle(this, wizard);
    }

    private class WizListener
    extends WizardAdapter {
        private WizListener() {
        }

        public void wizardFinished(WizardEvent event) {
            WizardPage proPage = WizardDialog.this._wizard.getProgressWizardPage();
            WizardPage endPage = WizardDialog.this._wizard.getEndOfProcessWizardPage();
            if (proPage == null && endPage == null) {
                WizardDialog.this.dismissDialog(false);
                return;
            }
            WizardPage page = WizardDialog.this._wizard.getNextPage(event.getPage());
            while (page == null || page != proPage && page != endPage) {
                if (page == null) {
                    WizardDialog.this.dismissDialog(false);
                    break;
                }
                page = WizardDialog.this._wizard.getNextPage(page);
            }
        }

        public void wizardCanceled(WizardEvent event) {
            WizardDialog.this.dismissDialog(true);
            if (WizardDialog.this._welcomeWizardPage != null) {
                WizardDialog.this._welcomeWizardPage.setSkipNextTime(WizardDialog.this._skipNextTime);
            }
        }

        public void wizardClosed(WizardEvent event) {
            WizardDialog.this.dismissDialog(false);
        }
    }
}

