/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.worker;

import java.util.Dictionary;
import oracle.bali.ewt.worker.InvocationContext;
import oracle.bali.ewt.worker.Worker;
import oracle.bali.ewt.worker.WorkerStatusAdapter;
import oracle.bali.ewt.worker.WorkerStatusListener;
import oracle.bali.ewt.worker.WorkerUtils;

public class SpawningWorkerStatus
extends WorkerStatusAdapter {
    private Worker _successWorker;
    private WorkerStatusListener _successListener;
    private Worker _failureWorker;
    private WorkerStatusListener _failureListener;

    public SpawningWorkerStatus(Worker successWorker, Worker failureWorker) {
        this(successWorker, null, failureWorker, null);
    }

    public SpawningWorkerStatus(Worker successWorker, WorkerStatusListener successListener, Worker failureWorker, WorkerStatusListener failureListener) {
        this._successWorker = successWorker;
        this._successListener = successListener;
        this._failureWorker = failureWorker;
        this._failureListener = failureListener;
    }

    public void workerSucceeded(InvocationContext invokeContext) {
        SpawningWorkerStatus._runOrQueueResult(this._successWorker, invokeContext, WorkerUtils.getMainResult(invokeContext), this._successListener);
    }

    public void workerFailed(InvocationContext invokeContext) {
        SpawningWorkerStatus._runOrQueueResult(this._failureWorker, invokeContext, WorkerUtils.getFailureCause(invokeContext), this._failureListener);
    }

    private static void _runOrQueueResult(Worker worker, InvocationContext parentContext, Object newParameter, WorkerStatusListener listener) {
        if (worker != null) {
            Dictionary parameters = WorkerUtils.createParameters(InvocationContext.PARENT_CONTEXT, parentContext);
            WorkerUtils.putNullableValue(parameters, InvocationContext.PARAMETER_VALUE, newParameter);
            WorkerUtils.runOrQueueWorker(worker, parameters, listener);
        }
    }
}

