/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.headless;

import java.io.File;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.display.DisplayHtml;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayModelCache;
import oracle.dbtools.raptor.controls.display.IErrorHandler;
import oracle.dbtools.raptor.headless.HeadlessCommandProcessor;
import oracle.dbtools.raptor.headless.HeadlessCore;
import oracle.dbtools.raptor.headless.HeadlessTask;
import oracle.dbtools.raptor.headless.InvalidCommandArgumentException;
import oracle.dbtools.raptor.report.Messages;
import oracle.dbtools.raptor.report.headless.CommandlineResources;
import oracle.dbtools.raptor.report.navigatorV2.RootNode;
import oracle.dbtools.raptor.utils.Connections;

public class ReportsProcessor
implements HeadlessCommandProcessor {
    private static final String ALL_REPORTS_PATH = Messages.getString("RootNode.1") + "/";
    private static final String USER_DEFINED_REPORTS_PATH = ALL_REPORTS_PATH + Messages.getString("RootNode.2") + "/";

    public HeadlessTask<Void> parseCommandArguments(HeadlessCore headlessCore, String ... stringArray) throws InvalidCommandArgumentException {
        if (stringArray.length != 0) {
            if ("GENERATE".equalsIgnoreCase(stringArray[0])) {
                String string = null;
                String string2 = null;
                String string3 = null;
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                int n = 1;
                while (n < stringArray.length - 1 && stringArray[n].startsWith("-")) {
                    String string4 = stringArray[n++];
                    String string5 = stringArray[n++];
                    if ("-REPORT".equalsIgnoreCase(string4)) {
                        string3 = string5;
                        continue;
                    }
                    if ("-DB".equalsIgnoreCase(string4)) {
                        string2 = string5;
                        continue;
                    }
                    if ("-FILE".equalsIgnoreCase(string4)) {
                        string = string5;
                        continue;
                    }
                    if ("-BIND".equalsIgnoreCase(string4)) {
                        int n2 = string5.indexOf(61);
                        if (n2 < 0) {
                            hashMap.put(string5, null);
                            continue;
                        }
                        String string6 = string5.substring(0, n2);
                        String string7 = string5.substring(n2 + 1);
                        hashMap.put(string6, string7);
                        continue;
                    }
                    throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", string4));
                }
                if (string == null) {
                    throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", "-FILE"));
                }
                if (string2 == null) {
                    throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", "-DB"));
                }
                if (string3 == null) {
                    throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", "-REPORT"));
                }
                return new GenerateReportTask(string, string2, string3, hashMap);
            }
            headlessCore.printErrorMessage(new String[]{CommandlineResources.format("INVALID_COMMAND", stringArray[0]), CommandlineResources.getString("USAGE_STRING")});
            throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", stringArray[0]));
        }
        headlessCore.printMessage(new String[]{CommandlineResources.getString("USAGE_STRING")});
        return null;
    }

    public String getUsageString() {
        return CommandlineResources.getString("USAGE_STRING");
    }

    private static class GenerateReportTask
    extends HeadlessTask<Void> {
        private File htmlFile;
        private String connectionDisplayName;
        private String reportName;
        private Map<String, Object> binds;
        private Throwable generationException;

        GenerateReportTask(String string, String string2, String string3, Map<String, Object> map) {
            super("generate");
            String string4;
            this.htmlFile = new File(string);
            if (!this.htmlFile.isAbsolute() && (string4 = System.getProperty("ide.startingcwd")) != null && !string4.equals("")) {
                File file = new File(string4);
                this.htmlFile = new File(file, string);
            }
            this.connectionDisplayName = string2;
            this.reportName = string3;
            this.binds = map;
        }

        protected Void doWork() throws TaskException {
            DisplayModel displayModel = null;
            try {
                displayModel = this.model(this.reportName);
            }
            catch (Exception exception) {
                throw new TaskException((Throwable)exception);
            }
            String string = this.connectionName(this.connectionDisplayName);
            if (string == null) {
                throw new TaskException((Throwable)new Exception("connection '" + this.connectionDisplayName + "' not found"));
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date(System.currentTimeMillis()));
            DateFormat dateFormat = DateFormat.getDateTimeInstance();
            String string2 = dateFormat.format(calendar.getTime());
            DisplayHtml displayHtml = new DisplayHtml(this.htmlFile, string, displayModel, this.binds, string2);
            IErrorHandler iErrorHandler = new IErrorHandler(){

                public void handleError(IErrorHandler.Category category, Throwable throwable) {
                    GenerateReportTask.this.generationException = throwable;
                }

                public boolean hasErrors() {
                    return GenerateReportTask.this.generationException != null;
                }
            };
            displayHtml.generate(iErrorHandler);
            if (this.generationException != null) {
                throw new TaskException(this.generationException);
            }
            return null;
        }

        private DisplayModel model(String string) throws Exception {
            TreeSet<String> treeSet = new TreeSet<String>();
            DisplayModel displayModel = this.findModel(USER_DEFINED_REPORTS_PATH, string, treeSet);
            if (displayModel == null) {
                displayModel = this.findModel(null, string, treeSet);
            }
            if (displayModel == null) {
                throw new Exception("'" + string + "' not found");
            }
            if (treeSet.size() > 1) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("ambiguous report name:\n");
                for (String string2 : treeSet) {
                    stringBuilder.append("  ");
                    stringBuilder.append(string2);
                    stringBuilder.append('\n');
                }
                throw new Exception(stringBuilder.toString());
            }
            return displayModel;
        }

        private DisplayModel findModel(String string, String string2, Set<String> set) {
            DisplayModel displayModel = null;
            RootNode.getInstance().initialize();
            String string3 = string != null ? "/" + string : null;
            String string4 = "/" + string2;
            for (String string5 : DisplayModelCache.getIds()) {
                DisplayModel displayModel2 = DisplayModelCache.getDisplayModel((String)string5);
                String string6 = displayModel2.getPath();
                String string7 = "/" + string6;
                if (string3 != null && !string7.startsWith(string3) || !string7.endsWith(string4)) continue;
                displayModel = displayModel2;
                set.add(string6);
            }
            return displayModel;
        }

        private String connectionName(String string) {
            String string2 = null;
            for (String string3 : Connections.getInstance().getConnNames()) {
                String string4 = Connections.getDisplayName((String)string3);
                if (!string4.equals(string)) continue;
                string2 = string3;
                break;
            }
            return string2;
        }
    }
}

