/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.navigatorV2;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTree;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DeferUIOperationTask;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.controls.JFileChooserFilter;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.report.Messages;
import oracle.dbtools.raptor.report.addin.ReportAddin;
import oracle.dbtools.raptor.report.addin.ReportEditor;
import oracle.dbtools.raptor.report.navigatorV2.FolderNode;
import oracle.dbtools.raptor.report.navigatorV2.ReportEditorNode;
import oracle.dbtools.raptor.report.navigatorV2.ReportNavigatorWindow;
import oracle.dbtools.raptor.report.navigatorV2.ReportNode;
import oracle.dbtools.raptor.report.navigatorV2.ReportXMLUtil;
import oracle.dbtools.raptor.report.navigatorV2.RootNode;
import oracle.dbtools.raptor.report.navigatorV2.TreeUtils;
import oracle.dbtools.raptor.report.ui.ReportArb;
import oracle.dbtools.raptor.report.ui.ReportDialog;
import oracle.dbtools.raptor.report.ui.ReportFolderDialog;
import oracle.dbtools.raptor.report.ui.ReportHtmlDialog;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.LicenseUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ideimpl.explorer.CustomTree;
import oracle.ideimpl.explorer.ExplorerNode;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.JDeveloperMenuConstants;

public class ReportNavigatorContextMenu
implements ContextMenuListener,
Controller {
    private static ReportNavigatorContextMenu _instance;
    static final int ADD_FOLDER_CMD_ID;
    static final int ADD_REPORT_CMD_ID;
    static final int EDIT_CMD_ID;
    static final int OPEN_CMD_ID;
    static final int OPEN_NEW_CMD_ID;
    static final int HTML_CMD_ID;
    static final int CUT_CMD_ID;
    static final int COPY_CMD_ID;
    static final int PASTE_CMD_ID;
    static final int DELETE_CMD_ID;
    static final int EXPORT_CMD_ID;
    static final int IMPORT_CMD_ID;
    private static IdeAction addFolderAction;
    private static IdeAction addReportAction;
    private static IdeAction editAction;
    private static IdeAction openAction;
    private static IdeAction openNewAction;
    private static IdeAction htmlAction;
    private static IdeAction cutAction;
    private static IdeAction copyAction;
    private static IdeAction pasteAction;
    private static IdeAction deleteAction;
    private static IdeAction exportAction;
    private static IdeAction importAction;
    private Node _Buffer = null;
    private Node _node;
    private Context _ctx;
    private Context _BufferParent;
    private File _file;
    private String ACTION = "";
    private String oldName = "";
    boolean _actionsMade = false;
    private static File _lastUrl;

    static void createActions() {
        exportAction = ReportNavigatorContextMenu.getAction(EXPORT_CMD_ID);
        importAction = ReportNavigatorContextMenu.getAction(IMPORT_CMD_ID);
        addFolderAction = ReportNavigatorContextMenu.getAction(ADD_FOLDER_CMD_ID);
        addReportAction = ReportNavigatorContextMenu.getAction(ADD_REPORT_CMD_ID);
        editAction = ReportNavigatorContextMenu.getAction(EDIT_CMD_ID);
        openAction = ReportNavigatorContextMenu.getAction(OPEN_CMD_ID);
        openNewAction = ReportNavigatorContextMenu.getAction(OPEN_NEW_CMD_ID);
        htmlAction = ReportNavigatorContextMenu.getAction(HTML_CMD_ID);
        copyAction = ReportNavigatorContextMenu.getAction(COPY_CMD_ID);
        cutAction = ReportNavigatorContextMenu.getAction(CUT_CMD_ID);
        pasteAction = ReportNavigatorContextMenu.getAction(PASTE_CMD_ID);
        deleteAction = ReportNavigatorContextMenu.getAction(DELETE_CMD_ID);
    }

    private static IdeAction getAction(int n) {
        IdeAction ideAction = IdeAction.get((int)n);
        ideAction.addController((Controller)ReportNavigatorContextMenu.getInstance());
        return ideAction;
    }

    public void attachMouseListener(Component component) {
        JTree jTree = TreeUtils.findTree(component);
        jTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                ExplorerNode explorerNode;
                Node node;
                TreePath treePath;
                if (mouseEvent.getButton() == 1 && mouseEvent.getSource() instanceof CustomTree && (ExplorerNode)((CustomTree)mouseEvent.getSource()).getLastSelectedPathComponent() != null && ((ExplorerNode)((CustomTree)mouseEvent.getSource()).getLastSelectedPathComponent()).getUserObject() != null && (treePath = ((CustomTree)mouseEvent.getSource()).getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null && (node = (Node)(explorerNode = (ExplorerNode)treePath.getLastPathComponent()).getUserObject()) instanceof ReportNode) {
                    ((ReportNode)node).getReport().setParent(null);
                    ((ReportNode)node).getReport().setQueriesBindMap(null);
                    ((Component)mouseEvent.getSource()).setCursor(new Cursor(3));
                    ReportNavigatorContextMenu.this.openReport((ReportNode)node, false, null);
                    ((Component)mouseEvent.getSource()).setCursor(new Cursor(0));
                }
            }
        });
        jTree.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127) {
                    keyEvent.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context;
        Element[] elementArray;
        if (!this._actionsMade) {
            ReportNavigatorContextMenu.createActions();
            this._actionsMade = true;
        }
        if ((elementArray = (context = contextMenu.getContext()).getSelection()).length == 1 && context.getView() instanceof ReportNavigatorWindow) {
            contextMenu.removeAll();
            Element element = ReportNavigatorContextMenu.getElement(context);
            if (element instanceof FolderNode) {
                if (element == RootNode.getInstance().getUserDefined()) {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)addReportAction), 1.0f);
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)addFolderAction), 1.0f);
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)copyAction), JDeveloperMenuConstants.SECTION_EDIT_CUT_COPY_PASTE);
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)pasteAction), JDeveloperMenuConstants.SECTION_EDIT_CUT_COPY_PASTE);
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)importAction), JDeveloperMenuConstants.SECTION_FILE_IMPORT_EXPORT);
                } else if (((FolderNode)element).isEditable()) {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)editAction), 1.0f);
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)addFolderAction), 1.0f);
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)addReportAction), 1.0f);
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)cutAction), JDeveloperMenuConstants.SECTION_EDIT_CUT_COPY_PASTE);
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)copyAction), JDeveloperMenuConstants.SECTION_EDIT_CUT_COPY_PASTE);
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)pasteAction), JDeveloperMenuConstants.SECTION_EDIT_CUT_COPY_PASTE);
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)deleteAction), JDeveloperMenuConstants.SECTION_EDIT_CUT_COPY_PASTE);
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)importAction), JDeveloperMenuConstants.SECTION_FILE_IMPORT_EXPORT);
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)exportAction), JDeveloperMenuConstants.SECTION_FILE_IMPORT_EXPORT);
                } else {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)copyAction), JDeveloperMenuConstants.SECTION_EDIT_CUT_COPY_PASTE);
                }
            } else if (element instanceof ReportNode) {
                if (((ReportNode)element).isEditable()) {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)editAction), 1.0f);
                }
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)openAction), 1.0f);
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)openNewAction), 1.0f);
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)htmlAction), 1.0f);
                if (((ReportNode)element).isEditable()) {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)cutAction), JDeveloperMenuConstants.SECTION_EDIT_CUT_COPY_PASTE);
                }
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)copyAction), JDeveloperMenuConstants.SECTION_EDIT_CUT_COPY_PASTE);
                if (((ReportNode)element).isEditable()) {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)deleteAction), JDeveloperMenuConstants.SECTION_EDIT_CUT_COPY_PASTE);
                }
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)exportAction), JDeveloperMenuConstants.SECTION_FILE_IMPORT_EXPORT);
            }
        }
    }

    private static Element getElement(Context context) {
        Element element = null;
        Element[] elementArray = context.getSelection();
        if (elementArray != null && elementArray.length == 1) {
            element = elementArray[0];
        }
        return element;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        if (context.getNode() instanceof ReportNode) {
            this.openReport(context, false);
            return true;
        }
        return false;
    }

    public FolderNode getParent(Context context) {
        TNode tNode = ExplorerContext.getSingleTNode((Context)context);
        TNode tNode2 = (TNode)tNode.getParent();
        FolderNode folderNode = (FolderNode)tNode2.getData();
        return folderNode;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == ADD_FOLDER_CMD_ID) {
            this.ACTION = "ADD";
            this.oldName = "";
            this.folderDialog((FolderNode)context.getNode(), null);
            this.refresh(context);
            this.saveUserDefined();
            return true;
        }
        if (n == ADD_REPORT_CMD_ID) {
            this.ACTION = "ADD";
            this.oldName = "";
            this.reportDialog((FolderNode)context.getNode(), null);
            this.refresh(context);
            this.saveUserDefined();
            return true;
        }
        if (n == OPEN_CMD_ID) {
            this.ACTION = "OPEN";
            this.oldName = "";
            this.openReport(context, false);
            return true;
        }
        if (n == OPEN_NEW_CMD_ID) {
            this.ACTION = "OPEN";
            this.oldName = "";
            this.openReport(context, true);
            return true;
        }
        if (n == HTML_CMD_ID) {
            this.ACTION = "HTML";
            this.htmlDialog((ReportNode)context.getNode());
            return true;
        }
        if (n == COPY_CMD_ID) {
            this.ACTION = "COPY";
            this.oldName = "";
            if (context.getNode() instanceof FolderNode) {
                this._Buffer = ((FolderNode)context.getNode()).clone(context.getNode().getURL());
                ((FolderNode)this._Buffer).setEditableRecursive(true);
            } else if (context.getNode() instanceof ReportNode) {
                this._Buffer = ((ReportNode)context.getNode()).clone(context.getNode().getURL());
                ((ReportNode)this._Buffer).setEditable(true);
            }
            return true;
        }
        if (n == EDIT_CMD_ID) {
            this.ACTION = "EDIT";
            if (context.getNode() instanceof FolderNode) {
                this.oldName = ((FolderNode)context.getNode()).getShortLabel();
                this.folderDialog(this.getParent(context), (FolderNode)context.getNode());
                this.refresh(context);
            } else if (context.getNode() instanceof ReportNode) {
                this.oldName = ((ReportNode)context.getNode()).getShortLabel();
                this.reportDialog(this.getParent(context), (ReportNode)context.getNode());
            }
            this.saveUserDefined();
            return true;
        }
        if (n == CUT_CMD_ID) {
            this.ACTION = "CUT";
            this.oldName = "";
            this._Buffer = context.getNode();
            this._BufferParent = context;
            return true;
        }
        if (n == PASTE_CMD_ID) {
            if (this._Buffer != null) {
                if (this.ACTION.equals("COPY")) {
                    Boolean bl = true;
                    String string = this._Buffer.getShortLabel();
                    String string2 = "";
                    if (context.getNode() instanceof FolderNode) {
                        Iterator iterator = ((FolderNode)context.getNode()).getChildren();
                        while (iterator.hasNext()) {
                            Object e = iterator.next();
                            if (e instanceof FolderNode) {
                                string2 = ((FolderNode)e).getFolder().getName();
                            } else if (e instanceof ReportNode) {
                                string2 = ((ReportNode)e).getReport().getName();
                            }
                            if (!string2.equals(string)) continue;
                            bl = false;
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)Messages.getString("ReportNavigatorContextMenu.50"), (String)Messages.getString("ReportNavigatorContextMenu.51"), null);
                            break;
                        }
                        if (bl.booleanValue()) {
                            ((FolderNode)context.getNode()).add((Element)this._Buffer);
                            UpdateMessage.fireChildAdded((Subject)context.getNode(), (Element)this._Buffer);
                        }
                    }
                } else if (this.ACTION.equals("CUT")) {
                    Boolean bl = true;
                    String string = this._Buffer.getShortLabel();
                    String string3 = "";
                    if (context.getNode() instanceof FolderNode) {
                        Object object;
                        Iterator iterator = ((FolderNode)context.getNode()).getChildren();
                        while (iterator.hasNext()) {
                            object = iterator.next();
                            if (object instanceof FolderNode) {
                                string3 = ((FolderNode)object).getFolder().getName();
                            } else if (object instanceof ReportNode) {
                                string3 = ((ReportNode)object).getReport().getName();
                            }
                            if (!string3.equals(string)) continue;
                            bl = false;
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)Messages.getString("ReportNavigatorContextMenu.54"), (String)Messages.getString("ReportNavigatorContextMenu.55"), null);
                            break;
                        }
                        if (bl.booleanValue()) {
                            try {
                                object = CommandProcessor.createCommand((String)"oracle.ide.cmd.DeleteTNodeCommand", (Context)this._BufferParent);
                                CommandProcessor.getInstance().invoke(object);
                                UpdateMessage.fireChildRemoved((Subject)this._BufferParent.getNode(), (Element)this._Buffer);
                                ((FolderNode)context.getNode()).add((Element)this._Buffer);
                                UpdateMessage.fireChildAdded((Subject)context.getNode(), (Element)this._Buffer);
                            }
                            catch (Exception exception) {
                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                            }
                        }
                    }
                }
                this.refresh(context);
                this.saveUserDefined();
                this._Buffer = null;
            }
            return true;
        }
        if (n == DELETE_CMD_ID) {
            this.ACTION = "DELETE";
            this.oldName = "";
            if (context.getNode() instanceof FolderNode) {
                this.deleteFolder(context);
            } else if (context.getNode() instanceof ReportNode) {
                this.deleteReport(context);
            }
            UpdateMessage.fireChildRemoved((Subject)context.getNode(), (Element)context.getNode());
            this.refresh(context);
            this.saveUserDefined();
            return true;
        }
        if (n == EXPORT_CMD_ID) {
            this.ACTION = "EXPORT";
            this.oldName = "";
            this.exportNode(context.getNode());
            return true;
        }
        if (n == IMPORT_CMD_ID) {
            this.ACTION = "IMPORT";
            this.oldName = "";
            this.importToNode(context.getNode());
            return true;
        }
        return false;
    }

    private void importToNode(Node node, URL uRL, String string) {
        ReportXMLUtil reportXMLUtil = new ReportXMLUtil();
        reportXMLUtil.setImport(true);
        try {
            FileInputStream fileInputStream = new FileInputStream(uRL.getFile());
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, string);
            ClassLoader classLoader = this.getClass().getClassLoader();
            reportXMLUtil.parseXML((DefaultContainer)node, inputStreamReader, true, classLoader);
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        reportXMLUtil.setImport(false);
        this.saveUserDefined();
    }

    private void importToNode(Node node) {
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.setName(Messages.getString("ReportNavigatorContextMenu.64"));
        if (this._file != null) {
            uRLFileChooser.setSelectedFile(this._file);
        }
        if (uRLFileChooser.showOpenDialog((Component)Ide.getMainWindow()) == 0) {
            this._file = uRLFileChooser.getSelectedFile();
            try {
                this.importToNode(node, uRLFileChooser.getSelectedFile().toURL(), "UTF-8");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            Iterator iterator = node.getChildren();
            while (iterator.hasNext()) {
                UpdateMessage.fireChildAdded((Subject)node, (Element)((Node)iterator.next()));
            }
        }
        this.saveUserDefined();
    }

    private void refresh(Context context) {
        TNode tNode = ExplorerContext.getSingleTNode((Context)context);
        TNode tNode2 = (TNode)tNode.getParent();
        try {
            ((ReportNavigatorWindow)((Object)context.getProperty("Context.VIEW"))).refresh(tNode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((ReportNavigatorWindow)((Object)context.getProperty("Context.VIEW"))).refresh(tNode2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveUserDefined() {
        if (!RootNode.getInstance().isOpen()) {
            try {
                RootNode.getInstance().open();
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
        Iterator iterator = RootNode.getInstance().getUserDefined().getChildren();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        while (iterator.hasNext()) {
            arrayList.add((Node)iterator.next());
        }
        Node[] nodeArray = new Node[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            nodeArray[i] = (Node)arrayList.get(i);
        }
        this.exportNodes(nodeArray, new File(ReportAddin.USER_REPORT_FILE), null);
    }

    public void exportNode(Node node, File file) {
        Node[] nodeArray = new Node[]{node};
        this.exportNodes(nodeArray, file, null);
    }

    public void exportNodes(Node[] nodeArray, File file, String string) {
        try {
            if (string == null) {
                string = "UTF-8";
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, string);
            outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"" + string + "\" ?>" + "\n");
            outputStreamWriter.write("<displays>\n");
            if (nodeArray != null) {
                for (Node node : nodeArray) {
                    if (node instanceof ReportNode) {
                        outputStreamWriter.write(((ReportNode)node).getReport().toXML(0));
                        continue;
                    }
                    if (!(node instanceof FolderNode)) continue;
                    outputStreamWriter.write(((FolderNode)node).toXML(0));
                }
            }
            outputStreamWriter.write("</displays>");
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)Messages.getString("ReportNavigatorContextMenu.73"), (String)Messages.getString("ReportNavigatorContextMenu.74"), (String)"f1_exportbadfile_html");
        }
    }

    private void exportNode(Node node) {
        int n;
        String string;
        String string2;
        URLFileChooser uRLFileChooser = new URLFileChooser();
        JFileChooserFilter jFileChooserFilter = new JFileChooserFilter("XML", ".xml");
        uRLFileChooser.setFileFilter((FileFilter)jFileChooserFilter);
        if (_lastUrl == null) {
            string2 = DBConfig.getInstance().getString("EXPORTDIR") + File.separator;
            if (string2 == null || string2.equals("")) {
                string2 = System.getProperty("user.home");
            }
            File file = new File(string2 + "report_export.xml");
            uRLFileChooser.setSelectedFile(file);
        } else {
            uRLFileChooser.setSelectedFile(_lastUrl);
        }
        if (uRLFileChooser.showSaveDialog(null) == 0 && (_lastUrl = (string = (string2 = uRLFileChooser.getSelectedFile().toString()).substring(n = string2.lastIndexOf(File.separator))).lastIndexOf(".") > -1 ? uRLFileChooser.getSelectedFile() : new File(uRLFileChooser.getSelectedFile().toString() + ".xml")) != null) {
            this.exportNode(node, _lastUrl);
        }
    }

    public boolean update(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == 20) {
            ideAction.setEnabled(false);
            return true;
        }
        if (ideAction.getCommandId() == 82) {
            ideAction.setEnabled(false);
            return true;
        }
        if (ideAction.getCommandId() == 77) {
            ideAction.setEnabled(false);
            return true;
        }
        return false;
    }

    public void openReport(DisplayModel displayModel, boolean bl, String string) {
        try {
            URL uRL = new URL(RootNode.getInstance().getURL() + "/" + displayModel.getName());
            ReportNode reportNode = new ReportNode(uRL, displayModel);
            this.openReport(reportNode, bl, string);
        }
        catch (MalformedURLException malformedURLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, malformedURLException.getStackTrace()[0].toString(), malformedURLException);
        }
    }

    public synchronized void openReport(Context context, boolean bl) {
        this.openReport((ReportNode)context.getNode(), bl, null);
    }

    public void openReport(ReportNode reportNode, boolean bl, String string) {
        ReportEditorNode reportEditorNode2;
        List list;
        boolean bl2 = true;
        DisplayModel displayModel = reportNode.getReport();
        Map map = displayModel.getExtAttributes();
        if (map == null || map.get("connType") == null || !((String)map.get("connType")).equals("Oracle")) {
            bl2 = false;
        }
        ReportEditor reportEditor = null;
        if (!bl && EditorManager.getEditorManager().getAllEditors().size() > 0) {
            list = EditorManager.getEditorManager().getAllEditors();
            for (ReportEditorNode reportEditorNode2 : list) {
                if (!(reportEditorNode2 instanceof ReportEditor) || ((ReportEditor)((Object)reportEditorNode2)).getPinned()) continue;
                reportEditor = (ReportEditor)((Object)reportEditorNode2);
            }
        }
        list = null;
        Object object = null;
        if (reportEditor != null) {
            object = reportEditor.getConnectionName();
            reportEditor.getTimer().setSelectedItem("0");
            reportEditorNode2 = (ReportEditorNode)reportEditor.getContext().getNode();
            if (string != null && !Connections.getInstance().isOracle(string) && bl2) {
                ReportAddin.showOracleOnlyReportMessage(reportEditor.getGUI());
                return;
            }
            if (object != null && !Connections.getInstance().isOracle((String)object) && bl2) {
                ReportAddin.showOracleOnlyReportMessage(reportEditor.getGUI());
                return;
            }
            reportEditorNode2.setReportNode(reportNode);
            reportEditorNode2.setViewedObject();
            list = Context.newIdeContext((Node)reportEditorNode2);
        } else {
            object = string;
            reportEditorNode2 = new ReportEditorNode();
            reportEditorNode2.setReportNode(reportNode);
            list = Context.newIdeContext((Node)reportEditorNode2);
        }
        if (object == null) {
            object = ConnectionSelectorUI.getConnection((String)ConnectionArb.getString((String)"SQL_VIEWER_CONNECTION_CHOICE_TITLE"), (String)ConnectionArb.getString((String)"SQL_VIEWER_CONNECTION_CHOICE_LABEL"), null, (boolean)bl2, (boolean)false);
        }
        if (object != null) {
            list.setProperty("report.conn.name", object);
            if (map != null && map.get("requiredLic") != null && ((String)map.get("requiredLic")).equals("diagnostics") && !LicenseUtils.requiresDiag((String)object)) {
                return;
            }
            this.runOpenReportTask((Context)list, (String)object, reportEditor);
        }
    }

    private void runOpenReportTask(final Context context, final String string, final ReportEditor reportEditor) {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(Messages.getString("ReportNavigatorContextMenu.ConnectionOpener"), true, IRaptorTaskRunMode.MODAL){

            protected Void doWork() throws TaskException {
                Connection connection = null;
                try {
                    connection = Connections.getInstance().getConnection(string);
                }
                catch (DBException dBException) {
                    ExceptionHandler.handleException((Throwable)dBException.getCause());
                }
                if (connection != null) {
                    ReportOpener reportOpener = new ReportOpener(Messages.getString("ReportEditor.3"), context, string, reportEditor);
                    RaptorTaskManager.getInstance().addTask((RaptorTask)reportOpener);
                }
                return null;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    public static synchronized ReportNavigatorContextMenu getInstance() {
        if (_instance == null) {
            _instance = new ReportNavigatorContextMenu();
        }
        return _instance;
    }

    public void deleteFolder(Context context) {
        this._ctx = context;
        this._node = context.getNode();
        String string = null;
        int n = ((DefaultContainer)this._node).size();
        String string2 = ((FolderNode)this._node).getFolder().getName();
        string = n > 0 ? ReportArb.format("DELETE_FOLDER_CONTENTS_CONFIRM", string2) : ReportArb.format("DELETE_FOLDER_CONFIRM", string2);
        boolean bl = MessageDialog.confirm(null, (Object)string, (String)ReportArb.getString("DELETE_FOLDER_TITLE"), null);
        if (bl) {
            this.closeEditors(this._node);
            try {
                Command command = CommandProcessor.createCommand((String)"oracle.ide.cmd.DeleteTNodeCommand", (Context)this._ctx);
                CommandProcessor.getInstance().invoke(command);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    public void closeEditors(Node node) {
        if (node instanceof ReportNode) {
            try {
                node.close();
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
            List list = EditorManager.getEditorManager().getAllEditors();
            for (int i = 0; i < list.size(); ++i) {
                if (!(list.get(i) instanceof ReportEditor) || ((ReportEditor)((Object)list.get(i))).getPanel().getModel() != ((ReportNode)node).getReport()) continue;
                ((ReportEditor)((Object)list.get(i))).close();
            }
        } else {
            Iterator iterator = node.getChildren();
            while (iterator.hasNext()) {
                Node node2 = (Node)iterator.next();
                try {
                    node2.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                }
                this.closeEditors(node2);
            }
        }
    }

    public void deleteReport(Context context) {
        this._ctx = context;
        this._node = context.getNode();
        String string = ((ReportNode)this._node).getReport().getName();
        String string2 = ReportArb.format("DELETE_REPORT_CONFIRM", string);
        boolean bl = MessageDialog.confirm(null, (Object)string2, (String)ReportArb.getString("DELETE_REPORT_TITLE"), null);
        if (bl) {
            this.closeEditors(this._node);
            try {
                Command command = CommandProcessor.createCommand((String)"oracle.ide.cmd.DeleteTNodeCommand", (Context)this._ctx);
                CommandProcessor.getInstance().invoke(command);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    public void htmlDialog(ReportNode reportNode) {
        ReportHtmlDialog reportHtmlDialog = new ReportHtmlDialog(reportNode);
        reportHtmlDialog.runDialog();
    }

    public void reportDialog(DefaultContainer defaultContainer, DefaultContainer defaultContainer2) {
        this.reportDialog(defaultContainer, defaultContainer2, "");
    }

    public boolean reportDialog(DefaultContainer defaultContainer, DefaultContainer defaultContainer2, String string) {
        ReportDialog reportDialog = new ReportDialog(defaultContainer, defaultContainer2, string, this.oldName);
        return reportDialog.runDialog();
    }

    public boolean folderDialog(FolderNode folderNode, FolderNode folderNode2) {
        ReportFolderDialog reportFolderDialog = new ReportFolderDialog(folderNode, folderNode2, this.oldName);
        return reportFolderDialog.runDialog();
    }

    static {
        ADD_FOLDER_CMD_ID = Ide.findOrCreateCmdID((String)"sqlreport.addFolder");
        ADD_REPORT_CMD_ID = Ide.findOrCreateCmdID((String)"sqlreport.addReport");
        EDIT_CMD_ID = Ide.findOrCreateCmdID((String)"sqlreport.edit");
        OPEN_CMD_ID = Ide.findOrCreateCmdID((String)"sqlreport.open");
        OPEN_NEW_CMD_ID = Ide.findOrCreateCmdID((String)"sqlreport.opennew");
        HTML_CMD_ID = Ide.findOrCreateCmdID((String)"sqlreport.html");
        CUT_CMD_ID = Ide.findOrCreateCmdID((String)"sqlreport.cut");
        COPY_CMD_ID = Ide.findOrCreateCmdID((String)"sqlreport.copy");
        PASTE_CMD_ID = Ide.findOrCreateCmdID((String)"sqlreport.paste");
        DELETE_CMD_ID = Ide.findOrCreateCmdID((String)"sqlreport.delete");
        EXPORT_CMD_ID = Ide.findOrCreateCmdID((String)"sqlreport.export");
        IMPORT_CMD_ID = Ide.findOrCreateCmdID((String)"sqlreport.import");
    }

    private class ReportOpener
    extends DeferUIOperationTask {
        Context _context;
        String _connName;
        ReportEditor _re;

        public ReportOpener(String string, Context context, String string2, ReportEditor reportEditor) {
            super(string);
            this._context = null;
            this._connName = null;
            this._re = null;
            this._context = context;
            this._connName = string2;
            this._re = reportEditor;
        }

        public String getConnectionName() {
            return this._connName;
        }

        protected void invokeLater() {
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(this._context);
            openEditorOptions.setFlags(1);
            if (this._re != null) {
                this._re.setConnectionName(this._connName);
            }
            this._re = (ReportEditor)EditorManager.getEditorManager().openEditor(openEditorOptions);
            this._re.getDefaultFocusComponent().requestFocusInWindow();
            this._re.updateContent();
            this._re.toString();
        }
    }
}

