/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.navigatorV2;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.report.Messages;
import oracle.dbtools.raptor.report.navigatorV2.Folder;
import oracle.dbtools.raptor.report.navigatorV2.FolderNode;
import oracle.dbtools.raptor.report.navigatorV2.ReportNode;
import oracle.dbtools.raptor.support.MetaXMLReference;
import oracle.dbtools.raptor.utils.XLIFFHelper;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.ide.log.LogManager;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ReportXMLUtil {
    private static final Logger LOGGER = Logger.getLogger(ReportXMLUtil.class.getName());
    private static ArrayList<URL> _urls = new ArrayList();
    Boolean _import = false;
    private DOMParser _parser;

    private void processNode(DefaultContainer defaultContainer, MetaXMLReference metaXMLReference, boolean bl, XLIFFHelper xLIFFHelper) {
        NodeList nodeList = metaXMLReference.getNode().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String string = node.getNodeName();
            MetaXMLReference metaXMLReference2 = MetaXMLReference.createXMLReference((MetaXMLReference)metaXMLReference, (Node)node);
            if (string.equalsIgnoreCase("folder")) {
                this.processFolder(defaultContainer, metaXMLReference2, bl, xLIFFHelper);
                continue;
            }
            if (string.equalsIgnoreCase("report")) {
                this.processReport(defaultContainer, metaXMLReference2, bl);
                continue;
            }
            if (string.equalsIgnoreCase("reports")) {
                this.processNode(defaultContainer, metaXMLReference2, bl, xLIFFHelper);
                continue;
            }
            if (!string.equalsIgnoreCase("displays")) continue;
            this.processNodeV2(defaultContainer, metaXMLReference2, bl, xLIFFHelper);
        }
    }

    private DOMParser getParser() {
        if (this._parser == null) {
            this._parser = new DOMParser();
        } else {
            this._parser.reset();
        }
        return this._parser;
    }

    public void parseXML(DefaultContainer defaultContainer, InputStreamReader inputStreamReader, boolean bl, String string, ClassLoader classLoader) {
        this.parseXML(defaultContainer, inputStreamReader, bl, string, new XLIFFHelper(classLoader, null), classLoader);
    }

    public void parseXML(DefaultContainer defaultContainer, InputStreamReader inputStreamReader, boolean bl, String string, XLIFFHelper xLIFFHelper, ClassLoader classLoader) {
        DOMParser dOMParser = this.getParser();
        dOMParser.setPreserveWhitespace(false);
        try {
            dOMParser.parse((Reader)inputStreamReader);
        }
        catch (SAXException sAXException) {
            if (string != null) {
                LOGGER.log(Level.SEVERE, string);
            }
            LOGGER.log(Level.WARNING, sAXException.getStackTrace()[0].toString(), sAXException);
        }
        catch (IOException iOException) {
            if (string != null) {
                LOGGER.log(Level.SEVERE, string);
            }
            LOGGER.log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        XMLDocument xMLDocument = dOMParser.getDocument();
        this.processNode(defaultContainer, MetaXMLReference.createXMLReference((Node)xMLDocument, (ClassLoader)classLoader), bl, xLIFFHelper);
    }

    public void parseXML(DefaultContainer defaultContainer, InputStreamReader inputStreamReader, boolean bl, ClassLoader classLoader) {
        this.parseXML(defaultContainer, inputStreamReader, bl, null, classLoader);
    }

    private DefaultContainer findOrCreateFolders(DefaultContainer defaultContainer, String string, boolean bl, ClassLoader classLoader) {
        URL uRL;
        String[] stringArray = string.split("/");
        String string2 = defaultContainer.getURL().toString();
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = string2 + "/" + stringArray[i];
            try {
                uRL = new URL(string2);
                for (URL object2 : _urls) {
                    if (!object2.equals(uRL)) continue;
                    uRL = object2;
                }
                if (!_urls.contains(uRL)) {
                    _urls.add(uRL);
                }
                arrayList.add(uRL);
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                LOGGER.log(Level.WARNING, malformedURLException.getStackTrace()[0].toString(), malformedURLException);
            }
        }
        Object object = defaultContainer;
        uRL = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            try {
                uRL = (DefaultContainer)NodeFactory.findOrCreate(FolderNode.class, (URL)((URL)arrayList.get(i)));
                if (uRL instanceof FolderNode && ((FolderNode)((Object)uRL)).getFolder() == null) {
                    String instantiationException = ((URL)arrayList.get(i)).toString().substring(((URL)arrayList.get(i)).toString().lastIndexOf("/") + 1);
                    ((FolderNode)((Object)uRL)).setFolder(new Folder(instantiationException, ""));
                    ((FolderNode)((Object)uRL)).setTemp(true);
                    ((FolderNode)((Object)uRL)).setEditable(bl);
                }
                if (!object.containsChild((Element)uRL)) {
                    object.add((Element)uRL);
                }
                object.markDirty(false);
                object = uRL;
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.log(Level.WARNING, illegalAccessException.getStackTrace()[0].toString(), illegalAccessException);
                continue;
            }
            catch (InstantiationException instantiationException) {
                LOGGER.log(Level.WARNING, instantiationException.getStackTrace()[0].toString(), instantiationException);
            }
        }
        return object;
    }

    private void processNodeV2(DefaultContainer defaultContainer, MetaXMLReference metaXMLReference, boolean bl, XLIFFHelper xLIFFHelper) {
        NodeList nodeList = metaXMLReference.getNode().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String string = node.getNodeName();
            MetaXMLReference metaXMLReference2 = MetaXMLReference.createXMLReference((MetaXMLReference)metaXMLReference, (Node)node);
            if (string.equalsIgnoreCase("folder")) {
                try {
                    this.processFolderV2(defaultContainer, metaXMLReference2, bl, xLIFFHelper);
                }
                catch (MalformedURLException malformedURLException) {
                    LOGGER.log(Level.WARNING, malformedURLException.getStackTrace()[0].toString(), malformedURLException);
                }
                continue;
            }
            if (!string.equalsIgnoreCase("display")) continue;
            try {
                this.processReportV2(defaultContainer, metaXMLReference2, bl, xLIFFHelper);
                continue;
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    private void processFolder(DefaultContainer defaultContainer, MetaXMLReference metaXMLReference, boolean bl, XLIFFHelper xLIFFHelper) {
        Object object;
        Node node = metaXMLReference.getNode();
        String string = XMLHelper.getNodeValue((Node)node, (String)"name");
        FolderNode folderNode = (FolderNode)this.findOrCreateFolders(defaultContainer, string, bl, metaXMLReference.getReferenceClassLoader());
        if (folderNode.isTemp()) {
            object = new Folder(node, xLIFFHelper);
            folderNode.setFolder((Folder)object);
            folderNode.setTemp(false);
            if (folderNode.getURL().toString().indexOf(Messages.getString("RootNode.2")) > 0) {
                folderNode.setEditable(true);
            } else {
                folderNode.setEditable(false);
            }
        } else if (this._import.booleanValue()) {
            LogManager.getIdeLogWindow().log((Object)MessageFormat.format(Messages.getString("ReportXMLUtil.3"), folderNode.getShortLabel()));
        }
        object = node.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            Node node2 = object.item(i);
            String string2 = node2.getNodeName();
            MetaXMLReference metaXMLReference2 = MetaXMLReference.createXMLReference((MetaXMLReference)metaXMLReference, (Node)node2);
            if (string2.equalsIgnoreCase("folder")) {
                this.processFolder(folderNode, metaXMLReference2, bl, xLIFFHelper);
                continue;
            }
            if (string2.equalsIgnoreCase("report")) {
                this.processReport(folderNode, metaXMLReference2, bl);
                continue;
            }
            if (!string2.equalsIgnoreCase("description") && string2.equalsIgnoreCase("name")) continue;
        }
    }

    private void processFolderV2(DefaultContainer defaultContainer, MetaXMLReference metaXMLReference, boolean bl, XLIFFHelper xLIFFHelper) throws MalformedURLException {
        Object object;
        Node node = metaXMLReference.getNode();
        String string = XMLHelper.getNodeValue((Node)node, (String)"name");
        FolderNode folderNode = (FolderNode)this.findOrCreateFolders(defaultContainer, string, bl, metaXMLReference.getReferenceClassLoader());
        if (folderNode.getFolder().getName().equals("Unit Test Runs")) {
            folderNode.removeAll();
        }
        if (folderNode.isTemp()) {
            object = new Folder(node, xLIFFHelper);
            folderNode.setFolder((Folder)object);
            folderNode.setTemp(false);
            if (folderNode.getURL().toString().indexOf(Messages.getString("RootNode.2")) > 0) {
                folderNode.setEditable(true);
            } else {
                folderNode.setEditable(false);
            }
        } else if (this._import.booleanValue()) {
            LogManager.getIdeLogWindow().log((Object)MessageFormat.format(Messages.getString("ReportXMLUtil.4"), folderNode.getShortLabel()));
        }
        object = node.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            Node node2 = object.item(i);
            String string2 = node2.getNodeName();
            MetaXMLReference metaXMLReference2 = MetaXMLReference.createXMLReference((MetaXMLReference)metaXMLReference, (Node)node2);
            if (string2.equalsIgnoreCase("folder")) {
                this.processFolderV2(folderNode, metaXMLReference2, bl, xLIFFHelper);
                continue;
            }
            if (string2.equalsIgnoreCase("display")) {
                this.processReportV2(folderNode, metaXMLReference2, bl, xLIFFHelper);
                continue;
            }
            if (!string2.equalsIgnoreCase("description") && string2.equalsIgnoreCase("name")) continue;
        }
    }

    private void processReportV2(DefaultContainer defaultContainer, MetaXMLReference metaXMLReference, boolean bl, XLIFFHelper xLIFFHelper) {
        Object object;
        DisplayModel displayModel = DisplayModel.getDisplayModel((MetaXMLReference)metaXMLReference, (XLIFFHelper)xLIFFHelper, null);
        URL uRL = URLFactory.newURL((URL)defaultContainer.getURL(), (String)displayModel.getName());
        displayModel.setPath(uRL.getPath());
        Iterator iterator = defaultContainer.getChildren();
        while (iterator.hasNext()) {
            DefaultContainer defaultContainer2;
            object = iterator.next();
            URL uRL2 = null;
            if (object instanceof ReportNode) {
                defaultContainer2 = (ReportNode)object;
                uRL2 = defaultContainer2.getURL();
                if (!uRL2.getPath().equals(uRL.getPath()) || !this._import.booleanValue()) continue;
                LogManager.getIdeLogWindow().log((Object)MessageFormat.format(Messages.getString("ReportXMLUtil.0"), defaultContainer2.getShortLabel()));
                return;
            }
            defaultContainer2 = (FolderNode)object;
            uRL2 = defaultContainer2.getURL();
            if (!uRL2.getPath().equals(uRL.getPath()) || !this._import.booleanValue()) continue;
            LogManager.getIdeLogWindow().log((Object)MessageFormat.format(Messages.getString("ReportXMLUtil.1"), defaultContainer2.getShortLabel()));
            return;
        }
        object = new ReportNode(uRL, displayModel);
        ((ReportNode)object).setEditable(bl);
        defaultContainer.add((Element)object);
        defaultContainer.markDirty(false);
    }

    private void processReport(DefaultContainer defaultContainer, MetaXMLReference metaXMLReference, boolean bl) {
        ReportNode reportNode;
        DisplayModel displayModel = DisplayModel.getDisplayModel((MetaXMLReference)metaXMLReference, null, null);
        URL uRL = URLFactory.newURL((URL)defaultContainer.getURL(), (String)displayModel.getName());
        Iterator iterator = defaultContainer.getChildren();
        while (iterator.hasNext()) {
            reportNode = (ReportNode)iterator.next();
            URL uRL2 = reportNode.getURL();
            if (!uRL2.getPath().equals(uRL.getPath()) || !this._import.booleanValue()) continue;
            LogManager.getIdeLogWindow().log((Object)MessageFormat.format(Messages.getString("ReportXMLUtil.2"), reportNode.getShortLabel()));
            return;
        }
        reportNode = new ReportNode(uRL, displayModel);
        reportNode.setEditable(bl);
        defaultContainer.add((Element)reportNode);
        defaultContainer.markDirty(false);
    }

    public void setImport(Boolean bl) {
        this._import = bl;
    }
}

