/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.navigatorV2;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayModelCache;
import oracle.dbtools.raptor.report.Messages;
import oracle.dbtools.raptor.report.addin.ReportAddin;
import oracle.dbtools.raptor.report.navigatorV2.Folder;
import oracle.dbtools.raptor.report.navigatorV2.FolderNode;
import oracle.dbtools.raptor.report.navigatorV2.ReportNavigatorContextMenu;
import oracle.dbtools.raptor.report.navigatorV2.ReportXMLUtil;
import oracle.dbtools.raptor.support.MetaPackageReference;
import oracle.dbtools.raptor.support.MetaURLReference;
import oracle.dbtools.raptor.utils.XLIFFHelper;
import oracle.ide.model.Attributes;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;

public class RootNode
extends DefaultContainer {
    private static RootNode INSTANCE;
    private static Logger LOGGER;
    private FolderNode _userReports;
    private FolderNode _sharedReports;
    ReportXMLUtil xmlUtil = new ReportXMLUtil();
    private Attributes m_attributes = new ElementAttributes();
    XLIFFHelper xliff;
    public static final String ROOTNODE_NAME;
    public static final String USER_DEFINED_REPORTS_NODE_NAME;
    public static final String SHARED_REPORTS_NODE_NAME;
    private boolean _init = false;

    public static synchronized RootNode getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RootNode();
        }
        return INSTANCE;
    }

    private RootNode() {
        this.setURL(URLFactory.newURL((String)"sqldev.reports", (String)ROOTNODE_NAME));
    }

    public FolderNode getUserDefined() {
        try {
            this.open();
        }
        catch (IOException iOException) {
            LOGGER.severe(iOException.getLocalizedMessage());
        }
        return this._userReports;
    }

    public FolderNode getSharedDefined() {
        try {
            this.open();
        }
        catch (IOException iOException) {
            LOGGER.severe(iOException.getLocalizedMessage());
        }
        return this._sharedReports;
    }

    public String getShortLabel() {
        return ROOTNODE_NAME;
    }

    public Icon getIcon() {
        return ReportAddin.rootIcon;
    }

    protected void openImpl() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                RootNode.this.initialize();
            }
        };
        Thread thread = new Thread(runnable);
        thread.setName("Report Tree Opener");
        thread.start();
    }

    public void open(String string) {
        this.initialize();
        Map map = null;
        DisplayModel displayModel = DisplayModelCache.getDisplayModel((String)string);
        displayModel.setQueriesBindMap(map);
        ReportNavigatorContextMenu.getInstance().openReport(displayModel, true, (String)null);
    }

    public void initialize() {
        if (!this._init) {
            Object object;
            InputStream inputStream;
            Object object3 = new Folder(Messages.getString("RootNode.5"), Messages.getString("RootNode.6"));
            List<MetaPackageReference> list = URLFactory.newURL((URL)this.getURL(), (String)"Data Dictionary Reports");
            Iterator<MetaPackageReference> iterator = new FolderNode((URL)((Object)list), (Folder)object3);
            ((FolderNode)((Object)iterator)).setEditable(false);
            this._children.add(iterator);
            object3 = new Folder(USER_DEFINED_REPORTS_NODE_NAME, USER_DEFINED_REPORTS_NODE_NAME);
            list = URLFactory.newURL((URL)this.getURL(), (String)USER_DEFINED_REPORTS_NODE_NAME);
            this._userReports = new FolderNode((URL)((Object)list), (Folder)object3);
            this._children.add(this._userReports);
            object3 = this;
            try {
                this.addPackage(MetaPackageReference.createPackageReference((String)"oracle.dbtools.raptor.report.reports", (ClassLoader)RootNode.class.getClassLoader()));
            }
            catch (Exception exception) {
                LOGGER.severe(Messages.getString("RootNode.10") + exception.getMessage() + "\n*****");
            }
            try {
                list = new File(ReportAddin.USER_REPORT_FILE);
                iterator = "UTF-8";
                FileInputStream object22 = new FileInputStream((File)((Object)list));
                inputStream = new BufferedInputStream(object22);
                object = new InputStreamReader(inputStream, (String)((Object)iterator));
                this.xmlUtil.parseXML(this._userReports, (InputStreamReader)object, true, RootNode.class.getClassLoader());
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (Exception exception) {
                LOGGER.severe(Messages.getString("RootNode.14") + USER_DEFINED_REPORTS_NODE_NAME);
            }
            try {
                list = ReportAddin.getRegisterReport();
                if (list.size() > 0) {
                    iterator = new Folder(SHARED_REPORTS_NODE_NAME, SHARED_REPORTS_NODE_NAME);
                    URL uRL = new URL(this.getURL().toString() + "/" + SHARED_REPORTS_NODE_NAME);
                    this._sharedReports = new FolderNode(uRL, (Folder)((Object)iterator));
                    this._sharedReports.setEditable(false);
                    this.add((Element)this._sharedReports);
                    UpdateMessage.fireChildAdded((Subject)object3, (Element)this._sharedReports);
                }
                for (MetaURLReference metaURLReference : list) {
                    try {
                        inputStream = metaURLReference.openInputStream();
                        object = "UTF-8";
                        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, (String)object);
                        this.xmlUtil.parseXML(this._sharedReports, inputStreamReader, false, metaURLReference.getReferenceClassLoader());
                    }
                    catch (Exception exception) {
                        object = metaURLReference.getURL();
                        if (((URL)object).toURI().toString().indexOf("www.oracle.com") == -1) {
                            LOGGER.severe(Messages.getString("RootNode.17") + ((URL)object).toString());
                            continue;
                        }
                        LOGGER.info(Messages.getString("RootNode.17") + ((URL)object).toString());
                    }
                }
            }
            catch (Exception exception) {
                System.err.println(Messages.getString("RootNode.18") + SHARED_REPORTS_NODE_NAME);
            }
            list = Collections.unmodifiableList(ReportAddin.getRegisterReportPackages());
            for (MetaPackageReference metaPackageReference : list) {
                try {
                    this.addPackage(metaPackageReference);
                    UpdateMessage.fireStructureChanged((Subject)object3);
                }
                catch (Exception exception) {
                    LOGGER.severe(Messages.getString("RootNode.19") + metaPackageReference.getPackage());
                }
            }
            UpdateMessage.fireStructureChanged((Subject)object3);
            this.markDirty(false);
            this._init = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPackage(MetaPackageReference metaPackageReference) throws Exception {
        List list = metaPackageReference.getURLReferences(".xml");
        for (MetaURLReference metaURLReference : list) {
            InputStreamReader inputStreamReader = null;
            try {
                InputStream inputStream = metaURLReference.openInputStream();
                ClassLoader classLoader = metaPackageReference.getReferenceClassLoader();
                String string = "UTF-8";
                inputStreamReader = new InputStreamReader(inputStream, string);
                String string2 = null;
                String string3 = metaURLReference.getURL().toExternalForm();
                string2 = string3.contains(".jar!") ? string3.substring(string3.lastIndexOf(".jar!") + 5) : string3.substring(string3.lastIndexOf("classes") + 7);
                XLIFFHelper xLIFFHelper = new XLIFFHelper(classLoader, string2);
                this.xmlUtil.parseXML(this, inputStreamReader, false, metaPackageReference.getPackage(), xLIFFHelper, classLoader);
            }
            catch (Exception exception) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                if (inputStreamReader == null) continue;
                try {
                    inputStreamReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public Attributes getAttributes() {
        return this.m_attributes;
    }

    static {
        LOGGER = Logger.getLogger(RootNode.class.getName());
        ROOTNODE_NAME = Messages.getString("RootNode.1");
        USER_DEFINED_REPORTS_NODE_NAME = Messages.getString("RootNode.2");
        SHARED_REPORTS_NODE_NAME = Messages.getString("RootNode.3");
    }
}

