/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.pdf;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.export.pdf.PDFConfig;
import oracle.dbtools.raptor.format.PDFFormatOptions;
import oracle.dbtools.raptor.report.pdf.IPDFOptions;
import oracle.dbtools.raptor.report.pdf.PDFArb;
import oracle.dbtools.raptor.report.pdf.PDFConstants;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.controls.URLPathField;
import oracle.ide.net.URLPath;
import oracle.ide.util.ResourceUtils;

public class PDFDocumentPropertiesPanel
implements IPDFOptions {
    private static final long serialVersionUID = 1L;
    private PDFFormatOptions _pdfFormat = null;
    private JTextField _author = null;
    private JTextField _keywords = null;
    private JTextField _subject = null;
    private JTextField _title = null;
    private JComboBox _version = null;
    private JComboBox _compression = null;
    private URLPathField _fontPath = null;
    private JButton _btnFontPath = null;
    private JCheckBox _embedFonts = null;
    private JTextField _fileName = null;
    private JButton _browseBtn = null;
    private Component _parent = null;
    private int _row = 0;
    private boolean _isPDFPref = false;

    public PDFDocumentPropertiesPanel() {
        this.init();
    }

    private void init() {
        this._author = new JTextField();
        this._keywords = new JTextField();
        this._subject = new JTextField();
        this._title = new JTextField();
        this._version = new JComboBox<String>(PDFConstants.PDF_COMPATIBILITY_LIST);
        this._compression = new JComboBox<String>(PDFConstants.COMPRESSION_LEVEL_LIST);
        this._embedFonts = new JCheckBox();
    }

    private void showFileDialog() {
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.setSelectionScope(0);
        String string = System.getProperty("user.home") + File.separator;
        uRLFileChooser.setCurrentDirectory(new File(string));
        if (uRLFileChooser.showOpenDialog(this._parent, PDFArb.getString("EXTERNAL_LIBRARY_TITLE")) == 0) {
            this._fileName.setText(uRLFileChooser.getSelectedFile().toString());
        }
    }

    @Override
    public JPanel getPanel() {
        JComponent jComponent;
        if (this._pdfFormat == null) {
            this.assignPDFFormatValues(new PDFConfig().getPDFPreferences());
            this._isPDFPref = true;
        }
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        JLabel jLabel6 = new JLabel();
        JLabel jLabel7 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel4, (Component)this._title, (String)PDFArb.getString("TITLE"));
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._author, (String)PDFArb.getString("AUTHOR"));
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this._subject, (String)PDFArb.getString("SUBJECT"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._keywords, (String)PDFArb.getString("KEYWORDS"));
        ResourceUtils.resLabel((JLabel)jLabel5, (Component)this._version, (String)PDFArb.getString("VERSION_SUPPORT"));
        ResourceUtils.resLabel((JLabel)jLabel6, (Component)this._compression, (String)PDFArb.getString("COMPRESSION"));
        ResourceUtils.resButton((AbstractButton)this._embedFonts, (String)PDFArb.getString("EMBED_FONTS"));
        ResourceUtils.resLabel((JLabel)jLabel7, (Component)this._fileName, (String)PDFArb.getString("EXTERNAL_LIBRARY"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel4, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 8, 0, 8), 0, 0));
        jPanel.add((Component)this._title, new GridBagConstraints(1, this._row, 1, 1, 0.5, 0.0, 23, 2, new Insets(6, 0, 0, 8), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 8, 0, 8), 0, 0));
        jPanel.add((Component)this._author, new GridBagConstraints(1, this._row, 1, 1, 0.5, 0.0, 23, 2, new Insets(8, 0, 0, 8), 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 8, 0, 8), 0, 0));
        jPanel.add((Component)this._subject, new GridBagConstraints(1, this._row, 1, 1, 0.5, 0.0, 23, 2, new Insets(8, 0, 0, 8), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 8, 6, 8), 0, 0));
        jPanel.add((Component)this._keywords, new GridBagConstraints(1, this._row, 1, 1, 0.5, 0.0, 23, 2, new Insets(8, 0, 6, 8), 0, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel, (String)PDFArb.getString("DESCRIPTION"));
        this._row = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jLabel5, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 8, 0, 8), 0, 0));
        jPanel2.add((Component)this._version, new GridBagConstraints(1, this._row, 2, 1, 0.0, 0.0, 23, 0, new Insets(6, 0, 0, 0), 0, 0));
        jPanel2.add((Component)jLabel6, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 8, 0, 8), 0, 0));
        jPanel2.add((Component)this._compression, new GridBagConstraints(1, this._row, 2, 1, 0.0, 0.0, 23, 0, new Insets(8, 0, 8, 0), 0, 0));
        jPanel2.add(Box.createGlue(), new GridBagConstraints(2, this._row, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel2, (String)PDFArb.getString("DOCUMENT"));
        this._row = 0;
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)this._embedFonts, new GridBagConstraints(0, ++this._row, 2, 1, 0.0, 0.0, 23, 0, new Insets(3, 8, 0, 8), 0, 0));
        jPanel3.add(Box.createGlue(), new GridBagConstraints(1, this._row, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        if (this._isPDFPref) {
            jComponent = new JLabel();
            String string = PDFArb.getString("FONT_LOCATION");
            String string2 = PDFArb.getString("EDIT_BUTTON");
            ResourceUtils.resLabel((JLabel)jComponent, (Component)this._fontPath, (String)(string != null ? string : ""));
            ResourceUtils.resButton((AbstractButton)this._btnFontPath, (String)(string2 != null ? string2 : ""));
            jPanel3.add((Component)jComponent, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 8, 0, 8), 0, 0));
            jPanel3.add((Component)this._fontPath, new GridBagConstraints(1, this._row, 1, 1, 1.0, 0.0, 23, 2, new Insets(8, 0, 0, 8), 0, 0));
            jPanel3.add((Component)this._btnFontPath, new GridBagConstraints(2, this._row, 1, 1, 0.0, 0.0, 23, 0, new Insets(8, 2, 0, 8), 0, 0));
            jPanel3.add((Component)jLabel7, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 8, 6, 8), 0, 0));
            jPanel3.add((Component)this._fileName, new GridBagConstraints(1, this._row, 1, 1, 1.0, 0.0, 23, 2, new Insets(8, 0, 6, 8), 0, 0));
            jPanel3.add((Component)this._browseBtn, new GridBagConstraints(2, this._row, 1, 1, 0.0, 0.0, 23, 0, new Insets(8, 2, 6, 8), 0, 0));
        }
        UIUtils.makeTitledBorder((JComponent)jPanel3, (String)PDFArb.getString("FONT_TITLE"));
        this._row = 0;
        jComponent = new JPanel(new GridBagLayout());
        jComponent.add((Component)jPanel, new GridBagConstraints(0, this._row, 2, 1, 0.0, 0.0, 23, 2, new Insets(3, 0, 0, 0), 0, 0));
        jComponent.add((Component)jPanel2, new GridBagConstraints(0, ++this._row, 2, 1, 0.0, 0.0, 23, 2, new Insets(8, 0, 0, 0), 0, 0));
        jComponent.add((Component)jPanel3, new GridBagConstraints(0, ++this._row, 2, 1, 0.0, 0.0, 23, 2, new Insets(8, 0, 0, 0), 0, 0));
        jComponent.add(Box.createGlue(), new GridBagConstraints(0, ++this._row, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jComponent;
    }

    @Override
    public void assignPDFFormatValues(PDFFormatOptions pDFFormatOptions) {
        this._pdfFormat = pDFFormatOptions;
        this._author.setText(this._pdfFormat.getAuthor());
        this._keywords.setText(this._pdfFormat.getKeywords());
        this._subject.setText(this._pdfFormat.getSubject());
        this._title.setText(this._pdfFormat.getTitle());
        this._version.setSelectedIndex(this._pdfFormat.getSupportedVersion().ordinal());
        this._compression.setSelectedIndex(this._pdfFormat.getCompressionLevel().ordinal());
        if (this._isPDFPref) {
            this._fontPath = new URLPathField();
            this._btnFontPath = new JButton();
            this._fontPath.setJarPathsAllowed(false);
            this._fontPath.setButtonAssociation(this._btnFontPath, true);
            this._fontPath.setEditTitle(PDFArb.getString("FONT_LOCATION_TITLE"));
            this._btnFontPath.addActionListener((ActionListener)this._fontPath);
            String string = this._pdfFormat.getFontLocations();
            URLPath uRLPath = URLPath.newURLPathFromString((String)string);
            this._fontPath.setURLPath(uRLPath);
        }
        this._fileName = new JTextField(this._pdfFormat.getExternalLibrary());
        this._browseBtn = new JButton(StringUtils.stripMnemonic((String)Messages.getString((String)"FilePanel.1")));
        this._browseBtn.setMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString((String)"FilePanel.1")));
        this._browseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PDFDocumentPropertiesPanel.this.showFileDialog();
            }
        });
        this._embedFonts.setSelected(this._pdfFormat.isEmbedFonts());
    }

    @Override
    public PDFFormatOptions getPDFFormatOptions() {
        if (this._pdfFormat != null) {
            this._pdfFormat.setAuthor(this._author.getText());
            this._pdfFormat.setKeywords(this._keywords.getText());
            this._pdfFormat.setSubject(this._subject.getText());
            this._pdfFormat.setTitle(this._title.getText());
            PDFFormatOptions.PDF_COMPATIBILITY[] pDF_COMPATIBILITYArray = PDFFormatOptions.PDF_COMPATIBILITY.values();
            this._pdfFormat.setSupportedVersion(pDF_COMPATIBILITYArray[this._version.getSelectedIndex()]);
            PDFFormatOptions.COMPRESSION_LEVEL[] cOMPRESSION_LEVELArray = PDFFormatOptions.COMPRESSION_LEVEL.values();
            this._pdfFormat.setCompressionLevel(cOMPRESSION_LEVELArray[this._compression.getSelectedIndex()]);
            if (this._isPDFPref) {
                try {
                    URLPath uRLPath = this.getFontPath();
                    List list = uRLPath.asList();
                    if (list == null || list.isEmpty()) {
                        this._pdfFormat.setFontLocations(null);
                    } else {
                        StringBuffer stringBuffer = new StringBuffer();
                        for (URL uRL : list) {
                            stringBuffer.append(uRL.getPath()).append(File.pathSeparator);
                        }
                        this._pdfFormat.setFontLocations(stringBuffer.toString());
                    }
                }
                catch (URLPathField.BadEntryException badEntryException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, badEntryException.getStackTrace()[0].toString(), badEntryException);
                }
            }
            this._pdfFormat.setExternalLibrary(this.getExternalLibrary());
            this._pdfFormat.setEmbedFonts(this._embedFonts.isSelected());
        }
        return this._pdfFormat;
    }

    public URLPath getFontPath() throws URLPathField.BadEntryException {
        URLPath uRLPath = null;
        uRLPath = this._fontPath != null ? this._fontPath.getURLPath() : new URLPath();
        return uRLPath;
    }

    public String getExternalLibrary() {
        String string = this._fileName.getText();
        if (this._fileName == null) {
            return null;
        }
        return string.trim();
    }

    public void setUsePDFPreferences(boolean bl, Component component) {
        this._isPDFPref = bl;
        this._parent = component;
    }
}

