/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayPanel;
import oracle.dbtools.raptor.controls.display.IDisplayDetail;
import oracle.dbtools.raptor.format.PDFFormatOptions;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.report.pdf.PDFSecurityPanel;
import oracle.dbtools.raptor.report.ui.AdvancedPanel;
import oracle.dbtools.raptor.report.ui.BindNode;
import oracle.dbtools.raptor.report.ui.BindPanel;
import oracle.dbtools.raptor.report.ui.ChildNode;
import oracle.dbtools.raptor.report.ui.DisplayModelContext;
import oracle.dbtools.raptor.report.ui.DrillDownNode;
import oracle.dbtools.raptor.report.ui.EditMode;
import oracle.dbtools.raptor.report.ui.MasterNode;
import oracle.dbtools.raptor.report.ui.ReportArb;
import oracle.dbtools.raptor.report.ui.ReportCellRenderer;
import oracle.dbtools.raptor.report.ui.ReportNamePanel;
import oracle.dbtools.raptor.report.ui.ReportOptionsPanel;
import oracle.dbtools.raptor.report.ui.ReportSQLPanel;
import oracle.dbtools.raptor.report.ui.ReportTreeNode;
import oracle.dbtools.raptor.report.ui.SQLNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.javatools.db.DBException;

public class ReportTreePanel
extends JPanel
implements TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    private DisplayModel _model;
    private String _path;
    private JTree _reportTree = null;
    private ReportOptionsPanel _reportOptions;
    private boolean initialized = false;
    private MasterNode masterNode;

    public ReportTreePanel() {
        this((String)null);
    }

    public ReportTreePanel(String string) {
        this.init(EditMode.NEW, string);
        this.initialized = true;
    }

    public ReportTreePanel(DisplayModel displayModel) {
        this._model = displayModel;
        this.init(EditMode.EDIT, null);
        this.initialized = true;
    }

    public void setPath(String string) {
        this._path = string;
    }

    void cleanUp() {
        if (this.masterNode != null) {
            this.masterNode.close();
        }
        if (this._reportOptions != null) {
            this._reportOptions.cleanUp();
        }
        this._model = null;
        this._reportTree = null;
        this._reportOptions = null;
    }

    private void init(EditMode editMode, String string) {
        this.masterNode = new MasterNode(this, editMode, this._model);
        this._reportOptions = new ReportOptionsPanel(this.masterNode.context(), new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("DB_NAME")) {
                    String string = ReportTreePanel.this._reportOptions.dbName();
                    ReportTreePanel.this.masterNode.propertyNode().setDbName(string);
                    for (ChildNode childNode : ReportTreePanel.this.masterNode.childReportsNode().childNodes(ChildNode.class)) {
                        childNode.propertyNode().setDbName(string);
                    }
                }
            }
        });
        this._reportOptions.onSelectNode(this.masterNode);
        if (string != null) {
            this.masterNode.panel().setSQL(string);
        }
        JScrollPane jScrollPane = this.createReportTreePane();
        JScrollPane jScrollPane2 = new JScrollPane(this._reportOptions);
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, jScrollPane2);
        jSplitPane.setTopComponent(jScrollPane);
        jSplitPane.setBottomComponent(jScrollPane2);
        jSplitPane.setOneTouchExpandable(false);
        jSplitPane.setDividerSize(3);
        jSplitPane.setDividerLocation(150);
        this.add((Component)jSplitPane, "Center");
        this.repaint();
        this._reportOptions.testButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportTreePanel.this.displayTestReportDialog();
            }
        });
    }

    private JScrollPane createReportTreePane() {
        this._reportTree = this.masterNode.createJTree();
        this.masterNode.populateTree();
        this._reportTree.setCellRenderer(new ReportCellRenderer());
        JScrollPane jScrollPane = new JScrollPane(this._reportTree);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        this._reportTree.setShowsRootHandles(true);
        this._reportTree.setRootVisible(true);
        this._reportTree.getSelectionModel().setSelectionMode(1);
        this._reportTree.setSelectionPath(new TreePath(((DefaultMutableTreeNode)this._reportTree.getModel().getRoot()).getPath()));
        Color color = this._reportTree.getBackground();
        jScrollPane.setBackground(color);
        jScrollPane.getViewport().setBackground(color);
        this._reportTree.addTreeSelectionListener(this);
        this.setLayout(new BorderLayout());
        return jScrollPane;
    }

    public void displayTestReportDialog() {
        DisplayPanel displayPanel = this.createDisplayPanel(null, false, null, false);
        if (displayPanel != null) {
            this.showTest(displayPanel);
        }
    }

    public void showTest(DisplayPanel displayPanel) {
        Dimension dimension = new Dimension(400, 400);
        try {
            JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)displayPanel, null, (String)ReportArb.getString("TEST_REPORT_TITLE"), (int)16);
            jEWTDialog.setMinimumSize(dimension);
            jEWTDialog.setSize(dimension);
            jEWTDialog.setLocation(300, 20);
            WizardLauncher.runDialog((JDialog)jEWTDialog);
        }
        catch (Exception exception) {
            // empty catch block
        }
        displayPanel.close();
    }

    public DisplayPanel createDisplayPanel(Object object, boolean bl, ChildNode childNode, boolean bl2) {
        DisplayPanel displayPanel = null;
        ReportSQLPanel reportSQLPanel = this.masterNode.sqlNode().panel();
        DisplayModel displayModel = this.getModel(bl, childNode);
        if (bl2) {
            displayModel.getExtValues().put("no.refresh.in.toolbar", "true");
            displayModel.getExtValues().put("no.run.in.toolbar", "true");
        }
        String string = this._reportOptions.dbName();
        try {
            Connections.getInstance().getConnection(string);
        }
        catch (DBException dBException) {
            Throwable throwable = dBException.getCause();
            ExceptionHandler.handleException((Throwable)(throwable != null ? throwable : dBException));
        }
        if (string != null && Connections.getInstance().isConnectionOpen(string)) {
            displayModel.setConnName(string);
            displayModel.setCustomValue(object);
            displayPanel = new DisplayPanel(displayModel);
            displayPanel.promptForBindsOnNextRun(true);
            displayPanel.refresh(true);
        }
        return displayPanel;
    }

    public DisplayModel getModel() {
        return this.getModel(false, null);
    }

    public void prepareForSave() {
        this.masterNode.prepareForSave();
    }

    public DisplayModel getModel(boolean bl, ChildNode childNode) {
        DisplayModel displayModel = null;
        if (bl && childNode != null) {
            displayModel = this.buildDisplayModel(childNode);
        } else {
            ReportSQLPanel reportSQLPanel;
            Serializable serializable;
            if (this.masterNode.context().mode() == EditMode.NEW) {
                serializable = this.masterNode.panel();
                String string = ((ReportNamePanel)serializable).getSQL();
                SQLNode reportTreeNode = this.masterNode.sqlNode();
                reportSQLPanel = reportTreeNode.panel();
                reportSQLPanel.setSQL(string);
            }
            displayModel = this.buildDisplayModel(this.masterNode);
            if (!bl) {
                serializable = new ArrayList();
                for (ChildNode childNode2 : this.masterNode.childReportsNode().childNodes(ChildNode.class)) {
                    reportSQLPanel = this.buildDisplayModel(childNode2);
                    ((ArrayList)serializable).add(reportSQLPanel);
                }
                displayModel.setChildren((List)((Object)serializable));
            }
        }
        return displayModel;
    }

    private DisplayModel buildDisplayModel(DisplayModelContext displayModelContext) {
        JPanel jPanel;
        ReportNamePanel reportNamePanel = displayModelContext.panel();
        SQLNode sQLNode = displayModelContext.sqlNode();
        BindNode bindNode = displayModelContext.bindNode();
        BindPanel bindPanel = null;
        if (bindNode != null) {
            bindPanel = bindNode.panel();
        }
        DrillDownNode drillDownNode = displayModelContext.drillDownNode();
        AdvancedPanel advancedPanel = null;
        if (drillDownNode != null) {
            advancedPanel = drillDownNode.panel();
        }
        IDisplayDetail iDisplayDetail = (jPanel = displayModelContext.propertyNode().panel()) instanceof IDisplayDetail ? (IDisplayDetail)jPanel : null;
        PDFFormatOptions pDFFormatOptions = displayModelContext.pdfNode().pdfFormatOptions();
        DisplayModel displayModel = new DisplayModel(reportNamePanel.getName(), reportNamePanel.getDesc(), "true", reportNamePanel.getTip());
        displayModel.setStyle(reportNamePanel.getStyle());
        List<Bind> list = null;
        if (bindPanel != null) {
            list = bindPanel.getBinds();
        }
        List<Query> list2 = sQLNode.createQueries(list);
        if (advancedPanel != null) {
            displayModel.setID(this.getAdvPanel().getId());
            displayModel.setActions(this.getAdvPanel().getActions());
            displayModel.setPath(this._path);
        }
        displayModel.setQueries(list2);
        if (iDisplayDetail != null) {
            displayModel.setExtValues(iDisplayDetail.getValues());
        }
        displayModel.setPDFFormatOptions(pDFFormatOptions);
        return displayModel;
    }

    public AdvancedPanel getAdvPanel() {
        return this.masterNode.drillDownNode().panel();
    }

    public BindPanel getBindPanel() {
        return this.masterNode.bindNode().panel();
    }

    public String validateSecurityPasswords() {
        StringBuffer stringBuffer = new StringBuffer();
        PDFSecurityPanel pDFSecurityPanel = this.masterNode.pdfNode().securityPanel();
        if (pDFSecurityPanel != null && !pDFSecurityPanel.validatePassword()) {
            stringBuffer.append(ReportArb.format("SECURITY_MASTER_REPORT", this.getMasterReportName())).append("\n");
            stringBuffer.append(pDFSecurityPanel.getErrorMessage()).append("\n\n");
        }
        for (ChildNode childNode : this.masterNode.childReportsNode().childNodes(ChildNode.class)) {
            pDFSecurityPanel = childNode.pdfNode().securityPanel();
            if (pDFSecurityPanel == null || pDFSecurityPanel.validatePassword()) continue;
            stringBuffer.append(ReportArb.format("SECURITY_CHILD_REPORT", childNode.name())).append("\n");
            stringBuffer.append(pDFSecurityPanel.getErrorMessage()).append("\n\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._reportTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode != null) {
            ReportTreeNode reportTreeNode = (ReportTreeNode)defaultMutableTreeNode.getUserObject();
            reportTreeNode.onSelection();
            this._reportOptions.onSelectNode(reportTreeNode);
        }
    }

    public void doRetrieveAllSQLColumnNames(final ChildNode childNode, final PropertyChangeListener propertyChangeListener) {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(ReportArb.getString("QUERYING_COLUMN_DATA"), true, IRaptorTaskRunMode.MODAL){

            protected Void doWork() throws TaskException {
                try {
                    String string = ReportTreePanel.this._reportOptions.dbName();
                    TreeSet<String> treeSet = new TreeSet<String>();
                    String string2 = childNode != null ? ReportTreePanel.this.getChildReportSQL(childNode) : ReportTreePanel.this.getMasterReportSQL();
                    Connection connection = Connections.getInstance().getConnection(string);
                    PreparedStatement preparedStatement = connection.prepareStatement(string2);
                    ResultSetMetaData resultSetMetaData = preparedStatement.getMetaData();
                    int n = resultSetMetaData.getColumnCount();
                    for (int i = 1; i <= n; ++i) {
                        String string3 = resultSetMetaData.getColumnName(i);
                        treeSet.add("\"" + string3 + "\"");
                    }
                    propertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, null, null, treeSet));
                }
                catch (DBException dBException) {
                    Throwable throwable = dBException.getCause();
                    ExceptionHandler.handleException((Throwable)(throwable != null ? throwable : dBException));
                }
                catch (SQLException sQLException) {
                    ExceptionHandler.handleException((Throwable)sQLException);
                }
                return null;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    public JTree getReportTree() {
        return this._reportTree;
    }

    public String getMasterReportName() {
        return this.masterNode.name();
    }

    public String getMasterReportSQL() {
        ReportSQLPanel reportSQLPanel = this.masterNode.sqlNode().panel();
        if (reportSQLPanel != null) {
            return reportSQLPanel.getSQL();
        }
        return null;
    }

    public String getChildReportSQL(ChildNode childNode) {
        ReportSQLPanel reportSQLPanel = childNode.sqlNode().panel();
        if (reportSQLPanel != null) {
            return reportSQLPanel.getSQL();
        }
        return null;
    }
}

