/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.ui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.report.ui.ReportArb;
import oracle.dbtools.raptor.report.ui.ReportSQLPanel;
import oracle.dbtools.raptor.report.ui.ReportTreeContext;
import oracle.dbtools.raptor.report.ui.ReportTreeNode;
import oracle.javatools.util.Version;

public class SQLNode
extends ReportTreeNode {
    public static final String LABEL = ReportArb.getString("SQL_NODE");
    public static final String ICON = ReportArb.getString("SQL_ICON");
    private ReportSQLPanel panel;
    private Query query;
    private boolean main;
    private Version minVersion;
    private Version maxVersion;
    private boolean variantsVisible;

    public SQLNode(ReportTreeContext reportTreeContext, Query object) {
        super(reportTreeContext);
        if (object != null) {
            this.main = false;
            this.query = this.cloneQuery((Query)object);
        } else {
            this.main = true;
        }
        if (this.main) {
            DisplayModel displayModel = reportTreeContext.model();
            List list = null;
            int n = 0;
            if (displayModel != null && (list = displayModel.getQueries()) != null) {
                if (list.size() == 1) {
                    object = (Query)list.get(0);
                    this.variantsVisible = object.getMaxversion() != null || object.getMinversion() != null;
                } else {
                    int n2 = 0;
                    for (SQLNode sQLNode : list) {
                        if (object == null) {
                            object = sQLNode;
                            n = n2;
                        } else if (object.getMaxversion() != null) {
                            Version version = sQLNode.getMaxversion();
                            if (version == null) {
                                object = sQLNode;
                                n = n2;
                            } else if (version.compareTo((Object)object.getMaxversion()) > 0) {
                                object = sQLNode;
                                n = n2;
                            }
                        }
                        ++n2;
                    }
                    this.variantsVisible = true;
                }
                this.query = this.cloneQuery((Query)object);
            }
            if (this.query != null) {
                for (Object object2 : list) {
                    SQLNode sQLNode;
                    sQLNode = new SQLNode(reportTreeContext, (Query)object2);
                    sQLNode.insertAtTail(this);
                }
            } else {
                this.query = new Query();
                SQLNode sQLNode = new SQLNode(reportTreeContext, this.query);
                sQLNode.insertAtTail(this);
            }
            this.setVariantsVisible(this.variantsVisible, n);
        }
        if (this.query != null) {
            this.minVersion = this.query.getMinversion();
            this.maxVersion = this.query.getMaxversion();
        }
    }

    private Query cloneQuery(Query query) {
        Query query2 = new Query();
        query2.setSql(query.getSql());
        query2.setBinds(query.getBinds());
        if (query.getMaxversion() != null) {
            query2.setMaxversion(query.getMaxversion());
        }
        if (query.getMinversion() != null) {
            query2.setMinversion(query.getMinversion());
        }
        return query2;
    }

    @Override
    public String toString() {
        String string = null;
        string = this.main ? super.toString() : this.minVersion() + " : " + this.maxVersion();
        return string;
    }

    public List<Query> createQueries(List<Bind> list) {
        ArrayList<Query> arrayList = null;
        if (this.main) {
            arrayList = new ArrayList<Query>();
            ReportSQLPanel reportSQLPanel = this.panel();
            if (this.variantsVisible) {
                for (SQLNode sQLNode : this.childNodes(SQLNode.class)) {
                    ReportSQLPanel reportSQLPanel2 = sQLNode.panel();
                    Query query = new Query();
                    query.setSql(reportSQLPanel2.getSQL());
                    if (sQLNode.maxVersion != null) {
                        query.setMaxversion(sQLNode.maxVersion);
                    }
                    if (sQLNode.minVersion != null) {
                        query.setMinversion(sQLNode.minVersion);
                    }
                    query.setBinds(list);
                    arrayList.add(query);
                }
            } else {
                Query query = new Query();
                query.setSql(reportSQLPanel.getSQL());
                query.setBinds(list);
                arrayList.add(query);
            }
        }
        return arrayList;
    }

    public List<Query> queryVariants() {
        if (!this.main) {
            throw new IllegalStateException();
        }
        ArrayList<Query> arrayList = new ArrayList<Query>();
        if (this.variantsVisible) {
            for (SQLNode sQLNode : this.childNodes(SQLNode.class)) {
                sQLNode.refreshQuery();
                arrayList.add(sQLNode.query);
            }
        } else {
            this.refreshQuery();
            arrayList.add(this.query);
        }
        return arrayList;
    }

    public String maxVersion() {
        return this.maxVersion != null ? this.maxVersion.toCanonicalString() : "*";
    }

    public String minVersion() {
        return this.minVersion != null ? this.minVersion.toCanonicalString() : "*";
    }

    public boolean setMaxVersion(String string) {
        boolean bl = true;
        if (string.trim().equals("*")) {
            this.maxVersion = null;
        } else {
            try {
                this.maxVersion = new Version(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        if (bl) {
            ((DefaultTreeModel)this.context().treePanel().getReportTree().getModel()).nodeChanged(this.jNode());
        }
        return bl;
    }

    public boolean setMinVersion(String string) {
        boolean bl = true;
        if (string.trim().equals("*")) {
            this.minVersion = null;
        } else {
            try {
                this.minVersion = new Version(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        if (bl) {
            ((DefaultTreeModel)this.context().treePanel().getReportTree().getModel()).nodeChanged(this.jNode());
        }
        return bl;
    }

    @Override
    public String typeLabel() {
        return LABEL;
    }

    @Override
    public String iconName() {
        return ICON;
    }

    public Query query() {
        return this.query;
    }

    public boolean isMain() {
        return this.main;
    }

    public void refreshQuery() {
        if (this.query != null && this.panel != null) {
            this.query.setSql(this.panel.getSQL());
        }
    }

    public void setVariantsVisible(boolean bl) {
        this.setVariantsVisible(bl, 0);
    }

    private void setVariantsVisible(boolean bl, int n) {
        Object object;
        List<SQLNode> list = this.childNodes(SQLNode.class);
        if (!bl && list.size() == 1) {
            object = list.get(0);
            ((SQLNode)object).refreshQuery();
            this.query = ((SQLNode)object).query();
            this.minVersion = null;
            this.maxVersion = null;
            if (this.panel != null) {
                this.panel.refreshSQL();
            }
        }
        if (bl) {
            this.refreshQuery();
            object = list.get(n);
            ((SQLNode)object).query = this.query;
            if (((SQLNode)object).panel != null) {
                ((SQLNode)object).panel.refreshSQL();
            }
        }
        for (SQLNode sQLNode : list) {
            sQLNode.setVisible(bl);
        }
        this.variantsVisible = bl;
    }

    public boolean variantsVisible() {
        return this.variantsVisible;
    }

    public SQLNode addVariant() {
        SQLNode sQLNode = new SQLNode(this.context(), new Query());
        sQLNode.insertAtTail(this);
        sQLNode.setVisible(true);
        return sQLNode;
    }

    @Override
    public ReportSQLPanel panel() {
        if (this.panel == null) {
            this.panel = new ReportSQLPanel(this.context(), this);
        }
        return this.panel;
    }

    @Override
    public void onSelection() {
        if (this.panel != null) {
            this.panel.updateMasterInfo();
        }
    }
}

