/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import oracle.ide.net.URLFactory;
import oracle.ide.webbrowser.internal.Util;
import oracle.ideimpl.webupdate.MasterListEntry;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.UpdateCenter;
import oracle.ideimpl.webupdate.UpdateCenterMonitor;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.UpdateManager;
import oracle.ideimpl.webupdate.parser.MasterListParser;
import oracle.ideimpl.webupdate.util.UpdateUtil;
import org.xml.sax.SAXException;

public abstract class CheckMasterListRunnable
implements Runnable {
    private boolean _isRunning;
    private final String[] _localHostNames;
    private final String _masterURL;
    private UpdateCenterMonitor _monitor;
    private boolean _isAutomaticUpdateMode;
    private final boolean _loadCenterListFile;

    public CheckMasterListRunnable(String masterURL) {
        this(masterURL, false);
    }

    CheckMasterListRunnable(String masterURL, boolean loadCenterListFile) {
        this._masterURL = masterURL;
        this._loadCenterListFile = loadCenterListFile;
        this._localHostNames = this.buildLocalHostNames();
    }

    void setAutomaticUpdateMode(boolean autoMode) {
        this._isAutomaticUpdateMode = autoMode;
    }

    private String[] buildLocalHostNames() {
        try {
            InetAddress[] inets = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
            String[] hostNames = new String[inets.length];
            for (int i = 0; i < inets.length; ++i) {
                InetAddress inet = inets[i];
                if (inet == null) continue;
                hostNames[i] = inet.getCanonicalHostName();
            }
            return hostNames;
        }
        catch (UnknownHostException uhe) {
            uhe.printStackTrace();
            return new String[0];
        }
    }

    public final void setMonitor(UpdateCenterMonitor monitor) {
        this._monitor = monitor;
    }

    protected final UpdateCenterMonitor getMonitor() {
        if (this._monitor == null) {
            this._monitor = new UpdateCenterMonitor(){

                @Override
                public void setMessage(String message) {
                }

                @Override
                public void setProgress(int i) {
                }

                @Override
                public void start() {
                }

                @Override
                public void finish() {
                }

                @Override
                public boolean isStopped() {
                    return false;
                }

                @Override
                public void setMaximum(int max) {
                }
            };
        }
        return this._monitor;
    }

    private boolean matchesLocalDomains(MasterListEntry entry) {
        if (".*\\.oracle.com".equals(entry.getDomainRegexp())) {
            return Util.isInsideOracle();
        }
        for (int i = 0; i < this._localHostNames.length; ++i) {
            if (!entry.matchesDomain(this._localHostNames[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        if (this.getMonitor().isStopped()) {
            return;
        }
        try {
            this.setRunning(true);
            this.getMonitor().start();
            this.getMonitor().setMessage(UpdateArb.getString(123));
            List<UpdateCenter> masterList = this.loadUpdateCenters();
            this.getMonitor().finish();
            this.setRunning(false);
            this.finished(masterList);
        }
        catch (Throwable t) {
            this.getMonitor().finish();
            this.setRunning(false);
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            this.failed(t);
        }
    }

    public synchronized boolean isRunning() {
        return this._isRunning;
    }

    private synchronized void setRunning(boolean running) {
        this._isRunning = running;
    }

    protected abstract void failed(Throwable var1);

    protected abstract void finished(List<UpdateInfo> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<UpdateCenter> loadUpdateCenters() throws IOException, ParserConfigurationException, SAXException {
        UpdateManager updateManager;
        ArrayList<UpdateCenter> masterList = new ArrayList<UpdateCenter>();
        if (this._loadCenterListFile && (updateManager = UpdateManager.getInstance()) != null) {
            masterList.addAll(updateManager.getUpdateCenters());
        }
        if (masterList.isEmpty()) {
            URL masterURL = URLFactory.newURL((String)this._masterURL);
            BufferedInputStream bis = null;
            try {
                URLConnection conn = masterURL.openConnection();
                conn.setRequestProperty("User-Agent", UpdateManager.getInstance().getUserAgent(masterURL.toString(), this._isAutomaticUpdateMode));
                bis = new BufferedInputStream(UpdateUtil.openConnectionCheckRedirects(conn));
                List masterEntries = new MasterListParser().parse(bis);
                for (MasterListEntry entry : masterEntries) {
                    if (!this.matchesLocalDomains(entry)) continue;
                    masterList.add(entry.getUpdateCenter());
                }
            }
            finally {
                if (bis != null) {
                    bis.close();
                }
            }
        }
        return masterList;
    }
}

