/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ide.extension.Extension;
import javax.ide.util.Version;
import javax.xml.parsers.ParserConfigurationException;
import oracle.ide.ExtensionRegistry;
import oracle.ide.net.URLFactory;
import oracle.ideimpl.webupdate.CheckForUpdatesPreferences;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateCenter;
import oracle.ideimpl.webupdate.UpdateCenterMonitor;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.UpdateManager;
import oracle.ideimpl.webupdate.WebUpdateAddin;
import oracle.ideimpl.webupdate.parser.UpdateCenterParser;
import oracle.ideimpl.webupdate.util.UpdateUtil;
import org.xml.sax.SAXException;

public abstract class CheckUpdatesRunnable
implements Runnable {
    private final List _updateCenters;
    private boolean _isRunning;
    private boolean _isAutomaticUpdateMode;
    private UpdateCenterMonitor _monitor;
    private Set<Version> _validNightlies = new HashSet<Version>();
    private final Comparator<UpdateInfo> reverseVersionComparator = new Comparator<UpdateInfo>(){

        @Override
        public int compare(UpdateInfo o1, UpdateInfo o2) {
            Version o1Version = o1.getVersion();
            Version o2Version = o2.getVersion();
            if (o1Version == null && o2Version == null) {
                return 0;
            }
            if (o1Version == null) {
                return -1;
            }
            if (o2Version == null) {
                return 1;
            }
            return o2Version.compareTo(o1Version);
        }
    };

    public CheckUpdatesRunnable(List updateCenters) {
        this._updateCenters = updateCenters;
    }

    void setAutomaticUpdatesMode(boolean autoMode) {
        this._isAutomaticUpdateMode = autoMode;
    }

    public final void setMonitor(UpdateCenterMonitor monitor) {
        this._monitor = monitor;
    }

    protected final UpdateCenterMonitor getMonitor() {
        if (this._monitor == null) {
            this._monitor = new UpdateCenterMonitor(){

                @Override
                public void setMessage(String message) {
                }

                @Override
                public void setProgress(int i) {
                }

                @Override
                public void start() {
                }

                @Override
                public void finish() {
                }

                @Override
                public boolean isStopped() {
                    return false;
                }

                @Override
                public void setMaximum(int max) {
                }
            };
        }
        return this._monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.isStopped()) {
            return;
        }
        try {
            this.setRunning(true);
            this.getMonitor().start();
            this.getMonitor().setMaximum(this._updateCenters.size());
            Map<String, List<UpdateInfo>> allUpdates = this.getAllAvailableUpdates();
            if (this.isStopped()) {
                this.stopped();
                return;
            }
            Map<String, UpdateInfo> installable = this.findInstallableUpdates(allUpdates);
            if (this.isStopped()) {
                this.stopped();
                return;
            }
            HashSet<UpdateBundle> allBundles = new HashSet<UpdateBundle>();
            for (UpdateInfo update : installable.values()) {
                allBundles.add(update.getBundle());
            }
            HashSet<UpdateBundle> partialBundles = new HashSet<UpdateBundle>();
            block6: for (UpdateBundle b : allBundles) {
                for (UpdateInfo update : b.getUpdates()) {
                    if (installable.containsKey(update.getID())) continue;
                    partialBundles.add(b);
                    continue block6;
                }
            }
            for (UpdateBundle bundle : partialBundles) {
                for (UpdateInfo update : bundle.getUpdates()) {
                    installable.remove(update.getID());
                }
            }
            this.finished(Collections.unmodifiableCollection(installable.values()));
        }
        finally {
            this.getMonitor().finish();
            this.setRunning(false);
        }
    }

    private Map<String, UpdateInfo> findInstallableUpdates(Map<String, List<UpdateInfo>> allAvailableUpdates) {
        HashMap<String, UpdateInfo> installableUpdates = new HashMap<String, UpdateInfo>();
        while (this.scanUpdates(allAvailableUpdates, installableUpdates)) {
        }
        return installableUpdates;
    }

    private boolean scanUpdates(Map<String, List<UpdateInfo>> allAvailableUpdates, Map<String, UpdateInfo> installableUpdates) {
        ExtensionRegistry extReg = ExtensionRegistry.getExtensionRegistry();
        boolean foundSome = false;
        Iterator<Map.Entry<String, List<UpdateInfo>>> entries = allAvailableUpdates.entrySet().iterator();
        block0: while (entries.hasNext()) {
            Map.Entry<String, List<UpdateInfo>> entry = entries.next();
            String updateId = entry.getKey();
            List<UpdateInfo> updates = entry.getValue();
            Iterator<UpdateInfo> iUpdates = updates.iterator();
            while (iUpdates.hasNext()) {
                boolean found;
                if (this.isStopped()) {
                    return false;
                }
                UpdateInfo thisUpdate = iUpdates.next();
                Extension minimalExtension = extReg.findMinimalExtension(thisUpdate.getID());
                if (minimalExtension != null && minimalExtension.getVersion().compareTo(thisUpdate.getVersion()) >= 0 || !(found = this.getInstallableUpdate(thisUpdate, installableUpdates))) continue;
                foundSome = true;
                installableUpdates.put(updateId, thisUpdate);
                entries.remove();
                continue block0;
            }
        }
        return foundSome;
    }

    private boolean getInstallableUpdate(UpdateInfo update, Map installableUpdates) {
        ExtensionRegistry extReg = ExtensionRegistry.getExtensionRegistry();
        update.clearRequiredUpdates();
        update.setNew(extReg.findExtension(update.getID()) == null);
        for (String requiredId : update.getRequiredIds()) {
            UpdateInfo installable = (UpdateInfo)installableUpdates.get(requiredId);
            if (installable != null) {
                if (CheckUpdatesRunnable.testCompatibleVersion(update, requiredId, installable.getVersion())) {
                    update.addRequiredUpdate(installable);
                    continue;
                }
                return false;
            }
            Extension installedExtension = extReg.findExtension(requiredId);
            if (installedExtension == null) {
                return false;
            }
            Version extensionVersion = installedExtension.getVersion();
            if (CheckUpdatesRunnable.testCompatibleVersion(update, requiredId, extensionVersion)) continue;
            return false;
        }
        return true;
    }

    public static boolean testCompatibleVersion(UpdateInfo update, String depId, Version version) {
        Version minVersion = update.getRequiredMinVersion(depId);
        Version maxVersion = update.getRequiredMaxVersion(depId);
        if (minVersion != null && version.compareTo(minVersion) < 0) {
            return false;
        }
        return maxVersion == null || version.compareTo(maxVersion) <= 0;
    }

    private Map<String, List<UpdateInfo>> getAllAvailableUpdates() {
        HashMap<String, List<UpdateInfo>> allAvailableUpdates = new HashMap<String, List<UpdateInfo>>();
        UpdateCenterParser parser = new UpdateCenterParser();
        for (int i = 0; i < this._updateCenters.size(); ++i) {
            if (this.isStopped()) {
                return null;
            }
            InputStream inStream = null;
            UpdateCenter center = (UpdateCenter)this._updateCenters.get(i);
            try {
                URLConnection conn;
                this.getMonitor().setMessage(UpdateArb.format(182, center.getName()));
                URL url = URLFactory.newURL((String)center.getURL());
                if ("file".equals(url.getProtocol())) {
                    inStream = new FileInputStream(url.getPath());
                } else {
                    conn = url.openConnection();
                    conn.setConnectTimeout(this.getTimeout());
                    conn.setReadTimeout(this.getTimeout());
                    conn.setRequestProperty("User-Agent", UpdateManager.getInstance().getUserAgent(url.toString(), this._isAutomaticUpdateMode));
                    inStream = UpdateUtil.openConnectionCheckRedirects(conn);
                }
                if (this.isStopped()) {
                    conn = null;
                    return conn;
                }
                Collection<UpdateBundle> bundles = parser.parse(inStream);
                CheckForUpdatesPreferences prefs = WebUpdateAddin.getPreferences();
                Object hiddenMessages = prefs.getHiddenMessages();
                if (hiddenMessages == null) {
                    hiddenMessages = Collections.emptyList();
                }
                for (UpdateBundle bundle : bundles) {
                    for (UpdateInfo thisUpdate : bundle.getUpdates()) {
                        if (thisUpdate.getType() == UpdateInfo.Type.MESSAGE && hiddenMessages.contains(thisUpdate.getID())) continue;
                        if (thisUpdate.getType() != UpdateInfo.Type.MESSAGE && thisUpdate.getVersion().toIntArray().length == 2) {
                            int[] numbers = thisUpdate.getVersion().toIntArray();
                            int l1 = String.valueOf(numbers[0]).length();
                            int l2 = String.valueOf(numbers[1]).length();
                            if (l1 >= 5 && l2 >= 2) continue;
                        }
                        thisUpdate.setSourceCenter(center);
                        ArrayList<UpdateInfo> updatesForId = (ArrayList<UpdateInfo>)allAvailableUpdates.get(thisUpdate.getID());
                        if (updatesForId == null) {
                            updatesForId = new ArrayList<UpdateInfo>();
                            allAvailableUpdates.put(thisUpdate.getID(), updatesForId);
                        } else if (thisUpdate.getType() != UpdateInfo.Type.MESSAGE) {
                            for (UpdateInfo otherVersionUpdate : updatesForId) {
                                if (!otherVersionUpdate.getVersion().equals((Object)thisUpdate.getVersion())) continue;
                                thisUpdate = null;
                                break;
                            }
                        }
                        if (thisUpdate == null) continue;
                        updatesForId.add(thisUpdate);
                    }
                }
                this.getMonitor().setProgress(i + 1);
                continue;
            }
            catch (IOException e) {
                this.updateCenterError(center, e);
                continue;
            }
            catch (SAXException e) {
                this.updateCenterError(center, e);
                continue;
            }
            catch (ParserConfigurationException e) {
                throw new IllegalStateException(e);
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
        }
        for (List updates : allAvailableUpdates.values()) {
            this.reverseSortByVersion(updates);
        }
        return allAvailableUpdates;
    }

    void reverseSortByVersion(List<UpdateInfo> updates) {
        Collections.sort(updates, this.reverseVersionComparator);
    }

    private synchronized boolean isStopped() {
        return this.getMonitor().isStopped();
    }

    public synchronized boolean isRunning() {
        return this._isRunning;
    }

    private synchronized void setRunning(boolean isRunning) {
        this._isRunning = isRunning;
    }

    protected abstract void updateCenterError(UpdateCenter var1, Throwable var2);

    protected abstract void finished(Collection<UpdateInfo> var1);

    protected abstract void stopped();

    private int getTimeout() {
        try {
            return Integer.parseInt(System.getProperty("ide.cfu.timeout", "15000"));
        }
        catch (NumberFormatException e) {
            return 15000;
        }
    }

    private void determineValidNightlies(Map<String, List<UpdateInfo>> list) {
        HashSet<Version> nightlies = new HashSet<Version>();
        for (List<UpdateInfo> infos : list.values()) {
            for (UpdateInfo info : infos) {
                Version maxVersion = info.getRequiredMaxVersion("oracle.jdeveloper");
                Version minVersion = info.getRequiredMinVersion("oracle.jdeveloper");
                if (minVersion == null || maxVersion == null || minVersion.compareTo(maxVersion) != 0) continue;
                nightlies.add(minVersion);
            }
        }
        this._validNightlies = Collections.unmodifiableSet(nightlies);
    }

    public Set<Version> getValidNightlies() {
        return this._validNightlies;
    }
}

