/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionRegistry;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.ideimpl.webupdate.InvalidLocalBundleException;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.parser.LocalBundleParser;
import oracle.ideimpl.webupdate.parser.ParserResult;
import oracle.ideimpl.webupdate.parser.UpdateBundleValidator;
import oracle.ideimpl.webupdate.util.UpdateUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class LocalUpdateBundle {
    private static final Logger LOGGER = Logger.getLogger(LocalUpdateBundle.class.getName());
    private static final String BUNDLE_MANIFEST = "META-INF/bundle.xml";
    private UpdateBundle _bundle;
    private File _bundleFile;

    public LocalUpdateBundle(UpdateBundle bundle) {
        this._bundle = bundle;
    }

    public UpdateBundle getBundle() {
        return this._bundle;
    }

    public void setBundleFile(File file) {
        this._bundleFile = file;
    }

    public File getBundleFile() {
        return this._bundleFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContent(String entryPath) throws IOException {
        ZipFile zipFile = new ZipFile(this.getBundleFile());
        ZipEntry entry = zipFile.getEntry(entryPath);
        BufferedReader br = null;
        StringBuffer sb = new StringBuffer();
        try {
            br = new BufferedReader(new InputStreamReader(zipFile.getInputStream(entry)));
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                line = br.readLine();
            }
        }
        catch (Throwable throwable) {
            LocalUpdateBundle.close(br);
            LocalUpdateBundle.close(zipFile);
            throw throwable;
        }
        LocalUpdateBundle.close(br);
        LocalUpdateBundle.close(zipFile);
        return sb.toString();
    }

    public static LocalUpdateBundle createInstance(File localFile) throws InvalidLocalBundleException {
        return LocalUpdateBundle.createInstance(localFile, true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LocalUpdateBundle createInstance(File localFile, boolean resolveExt) throws InvalidLocalBundleException {
        LocalUpdateBundle localUpdateBundle;
        if (!localFile.exists()) {
            throw new InvalidLocalBundleException(UpdateArb.format(136, localFile.getName()));
        }
        if (localFile.isDirectory()) {
            throw new InvalidLocalBundleException(UpdateArb.format(137, localFile.getName()));
        }
        if (!localFile.canRead()) {
            throw new InvalidLocalBundleException(UpdateArb.format(138, localFile.getName()));
        }
        ZipFile zipFile = null;
        InputStream inStream = null;
        try {
            zipFile = new ZipFile(localFile);
            ZipEntry entry = zipFile.getEntry(BUNDLE_MANIFEST);
            if (entry == null) {
                throw new InvalidLocalBundleException(UpdateArb.format(151, localFile.getName(), BUNDLE_MANIFEST));
            }
            inStream = zipFile.getInputStream(entry);
            ParserResult result = new LocalBundleParser().parse(inStream);
            if (result.problems().hasProblems()) {
                throw new InvalidLocalBundleException(UpdateArb.getString(204), result.problems());
            }
            LocalUpdateBundle.setCategoryFromExtension(zipFile, result.bundle());
            LocalUpdateBundle lub = new LocalUpdateBundle(result.bundle());
            lub.setBundleFile(localFile);
            if (resolveExt) {
                for (UpdateInfo info : result.bundle().getUpdates()) {
                    Extension oldExtension = ExtensionRegistry.getExtensionRegistry().findExtension(info.getID());
                    info.setNew(oldExtension == null);
                }
            }
            LocalUpdateBundle.validateLocalUpdateBundle(lub);
            localUpdateBundle = lub;
        }
        catch (IOException ioe) {
            try {
                throw new InvalidLocalBundleException(UpdateArb.format(139, localFile.getName()), ioe);
                catch (ParserConfigurationException pce) {
                    throw new InvalidLocalBundleException(UpdateArb.getString(152), pce);
                }
                catch (SAXException saxe) {
                    throw new InvalidLocalBundleException(UpdateArb.getString(152), saxe);
                }
            }
            catch (Throwable throwable) {
                LocalUpdateBundle.close(inStream);
                LocalUpdateBundle.close(zipFile);
                throw throwable;
            }
        }
        LocalUpdateBundle.close(inStream);
        LocalUpdateBundle.close(zipFile);
        return localUpdateBundle;
    }

    private static void close(final ZipFile zipFile) {
        LocalUpdateBundle.close(new Closeable(){

            @Override
            public void close() throws IOException {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
        });
    }

    private static void close(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException exception) {
                Logger.getLogger(LocalUpdateBundle.class.getName()).log(Level.SEVERE, null, exception);
            }
        }
    }

    private static void validateLocalUpdateBundle(LocalUpdateBundle lub) {
        UpdateBundleValidator bundleValidator;
        UpdateBundleValidator.Result validationResult;
        boolean isValidationEnabled = false;
        if (!$assertionsDisabled) {
            isValidationEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (isValidationEnabled && lub != null && !(validationResult = (bundleValidator = UpdateBundleValidator.createInstance(lub)).validate()).isValid()) {
            LOGGER.warning(validationResult.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setCategoryFromExtension(ZipFile zipFile, UpdateBundle bundle) throws SAXException, IOException, ParserConfigurationException {
        Set<UpdateInfo> set = bundle.getUpdates();
        for (UpdateInfo update : set) {
            StringReader reader;
            ZipInputStream zis;
            InputStream inputStream;
            block10: {
                if (update.getCategory().isCategorySet()) continue;
                String id = update.getID();
                String jarFileName = id + ".jar";
                ZipEntry jar = zipFile.getEntry(jarFileName);
                if (jar == null) {
                    Enumeration<? extends ZipEntry> list = zipFile.entries();
                    while (list.hasMoreElements()) {
                        ZipEntry e = list.nextElement();
                        if (!e.getName().endsWith(jarFileName)) continue;
                        jar = e;
                    }
                }
                if (jar == null) continue;
                inputStream = null;
                zis = null;
                reader = null;
                try {
                    inputStream = zipFile.getInputStream(jar);
                    zis = new ZipInputStream(inputStream);
                    String extensionXML = UpdateUtil.readExtensionXML(zis);
                    if (extensionXML == null) break block10;
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    SAXParser parser = factory.newSAXParser();
                    reader = new StringReader(extensionXML);
                    InputSource source = new InputSource(reader);
                    ReadCategoryHandler categoryHandler = new ReadCategoryHandler();
                    try {
                        parser.parse(source, (DefaultHandler)categoryHandler);
                        if (categoryHandler.getCategoryID() != null) {
                            update.getCategory().setCategoryId(categoryHandler.getCategoryID());
                        } else if (categoryHandler.getCategory() != null) {
                            update.getCategory().setCategory(categoryHandler.getCategory());
                        }
                    }
                    catch (Exception e) {
                        LOGGER.warning("Exception during parsing of " + zipFile.getName() + ":. " + jarFileName);
                    }
                }
                catch (Throwable throwable) {
                    LocalUpdateBundle.doClose(reader);
                    LocalUpdateBundle.doClose(inputStream);
                    LocalUpdateBundle.doClose(zis);
                    throw throwable;
                }
            }
            LocalUpdateBundle.doClose(reader);
            LocalUpdateBundle.doClose(inputStream);
            LocalUpdateBundle.doClose(zis);
        }
    }

    private static void doClose(Closeable s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private static class ReadCategoryHandler
    extends DefaultHandler {
        private String categoryID;
        private boolean inCategoryID;
        private String category;
        private boolean inCategory;

        private ReadCategoryHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equalsIgnoreCase("category-id")) {
                this.inCategoryID = true;
            } else if (qName.equalsIgnoreCase("category")) {
                this.inCategory = true;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equalsIgnoreCase("category-id")) {
                this.inCategoryID = false;
            } else if (qName.equalsIgnoreCase("category")) {
                this.inCategory = false;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String s = new String(ch, start, length).trim();
            if (!s.isEmpty() && this.inCategoryID) {
                this.categoryID = s;
            } else if (!s.isEmpty() && this.inCategory) {
                this.category = s;
            }
        }

        public String getCategory() {
            return this.category;
        }

        public String getCategoryID() {
            return this.categoryID;
        }
    }
}

