/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.commandline;

import java.awt.Window;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ide.extension.Extension;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ideimpl.webupdate.Directories;
import oracle.ideimpl.webupdate.LocalUpdateBundle;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.UpdateManager;
import oracle.ideimpl.webupdate.uninstall.CFUBundlesExtraInfo;
import oracle.ideimpl.webupdate.wizard.UpdateWizardModel;
import oracle.javatools.dialogs.ExceptionDialog;

public class PreInstaller {
    private UpdateWizardModel _model;
    private UpdateManager _updateManager;
    private boolean _commandLine;

    public static PreInstaller createCommandLineInstaller(Directories directories) {
        return new PreInstaller(directories);
    }

    public static PreInstaller createUpdateWizardInstaller(UpdateWizardModel model, UpdateManager updateManager) {
        return new PreInstaller(model, updateManager);
    }

    private PreInstaller(Directories directories) {
        this.getModel();
        this.getManager().setDirectories(directories);
        this._commandLine = true;
    }

    private PreInstaller(UpdateWizardModel model, UpdateManager updateManager) {
        this._model = model;
        this._updateManager = updateManager;
        this._commandLine = false;
    }

    public UpdateWizardModel getModel() {
        if (this._model == null) {
            this._model = new UpdateWizardModel(this.getManager());
        }
        return this._model;
    }

    private UpdateManager getManager() {
        if (this._updateManager == null) {
            this._updateManager = UpdateManager.getInstance();
        }
        return this._updateManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        ArrayList<String> updateList = new ArrayList<String>();
        UpdateManager updateManager = UpdateManager.getInstance();
        updateManager.getDirectories().save(updateList);
        if (this.getModel().getLocalBundle() != null) {
            LocalUpdateBundle localBundle = this.getModel().getLocalBundle();
            this.seedInstaller(updateList, localBundle.getBundle(), localBundle.getBundleFile());
        } else {
            Map zipFilesByBundle = this.getModel().getDownloadedUpdates();
            if (zipFilesByBundle == null) {
                return;
            }
            for (Map.Entry entry : zipFilesByBundle.entrySet()) {
                UpdateBundle bundle = (UpdateBundle)entry.getKey();
                File zipFile = (File)entry.getValue();
                this.seedInstaller(updateList, bundle, zipFile);
            }
        }
        File duFile = UpdateManager.getInstance().getDeferredUpdatesFile();
        BufferedWriter writer = null;
        try {
            try {
                writer = new BufferedWriter(new FileWriter(duFile));
                for (String line : updateList) {
                    writer.write(line);
                    writer.newLine();
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (IOException ioe) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ioe);
        }
    }

    private void seedInstaller(List<String> updateList, UpdateBundle bundle, File zipFile) {
        ArrayList<String> updateIds = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        for (UpdateInfo update : bundle.getUpdates()) {
            Extension extension = javax.ide.extension.ExtensionRegistry.getExtensionRegistry().findExtension(update.getID());
            if (extension != null) {
                buf.setLength(0);
                buf.append("DeinstallExtensionTask=");
                buf.append(update.getID());
                buf.append(',');
                buf.append(extension.getVersion().toString());
                updateList.add(buf.toString());
            }
            updateIds.add(update.getID());
        }
        File destinationDir = this.getDestinationDir(bundle);
        buf.setLength(0);
        buf.append("InstallExtensionTask=");
        buf.append(zipFile.getPath());
        buf.append(',');
        buf.append(destinationDir.getPath());
        buf.append(',');
        buf.append("false");
        for (String updateId : updateIds) {
            buf.append(',');
            buf.append(updateId);
        }
        updateList.add(buf.toString());
        for (UpdateInfo update : bundle.getUpdates()) {
            String postStartupHook = update.getPostStartupHookClass();
            if (postStartupHook == null || (postStartupHook = postStartupHook.trim()).length() <= 0) continue;
            buf.setLength(0);
            buf.append("ScheduleHookTask=");
            buf.append(postStartupHook);
            buf.append(',');
            buf.append(this.getInstallHookFile().getPath());
            buf.append(',');
            buf.append(update.getID());
            updateList.add(buf.toString());
        }
        for (UpdateInfo update : bundle.getUpdates()) {
            updateList.add(CFUBundlesExtraInfo.extrasToString(update));
        }
    }

    private File getInstallHookFile() {
        String homeDir = this._updateManager.getDirectories().getOracleHome();
        return new File(homeDir, "installhooks.properties");
    }

    private void replaceBundleInstallLocation(UpdateBundle bundle, String fromString, String fromPattern, String toString) {
        if (bundle.getInstallLocation().equals(fromString)) {
            bundle.setInstallLocation(toString);
        } else {
            bundle.getInstallLocation().replaceAll(fromPattern, toString);
        }
    }

    private File getDestinationDir(UpdateBundle bundle) {
        if (this._commandLine) {
            return this.getDistinationDirCommandLine(bundle);
        }
        return this.getDesitinationDirIDE(bundle);
    }

    private File getDistinationDirCommandLine(UpdateBundle bundle) {
        if (bundle.getInstallLocation() != null) {
            if (bundle.getInstallLocation().contains("${oracle.home}")) {
                this.replaceBundleInstallLocation(bundle, "${oracle.home}", "\\$\\{oracle.home\\}", this.getManager().getDirectories().getOracleHome());
            } else if (bundle.getInstallLocation().contains("${oracle.mw.home}")) {
                this.replaceBundleInstallLocation(bundle, "${oracle.mw.home}", "\\$\\{oracle.mw.home\\}", this.getManager().getDirectories().getOracleHome() + File.separator + "..");
            }
            return new File(bundle.getInstallLocation());
        }
        return new File(this.getManager().getDirectories().getGlobalExtensionsHome());
    }

    private File getDesitinationDirIDE(UpdateBundle bundle) {
        if (bundle.getInstallLocation() != null) {
            if (bundle.getInstallLocation().contains("${oracle.home}")) {
                this.replaceBundleInstallLocation(bundle, "${oracle.home}", "\\$\\{oracle.home\\}", Ide.getOracleHomeDirectory());
            } else if (bundle.getInstallLocation().contains("${oracle.mw.home}")) {
                if (System.getProperty("oracle.mw.home") != null) {
                    this.replaceBundleInstallLocation(bundle, "${oracle.mw.home}", "\\$\\{oracle.mw.home\\}", System.getProperty("oracle.mw.home"));
                } else {
                    this.replaceBundleInstallLocation(bundle, "${oracle.mw.home}", "\\$\\{oracle.mw.home\\}", Ide.getOracleHomeDirectory() + File.separator + "..");
                }
            }
            return new File(bundle.getInstallLocation());
        }
        Extension extension = javax.ide.extension.ExtensionRegistry.getExtensionRegistry().findExtension(bundle.getUpdates().iterator().next().getID());
        if (extension == null) {
            return new File(this.getModel().isInstallForEveryone() ? UpdateManager.getInstance().getDirectories().getGlobalExtensionsHome() : UpdateManager.getInstance().getDirectories().getUserExtensionsHome());
        }
        ExtensionRegistry extReg = (ExtensionRegistry)javax.ide.extension.ExtensionRegistry.getExtensionRegistry();
        if (extReg.isUserExtension(extension.getID())) {
            return new File(UpdateManager.getInstance().getDirectories().getUserExtensionsHome());
        }
        return new File(UpdateManager.getInstance().getDirectories().getGlobalExtensionsHome());
    }
}

