/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.parser;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import javax.ide.util.Version;
import javax.xml.parsers.ParserConfigurationException;
import oracle.ide.net.URLFactory;
import oracle.ideimpl.webupdate.LocalUpdateBundle;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.UpdateLrb;
import oracle.ideimpl.webupdate.UpdateManager;
import oracle.ideimpl.webupdate.parser.InputStreamLocator;
import oracle.ideimpl.webupdate.parser.Problems;
import oracle.ideimpl.webupdate.parser.UpdateHandler;
import oracle.ideimpl.webupdate.util.UpdateUtil;
import oracle.javatools.xml.esax.ElementContext;
import oracle.javatools.xml.esax.ElementHandler;
import oracle.javatools.xml.esax.ElementStartContext;
import oracle.javatools.xml.esax.HandlerException;
import oracle.javatools.xml.esax.MessageReporter;
import oracle.javatools.xml.esax.XMLLocator;
import oracle.javatools.xml.esax.spi.ExtensibleSAXParser;
import org.xml.sax.SAXException;

public final class UpdateBundleValidator {
    private final ValidatorImpl[] validators;

    private UpdateBundleValidator(ValidatorImpl ... validators) {
        this.validators = validators;
    }

    public final Result validate() {
        HashMap<UpdateInfo, Problems> retval = new HashMap<UpdateInfo, Problems>();
        for (ValidatorImpl nextValidator : this.validators) {
            Map<UpdateInfo, Problems> nextResult = nextValidator.validate();
            for (Map.Entry<UpdateInfo, Problems> entry : nextResult.entrySet()) {
                Problems problems;
                UpdateInfo updateInfo = entry.getKey();
                Problems originalProblems = retval.put(updateInfo, problems = entry.getValue());
                if (originalProblems == null) continue;
                problems.addDescriptions(originalProblems.descriptions());
            }
        }
        return new Result(retval);
    }

    public static UpdateBundleValidator createInstance(LocalUpdateBundle lub) {
        String bundleUrl = null;
        try {
            bundleUrl = lub.getBundleFile().toURI().toURL().toString();
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(UpdateBundleValidator.class.getName()).log(Level.SEVERE, null, ex);
        }
        UpdateBundle bundle = lub.getBundle();
        return bundleUrl != null ? new UpdateBundleValidator(ValidatorImpl.createInstances(bundle.getUpdates(), bundleUrl)) : new UpdateBundleValidator(new ValidatorImpl[0]);
    }

    private static enum ValidationMessages {
        BAD_REQUIRES_VERSION(true, "BAD_REQUIRES_VERSION"),
        MISING_JAR_FILE(false, "missing zip entry '%s'."),
        ATTRIBUTE_IS_REQUIRED(false, "missing '%s' for element '%s' in extension.xml."),
        UNEXPECTED_ATTRIBUTEVALUE(false, "expected value: '%s' of attribute '%s' for element '%s' but found value: '%s' in extension.xml.");

        private String formatPattern;
        private boolean isLocalized;

        private ValidationMessages(boolean isLocalized, String formatPattern) {
            this.isLocalized = isLocalized;
            this.formatPattern = formatPattern;
        }

        private String getFormatPattern() {
            return this.isLocalized ? UpdateLrb.get(this.formatPattern) : this.formatPattern;
        }

        private String getMessage(Object ... arguments) {
            return this.isLocalized ? MessageFormat.format(this.getFormatPattern(), arguments) : String.format(this.getFormatPattern(), arguments);
        }
    }

    private static class ValidatorImpl {
        private static final String EXTENSION_ELEMENT = "extension";
        private static final String ID_ELEMENT_ATTRIBUTE = "id";
        private static final String VERSION_ELEMENT_ATTRIBUTE = "version";
        private static final String JAR_EXTENSION = ".jar";
        private final URL bundleUrl;
        private final UpdateInfo updateInfo;
        private final ValidationMessageReporter problemsReporter;

        private static ValidatorImpl[] createInstances(Set<UpdateInfo> updates, String bundleDownloadUrl) {
            HashSet<ValidatorImpl> validators = new HashSet<ValidatorImpl>(updates.size());
            for (UpdateInfo updateInfo : updates) {
                validators.add(new ValidatorImpl(updateInfo, bundleDownloadUrl));
            }
            return validators.toArray(new ValidatorImpl[validators.size()]);
        }

        private ValidatorImpl(UpdateInfo updateInfo, String bundleDownloadUrl) {
            this.updateInfo = updateInfo;
            this.bundleUrl = URLFactory.newURL((String)bundleDownloadUrl);
            this.problemsReporter = new ValidationMessageReporter();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<UpdateInfo, Problems> validate() {
            HashMap<UpdateInfo, Problems> retval = new HashMap<UpdateInfo, Problems>(1);
            try {
                this.validate(this.updateInfo);
                this.problemsReporter.close();
                retval.put(this.updateInfo, this.problemsReporter.problems);
            }
            catch (IOException ex) {
                try {
                    String msg = ex instanceof ZipException ? String.format("%s (can be caused by corrupted zip file during download)", ex.getMessage()) : null;
                    Level level = ex instanceof ZipException ? Level.INFO : Level.SEVERE;
                    Logger.getLogger(UpdateBundleValidator.class.getName()).log(level, msg, ex);
                    this.problemsReporter.close();
                    retval.put(this.updateInfo, this.problemsReporter.problems);
                }
                catch (Throwable throwable) {
                    this.problemsReporter.close();
                    retval.put(this.updateInfo, this.problemsReporter.problems);
                    throw throwable;
                }
            }
            return retval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void validate(UpdateInfo updateInfo) throws IOException {
            String jarEntryName = updateInfo.getID() + JAR_EXTENSION;
            JarInputStream jarInputStream = null;
            ZipInputStream bundleZipStream = this.getBundleZipStream();
            try {
                ZipEntry nextEntry = bundleZipStream.getNextEntry();
                while (nextEntry != null) {
                    if (nextEntry.getName().endsWith(jarEntryName)) {
                        try {
                            jarInputStream = new JarInputStream(bundleZipStream);
                            String extensionContent = UpdateUtil.readExtensionXML(jarInputStream);
                            this.parseAndvalidateExtensionXML(extensionContent);
                        }
                        catch (Throwable throwable) {}
                        break;
                    }
                    nextEntry = bundleZipStream.getNextEntry();
                }
            }
            finally {
                ValidatorImpl.close(jarInputStream);
                ValidatorImpl.close(bundleZipStream);
            }
            if (jarInputStream == null) {
                this.problemsReporter.reportProblem(ValidationMessages.MISING_JAR_FILE.getMessage(new Object[]{jarEntryName}));
            }
        }

        private ZipInputStream getBundleZipStream() throws IOException {
            InputStream inStream;
            if ("file".equals(this.bundleUrl.getProtocol())) {
                inStream = new FileInputStream(this.bundleUrl.getPath());
            } else {
                URLConnection conn = this.bundleUrl.openConnection();
                conn.setConnectTimeout(this.getTimeout());
                conn.setReadTimeout(this.getTimeout());
                conn.setRequestProperty("User-Agent", UpdateManager.getInstance().getUserAgent(this.bundleUrl.toString(), false));
                inStream = new BufferedInputStream(UpdateUtil.openConnectionCheckRedirects(conn));
            }
            return new ZipInputStream(inStream);
        }

        final void parseAndvalidateExtensionXML(String extensionXMLContent) throws IOException {
            final ElementHandler extensionElementHandler = this.handlerForExtensionElement(this.updateInfo);
            ByteArrayInputStream extensionInputStream = new ByteArrayInputStream(extensionXMLContent.getBytes());
            InputStreamLocator inputStreamLocator = new InputStreamLocator(extensionInputStream);
            try {
                new ExtensibleSAXParser(){

                    public void parse(XMLLocator locator) throws ParserConfigurationException, SAXException, IOException {
                        ElementContext context = this.getContext();
                        context.setMessageReporter((MessageReporter)ValidatorImpl.this.problemsReporter);
                        context.registerChildHandler("http://jcp.org/jsr/198/extension-manifest", ValidatorImpl.EXTENSION_ELEMENT, extensionElementHandler);
                        super.parse(locator);
                    }
                }.parse(inputStreamLocator);
            }
            catch (ParserConfigurationException ex) {
                Logger.getLogger(UpdateBundleValidator.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (SAXException ex) {
                Logger.getLogger(UpdateBundleValidator.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        private ElementHandler handlerForExtensionElement(final UpdateInfo updateInfo) {
            return new ElementHandler(){

                public void handleStart(ElementStartContext context) throws HandlerException {
                    super.handleStart(context);
                    String extensionId = ValidatorImpl.this.requiredIDFromAttribute(context, ValidatorImpl.ID_ELEMENT_ATTRIBUTE, updateInfo.getID());
                    if (extensionId != null) {
                        ValidatorImpl.this.requiredVersionFromAttribute(context, extensionId, ValidatorImpl.VERSION_ELEMENT_ATTRIBUTE, updateInfo.getVersion());
                    }
                }
            };
        }

        private Version requiredVersionFromAttribute(ElementStartContext context, String extensionId, String versionAttrName, Version requiredVersion) {
            Version version = this.versionFromAttribute(context, extensionId, versionAttrName);
            if (version != null && version.compareTo(requiredVersion) != 0) {
                ValidatorImpl.reportWarningMessage(context, ValidationMessages.UNEXPECTED_ATTRIBUTEVALUE, requiredVersion.toCanonicalString(), versionAttrName, context.getLocalName(), version.toCanonicalString());
                return null;
            }
            return version;
        }

        private Version versionFromAttribute(ElementStartContext context, String extensionId, String attrName) {
            String versionString = context.getAttributeValue(attrName);
            if (versionString == null) {
                return null;
            }
            String message = versionString != null ? ValidationMessages.BAD_REQUIRES_VERSION.getMessage(new Object[]{attrName, extensionId, versionString}) : null;
            return UpdateHandler.parseVersion((ElementContext)context, versionString, message);
        }

        private String requiredIDFromAttribute(ElementStartContext context, String attrName, String requiredID) {
            String idString = this.idFromAttribute(context, attrName);
            if (idString != null && !idString.equals(requiredID)) {
                ValidatorImpl.reportWarningMessage(context, ValidationMessages.UNEXPECTED_ATTRIBUTEVALUE, requiredID, attrName, context.getLocalName(), idString);
                return null;
            }
            return idString;
        }

        private String idFromAttribute(ElementStartContext context, String idAttrName) {
            String idString = context.getAttributeValue(idAttrName);
            if (idString == null) {
                ValidatorImpl.reportWarningMessage(context, ValidationMessages.ATTRIBUTE_IS_REQUIRED, idAttrName, context.getLocalName());
            }
            return idString;
        }

        private static void reportWarningMessage(ElementStartContext context, ValidationMessages messageKey, Object ... arguments) {
            MessageReporter messageReporter = context.getMessageReporter();
            if (messageReporter != null) {
                messageReporter.warning(context.getLocator(), messageKey.getMessage(arguments));
            }
        }

        private int getTimeout() {
            try {
                return Integer.parseInt(System.getProperty("ide.cfu.timeout", "15000"));
            }
            catch (NumberFormatException e) {
                return 15000;
            }
        }

        URI getURI() {
            try {
                return this.bundleUrl.toURI();
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(UpdateBundleValidator.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        }

        private static void close(Closeable resource) {
            if (resource != null) {
                try {
                    resource.close();
                }
                catch (IOException exception) {
                    Logger.getLogger(UpdateBundleValidator.class.getName()).log(Level.SEVERE, null, exception);
                }
            }
        }

        private class ValidationMessageReporter
        implements MessageReporter {
            final Problems problems = new Problems();
            private final StringBuilder stringBuilder = new StringBuilder();

            private ValidationMessageReporter() {
            }

            public void severe(XMLLocator locator, String message, Throwable exception) {
                this.reportProblem(message);
            }

            public void error(XMLLocator locator, String message, Throwable exception) {
                this.reportProblem(message);
            }

            public void warning(XMLLocator locator, String message) {
                this.reportProblem(message);
            }

            public void information(XMLLocator locator, String message) {
            }

            private void addHeader() {
                this.stringBuilder.append(String.format("%s  (%s):", ValidatorImpl.this.updateInfo.toString(), ValidatorImpl.this.bundleUrl));
            }

            private void reportProblem(String message) {
                if (this.stringBuilder.length() == 0) {
                    this.addHeader();
                }
                this.stringBuilder.append(message);
            }

            public void close() {
                if (this.stringBuilder.length() != 0) {
                    this.problems.addDescription(this.stringBuilder.toString());
                }
                this.stringBuilder.setLength(0);
            }
        }
    }

    public static final class Result {
        private final Map<UpdateInfo, Problems> internalResults;

        private Result(Map<UpdateInfo, Problems> internalResults) {
            this.internalResults = internalResults;
        }

        public final boolean isValid() {
            Collection<Problems> instances = this.internalResults.values();
            for (Problems nextInstance : instances) {
                if (!nextInstance.hasProblems()) continue;
                return false;
            }
            return !instances.isEmpty();
        }

        public String toString() {
            Collection<Problems> instances = this.internalResults.values();
            StringBuilder sb = new StringBuilder();
            if (!instances.isEmpty()) {
                for (Problems nextInstance : instances) {
                    if (!nextInstance.hasProblems()) continue;
                    if (sb.length() > 0) {
                        sb.append('\n');
                    }
                    sb.append(nextInstance.toString());
                }
            }
            return sb.toString();
        }
    }
}

