/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.task;

import java.io.File;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.task.AtomicTask;
import oracle.ideimpl.webupdate.task.TaskContext;
import oracle.ideimpl.webupdate.task.TaskFailedException;

final class MoveFile
extends AtomicTask {
    private final File _originalFile;
    private final File _newFile;

    public MoveFile(File originalFile, File newFile) {
        this._originalFile = originalFile;
        this._newFile = newFile;
    }

    @Override
    public void perform(TaskContext tc) throws TaskFailedException {
        if (!this._originalFile.renameTo(this._newFile)) {
            throw new TaskFailedException(UpdateArb.format(166, this._originalFile.getPath(), this._newFile.getPath()));
        }
    }

    @Override
    public void rollback(TaskContext tc) throws TaskFailedException {
        if (!this._newFile.renameTo(this._originalFile)) {
            throw new TaskFailedException(UpdateArb.format(166, this._newFile.getPath(), this._originalFile.getPath()));
        }
    }
}

