/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.uninstall;

import javax.ide.util.Version;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateCategory;
import oracle.ideimpl.webupdate.UpdateInfo;

public class CFUBundlesExtraInfo {
    public static UpdateInfo createFromLineInExtras(String line) {
        UpdateInfo update = null;
        UpdateBundle bundle = null;
        String[] tokens = line.split(",");
        if (tokens.length >= 8) {
            update = new UpdateInfo();
            String id = tokens[0];
            update.setID(id);
            update.setVersion(new Version(tokens[1]));
            update.setName(tokens[2]);
            UpdateCategory cat = new UpdateCategory(tokens[3]);
            cat.setCategory(tokens[4]);
            update.setCategory(cat);
            update.setDescription(tokens[5]);
            update.setAuthor(tokens[6]);
            update.setAuthorURL(tokens[7]);
            bundle = new UpdateBundle();
            bundle.setName(tokens[8]);
            update.setBundle(bundle);
        }
        return update;
    }

    public static String extrasToString(UpdateInfo update) {
        StringBuilder buf = new StringBuilder();
        buf.append("UpdateExtraInfo=");
        buf.append(update.getID());
        buf.append(',');
        buf.append(update.getVersion());
        buf.append(',');
        buf.append(update.getName());
        buf.append(',');
        CFUBundlesExtraInfo.addCategoryInfo(buf, update);
        buf.append(update.getDescription());
        buf.append(',');
        buf.append(update.getAuthor());
        buf.append(',');
        buf.append(update.getAuthorURL());
        buf.append(',');
        if (update.getBundle() != null) {
            buf.append(update.getBundle().getName());
        } else {
            buf.append(update.getName());
        }
        return buf.toString();
    }

    private static void addCategoryInfo(StringBuilder buf, UpdateInfo update) {
        UpdateCategory category = update.getCategory();
        String categoryID = "";
        String categoryName = "";
        if (category != null) {
            categoryID = category.getCategoryId();
            categoryName = category.getCategoryName();
        }
        buf.append(categoryID == null ? "" : categoryID);
        buf.append(',');
        buf.append(categoryName == null ? "Other" : categoryName);
        buf.append(',');
    }
}

