/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.uninstall;

import java.awt.Window;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ide.extension.Extension;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ideimpl.webupdate.Directories;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.UpdateManager;
import oracle.ideimpl.webupdate.uninstall.CFUBundlesExtraInfo;
import oracle.javatools.dialogs.ExceptionDialog;

public class ManageInstalledUpdates {
    private Directories _directories = UpdateManager.getInstance().getDirectories();

    public List<UpdateInfo> getInstalledUpdates() {
        ArrayList<UpdateInfo> installedUpdates = new ArrayList<UpdateInfo>();
        List<String> bundlesInfoFile = this.readBundlesExtrasFile();
        for (String line : bundlesInfoFile) {
            UpdateInfo updateInfo = CFUBundlesExtraInfo.createFromLineInExtras(line);
            if (updateInfo == null || !this.isUpdateInsalled(updateInfo.getID())) continue;
            installedUpdates.add(updateInfo);
        }
        return installedUpdates;
    }

    public List<UpdateInfo> getUpdatesToBeInstalled() {
        ArrayList<UpdateInfo> installedUpdates = new ArrayList<UpdateInfo>();
        List<String> bundlesInfoFile = this.readBundlesExtrasFile();
        for (String line : bundlesInfoFile) {
            UpdateInfo updateInfo = CFUBundlesExtraInfo.createFromLineInExtras(line);
            if (updateInfo == null || !this.isUpdateInsalled(updateInfo.getID())) continue;
            installedUpdates.add(updateInfo);
        }
        return installedUpdates;
    }

    private boolean isUpdateInsalled(String id) {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
        Extension extension = extensionRegistry.findExtension(id);
        return extension != null;
    }

    File findBundlesInfoFile() {
        File file;
        File bundlesHome = new File(this._directories.getBundlesInfoHome());
        if (!bundlesHome.exists()) {
            bundlesHome.mkdirs();
        }
        if (!(file = new File(bundlesHome, "cfu_bundles.extras")).exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                file = null;
            }
        }
        return file;
    }

    private List<String> readBundlesExtrasFile() {
        return this.readPropertyStyleTypeFile(this.findBundlesInfoFile());
    }

    public List<String> readDeferredUpdatesFile() {
        return this.readPropertyStyleTypeFile(UpdateManager.getInstance().getDeferredUpdatesFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readPropertyStyleTypeFile(File bundlesInfoFile) {
        BufferedReader reader = null;
        ArrayList<String> lines = new ArrayList<String>();
        if (bundlesInfoFile != null && bundlesInfoFile.exists()) {
            try {
                String line;
                reader = new BufferedReader(new FileReader(bundlesInfoFile));
                while ((line = reader.readLine()) != null) {
                    lines.add(line);
                }
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return lines;
    }

    public void seedUnInstaller(Set<UpdateInfo> updates) {
        ArrayList<String> uninstallTasks = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        for (UpdateInfo update : updates) {
            buf.setLength(0);
            buf.append("DeinstallExtensionTask=");
            buf.append(update.getID());
            buf.append(',');
            buf.append(update.getVersion().toString());
            uninstallTasks.add(buf.toString());
        }
        this.write(uninstallTasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(List<String> uninstallTasks) {
        UpdateManager.getInstance().getDirectories().save(uninstallTasks);
        File duFile = UpdateManager.getInstance().getDeferredUpdatesFile();
        BufferedWriter writer = null;
        try {
            try {
                writer = new BufferedWriter(new FileWriter(duFile));
                for (String line : uninstallTasks) {
                    writer.write(line);
                    writer.newLine();
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (IOException ioe) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ioe);
        }
    }
}

