/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.uninstall;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionDependency;
import javax.swing.Action;
import oracle.ide.ExtensionRegistry;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.extension.preference.ManageFeaturesPanelListener;
import oracle.ide.extension.preference.ManageFeaturesPanelType;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.uninstall.ManageInstalledUpdates;
import oracle.ideimpl.webupdate.wizard.UpdateItem;
import oracle.ideimpl.webupdate.wizard.UpdatesTreePanel;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ListUtil;

public class ManageUpdatesTreePanel
extends UpdatesTreePanel
implements ManageFeaturesPanelType {
    private static final long serialVersionUID = 1L;
    private ManageInstalledUpdates installedUpdates = new ManageInstalledUpdates();
    private Action completionAction;
    private ManageFeaturesPanelListener panelChangedListener;
    Map<UpdateItem, Set<UpdateItem>> _dependencies;
    Map<String, Set<UpdateItem>> _reverseDependencies;

    public void populate() {
        this.initializeGUI();
        List<UpdateInfo> updates = this.installedUpdates.getInstalledUpdates();
        this.populateUpdates(updates, false);
        this.markForUninstall();
    }

    public void setPanelChangedListener(ManageFeaturesPanelListener listener) {
        this.panelChangedListener = listener;
    }

    @Override
    protected void nodeChanged(JMutableTreeNode node, boolean checked) {
        if (this.panelChangedListener != null) {
            this.panelChangedListener.panelChanged((ManageFeaturesPanelType)this);
        }
    }

    @Override
    protected void completeValueChanged() {
    }

    public Component getFirstFocusComponent() {
        return this;
    }

    public boolean hasChanges() {
        return this.getSelectedUpdates().size() > 0;
    }

    public void makeChanges() {
        List<UpdateInfo> list = this.getSelectedUpdates();
        if (list.size() > 0) {
            HashSet<UpdateInfo> selected = new HashSet<UpdateInfo>(list);
            this.installedUpdates.seedUnInstaller(selected);
            this.markForUninstall();
        }
    }

    private void markForUninstall() {
        List<String> lines = this.installedUpdates.readDeferredUpdatesFile();
        HashSet<String> toBeInstalled = new HashSet<String>();
        for (String line : lines) {
            String[] tokens;
            if (!line.startsWith("DeinstallExtensionTask=") || (tokens = line.substring("DeinstallExtensionTask=".length()).split(",")).length < 2) continue;
            String id = tokens[0];
            toBeInstalled.add(id);
        }
        Map<UpdateInfo, UpdateItem> infos = this.getMapOfUpdateInfos();
        for (UpdateItem item : infos.values()) {
            UpdateInfo ui = item.getUpdate();
            if (ui == null || !toBeInstalled.contains(ui.getID())) continue;
            item.setSelected(true);
        }
        this.refreshTree();
    }

    @Override
    protected void updateDependencies(UpdateItem item) {
        if (item.isSelected()) {
            this.initializeReverseDependencieCache();
            Set<UpdateItem> set = this._reverseDependencies.get(item.getUpdate().getID());
            if (set != null && !set.isEmpty()) {
                HashSet<UpdateItem> dependees = new HashSet<UpdateItem>(set);
                Iterator i = dependees.iterator();
                while (i.hasNext()) {
                    UpdateItem d = (UpdateItem)i.next();
                    if (!d.isSelected()) continue;
                    i.remove();
                }
                if (dependees.isEmpty()) {
                    return;
                }
                if (this.confirmInstallDepedencies(item.getUpdate().getID(), dependees, false)) {
                    for (UpdateItem requiredItem : dependees) {
                        requiredItem.setSelected(true);
                    }
                } else {
                    item.setSelected(false);
                }
            }
        } else {
            this.initinalDependenciesCache();
            Set<UpdateItem> prerequisites = this._dependencies.get(item);
            if (prerequisites != null) {
                ArrayList<String> deps = new ArrayList<String>();
                for (UpdateItem dependee : prerequisites) {
                    if (!dependee.isSelected()) continue;
                    deps.add(dependee.getUpdate().getID());
                }
                if (deps.size() > 0) {
                    boolean ok = MessageDialog.confirm((Component)this, (Object)UpdateArb.format(55, item.getUpdate().getName(), ListUtil.join(deps, (String)"\n")), (String)UpdateArb.getString(54), null);
                    if (ok) {
                        for (UpdateItem pre : prerequisites) {
                            pre.setSelected(false);
                        }
                    } else {
                        item.setSelected(true);
                    }
                }
            }
        }
    }

    private void initinalDependenciesCache() {
        ExtensionRegistry reg = ExtensionRegistry.getExtensionRegistry();
        if (this._dependencies == null) {
            this._dependencies = new HashMap<UpdateItem, Set<UpdateItem>>();
            Set<String> installedIDs = this.getInstalledIDs();
            Collection<UpdateItem> updates = this.getMapOfUpdateInfos().values();
            for (UpdateItem item : updates) {
                Extension extension = reg.findExtension(item.getUpdate().getID());
                Collection dependencies = extension.getDependencies();
                for (ExtensionDependency d : dependencies) {
                    String id = d.getID();
                    if (!installedIDs.contains(id)) continue;
                    Set<UpdateItem> set = this._dependencies.get(item);
                    if (set == null) {
                        set = new HashSet<UpdateItem>();
                        this._dependencies.put(item, set);
                    }
                    set.add(this.getUpdateItem(id));
                }
            }
        }
    }

    private UpdateItem getUpdateItem(String id) {
        for (UpdateItem item : this.getMapOfUpdateInfos().values()) {
            if (!item.getUpdate().getID().equals(id)) continue;
            return item;
        }
        return null;
    }

    private void initializeReverseDependencieCache() {
        ExtensionRegistry reg = ExtensionRegistry.getExtensionRegistry();
        if (this._reverseDependencies == null) {
            this._reverseDependencies = new HashMap<String, Set<UpdateItem>>();
            Set<String> installedIDs = this.getInstalledIDs();
            if (!installedIDs.isEmpty()) {
                Collection<UpdateItem> updates = this.getMapOfUpdateInfos().values();
                for (UpdateItem u : updates) {
                    Extension extension = reg.findExtension(u.getUpdate().getID());
                    Collection dependencies = extension.getDependencies();
                    for (ExtensionDependency ed : dependencies) {
                        String dependency = ed.getID();
                        if (!installedIDs.contains(dependency)) continue;
                        Set<UpdateItem> myDependencies = this._reverseDependencies.get(dependency);
                        if (myDependencies == null) {
                            myDependencies = new HashSet<UpdateItem>();
                            this._reverseDependencies.put(dependency, myDependencies);
                        }
                        myDependencies.add(u);
                    }
                }
            }
        }
    }

    private Set<String> getInstalledIDs() {
        Collection<UpdateItem> updates = this.getMapOfUpdateInfos().values();
        HashSet<String> installedIDs = new HashSet<String>();
        for (UpdateItem u : updates) {
            installedIDs.add(u.getUpdate().getID());
        }
        return installedIDs;
    }
}

