/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.wizard;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.UpdateManager;
import oracle.ideimpl.webupdate.commandline.PreInstaller;
import oracle.ideimpl.webupdate.wizard.DownloadLocationPage;
import oracle.ideimpl.webupdate.wizard.DownloadPage;
import oracle.ideimpl.webupdate.wizard.SummaryPage;
import oracle.ideimpl.webupdate.wizard.UpdateLicensePage;
import oracle.ideimpl.webupdate.wizard.UpdatePage;
import oracle.ideimpl.webupdate.wizard.UpdateSourcePage;
import oracle.ideimpl.webupdate.wizard.UpdateWizardModel;
import oracle.javatools.dialogs.MessageDialog;

public final class UpdateWizard {
    static final String STATE_SOURCE = "source";
    static final String STATE_UPDATE = "update";
    static final String STATE_LICENSE = "license";
    static final String STATE_DOWNLOAD_LOCATION = "downloadLocation";
    static final String STATE_DOWNLOAD = "download";
    static final String STATE_SUMMARY = "summary";
    static final String KEY_MODEL = "updateWizardModel";
    static final String TRANS_UPDATES_TO_DOWNLOAD = "updatesToDownload";
    static final String TRANS_UPDATES_TO_DL_LOC = "updatesToDlLocation";
    static final String TRANS_UPDATES_TO_LICENSE = "updatesToLicense";
    static final String TRANS_UPDATES_TO_SUMMARY = "updatesToSummary";
    static final String TRANS_LICENSE_TO_DL_LOC = "licenseToDlLocation";
    static final String TRANS_LICENSE_TO_DOWNLOAD = "licenseToDownload";
    static final String TRANS_LICENSE_TO_SUMMARY = "licenseToSummary";
    static final String TRANS_SOURCE_TO_LICENSE = "sourceToLicence";
    static final String TRANS_SOURCE_TO_DL_LOC = "sourceToDlLocation";
    static final String TRANS_SOURCE_TO_SUMMARY = "sourceToSummary";
    static final String TRANS_SOURCE_TO_UPDATES = "sourceToUpdates";
    static final String TRANS_DL_LOC_TO_SUMMARY = "dlLocationToSummary";
    private UpdateManager m_updateManager;
    private FSMWizard _wizard;
    private UpdateWizardModel m_model;
    private PreInstaller preInstaller;

    public UpdateWizard(UpdateManager um) {
        this.m_updateManager = um;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runWizard(Component parent, Context context) {
        WizardDialog wd;
        UpdateManager.getInstance().getAutomaticCheckForUpdates().uninstallNotificationIcon();
        if (UpdateManager.getInstance().getDeferredUpdatesFile().exists() && !MessageDialog.confirm((Component)parent, (Object)UpdateArb.format(88, Ide.getProgramShortName()), (String)UpdateArb.getString(87), null)) {
            return false;
        }
        List masterServers = context == null ? null : (List)context.getProperty("autoCfuMasterList");
        boolean showDlLoc = !UpdateManager.getInstance().isSingleUserMode() && UpdateManager.getInstance().isGlobalExtensionInstallationAllowed();
        FSMBuilder fsmBuilder = new FSMBuilder();
        Step step = new Step(UpdateArb.getString(108), UpdateSourcePage.class, "f1_idewideupdatesource_html");
        step.setStepLabel(UpdateArb.getString(109));
        fsmBuilder.newStartState(step, (Object)STATE_UPDATE);
        fsmBuilder.addStateTrans((Object)TRANS_SOURCE_TO_DL_LOC, (Object)STATE_DOWNLOAD_LOCATION);
        fsmBuilder.addStateTrans((Object)TRANS_SOURCE_TO_LICENSE, (Object)STATE_LICENSE);
        fsmBuilder.addStateTrans((Object)TRANS_SOURCE_TO_SUMMARY, (Object)STATE_SUMMARY);
        fsmBuilder.addStateTrans((Object)TRANS_SOURCE_TO_UPDATES, (Object)STATE_UPDATE);
        step = new Step(UpdateArb.getString(8), UpdatePage.class, "f1_idewideupdateupdates_html");
        step.setStepLabel(UpdateArb.getString(9));
        fsmBuilder.newState((Object)STATE_UPDATE, step, (Object)(showDlLoc ? STATE_DOWNLOAD_LOCATION : STATE_DOWNLOAD));
        fsmBuilder.addStateTrans((Object)TRANS_UPDATES_TO_DL_LOC, (Object)STATE_DOWNLOAD_LOCATION);
        fsmBuilder.addStateTrans((Object)TRANS_UPDATES_TO_DOWNLOAD, (Object)STATE_DOWNLOAD);
        fsmBuilder.addStateTrans((Object)TRANS_UPDATES_TO_LICENSE, (Object)STATE_LICENSE);
        fsmBuilder.addStateTrans((Object)TRANS_UPDATES_TO_SUMMARY, (Object)STATE_SUMMARY);
        step = new Step(UpdateArb.getString(157), UpdateLicensePage.class, "f1_idewideupdatelicense_html");
        fsmBuilder.newState((Object)STATE_LICENSE, step, (Object)(showDlLoc ? STATE_DOWNLOAD_LOCATION : STATE_DOWNLOAD));
        fsmBuilder.addStateTrans((Object)TRANS_LICENSE_TO_DL_LOC, (Object)STATE_DOWNLOAD_LOCATION);
        fsmBuilder.addStateTrans((Object)TRANS_LICENSE_TO_DOWNLOAD, (Object)STATE_DOWNLOAD);
        fsmBuilder.addStateTrans((Object)TRANS_LICENSE_TO_SUMMARY, (Object)STATE_SUMMARY);
        step = new Step(UpdateArb.getString(30), DownloadLocationPage.class, "f1_idewideupdatedownloadlocation_html");
        fsmBuilder.newState((Object)STATE_DOWNLOAD_LOCATION, step, (Object)STATE_DOWNLOAD);
        fsmBuilder.addStateTrans((Object)TRANS_DL_LOC_TO_SUMMARY, (Object)STATE_SUMMARY);
        step = new Step(UpdateArb.getString(35), DownloadPage.class, "f1_idewideupdatedownload_html");
        fsmBuilder.newState((Object)STATE_DOWNLOAD, step, (Object)STATE_SUMMARY);
        step = new Step(UpdateArb.getString(45), SummaryPage.class, "f1_idewideupdatesummary_html");
        fsmBuilder.newFinalState((Object)STATE_SUMMARY, step);
        FSM stateMachine = fsmBuilder.getFSM();
        Namespace ns = new Namespace();
        this.m_model = new UpdateWizardModel(this.getUpdateManager());
        if (context != null) {
            Object object = context.getProperty("extensionId");
            if (object != null && object instanceof String) {
                String extensionID = (String)object;
                this.m_model.setRequestedExtensionID(extensionID);
            } else {
                object = context.getProperty("extensionIds");
                if (object != null && object instanceof Collection) {
                    Collection extensionIDs = (Collection)object;
                    this.m_model.setRequestedExtensionIDs(extensionIDs);
                }
            }
        }
        this.preInstaller = PreInstaller.createUpdateWizardInstaller(this.m_model, this.m_updateManager);
        if (masterServers != null) {
            this.m_model.setForcedCenters(masterServers);
        }
        ns.put(KEY_MODEL, (Object)this.m_model);
        this._wizard = new FSMWizard(stateMachine, ns);
        this._wizard.setDefaultWizardSize(1);
        this._wizard.setWelcomePageAdded(false);
        this._wizard.setFinishPageAdded(true);
        this._wizard.setWizardTitle(UpdateArb.getString(3));
        this._wizard.setShowStepNumber(true);
        this._wizard.setLogoImage(new ImageIcon(UpdateWizard.class.getResource("wizard.png")).getImage());
        Dialog dlg = DialogUtil.getAncestorDialog((Component)parent);
        if (dlg != null) {
            wd = this._wizard.getDialog(dlg);
        } else {
            Frame f = DialogUtil.getAncestorFrame((Component)parent);
            wd = this._wizard.getDialog(f);
        }
        this._wizard.addCommitListener(new CommitListener(){

            public void checkCommit(ApplyEvent event) throws TraversalException {
            }

            public void commit(ApplyEvent event) throws TraversalException {
                UpdateWizard.this.commit();
            }

            public void rollback(ApplyEvent event) {
            }

            public void cancel(ApplyEvent event) {
                UpdateWizard.this.getModel().setWizardCancelled(true);
            }
        });
        try {
            boolean bl = WizardLauncher.runDialog((JDialog)wd);
            this._wizard = null;
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this._wizard = null;
                throw throwable;
            }
            catch (FSMInvalidException fie) {
                fie.printStackTrace();
                assert (false) : "Unexpected FSMInvalidException";
                return false;
            }
        }
    }

    boolean isDisposed() {
        return this._wizard == null || this._wizard.isDisposed();
    }

    private File getInstallHookFile() {
        String homeDir = Ide.getOracleHomeDirectory();
        return new File(homeDir, "installhooks.properties");
    }

    private void commit() {
        this.preInstaller.commit();
    }

    UpdateWizardModel getModel() {
        return this.m_model;
    }

    private UpdateManager getUpdateManager() {
        return this.m_updateManager;
    }
}

