/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.technology;

import java.net.URI;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.extension.ExtensionHook;
import javax.ide.util.MetaClass;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.feature.Feature;
import oracle.ide.extension.feature.FeatureRegistry;
import oracle.ide.model.TechId;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Assert;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.model.JDevTechnologyInfo;
import oracle.jdeveloper.model.JDevTechnologyRegistry;

public class TechnologyHookHandler
extends ExtensionHook {
    static final String nsURI = "http://xmlns.oracle.com/ide/extension";
    public static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "technology-hook");
    private ArrayList<TechnologyHookData> hookDataList_ = new ArrayList();
    private boolean ranOnce_ = false;
    private TechnologyHandler techHandler = new TechnologyHandler();
    private static final String HOOK_DATA = "hook-data";
    private static final String HOOK_DATA_LIST = "hook-data-list";

    public void start(ElementStartContext context) {
        context.registerChildVisitor(TechnologyHandler.ELEMENT_NAME, (ElementVisitor)this.techHandler);
        context.getScopeData().put(HOOK_DATA_LIST, this.hookDataList_);
    }

    public synchronized void registerTechnologies() {
        if (this.ranOnce_) {
            return;
        }
        this.ranOnce_ = true;
        TechnologyRegistry reg = TechnologyRegistry.getInstance();
        for (TechnologyHookData thd : this.hookDataList_) {
            TechId techId = reg.getTechId(thd.key_);
            Assert.check((techId != null ? 1 : 0) != 0);
            if (thd.dependencies_ != null) {
                for (String depKey : thd.dependencies_) {
                    TechId depTechId = reg.getTechId(depKey);
                    if (depTechId == null) {
                        String msg = "Dependency " + depKey + " not found. Coming from hook " + thd.extURI_;
                        Assert.fail((String)msg);
                        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
                        Logger logger = extensionRegistry.getLogger();
                        logger.log(Level.SEVERE, msg);
                        continue;
                    }
                    techId.addDependency(depTechId);
                }
            }
            JDevTechnologyInfo tInfo = new JDevTechnologyInfo(techId, null, null, null);
            if (thd.traversables_ != null) {
                int size = thd.traversables_.size();
                tInfo.setWizardPanels(thd.traversables_.toArray(new MetaClass[size]));
            }
            if (thd.libraries_ != null) {
                tInfo.setLibraries(thd.libraries_.toArray(new JDevTechnologyInfo.LibraryInfo[thd.libraries_.size()]));
            }
            if (thd.generatedFiles_ != null) {
                tInfo.setGeneratedFiles(thd.generatedFiles_.toArray(new JDevTechnologyInfo.GeneratedFileInfo[thd.generatedFiles_.size()]));
            }
            JDevTechnologyRegistry.getInstance().registerTechnologyInfo(tInfo);
        }
    }

    static class FileVisitorFactory
    extends ElementVisitor
    implements ElementVisitorFactory {
        static final ElementName NAME_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "name");
        static final ElementName PATH_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "path");
        static final ElementName TYPE_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "type");
        static final ElementName DESC_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "description");

        FileVisitorFactory() {
        }

        public ElementVisitor getVisitor(ElementName name) {
            return this;
        }

        public void start(ElementStartContext context) {
            JDevTechnologyInfo.GeneratedFileInfo genFile = (JDevTechnologyInfo.GeneratedFileInfo)context.getScopeData().get("FileHandler.GENERATED_FILE");
            Assert.check((genFile != null ? 1 : 0) != 0);
            ElementName element = context.getElementName();
            if (element.equals((Object)NAME_ELEMENT)) {
                boolean value = Boolean.parseBoolean(context.getAttributeValue("prompt"));
                genFile.setPromptForName(value);
            } else if (element.equals((Object)PATH_ELEMENT)) {
                boolean value = Boolean.parseBoolean(context.getAttributeValue("prompt"));
                genFile.setPromptForName(value);
            } else if (!element.equals((Object)TYPE_ELEMENT) && !element.equals((Object)DESC_ELEMENT)) {
                this.log((ElementContext)context, Level.SEVERE, "Unrecognized child element in <file>: " + element);
            }
        }

        public void end(ElementEndContext context) {
            JDevTechnologyInfo.GeneratedFileInfo genFile = (JDevTechnologyInfo.GeneratedFileInfo)context.getScopeData().get("FileHandler.GENERATED_FILE");
            Assert.check((genFile != null ? 1 : 0) != 0);
            ElementName element = context.getElementName();
            if (element.equals((Object)NAME_ELEMENT)) {
                genFile.setName(context.getText());
            } else if (element.equals((Object)PATH_ELEMENT)) {
                genFile.setPath(context.getText());
            } else if (element.equals((Object)TYPE_ELEMENT)) {
                genFile.setFileType(context.getText());
            } else if (element.equals((Object)DESC_ELEMENT)) {
                genFile.setDescription(context.getText());
            }
        }
    }

    static class FileHandler
    extends ElementVisitor {
        static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "file");
        static final String GENERATED_FILE = "FileHandler.GENERATED_FILE";
        static final FileVisitorFactory fileVisitorFactory = new FileVisitorFactory();

        FileHandler() {
        }

        public void start(ElementStartContext context) {
            JDevTechnologyInfo.GeneratedFileInfo genFile = new JDevTechnologyInfo.GeneratedFileInfo();
            context.getScopeData().put(GENERATED_FILE, genFile);
            context.registerVisitorFactory((ElementVisitorFactory)fileVisitorFactory);
        }

        public void end(ElementEndContext context) {
            TechnologyHookData hookData = (TechnologyHookData)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA);
            JDevTechnologyInfo.GeneratedFileInfo genFile = (JDevTechnologyInfo.GeneratedFileInfo)context.getScopeData().get(GENERATED_FILE);
            hookData.generatedFiles_.add(genFile);
        }
    }

    static class GeneratedFilesHandler
    extends ElementVisitor {
        static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "generated-files");
        private FileHandler fileHandler = new FileHandler();

        GeneratedFilesHandler() {
        }

        public void start(ElementStartContext context) {
            TechnologyHookData hookData = (TechnologyHookData)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA);
            hookData.generatedFiles_ = new ArrayList();
            context.registerChildVisitor(FileHandler.ELEMENT_NAME, (ElementVisitor)this.fileHandler);
        }

        public void end(ElementEndContext context) {
            TechnologyHookData hookData = (TechnologyHookData)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA);
            if (hookData.generatedFiles_.size() == 0) {
                hookData.generatedFiles_ = null;
            }
        }
    }

    static class TraversableClassHandler
    extends ElementVisitor {
        static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "traversable-class");

        TraversableClassHandler() {
        }

        public void end(ElementEndContext context) {
            String clazz = context.getText();
            if (ModelUtil.hasLength((String)clazz)) {
                TechnologyHookData hookData = (TechnologyHookData)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA);
                MetaClass mct = new MetaClass(ElementVisitor.getClassLoader((ElementContext)context), clazz);
                hookData.traversables_.add((MetaClass<Traversable>)mct);
            }
        }
    }

    static class TechKeyHandler
    extends ElementVisitor {
        static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "key");

        TechKeyHandler() {
        }

        public void end(ElementEndContext context) {
            String techKey = context.getText();
            if (ModelUtil.hasLength((String)techKey)) {
                TechnologyHookData hookData = (TechnologyHookData)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA);
                hookData.dependencies_.add(techKey);
            }
        }
    }

    static class PageHandler
    extends ElementVisitor {
        static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "page");
        private TraversableClassHandler tcHandler = new TraversableClassHandler();

        PageHandler() {
        }

        public void start(ElementStartContext context) {
            context.registerChildVisitor(TraversableClassHandler.ELEMENT_NAME, (ElementVisitor)this.tcHandler);
        }
    }

    static class WizPageHandler
    extends ElementVisitor {
        static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "wizard-pages");
        private PageHandler pageHandler = new PageHandler();

        WizPageHandler() {
        }

        public void start(ElementStartContext context) {
            TechnologyHookData hookData = (TechnologyHookData)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA);
            hookData.traversables_ = new ArrayList();
            context.registerChildVisitor(PageHandler.ELEMENT_NAME, (ElementVisitor)this.pageHandler);
        }

        public void end(ElementEndContext context) {
            TechnologyHookData hookData = (TechnologyHookData)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA);
            if (hookData.traversables_.size() == 0) {
                hookData.traversables_ = null;
            }
        }
    }

    static class LibVisitorFactory
    extends ElementVisitor
    implements ElementVisitorFactory {
        static final ElementName NAME_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "name");
        static final ElementName DESC_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "description");

        LibVisitorFactory() {
        }

        public ElementVisitor getVisitor(ElementName name) {
            return this;
        }

        public void end(ElementEndContext context) {
            JDevTechnologyInfo.LibraryInfo libInfo = (JDevTechnologyInfo.LibraryInfo)context.getScopeData().get("LibHandler.ASSOCIATED_LIBRARY");
            Assert.check((libInfo != null ? 1 : 0) != 0);
            ElementName element = context.getElementName();
            if (element.equals((Object)NAME_ELEMENT)) {
                libInfo.setName(context.getText());
            } else if (element.equals((Object)DESC_ELEMENT)) {
                libInfo.setDescription(context.getText());
            } else {
                this.log((ElementContext)context, Level.SEVERE, "Unrecognized child element in <library>: " + element);
            }
        }
    }

    static class LibHandler
    extends ElementVisitor {
        static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "library");
        static final String ASSOCIATED_LIBRARY = "LibHandler.ASSOCIATED_LIBRARY";
        static final LibVisitorFactory libVisitorFactory = new LibVisitorFactory();

        LibHandler() {
        }

        public void start(ElementStartContext context) {
            JDevTechnologyInfo.LibraryInfo libInfo = new JDevTechnologyInfo.LibraryInfo();
            context.getScopeData().put(ASSOCIATED_LIBRARY, libInfo);
            context.registerVisitorFactory((ElementVisitorFactory)libVisitorFactory);
        }

        public void end(ElementEndContext context) {
            TechnologyHookData hookData = (TechnologyHookData)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA);
            JDevTechnologyInfo.LibraryInfo libInfo = (JDevTechnologyInfo.LibraryInfo)context.getScopeData().get(ASSOCIATED_LIBRARY);
            hookData.libraries_.add(libInfo);
        }
    }

    static class LibrariesHandler
    extends ElementVisitor {
        static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "library-dependencies");
        private LibHandler libHandler = new LibHandler();

        LibrariesHandler() {
        }

        public void start(ElementStartContext context) {
            TechnologyHookData hookData = (TechnologyHookData)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA);
            hookData.libraries_ = new ArrayList();
            context.registerChildVisitor(LibHandler.ELEMENT_NAME, (ElementVisitor)this.libHandler);
        }

        public void end(ElementEndContext context) {
            TechnologyHookData hookData = (TechnologyHookData)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA);
            if (hookData.libraries_.size() == 0) {
                hookData.libraries_ = null;
            }
        }
    }

    static class TechDepHandler
    extends ElementVisitor {
        static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "technology-dependencies");
        private TechKeyHandler depKeyHandler = new TechKeyHandler();

        TechDepHandler() {
        }

        public void start(ElementStartContext context) {
            TechnologyHookData hookData = (TechnologyHookData)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA);
            hookData.dependencies_ = new ArrayList();
            context.registerChildVisitor(TechKeyHandler.ELEMENT_NAME, (ElementVisitor)this.depKeyHandler);
        }

        public void end(ElementEndContext context) {
            TechnologyHookData hookData = (TechnologyHookData)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA);
            if (hookData.dependencies_.size() == 0) {
                hookData.dependencies_ = null;
            }
        }
    }

    static class DescHandler
    extends ElementVisitor {
        static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "description");

        DescHandler() {
        }

        public void end(ElementEndContext context) {
            TechnologyHookData hookData = (TechnologyHookData)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA);
            hookData.desc_ = context.getText();
        }
    }

    static class NameHandler
    extends ElementVisitor {
        static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "name");

        NameHandler() {
        }

        public void end(ElementEndContext context) {
            TechnologyHookData hookData = (TechnologyHookData)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA);
            hookData.name_ = context.getText();
        }
    }

    static class KeyHandler
    extends ElementVisitor {
        static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "key");

        KeyHandler() {
        }

        public void end(ElementEndContext context) {
            TechnologyHookData hookData = (TechnologyHookData)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA);
            hookData.key_ = context.getText();
        }
    }

    static class TechnologyHandler
    extends ElementVisitor {
        static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "technology");
        private KeyHandler keyHandler_ = new KeyHandler();
        private NameHandler nameHandler_ = new NameHandler();
        private DescHandler descHandler_ = new DescHandler();
        private TechDepHandler techDepHandler_ = new TechDepHandler();
        private WizPageHandler wizPageHandler_ = new WizPageHandler();
        private LibrariesHandler libDepHandler_ = new LibrariesHandler();
        private GeneratedFilesHandler genFileHandler_ = new GeneratedFilesHandler();

        TechnologyHandler() {
        }

        public void start(ElementStartContext context) {
            context.registerChildVisitor(KeyHandler.ELEMENT_NAME, (ElementVisitor)this.keyHandler_);
            context.registerChildVisitor(NameHandler.ELEMENT_NAME, (ElementVisitor)this.nameHandler_);
            context.registerChildVisitor(DescHandler.ELEMENT_NAME, (ElementVisitor)this.descHandler_);
            context.registerChildVisitor(TechDepHandler.ELEMENT_NAME, (ElementVisitor)this.techDepHandler_);
            context.registerChildVisitor(LibrariesHandler.ELEMENT_NAME, (ElementVisitor)this.libDepHandler_);
            context.registerChildVisitor(WizPageHandler.ELEMENT_NAME, (ElementVisitor)this.wizPageHandler_);
            context.registerChildVisitor(GeneratedFilesHandler.ELEMENT_NAME, (ElementVisitor)this.genFileHandler_);
            TechnologyHookData thd = new TechnologyHookData();
            thd.extURI_ = context.getExtensionSourceURI();
            context.getScopeData().put(TechnologyHookHandler.HOOK_DATA, thd);
            String obsoleteAttr = this.getAttributeHelper(context, "obsolete", true, false);
            if ("true".equals(obsoleteAttr)) {
                thd.obsolete_ = true;
            }
        }

        public void end(ElementEndContext context) {
            TechnologyHookData hookData = (TechnologyHookData)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA);
            ArrayList hookDataList = (ArrayList)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA_LIST);
            if (hookData.key_ != null) {
                FeatureRegistry featureRegistry = ExtensionRegistry.getExtensionRegistry().getFeatureRegistry();
                Feature feature = featureRegistry.getFeatureAssociatedWithTechnology(hookData.key_);
                if (feature == null) {
                    if (!hookData.obsolete_) {
                        this.log((ElementContext)context, Level.WARNING, "<technology> with key '" + hookData.key_ + "' is not associated with a <feature>.");
                    }
                } else if (hookData.obsolete_) {
                    this.log((ElementContext)context, Level.WARNING, "<technology> with key '" + hookData.key_ + "' is marked as obsolete, but is still associated with a <feature>.");
                }
                TechnologyRegistry techReg = TechnologyRegistry.getInstance();
                techReg.registerTechnology(hookData.key_, hookData.name_, hookData.desc_, context.getExtension().getID(), hookData.obsolete_);
                hookDataList.add(hookData);
            } else {
                this.log((ElementContext)context, Level.SEVERE, "<technology> element missing required child <key>");
            }
        }
    }

    static class TechnologyHookData {
        String key_;
        String name_;
        String desc_;
        ArrayList<String> dependencies_;
        ArrayList<MetaClass<Traversable>> traversables_;
        ArrayList<JDevTechnologyInfo.LibraryInfo> libraries_;
        ArrayList<JDevTechnologyInfo.GeneratedFileInfo> generatedFiles_;
        URI extURI_;
        boolean obsolete_ = false;

        TechnologyHookData() {
        }
    }
}

