/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.addin;

import java.io.File;
import java.net.URL;
import java.util.Map;
import oracle.bali.xml.addin.XMLEditorOptions;
import oracle.bali.xml.addin.XMLEditorOptionsPrefs;
import oracle.ide.config.IdeSettingsMigrator;
import oracle.ide.config.Preferences;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.marshal.xml.Object2DomLogger;
import oracle.ide.migration.MigrationManager;
import oracle.ide.migration.Migrator;
import oracle.ide.net.URLFactory;
import oracle.ide.util.Assert;
import oracle.javatools.data.PropertyStorage;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.xml.sax.SAXParseException;

public final class XMLEditorOptionsPrefsMigrator
implements Migrator {
    public static final int XMLEDITOR_SETTINGS = 0;
    private static final String _NOTSPECIFIED_EXT = ".notspecified";

    public int[] getMigrationCategories() {
        return new int[]{0};
    }

    public String getDescription(int category) {
        return null;
    }

    public boolean canMigrate(int category, File sourceDir) {
        return false;
    }

    public void setSelected(int category, boolean selected) {
    }

    public boolean isSelected(int category) {
        return false;
    }

    public String[] migrate(File sourceDir, File destDir) {
        MigrationManager mm = MigrationManager.getMigrationManager();
        Migrator settings = mm.getMigrator(IdeSettingsMigrator.class);
        if (settings != null && settings.isSelected(0)) {
            try {
                this._updateSettings(this.getSourceFile(sourceDir));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return null;
    }

    protected File getSourceFile(File sourceDir) {
        File file = new File(sourceDir, "preferences.xml");
        if (!file.exists()) {
            file = new File(sourceDir, "settings.xml");
        }
        return file;
    }

    private void _updateSettings(File srcFile) {
        URL url = URLFactory.newFileURL((File)srcFile);
        Object2Dom o2d = Object2Dom.newInstance();
        Map map = null;
        try {
            NullLogger logger = new NullLogger();
            o2d.setLogger(2, (Object2DomLogger)logger);
            map = (Map)o2d.toObject(url, XMLEditorOptionsPrefsMigrator.class.getClassLoader());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (map == null) {
            return;
        }
        XMLEditorOptions options = (XMLEditorOptions)map.get(XMLEditorOptions.KEY_SETTINGS);
        if (options != null) {
            XMLEditorOptionsPrefs xmlEditorOptionsPrefs = XMLEditorOptionsPrefs.getInstance((PropertyStorage)Preferences.getPreferences());
            xmlEditorOptionsPrefs.setEndTagCompletion(options.getEndTagCompletion());
            xmlEditorOptionsPrefs.setRequiredAttributeInsertion(options.getRequiredAttributeInsertion());
            xmlEditorOptionsPrefs.setShowErrors(options.getShowErrors());
            xmlEditorOptionsPrefs.setSmartIndent(options.getSmartIndent());
        }
    }

    private static final class NullLogger
    implements Object2DomLogger {
        private NullLogger() {
        }

        public void logXMLParseException(XMLParseException e) {
            Assert.println((String)e.getLocalizedMessage());
        }

        public void logSAXParseException(SAXParseException e) {
            Assert.println((String)e.getLocalizedMessage());
        }

        public void logUnmarshalException(int line, int col, Throwable t) {
            Assert.println((String)t.getLocalizedMessage());
        }

        public void logOtherException(Throwable t) {
            Assert.println((String)t.getLocalizedMessage());
        }

        public void logMessage(String mesg) {
            Assert.println((String)mesg);
        }

        public void logXMLDocument(XMLDocument document) {
        }
    }
}

