/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.addin.schema;

import java.io.File;
import java.net.URL;
import java.util.Map;
import oracle.bali.xml.addin.SchemaRegistryAddin;
import oracle.bali.xml.addin.schema.MapSchema;
import oracle.bali.xml.addin.schema.SchemaMap;
import oracle.bali.xml.addin.schema.SchemaOptions;
import oracle.bali.xml.addin.schema.SchemaOptionsPrefs;
import oracle.ide.config.IdeSettingsMigrator;
import oracle.ide.config.Preferences;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.marshal.xml.Object2DomLogger;
import oracle.ide.migration.MigrationManager;
import oracle.ide.migration.Migrator;
import oracle.ide.net.URLFactory;
import oracle.ide.util.Assert;
import oracle.javatools.data.PropertyStorage;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.xml.sax.SAXParseException;

public final class SchemaMigrator
implements Migrator {
    public static final int SCHEMA_SETTINGS = 0;
    private static final String _NOTSPECIFIED_EXT = ".notspecified";

    public int[] getMigrationCategories() {
        return new int[]{0};
    }

    public String getDescription(int category) {
        return null;
    }

    public boolean canMigrate(int category, File sourceDir) {
        return false;
    }

    public void setSelected(int category, boolean selected) {
    }

    public boolean isSelected(int category) {
        return false;
    }

    public String[] migrate(File sourceDir, File destDir) {
        MigrationManager mm = MigrationManager.getMigrationManager();
        Migrator settings = mm.getMigrator(IdeSettingsMigrator.class);
        if (settings != null && settings.isSelected(0)) {
            try {
                this._updateSettings(this.getSourceFile(sourceDir));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return null;
    }

    protected File getSourceFile(File sourceDir) {
        File file = new File(sourceDir, "preferences.xml");
        if (!file.exists()) {
            file = new File(sourceDir, "settings.xml");
        }
        return file;
    }

    private void _updateSettings(File srcFile) {
        URL url = URLFactory.newFileURL((File)srcFile);
        Object2Dom o2d = Object2Dom.newInstance();
        Map map = null;
        try {
            NullLogger logger = new NullLogger();
            o2d.setLogger(2, (Object2DomLogger)logger);
            map = (Map)o2d.toObject(url, SchemaMigrator.class.getClassLoader());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (map == null) {
            return;
        }
        SchemaOptions options = (SchemaOptions)map.get(SchemaOptions.KEY_SETTINGS);
        if (options != null) {
            SchemaMap sm = options.getSchemas();
            for (MapSchema toCheck : sm.getSchemas()) {
                if (!toCheck.isUserDefined()) {
                    sm.remove(toCheck.getURL(), toCheck.getExtension(), toCheck.isUserDefined());
                    continue;
                }
                if (!_NOTSPECIFIED_EXT.equals(toCheck.getExtension())) continue;
                sm.remove(toCheck.getURL(), toCheck.getExtension(), toCheck.isUserDefined());
                sm.put(toCheck.getURL(), ".xml", toCheck.isUserDefined());
            }
            SchemaOptionsPrefs schemaPrefs = SchemaOptionsPrefs.getInstance((PropertyStorage)Preferences.getPreferences());
            SchemaRegistryAddin.setSchemaMap(sm, schemaPrefs);
        }
    }

    private static final class NullLogger
    implements Object2DomLogger {
        private NullLogger() {
        }

        public void logXMLParseException(XMLParseException e) {
            Assert.println((String)e.getLocalizedMessage());
        }

        public void logSAXParseException(SAXParseException e) {
            Assert.println((String)e.getLocalizedMessage());
        }

        public void logUnmarshalException(int line, int col, Throwable t) {
            Assert.println((String)t.getLocalizedMessage());
        }

        public void logOtherException(Throwable t) {
            Assert.println((String)t.getLocalizedMessage());
        }

        public void logMessage(String mesg) {
            Assert.println((String)mesg);
        }

        public void logXMLDocument(XMLDocument document) {
        }
    }
}

