/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.ceditor;

import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import oracle.bali.xml.dom.buffer.DocumentScannerFactory;
import oracle.bali.xml.editor.insight.XMLCompletionInsightProvider;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.ceditor.CodeEditorDropHandler;
import oracle.bali.xml.gui.jdev.ceditor.CodeEditorSelectionListener;
import oracle.bali.xml.gui.jdev.ceditor.JDevTextSelectionSynchronizer;
import oracle.bali.xml.gui.jdev.ceditor.ToggleCommentPlugin;
import oracle.bali.xml.gui.jdev.ceditor.XmlBrowseClickPlugin;
import oracle.bali.xml.gui.jdev.ceditor.XmlEditorPeekPlugin;
import oracle.bali.xml.gui.jdev.ceditor.XmlTintPlugin;
import oracle.bali.xml.gui.jdev.ceditor.XmlToolbarPlugin;
import oracle.bali.xml.gui.jdev.ceditor.breadcrumbs.XMLBreadcrumbsPlugin;
import oracle.bali.xml.gui.jdev.ceditor.folding.JDevXmlCodeFoldingPlugin;
import oracle.bali.xml.gui.swing.ceditor.SwingXmlCodeEditorGui;
import oracle.bali.xml.gui.swing.ceditor.folding.XmlCodeFoldingPlugin;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.model.XmlView;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorViewSelectionSetter;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;

public class JDevXmlCodeEditorGui
extends SwingXmlCodeEditorGui {
    private final CodeEditorListener _codeEditorListener = new CodeEditorListener();
    private final Map<CodeEditor, CodeEditorSelectionListener> _selectionListenerMap = new HashMap<CodeEditor, CodeEditorSelectionListener>(2);
    private final Set<CodeEditor> _codeEditors = new LinkedHashSet<CodeEditor>();

    public JDevXmlCodeEditorGui(XmlView view) {
        super(view);
    }

    public List createEditorPlugins() {
        List fromSuper = super.createEditorPlugins();
        ArrayList<Object> list = new ArrayList<Object>(6 + fromSuper.size());
        list.addAll(fromSuper);
        list.add((Object)new XmlBrowseClickPlugin());
        list.add((Object)new CodeEditorDropHandler(this));
        list.add(new XmlEditorPeekPlugin());
        list.add(new ToggleCommentPlugin());
        list.add((Object)new XMLBreadcrumbsPlugin());
        list.add((Object)new XmlTintPlugin());
        list.add(new XmlToolbarPlugin());
        return list;
    }

    public void dispose() {
        super.dispose();
    }

    public CodeEditor getCodeEditor() {
        CodeEditor ret = null;
        for (CodeEditor ce : this._codeEditors) {
            Component gui = ce.getGUI();
            if (gui != null && gui.isShowing()) {
                return ce;
            }
            if (ret != null) continue;
            ret = ce;
        }
        return ret;
    }

    protected DocumentScannerFactory getDocumentScannerFactory() {
        JDevXmlContext xmlContext = (JDevXmlContext)this.getGuiContext();
        return xmlContext.getIdeDocument().getDocumentScannerFactory(xmlContext.createContext(), xmlContext);
    }

    protected XMLCompletionInsightProvider createCompletionInsightProvider() {
        JDevXmlContext xmlContext = (JDevXmlContext)this.getGuiContext();
        return xmlContext.getIdeDocument().createInsightProvider(xmlContext);
    }

    protected XmlCodeFoldingPlugin createCodeFoldingPlugin() {
        return new JDevXmlCodeFoldingPlugin(this);
    }

    protected void postCreationHook() {
        super.postCreationHook();
        this.addModelListener((XmlModelListener)JDevTextSelectionSynchronizer.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void __attachToEditor(final CodeEditor editor, CodeEditorViewSelectionSetter setter) {
        Set<CodeEditor> set = this._codeEditors;
        synchronized (set) {
            boolean newEditor = this._codeEditors.add(editor);
            if (newEditor) {
                editor.addViewListener((ViewListener)this._codeEditorListener);
                editor.getGUI().addHierarchyListener(this._codeEditorListener);
                CodeEditorSelectionListener cesl = this._selectionListenerMap.get(editor);
                if (cesl == null) {
                    cesl = new CodeEditorSelectionListener(this);
                    this._selectionListenerMap.put(editor, cesl);
                }
                cesl.__attachToEditor(editor, setter);
                this.shown();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JDevXmlCodeEditorGui.this._updateShownOrHidden();
                        JDevTextSelectionSynchronizer.INSTANCE.syncTextSelection(JDevXmlCodeEditorGui.this.getGuiContext(), editor);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void __detachFromEditor(CodeEditor editor) {
        Set<CodeEditor> set = this._codeEditors;
        synchronized (set) {
            boolean removed = this._codeEditors.remove(editor);
            if (removed) {
                editor.removeViewListener((ViewListener)this._codeEditorListener);
                CodeEditorSelectionListener cesl = this._selectionListenerMap.remove(editor);
                if (cesl != null) {
                    cesl.__detachFromEditor(editor);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _updateShownOrHidden() {
        boolean showing = false;
        Set<CodeEditor> set = this._codeEditors;
        synchronized (set) {
            for (CodeEditor editor : this._codeEditors) {
                if (!editor.getFocusedEditorPane().isShowing()) continue;
                showing = true;
                break;
            }
        }
        if (showing) {
            this.shown();
        } else {
            this.hidden();
        }
    }

    private class CodeEditorListener
    implements ViewListener,
    HierarchyListener {
        private CodeEditorListener() {
        }

        public void viewActivated(ViewEvent e) {
            JDevXmlContext xmlContext = (JDevXmlContext)JDevXmlCodeEditorGui.this.getGuiContext();
            xmlContext.acquireActiveGui((XmlGui)JDevXmlCodeEditorGui.this);
        }

        public void viewDeactivated(ViewEvent e) {
        }

        public void viewClosed(ViewEvent e) {
            JDevXmlContext xmlContext = (JDevXmlContext)JDevXmlCodeEditorGui.this.getGuiContext();
            xmlContext.releaseActiveGui((XmlGui)JDevXmlCodeEditorGui.this);
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if ((e.getChangeFlags() | 4L) > 0L) {
                JDevXmlCodeEditorGui.this._updateShownOrHidden();
            }
        }
    }
}

