/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.ceditor.breadcrumbs;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.bali.xml.dom.changes.AbstractAttrChange;
import oracle.bali.xml.dom.changes.AttrAddedChange;
import oracle.bali.xml.dom.changes.AttrRemovedChange;
import oracle.bali.xml.dom.changes.AttrValueChange;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.DomChangeHandler;
import oracle.bali.xml.dom.changes.NodeInsertedChange;
import oracle.bali.xml.dom.changes.NodeRemovedChange;
import oracle.bali.xml.dom.changes.NodeValueChange;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.jdev.JDevViewHostedGui;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.ceditor.breadcrumbs.XmlBreadcrumb;
import oracle.bali.xml.gui.jdev.ceditor.breadcrumbs.XmlBreadcrumbs;
import oracle.bali.xml.gui.swing.ComponentXmlGui;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.event.XmlModelAdapter;
import oracle.ide.view.View;
import oracle.javatools.ui.breadcrumbs.Breadcrumb;
import oracle.javatools.ui.breadcrumbs.JBreadcrumbs;
import oracle.javatools.ui.breadcrumbs.PopupHandler;
import oracle.javatools.ui.breadcrumbs.PopupItem;
import oracle.javatools.ui.breadcrumbs.PopupProvider;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;

public class JDevXmlCodeEditorBreadcrumbsGui
extends XmlGui
implements ComponentXmlGui,
JDevViewHostedGui {
    private XmlView _mXmlView;
    private XmlBreadcrumbs _mCrumbs;
    private View _mView;
    private PopupHandler _mPopupHandler;
    private XmlBreadcrumbsXmlModelListener _mModelListener;
    private volatile boolean _mOutOfSync = true;

    public JDevXmlCodeEditorBreadcrumbsGui(XmlView view) {
        this(view, null);
    }

    public JDevXmlCodeEditorBreadcrumbsGui(XmlView view, NodeFilter filter) {
        super(view);
        this._mXmlView = view;
        if (this._mXmlView != null) {
            this._mModelListener = new XmlBreadcrumbsXmlModelListener();
            this._mXmlView.addModelListener((XmlModelListener)this._mModelListener);
        }
        this._mCrumbs = this.createBreadcrumbs(view, filter);
        this._mPopupHandler = new PopupHandler();
        this._mPopupHandler.attach(this._mCrumbs.getBreadcrumbsComponent(), (PopupProvider)new XmlPopupProvider());
        this._mCrumbs.setXmlBreadcrumbsContextMenuListener(new XmlBreadcrumbsListenerImpl());
    }

    public void dispose() {
        if (this._mXmlView != null) {
            this._mXmlView.removeModelListener((XmlModelListener)this._mModelListener);
            super.dispose();
        }
        if (this._mCrumbs != null) {
            this._mCrumbs.dispose();
        }
        this._mCrumbs = null;
        this._mXmlView = null;
    }

    public Component getComponent() {
        return this.getBreadcrumbs();
    }

    JBreadcrumbs getBreadcrumbs() {
        return this._mCrumbs.getBreadcrumbsComponent();
    }

    @Override
    public void setOwningJDevView(View view) {
        this._mView = view;
    }

    @Override
    public View getOwningJDevView() {
        return this._mView;
    }

    protected XmlBreadcrumbs createBreadcrumbs(XmlView view, NodeFilter filter) {
        return new XmlBreadcrumbs(view, this, filter);
    }

    protected void handleShown() {
        super.handleShown();
        if (this._mOutOfSync) {
            this.updateModel();
        }
    }

    protected void handleHidden() {
        super.handleHidden();
    }

    protected void handleModelInvalidateEvent(XmlModelEvent event) {
        super.handleModelInvalidateEvent(event);
        this._mOutOfSync = true;
    }

    protected void handleModelChangeEvent(XmlModelEvent event) {
        if (!this.isShown()) {
            return;
        }
        super.handleModelChangeEvent(event);
        if (event.isSelectionOrRangeSelectionChanged() || event.getCursorLocationPropertyChange() != null) {
            this.updateModel();
        }
    }

    public void activate() {
        this.updateModel();
    }

    public void setBreadcrumbs(JBreadcrumbs breadcrumbs) {
        assert (breadcrumbs != null);
        if (this.getComponent() != breadcrumbs) {
            this._mPopupHandler.detatch();
            this._mCrumbs.setBreadcrumbs(breadcrumbs);
            this._mPopupHandler.attach(this._mCrumbs.getBreadcrumbsComponent(), (PopupProvider)new XmlPopupProvider());
        }
    }

    protected void updateModel() {
        if (this._mCrumbs != null) {
            this._mCrumbs.updateModel();
            this._mOutOfSync = false;
        }
    }

    private class XmlBreadcrumbsXmlModelListener
    extends XmlModelAdapter {
        private XmlBreadcrumbsDomChangeHandler _mDomChangeHandler = new XmlBreadcrumbsDomChangeHandler();

        XmlBreadcrumbsXmlModelListener() {
        }

        public void modelChanged(XmlModelEvent event) {
            if (!event.isDomAttributeChanged()) {
                return;
            }
            List domChangeList = event.getBaseModelDomChanges();
            if (domChangeList.size() == 0) {
                return;
            }
            for (DomChange dChange : domChangeList) {
                if (dChange == null) continue;
                this._mDomChangeHandler.reset();
                dChange.process((DomChangeHandler)this._mDomChangeHandler);
                if (!this._mDomChangeHandler.isIdAttrChanged()) continue;
                JDevXmlCodeEditorBreadcrumbsGui.this._mCrumbs.updateModel();
                return;
            }
        }

        class XmlBreadcrumbsDomChangeHandler
        implements DomChangeHandler {
            private boolean idAttrChanged = false;

            XmlBreadcrumbsDomChangeHandler() {
            }

            void reset() {
                this.idAttrChanged = false;
            }

            boolean isIdAttrChanged() {
                return this.idAttrChanged;
            }

            private void updateIdAttrChanged(AbstractAttrChange attrChange) {
                if (attrChange.getAffectedAttrLocalName().equals("id")) {
                    this.idAttrChanged = true;
                }
            }

            public void handleAttrAddedChange(AttrAddedChange change) {
                this.updateIdAttrChanged((AbstractAttrChange)change);
            }

            public void handleAttrRemovedChange(AttrRemovedChange change) {
                this.updateIdAttrChanged((AbstractAttrChange)change);
            }

            public void handleAttrValueChange(AttrValueChange change) {
                this.updateIdAttrChanged((AbstractAttrChange)change);
            }

            public void handleNodeInsertedChange(NodeInsertedChange change) {
            }

            public void handleNodeRemovedChange(NodeRemovedChange change) {
            }

            public void handleNodeValueChange(NodeValueChange change) {
            }
        }
    }

    private class XmlPopupProvider
    implements PopupProvider<Node> {
        private XmlPopupProvider() {
        }

        public List<PopupItem<Node>> getPopupItems(Breadcrumb breadcrumb) {
            List<PopupItem<Node>> itemList = ((XmlBreadcrumb)breadcrumb).getChildren();
            return itemList;
        }

        public void itemSelected(PopupItem<Node> popupItem) {
            JDevXmlCodeEditorBreadcrumbsGui.this._mCrumbs.setSelection((Node)popupItem.getUserObject());
        }
    }

    private class XmlBreadcrumbsListenerImpl
    implements XmlBreadcrumbs.XmlBreadcrumbsContextMenuListener {
        private XmlBreadcrumbsListenerImpl() {
        }

        @Override
        public void contextMenuClicked(final Point p) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JDevXmlContext.showContextMenu(JDevXmlCodeEditorBreadcrumbsGui.this, new MouseEvent(JDevXmlCodeEditorBreadcrumbsGui.this.getComponent(), 500, 0L, 0, p.x, p.y, 1, false, 0));
                }
            });
        }
    }
}

