/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.dependency;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.DeferredElementVisitorHook;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.util.MetaClass;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.dependency.ExternalIdReference;
import oracle.bali.xml.gui.jdev.dependency.ExternalReferenceProvider;
import oracle.bali.xml.gui.jdev.dependency.IndexingUtils;
import oracle.bali.xml.gui.jdev.dependency.XmlWrapperReference;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.dependency.DependencyUtils;
import oracle.bali.xml.model.dependency.Reference;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.dependency.Declaration;
import oracle.ide.dependency.DependencyManager;
import oracle.ide.dependency.IdDeclaration;
import oracle.ide.dependency.ProgressIndicator;
import oracle.ide.dependency.ReferenceProvider;
import oracle.ide.dependency.Scope;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.LockFailedException;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.TechnologyScope;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.javatools.data.PropertyStorage;
import org.w3c.dom.NamedNodeMap;

public class XmlReferenceProvider
implements ReferenceProvider {
    public static final ElementName HOOK_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "xml-reference-provider-hook");
    private static final Object _providerVisitorLock = new Object();
    private static XmlReferenceProviderVisitor _providerVisitor = null;
    private static final CopyOnWriteArrayList<ExternalReferenceProvider> _sProviders = new CopyOnWriteArrayList();
    private static final CopyOnWriteArrayList<XmlReferenceProviderInfo> _sProviderInfos = new CopyOnWriteArrayList();
    private static final Logger LOG = Logger.getLogger(XmlReferenceProvider.class.getName());

    public static void addReferenceProvider(ExternalReferenceProvider provider) {
        _sProviders.add(provider);
    }

    public boolean canGetReference(Context context) {
        return false;
    }

    public oracle.ide.dependency.Reference getReference(Context context) {
        return null;
    }

    public boolean canGetReferences(Context context, Node node) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends oracle.ide.dependency.Reference> getReferences(Context context, Node node) throws InterruptedException {
        if (!(node instanceof XMLSourceNode)) {
            return Collections.emptyList();
        }
        ArrayList<XmlWrapperReference> allRefs = new ArrayList<XmlWrapperReference>();
        Context newContext = new Context(context);
        newContext.setNode(node);
        JDevXmlContext xmlContext = JDevXmlContext.getXmlContext(newContext);
        XmlModel model = xmlContext.getModel();
        model.acquireReadLock();
        try {
            TreeTraversal traversal = model.getTreeTraversal();
            for (org.w3c.dom.Node domNode : traversal.allNodes((org.w3c.dom.Node)model.getDocument())) {
                allRefs.addAll(this._getReferences(xmlContext, domNode));
                NamedNodeMap attrs = domNode.getAttributes();
                if (attrs == null) continue;
                for (int i = 0; i < attrs.getLength(); ++i) {
                    org.w3c.dom.Node attr = attrs.item(i);
                    allRefs.addAll(this._getReferences(xmlContext, attr));
                }
            }
        }
        finally {
            model.releaseReadLock();
        }
        return allRefs;
    }

    public boolean canFindReferences(Context context, Scope scope, Declaration declaration) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends oracle.ide.dependency.Reference> findReferences(Context context, Scope scope, Declaration declaration, ProgressIndicator progress) throws InterruptedException {
        ArrayList<XmlWrapperReference> references = new ArrayList<XmlWrapperReference>();
        if (declaration instanceof IdDeclaration) {
            IdDeclaration idDeclaration = (IdDeclaration)declaration;
            for (Project project : scope.getProjects()) {
                Collection<ExternalReferenceProvider> providers = this._getProviders(context, project, (Declaration)idDeclaration);
                if (providers.isEmpty()) continue;
                ContentSet content = this.getContentSet(project);
                Index index = IndexManager.getIndexManager().getIndex(project, content);
                try {
                    index.lock();
                    try {
                        for (ExternalReferenceProvider provider : providers) {
                            String id;
                            String indexValue = provider.getIndexValue(context, id = idDeclaration.getDeclarationId());
                            if (indexValue == null) continue;
                            Collection<Reference> xmlRefs = IndexingUtils.getReferences(new Scope(project), provider.getIndexKey(), indexValue);
                            for (Reference xmlRef : xmlRefs) {
                                if (!(xmlRef instanceof ExternalIdReference)) continue;
                                ExternalIdReference idRef = (ExternalIdReference)xmlRef;
                                if (!idDeclaration.getDeclarationId().equals(idRef.getDeclarationId())) continue;
                                references.add(new XmlWrapperReference((ExternalIdReference)xmlRef));
                            }
                        }
                    }
                    finally {
                        index.unlock();
                    }
                }
                catch (LockFailedException e) {
                    DependencyManager.getDependencyManager().getLogger().log(Level.SEVERE, "Unable to find references", e);
                }
                finally {
                    index.release();
                }
            }
        }
        return Collections.unmodifiableCollection(references);
    }

    protected boolean verify(Context context, oracle.ide.dependency.Reference reference, Declaration declaration) throws InterruptedException {
        return reference.isReferenceTo(context, declaration);
    }

    protected ContentSet getContentSet(Project project) {
        return ProjectContent.getInstance((PropertyStorage)project).getAllContents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ExternalReferenceProvider> _getProviders(Context context, Project project, Declaration declaration) {
        ArrayList<ExternalReferenceProvider> providers = new ArrayList<ExternalReferenceProvider>();
        if (_providerVisitor == null) {
            Object object = _providerVisitorLock;
            synchronized (object) {
                if (_providerVisitor == null) {
                    _providerVisitor = new XmlReferenceProviderVisitor();
                    ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
                    DeferredElementVisitorHook hookHandler = (DeferredElementVisitorHook)extensionRegistry.getHook(HOOK_ELEMENT);
                    hookHandler.attachElementVisitor((ElementVisitor)_providerVisitor);
                }
            }
        }
        TechnologyScope techScope = TechnologyScopeConfiguration.getInstance((PropertyStorage)project).getTechnologyScope();
        HashSet<String> projectKeys = new HashSet<String>();
        Collections.addAll(projectKeys, techScope.getTechnologyKeys());
        for (XmlReferenceProviderInfo info : _sProviderInfos) {
            Set<String> providerKeys = info.getTechnologyKeys();
            if (!providerKeys.contains("*") && !this.matchAny(projectKeys, providerKeys)) continue;
            try {
                ExternalReferenceProvider provider = (ExternalReferenceProvider)info.getMetaClass().newInstance();
                if (!provider.isReferenceFor(declaration)) continue;
                providers.add(provider);
            }
            catch (ClassNotFoundException e) {
                LOG.log(Level.WARNING, "Can't locate a suitable xmlReferenceProvider implementation for " + info.getClass(), e);
            }
            catch (InstantiationException e) {
                LOG.log(Level.WARNING, "Can't locate a suitable xmlReferenceProvider implementation for " + info.getClass(), e);
            }
            catch (IllegalAccessException e) {
                LOG.log(Level.WARNING, "Can't locate a suitable xmlReferenceProvider implementation for " + info.getClass(), e);
            }
        }
        for (ExternalReferenceProvider provider : _sProviders) {
            if (!provider.isReferenceFor(declaration)) continue;
            providers.add(provider);
        }
        return providers;
    }

    private Collection<XmlWrapperReference> _getReferences(JDevXmlContext xmlContext, org.w3c.dom.Node node) {
        List<XmlWrapperReference> xmlRefs = Collections.emptyList();
        Collection references = DependencyUtils.getReferences((XmlContext)xmlContext, (org.w3c.dom.Node)node);
        for (Reference reference : references) {
            if (!(reference instanceof ExternalIdReference)) continue;
            if (xmlRefs.isEmpty()) {
                xmlRefs = new ArrayList<XmlWrapperReference>();
            }
            xmlRefs.add(new XmlWrapperReference((ExternalIdReference)reference));
        }
        return xmlRefs;
    }

    private boolean matchAny(Set<String> projectKeys, Set<String> providerKeys) {
        for (String key : providerKeys) {
            if (!projectKeys.contains(key)) continue;
            return true;
        }
        return false;
    }

    private static class XmlReferenceProviderVisitor
    extends ElementVisitor {
        public static final ElementName PROVIDER_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "xml-reference-provider");
        private static final String CLASS_ATTR = "class";
        private static final String TECHNOLOGY_KEYS_ATTR = "technology-keys";

        private XmlReferenceProviderVisitor() {
        }

        public void start(ElementStartContext context) {
            if (HOOK_ELEMENT.equals((Object)context.getElementName())) {
                context.registerChildVisitor(PROVIDER_ELEMENT, (ElementVisitor)this);
            } else if (PROVIDER_ELEMENT.equals((Object)context.getElementName())) {
                String clazz = context.getAttributeValue(CLASS_ATTR);
                if (clazz == null || (clazz = clazz.trim()).length() == 0) {
                    this.log((ElementContext)context, Level.SEVERE, "Missing required attribute 'class'.");
                    return;
                }
                MetaClass metaClass = new MetaClass(this.getMetaClassLoader((ElementContext)context), clazz);
                String technologyKeys = context.getAttributeValue(TECHNOLOGY_KEYS_ATTR);
                _sProviderInfos.add(new XmlReferenceProviderInfo(metaClass, technologyKeys));
            }
        }
    }

    private static class XmlReferenceProviderInfo {
        private MetaClass _clazz;
        private Set<String> _technologyKeys;

        public XmlReferenceProviderInfo(MetaClass clazz, String technologyKeys) {
            this._clazz = clazz;
            this.parseKeys(technologyKeys);
        }

        public MetaClass getMetaClass() {
            return this._clazz;
        }

        public Set<String> getTechnologyKeys() {
            return this._technologyKeys;
        }

        private void parseKeys(String technologyKeys) {
            this._technologyKeys = new HashSet<String>();
            if (technologyKeys != null && !"".equals(technologyKeys)) {
                String[] keys;
                for (String key : keys = technologyKeys.split(",")) {
                    if ("".equals(key = key.trim())) continue;
                    this._technologyKeys.add(key);
                }
            }
            if (this._technologyKeys.isEmpty()) {
                this._technologyKeys.add("*");
            }
        }
    }
}

