/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.dependency;

import java.net.URL;
import javax.swing.Icon;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.dependency.DependencyBundle;
import oracle.bali.xml.gui.jdev.dependency.ExternalIdReference;
import oracle.bali.xml.gui.jdev.dependency.JDevDependencyContext;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.dependency.CommandResult;
import oracle.bali.xml.model.dependency.ValueInfo;
import oracle.ide.dependency.IdReference;
import oracle.ide.dependency.SourceReference;
import oracle.ide.dependency.SourceUtils;
import oracle.ide.model.Displayable;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.javatools.status.Severity;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XmlWrapperReference
extends IdReference
implements SourceReference,
Displayable {
    private ExternalIdReference _reference;

    public XmlWrapperReference(ExternalIdReference reference) {
        this._reference = reference;
    }

    public Workspace getWorkspace() {
        return this._reference.getWorkspace();
    }

    public Project getProject() {
        return this._reference.getProject();
    }

    public URL getURL() {
        return this._reference.getURL();
    }

    public int getStartOffset() {
        return this._reference.getStartOffset();
    }

    public int getEndOffset() {
        return this._reference.getEndOffset();
    }

    public String getDeclarationId() {
        return this._reference.getDeclarationId();
    }

    public boolean setDeclarationId(String id) {
        JDevDependencyContext dc = new JDevDependencyContext();
        if (this._reference.supportsCommand(dc, "updateReferenceCommand")) {
            try {
                CommandResult result = this._reference.performCommand(dc, "updateReferenceCommand", new ValueInfo(null, id));
                return result.getResult() == Severity.OK;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public void show() {
        JDevDependencyContext dc = new JDevDependencyContext();
        if (this._reference.supportsCommand(dc, "gotoSelfCommand")) {
            this._reference.performCommand(dc, "gotoSelfCommand", null);
        } else {
            SourceUtils.openSourceFile((Workspace)this.getWorkspace(), (Project)this.getProject(), (URL)this.getURL(), (int)this.getStartOffset(), (int)this.getEndOffset());
        }
    }

    public String getShortLabel() {
        return (String)this._reference.getMetadata(new WrapperDependencyContext(), "displayTextMetadata");
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public Icon getIcon() {
        return null;
    }

    public String getToolTipText() {
        return null;
    }

    private static class WrapperDependencyContext
    extends JDevDependencyContext {
        private static final String[] ID_ATTRS = new String[]{"id", "name"};

        private WrapperDependencyContext() {
        }

        private static String getElementName(Element element) {
            for (String attrName : ID_ATTRS) {
                NamedNodeMap attrs = element.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node n = attrs.item(i);
                    if (!n.getNodeName().equalsIgnoreCase(attrName)) continue;
                    return element.getTagName() + "#" + n.getNodeValue();
                }
            }
            return element.getTagName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getDisplayText(XmlContext context, Node node) {
            if (!(context instanceof JDevXmlContext)) {
                return node.getNodeName();
            }
            JDevXmlContext xmlContext = (JDevXmlContext)context;
            XmlModel model = xmlContext.getSourceModel();
            model.acquireReadLock();
            try {
                if (DomUtils.isAttribute((Node)node)) {
                    String string = DependencyBundle.format("DISPLAY_ATTR_IN_NODE", node.getNodeName(), WrapperDependencyContext.getElementName(((Attr)node).getOwnerElement()));
                    return string;
                }
                if (DomUtils.isElement((Node)node)) {
                    String string = WrapperDependencyContext.getElementName((Element)node);
                    return string;
                }
                if (DomUtils.isElement((Node)node.getParentNode())) {
                    String string = DependencyBundle.format("DISPLAY_VALUE_OF", WrapperDependencyContext.getElementName((Element)node.getParentNode()));
                    return string;
                }
                String string = node.getNodeName();
                return string;
            }
            finally {
                model.releaseReadLock();
            }
        }
    }
}

