/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.explorer;

import java.awt.Component;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.jdev.JDevInspectableViewTracker;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.XmlController;
import oracle.bali.xml.gui.jdev.XmlGuiHostedJDevView;
import oracle.bali.xml.gui.jdev.explorer.ExplorerToolbar;
import oracle.bali.xml.gui.jdev.explorer.JDevExplorerComponent;
import oracle.bali.xml.gui.jdev.explorer.JDevExplorerGui;
import oracle.bali.xml.gui.jdev.util.JDevUtils;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.model.XmlUsage;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.share.SwitchableReference;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.explorer.Explorer;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.StatusProvider;
import oracle.ide.view.View;
import oracle.javatools.ui.themes.Themes;

public abstract class AbstractXmlExplorer
extends Explorer
implements StatusProvider,
XmlModelListener,
XmlGuiHostedJDevView {
    private ExplorerToolbar _explorerToolbar = null;
    private final JDevExplorerComponent _explorerComponent = new JDevExplorerComponent();
    private final JScrollPane _scrollPane = new JScrollPane();
    private final XmlController _controller;
    private Context _context;
    private SwitchableReference _guiReference;
    private Reference _treeReference;
    private Reference _viewReference = null;

    public AbstractXmlExplorer() {
        if (Themes.isThemed()) {
            this._scrollPane.setOpaque(false);
            this._scrollPane.getViewport().setOpaque(false);
        }
        this._scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this._controller = XmlController.getXmlController(this.getXmlUsage());
        this._explorerComponent.addScrollPane(this._scrollPane);
    }

    public void activate() {
        super.activate();
        JDevXmlContext context = this.getCurrentXmlContext();
        if (context != null) {
            context.acquireActiveGui((XmlGui)this.getCurrentJDevExplorerGui());
        }
    }

    public void deactivate() {
        super.deactivate();
    }

    public Context getContext(EventObject event) {
        if (this._context != null) {
            this._context.setEvent(event);
            this._context.setSelection(this.getSelection());
        }
        return this._context;
    }

    protected Element[] getSelectionFromUI() {
        JDevXmlContext xmlContext = this.getCurrentXmlContext();
        if (xmlContext != null) {
            return new Element[]{xmlContext.createSelectionProxyElement()};
        }
        return null;
    }

    public Component getGUI() {
        if (this.getScrollPane().getViewport().getView() != null || this.getCurrentJDevExplorerGui() != null) {
            return this._explorerComponent;
        }
        return null;
    }

    protected void setContextImpl(Context ideContext) {
        if (this._context != ideContext) {
            JDevExplorerGui oldExplorerGui = this.getCurrentJDevExplorerGui();
            this._context = ideContext;
            JDevXmlContext newXmlContext = JDevXmlContext.getXmlContext(this._context);
            JDevExplorerGui newExplorerGui = newXmlContext == null ? null : (JDevExplorerGui)newXmlContext.getGui(this.getXmlUsage());
            if (newExplorerGui != oldExplorerGui) {
                if (oldExplorerGui != null) {
                    this._doHide(oldExplorerGui);
                    this._clearViewListener();
                    oldExplorerGui.setOwningJDevView(null);
                    JTree treeComponent = (JTree)this._scrollPane.getViewport().getView();
                    if (treeComponent == null && this._treeReference != null) {
                        treeComponent = (JTree)this._treeReference.get();
                    }
                    if (this._treeReference != null) {
                        this._treeReference.clear();
                    }
                    this._scrollPane.setViewportView(null);
                    if (treeComponent != null) {
                        oldExplorerGui.disposeJTree(treeComponent);
                    }
                    if (this._context != null) {
                        this._context.setNode(null);
                    }
                } else {
                    this._clearViewListener();
                }
                this._guiReference = new SwitchableReference((Object)newExplorerGui);
                if (newExplorerGui != null) {
                    newExplorerGui.setOwningJDevView(this.owner());
                    this._createNewTree(newExplorerGui);
                    this._viewReference = new WeakReference<XmlView>(newExplorerGui.getView());
                    newExplorerGui.getView().addModelListener((XmlModelListener)this);
                }
            }
            if (this.getCurrentXmlContext() != null && this._context != null) {
                this._context.setNode((Node)this.getCurrentXmlContext().getIdeDocument());
            }
        }
    }

    private void _clearViewListener() {
        if (this._viewReference != null) {
            XmlView view = (XmlView)this._viewReference.get();
            if (view != null) {
                view.removeModelListener((XmlModelListener)this);
            }
            this._viewReference.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _createNewTree(JDevExplorerGui newExplorerGui) {
        newExplorerGui.getView().acquireReadLock();
        try {
            JTree treeComponent = newExplorerGui.getNewJTree();
            this._explorerComponent.setXmlGui(newExplorerGui);
            newExplorerGui.setExplorerComponent(this._explorerComponent);
            this._treeReference = new WeakReference<JTree>(treeComponent);
            this._scrollPane.setViewportView(treeComponent);
        }
        finally {
            newExplorerGui.getView().releaseReadLock();
        }
    }

    protected JScrollPane getScrollPane() {
        return this._scrollPane;
    }

    public void setOwner(View owner) {
        super.setOwner(owner);
        JDevExplorerGui gui = this.getCurrentJDevExplorerGui();
        if (gui != null) {
            gui.setOwningJDevView(this.owner());
        }
    }

    public ContextMenu getContextMenu() {
        return ExplorerManager.getExplorerManager().getContextMenu();
    }

    public Controller getController() {
        return this._controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HelpInfo getHelpInfo() {
        HelpInfo hi = null;
        JDevExplorerGui gui = this.getCurrentJDevExplorerGui();
        if (gui != null) {
            XmlView view = gui.getView();
            view.acquireReadLock();
            try {
                Selection s = view.getSelection();
                org.w3c.dom.Node n = s.getFirstSelectedNode();
                if (n != null) {
                    String info = gui.getHelpTopic(n, view.getNodeXmlKey(n));
                    HelpInfo helpInfo = new HelpInfo(info);
                    return helpInfo;
                }
            }
            finally {
                view.releaseReadLock();
            }
        }
        if (hi == null) {
            hi = super.getHelpInfo();
        }
        return hi;
    }

    public void listenerAttached(XmlModelEvent event) {
    }

    public void invalidate(XmlModelEvent event) {
    }

    public void modelChanged(XmlModelEvent event) {
        if (event.isSelectionChanged()) {
            if (SwingUtilities.isEventDispatchThread()) {
                if (JDevInspectableViewTracker.INSTANCE.getLastViewSupportingInspection((View)this) == this) {
                    this.updateSelectionImpl(true);
                }
            } else {
                final AbstractXmlExplorer explorer = this;
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        if (JDevInspectableViewTracker.INSTANCE.getLastViewSupportingInspection((View)AbstractXmlExplorer.this) == explorer) {
                            AbstractXmlExplorer.this.updateSelectionImpl(false);
                        }
                    }
                };
                SwingUtilities.invokeLater(r);
            }
        }
    }

    public void noChange(XmlModelEvent event) {
    }

    public void listenerDetached(XmlModelEvent event) {
    }

    public void stateChanged(int state) {
        super.stateChanged(state);
        JDevExplorerGui explorerGui = this.getCurrentJDevExplorerGui();
        switch (state) {
            case 2: {
                if (this._explorerToolbar != null) {
                    this._explorerToolbar.dispose();
                    this._explorerToolbar = null;
                }
                this._explorerComponent.setXmlGui(null);
                this.setContext(null);
                break;
            }
            case 1: {
                if (explorerGui == null) break;
                this._doHide(explorerGui);
                if (this._explorerToolbar != null) {
                    this._explorerToolbar.dispose();
                    this._explorerToolbar = null;
                }
                this._explorerComponent.setXmlGui(null);
                this._guiReference.setWeak(true);
                this._treeReference = new WeakReference<Component>(this._scrollPane.getViewport().getView());
                this._scrollPane.setViewportView(null);
                break;
            }
            case 0: {
                if (explorerGui == null) break;
                if (this._treeReference == null) {
                    this._createNewTree(explorerGui);
                } else {
                    JTree tree = (JTree)this._treeReference.get();
                    if (tree == null) {
                        this._createNewTree(explorerGui);
                    } else {
                        this._scrollPane.setViewportView(tree);
                    }
                }
                this._explorerComponent.setXmlGui(explorerGui);
                this._explorerToolbar = new ExplorerToolbar(explorerGui);
                this._explorerToolbar.addToolbarItems();
                explorerGui.shown();
                XmlGui statusGui = this._getStatusGui(true);
                if (statusGui != null) {
                    statusGui.shown();
                }
                this._guiReference.setWeak(false);
            }
        }
    }

    private void _doHide(JDevExplorerGui explorerGui) {
        ((JDevXmlContext)explorerGui.getGuiContext()).releaseActiveGui((XmlGui)explorerGui);
        explorerGui.hidden();
        XmlGui statusGui = this._getStatusGui(false);
        if (statusGui != null) {
            statusGui.hidden();
        }
    }

    protected XmlUsage getXmlUsage() {
        return XmlUsage.EXPLORER;
    }

    @Override
    public final XmlGui getCurrentXmlGui() {
        return this.getCurrentJDevExplorerGui();
    }

    protected final JDevXmlContext getCurrentXmlContext() {
        JDevExplorerGui gui = this.getCurrentJDevExplorerGui();
        if (gui == null) {
            return null;
        }
        return (JDevXmlContext)gui.getGuiContext();
    }

    protected final JDevExplorerGui getCurrentJDevExplorerGui() {
        Object gui;
        if (this._guiReference != null && (gui = this._guiReference.get()) instanceof JDevExplorerGui) {
            return (JDevExplorerGui)gui;
        }
        return null;
    }

    public JComponent[] getCustomCells() {
        XmlGui gui;
        JDevXmlContext xmlContext = this.getCurrentXmlContext();
        if (xmlContext != null && (gui = xmlContext.getGui(XmlUsage.STATUS_BAR)) instanceof StatusProvider) {
            return ((StatusProvider)gui).getCustomCells();
        }
        return null;
    }

    public boolean isExpandable(JComponent component) {
        XmlGui gui;
        JDevXmlContext xmlContext = this.getCurrentXmlContext();
        if (xmlContext != null && (gui = xmlContext.getGui(XmlUsage.STATUS_BAR)) instanceof StatusProvider) {
            return ((StatusProvider)gui).isExpandable(component);
        }
        return false;
    }

    public void updateVisibleActions(UpdateMessage updateMessage) {
        this.activate();
        super.updateVisibleActions(updateMessage);
    }

    private XmlGui _getStatusGui(boolean createIfNeeded) {
        JDevExplorerGui explorerGui = this.getCurrentJDevExplorerGui();
        if (explorerGui == null) {
            return null;
        }
        JDevXmlContext xmlContext = (JDevXmlContext)explorerGui.getGuiContext();
        return JDevUtils.getStatusGui(xmlContext, createIfNeeded);
    }
}

