/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.inspector;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.xml.gui.base.inspector.XmlPropertyModel;
import oracle.bali.xml.gui.base.inspector.XmlPropertyModelListener;
import oracle.bali.xml.share.TransactionToken;
import oracle.javatools.util.Filter;
import oracle.javatools.util.Pair;

final class PropModelProxy
extends PropertyModel
implements XmlPropertyModel {
    private final boolean _isFormLayoutPromoted;
    private final PropertyModel _base;
    private final String _idPrefix;
    private final int[] _outerToInner;
    private final int[] _innerToOuter;

    public PropModelProxy(PropertyModel base, String idPrefix, Filter<Pair<PropertyModel, Integer>> filter, boolean isFormLayoutPromoted) {
        this._base = base;
        this._idPrefix = idPrefix;
        Pair<int[], int[]> mappings = PropModelProxy._computeMappings(base, filter);
        this._innerToOuter = (int[])mappings.getFirst();
        this._outerToInner = (int[])mappings.getSecond();
        this._isFormLayoutPromoted = isFormLayoutPromoted;
        Listeners listeners = new Listeners();
        this._base.addPropertyChangeListener((PropertyChangeListener)listeners);
        this._base.addTableModelListener((TableModelListener)listeners);
    }

    public Object[] getColumnMapping() {
        return this._base.getColumnMapping();
    }

    public String getTargetDisplayName() {
        return this._base.getTargetDisplayName();
    }

    public void invalidateValueData() {
        this._base.invalidateValueData();
    }

    public int getRowCount() {
        return this._outerToInner.length;
    }

    public Object getValueAt(int row, int column) {
        int innerRow = this._rowOuterToInner(row);
        if (innerRow < 0) {
            throw new IllegalArgumentException("no such row: " + row);
        }
        return this._base.getValueAt(innerRow, column);
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this._base.setLocale(this.getLocale());
    }

    public int findColumn(String columnName) {
        return this._base.findColumn(columnName);
    }

    public Object getPropertyByID(int column, Object propertyID) {
        int row = this.getPropertyIndex(propertyID);
        if (row < 0) {
            return DOES_NOT_EXIST;
        }
        return this.getValueAt(row, column);
    }

    public int getPropertyIndex(Object propertyID) {
        return this._rowInnerToOuter(this._base.getPropertyIndex(propertyID));
    }

    public boolean isCellEditable(int row, int column) {
        int innerRow = this._rowOuterToInner(row);
        if (innerRow < 0) {
            return false;
        }
        return this._base.isCellEditable(innerRow, column);
    }

    public boolean isDataConflicting(int row, int column) {
        int innerRow = this._rowOuterToInner(row);
        if (innerRow < 0) {
            return false;
        }
        return this._base.isDataConflicting(innerRow, column);
    }

    public Object getMatchingId(Object id) {
        if (id instanceof String) {
            String sid = id.toString();
            if (!sid.startsWith(this._idPrefix)) {
                return null;
            }
            sid = sid.substring(this._idPrefix.length());
            return this._base.getMatchingId((Object)sid);
        }
        return super.getMatchingId(id);
    }

    public boolean isPropertyCommon(int row) {
        int innerRow = this._rowOuterToInner(row);
        if (innerRow < 0) {
            return false;
        }
        return this._base.isPropertyCommon(innerRow);
    }

    public boolean isSettable(Object oldValue, Object newValue) {
        return this._base.isSettable(oldValue, newValue);
    }

    public void setValueAt(Object aValue, int row, int column) {
        int innerRow = this._rowOuterToInner(row);
        if (innerRow < 0) {
            throw new IllegalArgumentException("no such row: " + row);
        }
        this._base.setValueAt(aValue, innerRow, column);
    }

    public void startRead() {
        this._base.startRead();
    }

    public void stopRead() {
        this._base.stopRead();
    }

    public void setTransactionToken(TransactionToken token) {
        if (this._base instanceof XmlPropertyModel) {
            ((XmlPropertyModel)this._base).setTransactionToken(token);
        }
    }

    public void addXmlPropertyChangeListener(XmlPropertyModelListener listener) {
        if (this._base instanceof XmlPropertyModel) {
            ((XmlPropertyModel)this._base).addXmlPropertyChangeListener(listener);
        }
    }

    public void removeXmlPropertyChangeListener(XmlPropertyModelListener listener) {
        if (this._base instanceof XmlPropertyModel) {
            ((XmlPropertyModel)this._base).removeXmlPropertyChangeListener(listener);
        }
    }

    public void fireXmlPropertyModelEvent(Object o) {
        if (this._base instanceof XmlPropertyModel) {
            ((XmlPropertyModel)this._base).fireXmlPropertyModelEvent(o);
        }
    }

    public boolean isFormLayoutPromoted() {
        return this._isFormLayoutPromoted;
    }

    private int _rowOuterToInner(int outer) {
        if (outer < 0 || outer >= this._outerToInner.length) {
            return -1;
        }
        return this._outerToInner[outer];
    }

    private int _rowInnerToOuter(int inner) {
        if (inner < 0 || inner >= this._innerToOuter.length) {
            return -1;
        }
        return this._innerToOuter[inner];
    }

    private static Pair<int[], int[]> _computeMappings(PropertyModel base, Filter<Pair<PropertyModel, Integer>> filter) {
        filter = Filter.Instances.nonNull(filter);
        Pair pair = new Pair();
        pair.setFirst((Object)base);
        int innerCount = base.getRowCount();
        int[] innerToOuter = new int[innerCount];
        LinkedList<Integer> outerToInnerList = new LinkedList<Integer>();
        for (int i = 0; i < innerCount; ++i) {
            pair.setSecond((Object)i);
            if (filter.matches((Object)pair)) {
                innerToOuter[i] = outerToInnerList.size();
                outerToInnerList.add(i);
                continue;
            }
            innerToOuter[i] = -1;
        }
        int[] outerToInner = new int[outerToInnerList.size()];
        int i = 0;
        Iterator i$ = outerToInnerList.iterator();
        while (i$.hasNext()) {
            int val;
            outerToInner[i] = val = ((Integer)i$.next()).intValue();
            ++i;
        }
        return new Pair((Object)innerToOuter, (Object)outerToInner);
    }

    private class Listeners
    implements PropertyChangeListener,
    TableModelListener {
        private Listeners() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PropModelProxy.this.firePropertyChanged(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            PropModelProxy.this.fireTableChanged(new TableModelEvent((TableModel)((Object)PropModelProxy.this)));
        }
    }
}

